package com.ejie.ab78.dao.terceros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.nora.T17Localidad;
import com.ejie.ab78.model.nora.T17Municipio;
import com.ejie.ab78.model.nora.T17Pais;
import com.ejie.ab78.model.nora.T17Provincia;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.DatosTerceros;
import com.ejie.ab78.model.terceros.Sexo;
import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.ab78.model.terceros.TiposDocumento;
import com.ejie.ab78.util.UtilDao;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DatosDireccionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DatosDireccionesDaoImpl implements DatosDireccionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDDIRECCION", "DIRECCION", "NUMERO", "ESCALERA",
			"IDTIPODIRECCION", "ESTABLECIMIENTO", "PISO", "LETRA", "CODIGOPOSTAL", "IDPROVINCIA", "IDMUNICIPIO",
			"IDLOCALIDAD", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION",
			"DATOSTERCEROSIDTERCERO", "DATOSTERCEROSDOCUMENTO", "DATOSTERCEROSIDTIPODOCUMENTO", "DATOSTERCEROSNOMBRE",
			"DATOSTERCEROSAPELLIDO1", "DATOSTERCEROSAPELLIDO2", "DATOSTERCEROSIDSEXO", "DATOSTERCEROSTELEFONO",
			"DATOSTERCEROSEMAIL", "DATOSTERCEROSIDIOMA", "DATOSTERCEROSTIPOPARTICIPANTE", "DATOSTERCEROSFECHAREGISTRO",
			"DATOSTERCEROSUSUARIOREGISTRO", "DATOSTERCEROSFECHAULTMOD", "DATOSTERCEROSUSUULTMOD",
			"TIPOSDIRECCIONIDTIPODIRECCION", "TIPOSDIRECCIONDESCCASTELLANO", "TIPOSDIRECCIONDESCEUSKERA",
			"TIPOSDIRECCIONFECHAREGISTRO", "TIPOSDIRECCIONUSUARIOREGISTRO", "DATOSTERCEROSIDREPRESENTANTE", "IDPAIS",
			"DESCRIPCIONPROVINCIAEXTR", "DESCRIPCIONCIUDADEXTR" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosDirecciones> rwMap = new RowMapper<DatosDirecciones>() {

		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return new DatosDirecciones(resultSet.getInt("IDDIRECCION"), resultSet.getString("ESTABLECIMIENTO"),
					resultSet.getString("DIRECCION"), resultSet.getString("NUMERO"), resultSet.getString("ESCALERA"),
					resultSet.getString("PISO"), resultSet.getString("LETRA"), resultSet.getString("CODIGOPOSTAL"),
					resultSet.getLong("IDPAIS"), resultSet.getLong("IDPROVINCIA"), resultSet.getLong("IDMUNICIPIO"),
					resultSet.getLong("IDLOCALIDAD"), resultSet.getString("DESCRIPCIONPROVINCIAEXTR"),
					resultSet.getString("DESCRIPCIONCIUDADEXTR"), resultSet.getString("IDENTIFICADORESTABLECIMIENTO"),	
					new DatosTerceros(resultSet.getInt("DatosTercerosIDTERCERO"),
							resultSet.getString("DatosTercerosDOCUMENTO"),
							new TiposDocumento(resultSet.getLong("ID_TIPO_DOCUMENTO"),
									resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getString("DatosTercerosNOMBRE"), resultSet.getString("DatosTercerosAPELLIDO1"),
							resultSet.getString("DatosTercerosAPELLIDO2"),
							new Sexo(resultSet.getLong("ID_SEXO"), resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getLong("DatosTercerosTELEFONO"), resultSet.getString("DatosTercerosEMAIL"),
							resultSet.getInt("DatosTercerosIDIOMA"), resultSet.getInt("DatosTercerosTIPOPARTICIPANTE")),
					new TiposDireccion(resultSet.getLong("TiposDireccionIDTIPODIRECCION"),
							resultSet.getString("TIPOSDIRECCIONDESCCASTELLANO"),
							resultSet.getString("TIPOSDIRECCIONDESCEUSKERA"),
							resultSet.getDate("TiposDireccionFECHAREGISTRO"),
							resultSet.getString("TiposDireccionUSUARIOREGISTRO")),
					null);

		}
	};

	private RowMapper<DatosDirecciones> rwMapUbicacionTerceroId = new RowMapper<DatosDirecciones>() {
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosDirecciones(resultSet.getInt("IDDIRECCION"), resultSet.getString("ESTABLECIMIENTO"),
					resultSet.getString("DIRECCION"), resultSet.getString("NUMERO"), resultSet.getString("ESCALERA"),
					resultSet.getString("PISO"), resultSet.getString("LETRA"), resultSet.getString("CODIGOPOSTAL"),
					resultSet.getLong("IDPAIS"), resultSet.getLong("IDPROVINCIA"), resultSet.getLong("IDMUNICIPIO"),
					resultSet.getLong("IDLOCALIDAD"), resultSet.getString("DESCRIPCIONPROVINCIAEXTR"),
					resultSet.getString("DESCRIPCIONCIUDADEXTR"), resultSet.getString("IDENTIFICADORESTABLECIMIENTO"),
					new DatosTerceros(resultSet.getInt("IDTERCERO"), null, null, null, null,
							null, null, null, null, null, null),
					new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"), resultSet.getString("DESCASTELLANO"),
							resultSet.getString("DESEUSKERA"), null, null),
					null);
		}
	};

	private RowMapper<DatosDirecciones> rwMapInfoContactoTercero = new RowMapper<DatosDirecciones>() {
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosDirecciones(resultSet.getInt("IDDIRECCION"), resultSet.getString("ESTABLECIMIENTO"),
					resultSet.getString("DIRECCION"), resultSet.getString("NUMERO"), resultSet.getString("ESCALERA"),
					resultSet.getString("PISO"), resultSet.getString("LETRA"), resultSet.getString("CODIGOPOSTAL"),
					resultSet.getLong("IDPAIS"), resultSet.getLong("IDPROVINCIA"), resultSet.getLong("IDMUNICIPIO"),
					resultSet.getLong("IDLOCALIDAD"), resultSet.getString("DESCRIPCIONPROVINCIAEXTR"),
					resultSet.getString("DESCRIPCIONCIUDADEXTR"), resultSet.getString("IDENTIFICADORESTABLECIMIENTO"),
					new DatosTerceros(resultSet.getInt("IDTERCERO35"), resultSet.getString("DOCUMENTO"),
							new TiposDocumento(null != resultSet.getObject("ID_TIPO_DOCUMENTO")
									? resultSet.getLong("ID_TIPO_DOCUMENTO") : null),
							resultSet.getString("NOMBRE"), resultSet.getString("APELLIDO1"),
							resultSet.getString("APELLIDO2"), null, resultSet.getLong("TELEFONO"),
							resultSet.getString("EMAIL"), null, null),
					new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"), resultSet.getString("DESCASTELLANO"),
							resultSet.getString("DESEUSKERA"), null, null),
					null);
		}
	};
	private RowMapper<DatosDirecciones> rwMapPK = new RowMapper<DatosDirecciones>() {
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new DatosDirecciones(resultSet.getInt("IDDIRECCION"));
		}
	};

	private RowMapper<DatosDirecciones> rwMapUbicacionExpedienteId = new RowMapper<DatosDirecciones>() {
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			DatosDirecciones datosDirecciones = new DatosDirecciones(resultSet.getInt("IDDIRECCION"),
					resultSet.getString("ESTABLECIMIENTO"), resultSet.getString("DIRECCION"),
					resultSet.getString("NUMERO"), resultSet.getString("ESCALERA"), resultSet.getString("PISO"),
					resultSet.getString("LETRA"), resultSet.getString("CODIGOPOSTAL"), resultSet.getLong("IDPAIS"),
					resultSet.getLong("IDPROVINCIA"), resultSet.getLong("IDMUNICIPIO"),
					resultSet.getLong("IDLOCALIDAD"), resultSet.getString("DESCRIPCIONPROVINCIAEXTR"),
					resultSet.getString("DESCRIPCIONCIUDADEXTR"), resultSet.getString("IDENTIFICADORESTABLECIMIENTO"),
					new DatosTerceros(resultSet.getInt("DatosTercerosIDTERCERO"), null, null, null,
							null, null, null, null, null, null, null),
					new TiposDireccion(), null);
			datosDirecciones.setMunicipiodso(resultSet.getString("MUNICIPIODSO"));
			datosDirecciones.setLocalidaddso(resultSet.getString("LOCALIDADDSO"));
			TiposDireccion tipoDir = new TiposDireccion(resultSet.getLong("IDTIPODIRECCION"));
			datosDirecciones.setTiposDireccion(tipoDir);

			return datosDirecciones;
		}
	};
	
	private RowMapper<DatosDirecciones> rwMapDomicilioUbicacion = new RowMapper<DatosDirecciones>() {
		@Override
		public DatosDirecciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosDirecciones datosDirecciones = new DatosDirecciones();
			datosDirecciones.setIdDireccion(resultSet.getInt("IDDIRECCION"));
			datosDirecciones.setDireccion(resultSet.getString("DIRECCION"));
			datosDirecciones.setNumero(resultSet.getString("NUMERO"));
			datosDirecciones.setEscalera(resultSet.getString("ESCALERA"));
			datosDirecciones.setPiso(resultSet.getString("PISO"));
			datosDirecciones.setLetra(resultSet.getString("LETRA"));
			datosDirecciones.setCodigoPostal(resultSet.getString("CODIGOPOSTAL"));
			datosDirecciones.setEstablecimiento(resultSet.getString("ESTABLECIMIENTO"));
			datosDirecciones.setIdentificadorEstablecimiento(resultSet.getString("IDENTESTABLECIMIENTO"));
			datosDirecciones.setComplementoDireccion(resultSet.getString("COMPLEMENTODIRECCION"));
			datosDirecciones.setDescripcionCiudad(resultSet.getString("DESCRIPCIONCIUDAD"));
			datosDirecciones.setDescripcionProvincia(resultSet.getString("DESCRIPCIONPROVINCIA"));
			datosDirecciones.setIdProvincia(resultSet.getLong("IDPROVINCIA"));
			datosDirecciones.setIdMunicipio(resultSet.getLong("IDMUNICIPIO"));
			datosDirecciones.setIdLocalidad(resultSet.getLong("IDLOCALIDAD"));

			DatosTerceros datosTercero = new DatosTerceros();
			datosTercero.setIdTercero(resultSet.getInt("IDTERCERO"));
			datosDirecciones.setDatosTerceros(datosTercero);

			TiposDireccion tipoDireccion = new TiposDireccion();
			tipoDireccion.setIdTipoDireccion(resultSet.getLong("IDTIPODIRECCION"));
			datosDirecciones.setTiposDireccion(tipoDireccion);

			T17Provincia provincia = new T17Provincia();
			provincia.setId(resultSet.getString("IDPROVINCIA"));
			datosDirecciones.setProvincia(provincia);

			T17Municipio municipio = new T17Municipio();
			municipio.setId(resultSet.getString("IDMUNICIPIO"));
			datosDirecciones.setMunicipio(municipio);

			T17Localidad localidad = new T17Localidad();
			localidad.setId(resultSet.getString("IDLOCALIDAD"));
			datosDirecciones.setLocalidad(localidad);

			T17Pais pais = new T17Pais();
			pais.setId(resultSet.getString("IDPAIS"));
			datosDirecciones.setPais(pais);

			return datosDirecciones;
		}
	};

	private RowMapper<JerarquiaDto<DatosDirecciones>> rwMapJerarquia = new RowMapper<JerarquiaDto<DatosDirecciones>>() {
		public JerarquiaDto<DatosDirecciones> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			DatosDirecciones datosdirecciones = new DatosDirecciones(resultSet.getInt("IDDIRECCION"),
					resultSet.getString("ESTABLECIMIENTO"), resultSet.getString("DIRECCION"),
					resultSet.getString("NUMERO"), resultSet.getString("ESCALERA"), resultSet.getString("PISO"),
					resultSet.getString("LETRA"), resultSet.getString("CODIGOPOSTAL"), resultSet.getLong("IDPAIS"),
					resultSet.getLong("IDPROVINCIA"), resultSet.getLong("IDMUNICIPIO"),
					resultSet.getLong("IDLOCALIDAD"), resultSet.getString("DESCRIPCIONPROVINCIAEXTR"),
					resultSet.getString("DESCRIPCIONCIUDADEXTR"), resultSet.getString("IDENTIFICADORESTABLECIMIENTO"),
					new DatosTerceros(resultSet.getInt("DatosTercerosIDTERCERO"),
							resultSet.getString("DatosTercerosDOCUMENTO"),
							new TiposDocumento(resultSet.getLong("ID_TIPO_DOCUMENTO"),
									resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getString("DatosTercerosNOMBRE"), resultSet.getString("DatosTercerosAPELLIDO1"),
							resultSet.getString("DatosTercerosAPELLIDO2"),
							new Sexo(resultSet.getLong("ID_SEXO"), resultSet.getString("DESCRIPCION_CASTELLANO"),
									resultSet.getString("DESCRIPCION_EUSKERA"), resultSet.getDate("FECHA_REGISTRO"),
									resultSet.getString("USUARIO_REGISTRO")),
							resultSet.getLong("DatosTercerosTELEFONO"), resultSet.getString("DatosTercerosEMAIL"),
							resultSet.getInt("DatosTercerosIDIOMA"), resultSet.getInt("DatosTercerosTIPOPARTICIPANTE")),
					new TiposDireccion(resultSet.getLong("TiposDireccionIDTIPODIRECCION"),
							resultSet.getString("TiposDireccionDESCRIPCIONCASTELLANO"),
							resultSet.getString("TiposDireccionDESCRIPCIONEUSKERA"),
							resultSet.getDate("TiposDireccionFECHAREGISTRO"),
							resultSet.getString("TiposDireccionUSUARIOREGISTRO")),
					null);

			JerarquiaDto<DatosDirecciones> jerarquia = new JerarquiaDto<DatosDirecciones>();
			jerarquia.setModel(datosdirecciones);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public DatosDirecciones add(DatosDirecciones datosdirecciones) {
		String query = "INSERT INTO AB78.DATOS_DIRECCIONES (ID_DIRECCION, ID_TERCERO, ID_TIPO_DIRECCION, ESTABLECIMIENTO, DIRECCION, NUMERO, ESCALERA, "
				+ " PISO, LETRA, CODIGO_POSTAL, ID_PROVINCIA, ID_MUNICIPIO, ID_LOCALIDAD,IDENTIFICADOR_ESTABLECIMIENTO, FECHA_REGISTRO, USUARIO_REGISTRO, "
				+ " DESCRIPCION_PROVINCIA,DESCRIPCION_CIUDAD,ID_PAIS) VALUES (AB61.S_AB6136T00.NEXTVAL,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?,?,?,?)";
		Object getDatosTercerosIdTerceroAux = null;
		if (datosdirecciones.getDatosTerceros() != null && datosdirecciones.getDatosTerceros().getIdTercero() != null) {
			getDatosTercerosIdTerceroAux = datosdirecciones.getDatosTerceros().getIdTercero();
		}
		Object getTiposDireccionIdTipoDireccionAux = null;
		if (datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getIdTipoDireccion() != null) {
			getTiposDireccionIdTipoDireccionAux = datosdirecciones.getTiposDireccion().getIdTipoDireccion();
		}
		this.jdbcTemplate.update(query, getDatosTercerosIdTerceroAux, getTiposDireccionIdTipoDireccionAux,
				datosdirecciones.getEstablecimiento(), datosdirecciones.getDireccion(), datosdirecciones.getNumero(),
				datosdirecciones.getEscalera(), datosdirecciones.getPiso(), datosdirecciones.getLetra(),
				datosdirecciones.getCodigoPostal(), datosdirecciones.getIdProvincia(),
				datosdirecciones.getIdMunicipio(), datosdirecciones.getIdLocalidad(),
				datosdirecciones.getIdentificadorEstablecimiento(), UtilUsuario.getUserConnected(),
				datosdirecciones.getDescProvinciaExtranjera(), datosdirecciones.getDescCiudadExtranjera(),
				datosdirecciones.getIdPais());
		return datosdirecciones;
	}

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	public DatosDirecciones addDireccionDenuncia(DatosDirecciones datosdirecciones) {
		Long idDireccion = UtilDao.getNextId(jdbcTemplate, "AB61.S_AB6136T00");
		datosdirecciones.setIdDireccion(idDireccion.intValue());
		String query = "INSERT INTO AB78.DATOS_DIRECCIONES (ID_DIRECCION, ID_TERCERO, ID_TIPO_DIRECCION, ESTABLECIMIENTO, DIRECCION, NUMERO, ESCALERA, PISO, LETRA, "
				+ " CODIGO_POSTAL, ID_PROVINCIA, ID_MUNICIPIO, ID_LOCALIDAD,IDENTIFICADOR_ESTABLECIMIENTO, FECHA_REGISTRO, USUARIO_REGISTRO, "
				+ " DESCRIPCION_PROVINCIA,DESCRIPCION_CIUDAD,ID_PAIS) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?,?,?,?)";
		Object getDatosTercerosIdTerceroAux = null;
		if (datosdirecciones.getDatosTerceros() != null && datosdirecciones.getDatosTerceros().getIdTercero() != null) {
			getDatosTercerosIdTerceroAux = datosdirecciones.getDatosTerceros().getIdTercero();
		}
		Object getTiposDireccionIdTipoDireccionAux = null;
		if (datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getIdTipoDireccion() != null) {
			getTiposDireccionIdTipoDireccionAux = datosdirecciones.getTiposDireccion().getIdTipoDireccion();
		}
		this.jdbcTemplate.update(query, idDireccion, getDatosTercerosIdTerceroAux, getTiposDireccionIdTipoDireccionAux,
				datosdirecciones.getEstablecimiento(), datosdirecciones.getDireccion(), datosdirecciones.getNumero(),
				datosdirecciones.getEscalera(), datosdirecciones.getPiso(), datosdirecciones.getLetra(),
				datosdirecciones.getCodigoPostal(), datosdirecciones.getIdProvincia(),
				datosdirecciones.getIdMunicipio(), datosdirecciones.getIdLocalidad(),
				datosdirecciones.getIdentificadorEstablecimiento(), UtilUsuario.getUserConnected(),
				datosdirecciones.getDescProvinciaExtranjera(), datosdirecciones.getDescCiudadExtranjera(),
				datosdirecciones.getIdPais());
		return datosdirecciones;
	}

	/**
	 * Updates a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	public DatosDirecciones update(DatosDirecciones datosdirecciones) {

		String query = "UPDATE AB78.DATOS_DIRECCIONES SET  DIRECCION=?, NUMERO=?, ESTABLECIMIENTO=?, IDENTIFICADOR_ESTABLECIMIENTO = ?, ESCALERA=?,   PISO=?,  LETRA=?,   CODIGO_POSTAL=?, "
				+ "  ID_PROVINCIA=?,  ID_MUNICIPIO=?,   ID_LOCALIDAD=?,   FECHA_ULTMODIFICACION=SYSDATE,  DESCRIPCION_PROVINCIA=?, DESCRIPCION_CIUDAD=?, ID_PAIS=?, USUARIO_ULTMODIFICACION=?  "
				+ " WHERE ID_DIRECCION = ?";

		this.jdbcTemplate.update(query, datosdirecciones.getDireccion(), datosdirecciones.getNumero(),
				datosdirecciones.getEstablecimiento(), datosdirecciones.getIdentificadorEstablecimiento(),
				datosdirecciones.getEscalera(), datosdirecciones.getPiso(), datosdirecciones.getLetra(),
				datosdirecciones.getCodigoPostal(), datosdirecciones.getIdProvincia(),
				datosdirecciones.getIdMunicipio(), datosdirecciones.getIdLocalidad(),
				datosdirecciones.getDescProvinciaExtranjera(), datosdirecciones.getDescCiudadExtranjera(),
				datosdirecciones.getIdPais(), UtilUsuario.getUserConnected(), datosdirecciones.getIdDireccion());

		return datosdirecciones;
	}

	@Transactional(readOnly = true)
	public DatosDirecciones find(DatosDirecciones datosdirecciones) {
		String query = "SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, "
				+ " T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, "
				+ " T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, "
				+ " T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t4.ID_TIPO_DOCUMENTO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,"
				+ " t4.USUARIO_REGISTRO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t5.ID_SEXO,t5.DESCRIPCION_CASTELLANO,"
				+ " t5.DESCRIPCION_EUSKERA,t5.FECHA_REGISTRO,t5.USUARIO_REGISTRO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, "
				+ " T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, "
				+ " T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, "
				+ " T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, "
				+ " T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE "
				+ " FROM AB78.DATOS_DIRECCIONES t1, AB78.DATOS_TERCERO t2 , AB78.TIPO_DIRECCION t3, AB78.TIPOS_DOCUMENTO t4, AB78.SEXO t5  WHERE t1.ID_DIRECCION = ? AND t2.ID_TIPO_DOCUMENTO = t4.ID_TIPO_DOCUMENTO(+) AND t2.ID_SEXO = t5.ID_SEXO(+) AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+)";

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMap,
				datosdirecciones.getIdDireccion());
		return DataAccessUtils.uniqueResult(datosdireccionesList);
	}

	/**
	 * Finds las ubicaciones del terceros solicitante
	 *
	 * @param idTercero
	 *            Integer
	 * @return DatosDirecciones
	 */
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findUbicacionTerceroId(Integer idTercero) {
		String query = "SELECT T1.ID_DIRECCION IDDIRECCION, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.ESTABLECIMIENTO ESTABLECIMIENTO, "
				+ " t1.ID_TERCERO IDTERCERO, t1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.DIRECCION DIRECCION, t1.NUMERO NUMERO, t1.ESCALERA ESCALERA, t1.PISO PISO, t1.LETRA LETRA, "
				+ " t1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, t1.ID_PROVINCIA IDPROVINCIA, t1.ID_MUNICIPIO IDMUNICIPIO, t1.ID_LOCALIDAD IDLOCALIDAD, "
				+ " T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, t3.ID_TIPO_DIRECCION IDTIPODIRECCION, "
				+ " t3.DESCRIPCION_CASTELLANO DESCASTELLANO, t3.DESCRIPCION_EUSKERA DESEUSKERA "
				+ " FROM AB78.DATOS_DIRECCIONES t1 , AB78.TIPO_DIRECCION t3, AB78.DATOS_TERCERO t2 "
				+ " WHERE t1.ID_TERCERO = ? and t1.ID_TERCERO  = t2.ID_TERCERO AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+)";

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMapUbicacionTerceroId,
				idTercero);
		return datosdireccionesList;
	}

	@Transactional(readOnly = true)
	public List<DatosDirecciones> findInfoContactoTercero(Integer idTercero) {
		String query = "SELECT T2.ID_DIRECCION IDDIRECCION, T2.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T2.ESTABLECIMIENTO ESTABLECIMIENTO, "
				+ " T2.ID_TERCERO IDTERCERO, T2.ESTABLECIMIENTO ESTABLECIMIENTO, T2.DIRECCION DIRECCION, T2.NUMERO NUMERO, T2.ESCALERA ESCALERA, T2.PISO PISO, T2.LETRA LETRA, "
				+ " T2.CODIGO_POSTAL CODIGOPOSTAL, T2.ID_PAIS IDPAIS, T2.ID_PROVINCIA IDPROVINCIA, T2.ID_MUNICIPIO IDMUNICIPIO, T2.ID_LOCALIDAD IDLOCALIDAD, "
				+ " T2.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T2.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.ID_TERCERO IDTERCERO35, T1.DOCUMENTO, T1.ID_TIPO_DOCUMENTO, "
				+ " T1.NOMBRE, T1.APELLIDO1, T1.APELLIDO2, T1.TELEFONO, T1.EMAIL, T3.ID_TIPO_DIRECCION IDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO DESCASTELLANO, "
				+ " T3.DESCRIPCION_EUSKERA DESEUSKERA FROM AB78.DATOS_TERCERO T1, AB78.TIPO_DIRECCION T3, (SELECT ID_DIRECCION, ID_TERCERO, IDENTIFICADOR_ESTABLECIMIENTO, ESTABLECIMIENTO, "
				+ " DIRECCION, NUMERO, ESCALERA, PISO, LETRA, CODIGO_POSTAL, ID_PAIS, ID_PROVINCIA, ID_MUNICIPIO, ID_LOCALIDAD, DESCRIPCION_PROVINCIA, DESCRIPCION_CIUDAD, ID_TIPO_DIRECCION "
				+ " FROM AB78.DATOS_DIRECCIONES WHERE ID_TIPO_DIRECCION = 4 ) T2 "
				+ " WHERE T1.ID_TERCERO =? AND T1.ID_TERCERO = T2.ID_TERCERO (+) AND T2.ID_TIPO_DIRECCION = T3.ID_TIPO_DIRECCION (+)";
		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMapInfoContactoTercero,
				idTercero);
		return datosdireccionesList;
	}

	/**
	 * Finds las ubicaciones del terceros solicitante
	 *
	 * @param idTercero
	 *            Integer
	 * @return DatosDirecciones
	 */
	@Transactional(readOnly = true)
	public DatosDirecciones findPostalTerceroId(Integer idTercero) {
		String query = "SELECT T1.ID_DIRECCION IDDIRECCION, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.ESTABLECIMIENTO ESTABLECIMIENTO, "
				+ " t1.ID_TERCERO IDTERCERO, t1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.DIRECCION DIRECCION, t1.NUMERO NUMERO, t1.ESCALERA ESCALERA, t1.PISO PISO, t1.LETRA LETRA, "
				+ " t1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, t1.ID_PROVINCIA IDPROVINCIA, t1.ID_MUNICIPIO IDMUNICIPIO, t1.ID_LOCALIDAD IDLOCALIDAD, "
				+ " T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, t3.ID_TIPO_DIRECCION IDTIPODIRECCION, t3.DESCRIPCION_CASTELLANO DESCASTELLANO,"
				+ " t3.DESCRIPCION_EUSKERA DESEUSKERA "
				+ " FROM AB78.DATOS_DIRECCIONES t1 , TIPO_DIRECCION t3, DATOS_TERCERO t2 "
				+ " WHERE t1.ID_TERCERO  = ? AND  t1.ID_TIPO_DIRECCION = 4 and t1.ID_TERCERO  = t2.ID_TERCERO AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ";

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMapUbicacionTerceroId,
				idTercero);
		if (datosdireccionesList.isEmpty()) {
			return new DatosDirecciones();
		}

		return datosdireccionesList.get(0);
	}

	/**
	 * Finds las ubicaciones del terceros solicitante
	 *
	 * @param idTercero
	 *            Integer
	 * @return DatosDirecciones
	 */
	@Transactional(readOnly = true)
	public DatosDirecciones findEstablecimientoExpediente(Integer idExpediente) {
		StringBuffer query = new StringBuffer(
				"SELECT direcciones.ID_DIRECCION IDDIRECCION, direcciones.ID_TIPO_DIRECCION IDTIPODIRECCION, direcciones.ESTABLECIMIENTO ESTABLECIMIENTO, direcciones.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, direcciones.DIRECCION DIRECCION, direcciones.NUMERO NUMERO, direcciones.ESCALERA ESCALERA, direcciones.PISO PISO, direcciones.LETRA LETRA, direcciones.CODIGO_POSTAL CODIGOPOSTAL, direcciones.ID_PAIS IDPAIS, direcciones.ID_PROVINCIA IDPROVINCIA, direcciones.ID_MUNICIPIO IDMUNICIPIO, direcciones.ID_LOCALIDAD IDLOCALIDAD, direcciones.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, direcciones.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, direcciones.FECHA_REGISTRO FECHAREGISTRO, direcciones.USUARIO_REGISTRO USUARIOREGISTRO, direcciones.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, direcciones.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, direcciones.ID_TERCERO DATOSTERCEROSIDTERCERO, municipio.ds_o MUNICIPIODSO, localidad.ds_o LOCALIDADDSO ");
		query.append(" FROM AB78.DATOS_DIRECCIONES direcciones ")
				.append(" INNER JOIN AB78.REL_EXP_TER relTer ON relTer.ID_TERCERO = direcciones.ID_TERCERO AND direcciones.ID_TIPO_DIRECCION = 2 ")
				.append(" LEFT JOIN AB78.MUNICIPIOS municipio ON municipio.ID = direcciones.ID_MUNICIPIO AND direcciones.ID_PROVINCIA = municipio.PROVINCIA_ID ")
				.append(" LEFT JOIN AB78.LOCALIDADES localidad ON localidad.ID = direcciones.ID_LOCALIDAD AND localidad.MUNICIPIO_ID = direcciones.ID_MUNICIPIO AND direcciones.ID_PROVINCIA = localidad.PROVINCIA_ID ")
				.append(" WHERE relTer.ID_EXPEDIENTE = ? ");
		List<DatosDirecciones> list = this.jdbcTemplate.query(query.toString(), this.rwMapUbicacionExpedienteId,
				idExpediente);
		if (list.isEmpty()) {
			return new DatosDirecciones();
		} else {
			return list.get(0);
		}
	}

	/**
	 * Finds las ubicaciones relacionadas del terceros solicitante
	 *
	 * @param idTercero
	 *            Integer
	 * @return DatosDirecciones
	 */
	@Transactional(readOnly = true)
	public DatosDirecciones findEstablecimientoRelacionadoExpediente(Integer idExpediente) {
		StringBuffer query = new StringBuffer(
				"SELECT direcciones.ID_DIRECCION IDDIRECCION, direcciones.ID_TIPO_DIRECCION IDTIPODIRECCION, direcciones.ESTABLECIMIENTO ESTABLECIMIENTO, direcciones.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, direcciones.DIRECCION DIRECCION, direcciones.NUMERO NUMERO, direcciones.ESCALERA ESCALERA, direcciones.PISO PISO, direcciones.LETRA LETRA, direcciones.CODIGO_POSTAL CODIGOPOSTAL, direcciones.ID_PAIS IDPAIS, direcciones.ID_PROVINCIA IDPROVINCIA, direcciones.ID_MUNICIPIO IDMUNICIPIO, direcciones.ID_LOCALIDAD IDLOCALIDAD, direcciones.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, direcciones.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, direcciones.FECHA_REGISTRO FECHAREGISTRO, direcciones.USUARIO_REGISTRO USUARIOREGISTRO, direcciones.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, direcciones.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, direcciones.ID_TERCERO DATOSTERCEROSIDTERCERO, municipio.ds_o MUNICIPIODSO, localidad.ds_o LOCALIDADDSO ");
		query.append(" FROM AB78.DATOS_DIRECCIONES direcciones ")
				.append(" INNER JOIN AB78.REL_EXP_TER relTer ON relTer.ID_TERCERO = direcciones.ID_TERCERO AND direcciones.ID_TIPO_DIRECCION = 2 ")
				.append(" LEFT JOIN AB78.MUNICIPIOS municipio ON municipio.ID = direcciones.ID_MUNICIPIO AND direcciones.ID_PROVINCIA = municipio.PROVINCIA_ID ")
				.append(" LEFT JOIN AB78.LOCALIDADES localidad ON localidad.ID = direcciones.ID_LOCALIDAD AND localidad.MUNICIPIO_ID = direcciones.ID_MUNICIPIO AND direcciones.ID_PROVINCIA = localidad.PROVINCIA_ID ")
				.append(" WHERE relTer.ID_EXPEDIENTE = ? AND direcciones.IDENTIFICADO_ESTABLECIMIENTO IS NOT NULL");
		List<DatosDirecciones> list = this.jdbcTemplate.query(query.toString(), this.rwMapUbicacionExpedienteId,
				idExpediente);
		if (list.isEmpty()) {
			return new DatosDirecciones();
		} else {
			return list.get(0);
		}
	}

	/**
	 * Removes a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return
	 */
	public void remove(DatosDirecciones datosdirecciones) {
		String query = "DELETE FROM AB78.DATOS_DIRECCIONES WHERE ID_DIRECCION=?";
		this.jdbcTemplate.update(query, datosdirecciones.getIdDireccion());
	}

	/**
	 * Borrar los canaels de aviso de un tercero
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return
	 */
	public void removeDireccionesTercero(Integer idTercero) {
		String query = "DELETE FROM AB78.DATOS_DIRECCIONES WHERE ID_TERCERO=?";
		this.jdbcTemplate.update(query, idTercero);
	}

	/**
	 * Finds a list of rows in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<DatosDirecciones>
	 */
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findAll(DatosDirecciones datosdirecciones, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO,T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t4.ID_TIPO_DOCUMENTO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t5.ID_SEXO,t5.DESCRIPCION_CASTELLANO,t5.DESCRIPCION_EUSKERA,t5.FECHA_REGISTRO,t5.USUARIO_REGISTRO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		query.append(
				" FROM AB78.DATOS_DIRECCIONES t1 , AB78.DATOS_TERCERO t2 ,AB78.TIPO_DIRECCION t3, AB78.TIPOS_DOCUMENTO t4, AB78.SEXO t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosdirecciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t2.ID_TIPO_DOCUMENTO = t4.ID_TIPO_DOCUMENTO(+) AND t2.ID_SEXO = t5.ID_SEXO(+) AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query,
					DatosDireccionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<DatosDirecciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the DatosDirecciones table using like.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<DatosDirecciones>
	 */
	@Transactional(readOnly = true)
	public List<DatosDirecciones> findAllLike(DatosDirecciones datosdirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO,T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t4.ID_TIPO_DOCUMENTO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t5.ID_SEXO,t5.DESCRIPCION_CASTELLANO,t5.DESCRIPCION_EUSKERA,t5.FECHA_REGISTRO,t5.USUARIO_REGISTRO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		query.append(
				" FROM AB78.DATOS_DIRECCIONES t1, AB78.DATOS_TERCERO t2, AB78.TIPO_DIRECCION t3, AB78.TIPOS_DOCUMENTO t4, AB78.SEXO t5 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosdirecciones, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t2.ID_TIPO_DOCUMENTO = t4.ID_TIPO_DOCUMENTO AND t2.ID_SEXO = t5.ID_SEXO AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query,
					DatosDireccionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<DatosDirecciones>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	@Override
	public DatosDirecciones buscarEstablecimiento(String numeroRegistro) {
		StringBuilder query = new StringBuilder();

		query.append("SELECT t1.NOMBRE_COMERCIAL ESTABLECIMIENTO, t6136.IDENTIFICADOR_ESTABLECIMIENTO IDENTESTABLECIMIENTO");
		query.append(
				", t6136.ID_DIRECCION IDDIRECCION, t6136.ID_TIPO_DIRECCION IDTIPODIRECCION, t6136.ID_PROVINCIA IDPROVINCIA");
		query.append(", t6136.ID_MUNICIPIO IDMUNICIPIO, t6136.ID_LOCALIDAD IDLOCALIDAD");
		query.append(", t6136.DIRECCION DIRECCION, t6136.NUMERO NUMERO, t6136.ESCALERA ESCALERA");
		query.append(
				", t6136.PISO PISO, t6136.LETRA LETRA, t6136.CODIGO_POSTAL CODIGOPOSTAL, t6136.COMPLEMENTO_DIRECCION COMPLEMENTODIRECCION");
		query.append(
				", t6136.DESCRIPCION_CIUDAD DESCRIPCIONCIUDAD, t6136.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIA, t6136.ID_PAIS IDPAIS, t6136.ID_TERCERO IDTERCERO ");
		query.append(" FROM ESTABLECIMIENTOS_REGISTRADOS t1, REL_EST_DIR t2, DATOS_DIRECCIONES t6136");
		query.append(" WHERE t1.ID_ESTABLECIMIENTO = t2.ID_ESTABLECIMIENTO AND t2.ID_DIRECCION = t6136.ID_DIRECCION");
		query.append(" AND t6136.ID_TIPO_DIRECCION = ? AND t1.IDENTIFICADOR_ESTABLECIMIENTO = ?");

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query.toString(),
				this.rwMapDomicilioUbicacion, Constantes.ID_DIRECCION_ACTIVIDAD, numeroRegistro);
		return DataAccessUtils.uniqueResult(datosdireccionesList);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosDirecciones datosdirecciones) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.DATOS_DIRECCIONES t1 , AB78.DATOS_TERCERO t2 , AB78.TIPO_DIRECCION t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(datosdirecciones);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the DatosDirecciones table using like.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosDirecciones datosdirecciones, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.DATOS_DIRECCIONES t1 ,AB78.DATOS_TERCERO t2 ,AB78.TIPO_DIRECCION t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosdirecciones, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of DatosDirecciones selected for rup_table
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	@Override
	public List<TableRowDto<DatosDirecciones>> reorderSelection(DatosDirecciones datosdirecciones,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO,t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, T2.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, T2.ID_SEXO DATOSTERCEROSIDSEXO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		// FROM
		query.append("FROM AB78.DATOS_DIRECCIONES t1 ,AB78.DATOS_TERCERO t2 ,AB78.TIPO_DIRECCION t3 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(datosdirecciones, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto,
				DatosDirecciones.class, filterParamList, "ID_DIRECCION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DatosDirecciones>(this.rwMapPK, TableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            DatosDirecciones
	 * @param searchParams
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	@Override
	public List<TableRowDto<DatosDirecciones>> search(DatosDirecciones filterParams, DatosDirecciones searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, T2.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, T2.ID_SEXO DATOSTERCEROSIDSEXO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		// FROM
		query.append("FROM AB78.DATOS_DIRECCIONES t1 ,AB78.DATOS_TERCERO t2 ,AB78.TIPO_DIRECCION t3 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TERCERO= t2.ID_TERCERO(+) AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto,
				DatosDirecciones.class, filterParamList, searchSQL, searchParamList, from_alias, "ID_DIRECCION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DatosDirecciones>(this.rwMapPK, TableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterdatosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(DatosDirecciones filterdatosdirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, T2.ID_TIPO_DOCUMENTO DATOSTERCEROSIDTIPODOCUMENTO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, T2.ID_SEXO DATOSTERCEROSIDSEXO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		// FROM
		query.append("FROM AB78.DATOS_DIRECCIONES t1 ,AB78.DATOS_TERCERO t2 ,AB78.TIPO_DIRECCION t3 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterdatosdirecciones, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, DatosDirecciones.class,
				query, params, "ID_DIRECCION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<DatosDirecciones>>
	 */
	@Override
	public List<JerarquiaDto<DatosDirecciones>> findAllLikeJerarquia(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR, T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t4.ID_TIPO_DOCUMENTO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,t4.USUARIO_REGISTRO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t5.ID_SEXO,t5.DESCRIPCION_CASTELLANO,t5.DESCRIPCION_EUSKERA,t5.FECHA_REGISTRO,t5.USUARIO_REGISTRO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM DATOS_DIRECCIONES t1
		// ,DATOS_TERCERO t2 ,TIPO_DIRECCION t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.DATOS_DIRECCIONES");
		from.add("AB78.DATOS_TERCERO");
		from.add("AB78.TIPO_DIRECCION");

		from.add("AB78.TIPOS_DOCUMENTO");
		from.add("AB78.SEXO");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		from_alias.add(" t4 ");
		from_alias.add(" t5 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterDatosDirecciones, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_DIRECCION", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					DatosDireccionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM DATOS_DIRECCIONES t1
		// ,DATOS_TERCERO t2 ,TIPO_DIRECCION t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.DATOS_DIRECCIONES");
		from.add("AB78.DATOS_TERCERO");
		from.add("AB78.TIPO_DIRECCION");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterDatosDirecciones, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_DIRECCION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	@Override
	public List<TableRowDto<DatosDirecciones>> findAllChild(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM DATOS_DIRECCIONES t1
		// ,DATOS_TERCERO t2 ,TIPO_DIRECCION t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.DATOS_DIRECCIONES");
		from.add("AB78.DATOS_TERCERO");
		from.add("AB78.TIPO_DIRECCION");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterDatosDirecciones, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_DIRECCION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<DatosDirecciones>(this.rwMapPK, "ID_DIRECCION"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosDirecciones entity
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosDirecciones datosdirecciones) {

		StringBuilder where = new StringBuilder(DatosDireccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosdirecciones != null && datosdirecciones.getIdDireccion() != null) {
			where.append(" AND t1.ID_DIRECCION = ?");
			params.add(datosdirecciones.getIdDireccion());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getIdTercero() != null) {
			where.append(" AND t2.ID_TERCERO = ?");
			params.add(datosdirecciones.getDatosTerceros().getIdTercero());
		}

		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getDocumento() != null) {
			where.append(" AND t2.DOCUMENTO = ?");
			params.add(datosdirecciones.getDatosTerceros().getDocumento());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTiposDocumento() != null
				&& datosdirecciones.getDatosTerceros().getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t2.ID_TIPO_DOCUMENTO = ?");
			params.add(datosdirecciones.getDatosTerceros().getTiposDocumento().getIdTipoDocumento());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getNombre() != null) {
			where.append(" AND t2.NOMBRE = ?");
			params.add(datosdirecciones.getDatosTerceros().getNombre());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getApellido1() != null) {
			where.append(" AND t2.APELLIDO1 = ?");
			params.add(datosdirecciones.getDatosTerceros().getApellido1());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getApellido2() != null) {
			where.append(" AND t2.APELLIDO2 = ?");
			params.add(datosdirecciones.getDatosTerceros().getApellido2());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getSexo() != null
				&& datosdirecciones.getDatosTerceros().getSexo().getIdSexo() != null) {
			where.append(" AND t2.ID_SEXO = ?");
			params.add(datosdirecciones.getDatosTerceros().getSexo().getIdSexo());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(datosdirecciones.getDatosTerceros().getTelefono());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(datosdirecciones.getDatosTerceros().getEmail());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(datosdirecciones.getDatosTerceros().getIdioma());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTipoParticipante() != null) {
			where.append(" AND t2.TIPO_PARTICIPANTE = ?");
			params.add(datosdirecciones.getDatosTerceros().getTipoParticipante());
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getIdTipoDireccion() != null) {
			where.append(" AND t3.ID_TIPO_DIRECCION = ?");
			params.add(datosdirecciones.getTiposDireccion().getIdTipoDireccion());
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getDescripcionCastellano() != null) {
			where.append(" AND t3.DESCRIPCION_CASTELLANO = ?");
			params.add(datosdirecciones.getTiposDireccion().getDescripcionCastellano());
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getDescripcionEuskera() != null) {
			where.append(" AND t3.DESCRIPCION_EUSKERA = ?");
			params.add(datosdirecciones.getTiposDireccion().getDescripcionEuskera());
		}
		if (datosdirecciones != null && datosdirecciones.getDireccion() != null) {
			where.append(" AND t1.DIRECCION = ?");
			params.add(datosdirecciones.getDireccion());
		}
		if (datosdirecciones != null && datosdirecciones.getNumero() != null) {
			where.append(" AND t1.NUMERO = ?");
			params.add(datosdirecciones.getNumero());
		}
		if (datosdirecciones != null && datosdirecciones.getEscalera() != null) {
			where.append(" AND t1.ESCALERA = ?");
			params.add(datosdirecciones.getEscalera());
		}
		if (datosdirecciones != null && datosdirecciones.getPiso() != null) {
			where.append(" AND t1.PISO = ?");
			params.add(datosdirecciones.getPiso());
		}
		if (datosdirecciones != null && datosdirecciones.getLetra() != null) {
			where.append(" AND t1.LETRA = ?");
			params.add(datosdirecciones.getLetra());
		}
		if (datosdirecciones != null && datosdirecciones.getCodigoPostal() != null) {
			where.append(" AND t1.CODIGO_POSTAL = ?");
			params.add(datosdirecciones.getCodigoPostal());
		}
		if (datosdirecciones != null && datosdirecciones.getIdProvincia() != null) {
			where.append(" AND t1.ID_PROVINCIA = ?");
			params.add(datosdirecciones.getIdProvincia());
		}
		if (datosdirecciones != null && datosdirecciones.getIdMunicipio() != null) {
			where.append(" AND t1.ID_MUNICIPIO = ?");
			params.add(datosdirecciones.getIdMunicipio());
		}
		if (datosdirecciones != null && datosdirecciones.getIdLocalidad() != null) {
			where.append(" AND t1.ID_LOCALIDAD = ?");
			params.add(datosdirecciones.getIdLocalidad());
		}
		if (datosdirecciones != null && datosdirecciones.getIdentificadorEstablecimiento() != null) {
			where.append(" AND t1.IDENTIFICADOR_ESTABLECIMIENTO = ?");
			params.add(datosdirecciones.getIdentificadorEstablecimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the DatosDirecciones entity
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DatosDirecciones datosdirecciones, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DatosDireccionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (datosdirecciones != null && datosdirecciones.getIdDireccion() != null) {
			where.append(" AND t1.ID_DIRECCION = ?");
			params.add(datosdirecciones.getIdDireccion());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getIdTercero() != null) {
			where.append(" AND t2.ID_TERCERO = ?");
			params.add(datosdirecciones.getDatosTerceros().getIdTercero());
		}

		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getDocumento() != null) {
			where.append(" AND UPPER(t2.DOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDatosTerceros().getDocumento().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDatosTerceros().getDocumento().toUpperCase() + "%");
			}
			where.append(" AND t2.DOCUMENTO IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTiposDocumento() != null
				&& datosdirecciones.getDatosTerceros().getTiposDocumento().getIdTipoDocumento() != null) {
			where.append(" AND t2.ID_TIPO_DOCUMENTO = ?");
			params.add(datosdirecciones.getDatosTerceros().getTiposDocumento().getIdTipoDocumento());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getNombre() != null) {
			where.append(" AND UPPER(t2.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDatosTerceros().getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDatosTerceros().getNombre().toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getApellido1() != null) {
			where.append(" AND UPPER(t2.APELLIDO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDatosTerceros().getApellido1().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDatosTerceros().getApellido1().toUpperCase() + "%");
			}
			where.append(" AND t2.APELLIDO1 IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getApellido2() != null) {
			where.append(" AND UPPER(t2.APELLIDO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDatosTerceros().getApellido2().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDatosTerceros().getApellido2().toUpperCase() + "%");
			}
			where.append(" AND t2.APELLIDO2 IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getSexo() != null
				&& datosdirecciones.getDatosTerceros().getSexo().getIdSexo() != null) {
			where.append(" AND t2.ID_SEXO = ?");
			params.add(datosdirecciones.getDatosTerceros().getSexo().getIdSexo());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(datosdirecciones.getDatosTerceros().getTelefono());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getEmail() != null) {
			where.append(" AND UPPER(t2.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDatosTerceros().getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDatosTerceros().getEmail().toUpperCase() + "%");
			}
			where.append(" AND t2.EMAIL IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getIdioma() != null) {
			where.append(" AND t2.IDIOMA = ?");
			params.add(datosdirecciones.getDatosTerceros().getIdioma());
		}
		if (datosdirecciones != null && datosdirecciones.getDatosTerceros() != null
				&& datosdirecciones.getDatosTerceros().getTipoParticipante() != null) {
			where.append(" AND t2.TIPO_PARTICIPANTE = ?");
			params.add(datosdirecciones.getDatosTerceros().getTipoParticipante());
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getIdTipoDireccion() != null) {
			where.append(" AND t3.ID_TIPO_DIRECCION = ?");
			params.add(datosdirecciones.getTiposDireccion().getIdTipoDireccion());
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t3.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getTiposDireccion().getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getTiposDireccion().getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t3.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getTiposDireccion() != null
				&& datosdirecciones.getTiposDireccion().getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t3.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getTiposDireccion().getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getTiposDireccion().getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t3.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getDireccion() != null) {
			where.append(" AND UPPER(t1.DIRECCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getDireccion().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getDireccion().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRECCION IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getNumero() != null) {
			where.append(" AND UPPER(t1.NUMERO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getNumero().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getNumero().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMERO IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getEscalera() != null) {
			where.append(" AND UPPER(t1.ESCALERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getEscalera().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getEscalera().toUpperCase() + "%");
			}
			where.append(" AND t1.ESCALERA IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getPiso() != null) {
			where.append(" AND UPPER(t1.PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getPiso().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getPiso().toUpperCase() + "%");
			}
			where.append(" AND t1.PISO IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getLetra() != null) {
			where.append(" AND UPPER(t1.LETRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getLetra().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getLetra().toUpperCase() + "%");
			}
			where.append(" AND t1.LETRA IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getCodigoPostal() != null) {
			where.append(" AND UPPER(t1.CODIGO_POSTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getCodigoPostal().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getCodigoPostal().toUpperCase() + "%");
			}
			where.append(" AND t1.CODIGO_POSTAL IS NOT NULL");
		}
		if (datosdirecciones != null && datosdirecciones.getIdProvincia() != null) {
			where.append(" AND t1.ID_PROVINCIA = ?");
			params.add(datosdirecciones.getIdProvincia());
		}
		if (datosdirecciones != null && datosdirecciones.getIdMunicipio() != null) {
			where.append(" AND t1.ID_MUNICIPIO = ?");
			params.add(datosdirecciones.getIdMunicipio());
		}
		if (datosdirecciones != null && datosdirecciones.getIdLocalidad() != null) {
			where.append(" AND t1.ID_LOCALIDAD = ?");
			params.add(datosdirecciones.getIdLocalidad());
		}
		if (datosdirecciones != null && datosdirecciones.getIdentificadorEstablecimiento() != null) {
			where.append(" AND UPPER(t1.IDENTIFICADOR_ESTABLECIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(datosdirecciones.getIdentificadorEstablecimiento().toUpperCase() + "%");
			} else {
				params.add("%" + datosdirecciones.getIdentificadorEstablecimiento().toUpperCase() + "%");
			}
			where.append(" AND t1.IDENTIFICADOR_ESTABLECIMIENTO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	@Override
	@Transactional(readOnly = true)
	public DatosDirecciones findByIdTercero(Integer idTitular, long idDireccionActividad) {
		String query = "SELECT T1.ID_DIRECCION IDDIRECCION, T1.DIRECCION DIRECCION, T1.ESTABLECIMIENTO ESTABLECIMIENTO, t1.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO,"
				+ " T1.NUMERO NUMERO, T1.ESCALERA ESCALERA, T1.PISO PISO, T1.LETRA LETRA, T1.CODIGO_POSTAL CODIGOPOSTAL, T1.ID_PAIS IDPAIS, T1.ID_PROVINCIA IDPROVINCIA, "
				+ " T1.ID_MUNICIPIO IDMUNICIPIO, T1.ID_LOCALIDAD IDLOCALIDAD, T1.DESCRIPCION_PROVINCIA DESCRIPCIONPROVINCIAEXTR, T1.DESCRIPCION_CIUDAD DESCRIPCIONCIUDADEXTR,"
				+ " T1.FECHA_REGISTRO FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " T2.ID_TERCERO DATOSTERCEROSIDTERCERO, T2.DOCUMENTO DATOSTERCEROSDOCUMENTO, t4.ID_TIPO_DOCUMENTO,t4.DESCRIPCION_CASTELLANO,t4.DESCRIPCION_EUSKERA,t4.FECHA_REGISTRO,"
				+ " t4.USUARIO_REGISTRO, T2.NOMBRE DATOSTERCEROSNOMBRE, T2.APELLIDO1 DATOSTERCEROSAPELLIDO1, T2.APELLIDO2 DATOSTERCEROSAPELLIDO2, t5.ID_SEXO,t5.DESCRIPCION_CASTELLANO,"
				+ " t5.DESCRIPCION_EUSKERA,t5.FECHA_REGISTRO,t5.USUARIO_REGISTRO, T2.TELEFONO DATOSTERCEROSTELEFONO, T2.EMAIL DATOSTERCEROSEMAIL, T2.IDIOMA DATOSTERCEROSIDIOMA, "
				+ " T2.TIPO_PARTICIPANTE DATOSTERCEROSTIPOPARTICIPANTE, T2.FECHA_REGISTRO DATOSTERCEROSFECHAREGISTRO, T2.USUARIO_REGISTRO DATOSTERCEROSUSUARIOREGISTRO, "
				+ " T2.FECHA_ULTMODIFICACION DATOSTERCEROSFECHAULTMOD, T2.USUARIO_ULTMODIFICACION DATOSTERCEROSUSUARIOULTMOD, T3.ID_TIPO_DIRECCION TIPOSDIRECCIONIDTIPODIRECCION, "
				+ " T3.DESCRIPCION_CASTELLANO TIPOSDIRECCIONDESCCASTELLANO, T3.DESCRIPCION_EUSKERA TIPOSDIRECCIONDESCEUSKERA, T3.FECHA_REGISTRO TIPOSDIRECCIONFECHAREGISTRO, "
				+ " T3.USUARIO_REGISTRO TIPOSDIRECCIONUSUARIOREGISTRO, T2.ID_REPRESENTANTE DATOSTERCEROSIDREPRESENTANTE "
				+ " FROM AB78.DATOS_DIRECCIONES t1, AB78.DATOS_TERCERO t2, AB78.TIPO_DIRECCION t3, AB78.TIPOS_DOCUMENTO t4, AB78.SEXO t5 "
				+ " WHERE t2.ID_TIPO_DOCUMENTO = t4.ID_TIPO_DOCUMENTO(+) AND t2.ID_SEXO = t5.ID_SEXO(+) AND t1.ID_TERCERO= t2.ID_TERCERO(+) "
				+ " AND t1.ID_TIPO_DIRECCION= t3.ID_TIPO_DIRECCION(+) AND t1.ID_TERCERO = ? AND t1.ID_TIPO_DIRECCION = ?";

		List<DatosDirecciones> datosdireccionesList = this.jdbcTemplate.query(query, this.rwMap, idTitular,
				idDireccionActividad);
		if (datosdireccionesList.isEmpty()) {
			return new DatosDirecciones();
		}
		return datosdireccionesList.get(0);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public int updateDireccionEstablecimientoDenunciado(DatosDirecciones datosdirecciones) {

		String query = "UPDATE DATOS_DIRECCIONES SET IDENTIFICADOR_ESTABLECIMIENTO = ?, ID_PAIS = ?, DESCRIPCION_CIUDAD = ?, DESCRIPCION_PROVINCIA = ?, "
				+ " ESTABLECIMIENTO = ?, DIRECCION = ?, NUMERO = ?, ESCALERA = ?, PISO = ?, LETRA = ?, CODIGO_POSTAL = ?, ID_PROVINCIA = ?, ID_MUNICIPIO = ?, ID_LOCALIDAD = ?, "
				+ " FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_DIRECCION = ?";

		return this.jdbcTemplate.update(query, datosdirecciones.getIdentificadorEstablecimiento(),
				datosdirecciones.getIdPais(), datosdirecciones.getDescCiudadExtranjera(),
				datosdirecciones.getDescProvinciaExtranjera(),
				datosdirecciones.getEstablecimiento(), datosdirecciones.getDireccion(), datosdirecciones.getNumero(),
				datosdirecciones.getEscalera(), datosdirecciones.getPiso(), datosdirecciones.getLetra(),
				datosdirecciones.getCodigoPostal(), datosdirecciones.getIdProvincia(),
				datosdirecciones.getIdMunicipio(), datosdirecciones.getIdLocalidad(), UtilUsuario.getUserConnected(),
				datosdirecciones.getIdDireccion());
	}
}
