package com.ejie.ab78.dao.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DatosDireccionesDao  
 * 
 *  
 */

public interface DatosDireccionesDao {

	/**
	 * Inserts a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones add(DatosDirecciones datosdirecciones);

	DatosDirecciones addDireccionDenuncia(DatosDirecciones datosdirecciones);

	/**
	 * Updates a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones update(DatosDirecciones datosdirecciones);

	/**
	 * Finds a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return DatosDirecciones
	 */
	DatosDirecciones find(DatosDirecciones datosdirecciones);

	/**
	 * Removes a single row in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 */
	void remove(DatosDirecciones datosdirecciones);

	void removeDireccionesTercero(Integer idTercero);

	/**
	 * Finds a List of rows in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<DatosDirecciones> findAll(DatosDirecciones datosdirecciones, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the DatosDirecciones table using like.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DatosDirecciones> findAllLike(DatosDirecciones datosdirecciones, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Finds las ubicaciones del terceros solicitante
	 *
	 * @param idTercero
	 *            Integer
	 * @return DatosDirecciones
	 */

	List<DatosDirecciones> findUbicacionTerceroId(Integer idTercero);

	DatosDirecciones findEstablecimientoExpediente(Integer idExpediente);

	DatosDirecciones findPostalTerceroId(Integer idTercero);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the DatosDirecciones table using like.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(DatosDirecciones datosdirecciones, Boolean startsWith);

	/**
	 * Counts rows in the DatosDirecciones table.
	 *
	 * @param datosdirecciones
	 *            DatosDirecciones
	 * @return Long
	 */
	Long findAllCount(DatosDirecciones datosdirecciones);

	/**
	 * Reorder selection.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	List<TableRowDto<DatosDirecciones>> reorderSelection(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param searchDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	List<TableRowDto<DatosDirecciones>> search(DatosDirecciones filterDatosDirecciones,
			DatosDirecciones searchDatosDirecciones, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical DatosDirecciones table.
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<DatosDirecciones>>
	 */
	List<JerarquiaDto<DatosDirecciones>> findAllLikeJerarquia(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(DatosDirecciones filterDatosDirecciones, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterDatosDirecciones
	 *            DatosDirecciones
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<DatosDirecciones>>
	 */
	List<TableRowDto<DatosDirecciones>> findAllChild(DatosDirecciones filterDatosDirecciones,
			TableRequestDto TableRequestDto);

	DatosDirecciones findEstablecimientoRelacionadoExpediente(Integer idExpediente);

	DatosDirecciones findByIdTercero(Integer idTitular, long idDireccionActividad);

	List<DatosDirecciones> findInfoContactoTercero(Integer idTercero);

	int updateDireccionEstablecimientoDenunciado(DatosDirecciones datosdirecciones);
	
	DatosDirecciones buscarEstablecimiento(String numeroRegistro);

}
