package com.ejie.ab78.dao.terceros;

import java.util.List;

import com.ejie.ab78.model.terceros.CanalesAviso;

/**
 * CanalesAvisoDao  
 * 
 *  
 */

public interface CanalesAvisoDao {

	/**
	 * Inserts a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	CanalesAviso add(CanalesAviso canalesaviso);

	/**
	 * Inserts a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	CanalesAviso addCanalesAviso(CanalesAviso canalesaviso);

	/**
	 * Updates a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	CanalesAviso update(CanalesAviso canalesaviso);

	/**
	 * Updates a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	CanalesAviso updateCanalAviso(CanalesAviso canalesaviso);

	/**
	 * Finds a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	CanalesAviso find(CanalesAviso canalesaviso);

	/**
	 * Buscar que canales tiene un id tercero.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return Integer
	 */

	Integer findCanalByIdTercero(CanalesAviso canalesaviso);

	/**
	 * Busca todos los caneles de aviso de un tercero
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	List<CanalesAviso> findCanalesAvisoByIdTercero(Integer idTercero);

	/**
	 * Eliminar un tipo de canal de un id tercero
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return
	 */
	void removeCanalesByIdTercero(CanalesAviso canalesaviso);

	/**
	 * Buscar que canales tiene un id tercero.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return CanalesAviso
	 */
	Integer findTodosLosCanalByIdTercero(Integer idTercero);

	/**
	 * Removes a single row in the CanalesAviso table.
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 */
	void remove(CanalesAviso canalesaviso);

	/**
	 * Borrar los canaels de aviso de un tercero
	 *
	 * @param canalesaviso
	 *            CanalesAviso
	 * @return
	 */
	void removeCanalesTercero(Integer idTercero);

}
