package com.ejie.ab78.dao.procedimientos;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.procedimientos.Areas;
import com.ejie.ab78.model.procedimientos.Departamentos;
import com.ejie.ab78.model.procedimientos.Direcciones;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

@Repository
@Transactional
public class ProcedimientosDaoImpl implements ProcedimientosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDPROCEDIMIENTO", "CODPROCEDUREID", "FOLDERID",
			"FOLDERNUMBER", "CAMPOSTITULOEXPEDIENTE", "FECHAREGISTRO", "USUARIOREGISTRO", "DIRECCIONESIDDIRECCION",
			"DIRECCIONESCASTELLANO", "DIRECCIONESEUSKERA", "DIRECCIONESFECHAREGISTRO", "DIRECCIONESUSUARIOREGISTRO",
			"AREASIDAREA", "AREASDESCRIPCIONCASTELLANO", "AREASDESCRIPCIONEUSKERA", "AREASFECHAREGISTRO",
			"AREASUSUARIOREGISTRO", "DIRECCIONESIDDEPARTAMENTO", "AREASIDDIRECCION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Procedimientos> rwMap = new RowMapper<Procedimientos>() {
		@Override
		public Procedimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Procedimientos procedimiento = new Procedimientos();
			procedimiento.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			procedimiento.setCodProcedureId(resultSet.getString("CODPROCEDUREID"));
			procedimiento.setCamposTituloExpediente(resultSet.getString("CAMPOSTITULOEXPEDIENTE"));
			procedimiento.setDescripcionEs(resultSet.getString("DESCRIPCIONCASTELLANO"));
			procedimiento.setDescripcionEu(resultSet.getString("DESCRIPCIONEUSKERA"));
			procedimiento.setInspeccionable(resultSet.getString("INSPECCIONABLE"));
			procedimiento.setTipoDenuncia(resultSet.getInt("TIPODENUNCIA"));
			if (resultSet.wasNull()) {
				procedimiento.setTipoDenuncia(null);
			}

			Direcciones direccion = new Direcciones();
			direccion.setIdDireccion(resultSet.getInt("DireccionesIDDIRECCION"));
			direccion.setDescripcionCastellano(resultSet.getString("DIRECCIONESCASTELLANO"));
			direccion.setDescripcionEuskera(resultSet.getString("DIRECCIONESEUSKERA"));
			direccion.setDepartamentos(new Departamentos(resultSet.getInt("DireccionesIDDEPARTAMENTO")));

			Areas area = new Areas();
			area.setIdArea(resultSet.getInt("AreasIDAREA"));
			area.setDescripcionCastellano(resultSet.getString("AreasDESCRIPCIONCASTELLANO"));
			area.setDescripcionEuskera(resultSet.getString("AreasDESCRIPCIONEUSKERA"));
			area.setDirecciones(new Direcciones(resultSet.getInt("AreasIDDIRECCION")));

			procedimiento.setDirecciones(direccion);
			procedimiento.setAreas(area);

			return procedimiento;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Procedimientos> rwMapTablaMaestro = new RowMapper<Procedimientos>() {
		@Override
		public Procedimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Procedimientos procedimientos = new Procedimientos();
			procedimientos.setCodProcedureId(resultSet.getString("CODPROCEDUREID"));
			procedimientos.setDescripcionEs(
					resultSet.getString("CODPROCEDUREID") + " - " + resultSet.getString("DESCRIPCIONCASTELLANO"));
			procedimientos.setDescripcionEu(
					resultSet.getString("CODPROCEDUREID") + " - " + resultSet.getString("DESCRIPCIONEUSKERA"));
			procedimientos.setIdProcedimiento(resultSet.getInt("IDPROCEDIMIENTO"));
			return procedimientos;
		}
	};

	private RowMapper<Procedimientos> rwMapPK = new RowMapper<Procedimientos>() {
		@Override
		public Procedimientos mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Procedimientos(resultSet.getInt("IDPROCEDIMIENTO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Procedimientos>> rwMapJerarquia = new RowMapper<JerarquiaDto<Procedimientos>>() {
		@Override
		public JerarquiaDto<Procedimientos> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Procedimientos procedimientos = new Procedimientos(resultSet.getInt("IDPROCEDIMIENTO"),
					resultSet.getString("CODPROCEDUREID"), resultSet.getString("CAMPOSTITULOEXPEDIENTE"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					new Direcciones(resultSet.getInt("DireccionesIDDIRECCION"),
							resultSet.getString("DIRECCIONESCASTELLANO"), resultSet.getString("DIRECCIONESEUSKERA"),
							resultSet.getDate("DireccionesFECHAREGISTRO"),
							resultSet.getString("DireccionesUSUARIOREGISTRO"),
							new Departamentos(resultSet.getInt("DireccionesIDDEPARTAMENTO"), null, null, null, null,
									null)),
					new Areas(resultSet.getInt("AreasIDAREA"), resultSet.getString("AreasDESCRIPCIONCASTELLANO"),
							resultSet.getString("AreasDESCRIPCIONEUSKERA"), resultSet.getDate("AreasFECHAREGISTRO"),
							resultSet.getString("AreasUSUARIOREGISTRO"),
							new Direcciones(resultSet.getInt("AreasIDDIRECCION"), null, null, null, null, null, null,
									null)),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"), null);

			JerarquiaDto<Procedimientos> jerarquia = new JerarquiaDto<Procedimientos>();
			jerarquia.setModel(procedimientos);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Override
	public Procedimientos add(Procedimientos procedimientos) {
		String query = "INSERT INTO AB78.PROCEDIMIENTOS (ID_PROCEDIMIENTO, ID_DIRECCION, ID_AREA, COD_PROCEDURE_ID, CAMPOS_TITULO_EXPEDIENTE, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?,?,?)";
		Object getDireccionesIdDireccionAux = null;
		if (procedimientos.getDirecciones() != null && procedimientos.getDirecciones().getIdDireccion() != null) {
			getDireccionesIdDireccionAux = procedimientos.getDirecciones().getIdDireccion();
		}
		Object getAreasIdAreaAux = null;
		if (procedimientos.getAreas() != null && procedimientos.getAreas().getIdArea() != null) {
			getAreasIdAreaAux = procedimientos.getAreas().getIdArea();
		}
		this.jdbcTemplate.update(query, procedimientos.getIdProcedimiento(), getDireccionesIdDireccionAux,
				getAreasIdAreaAux, procedimientos.getCodProcedureId(), procedimientos.getCamposTituloExpediente(),
				procedimientos.getFechaRegistro(), procedimientos.getUsuarioRegistro());
		return procedimientos;
	}

	/**
	 * Updates a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Override
	public Procedimientos update(Procedimientos procedimientos) {
		String query = "UPDATE AB78.PROCEDIMIENTOS SET ID_DIRECCION=?, ID_AREA=?, COD_PROCEDURE_ID=?, CAMPOS_TITULO_EXPEDIENTE=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=? WHERE ID_PROCEDIMIENTO=?";
		Object getDireccionesIdDireccionAux = null;
		if (procedimientos.getDirecciones() != null && procedimientos.getDirecciones().getIdDireccion() != null) {
			getDireccionesIdDireccionAux = procedimientos.getDirecciones().getIdDireccion();
		}
		Object getAreasIdAreaAux = null;
		if (procedimientos.getAreas() != null && procedimientos.getAreas().getIdArea() != null) {
			getAreasIdAreaAux = procedimientos.getAreas().getIdArea();
		}
		this.jdbcTemplate.update(query, getDireccionesIdDireccionAux, getAreasIdAreaAux,
				procedimientos.getCodProcedureId(), procedimientos.getCamposTituloExpediente(),
				procedimientos.getFechaRegistro(), procedimientos.getUsuarioRegistro(),
				procedimientos.getIdProcedimiento());
		return procedimientos;
	}

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Override
	@Transactional(readOnly = true)
	public Procedimientos find(Procedimientos procedimientos) {
		String query = "SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.INSPECCIONABLE INSPECCIONABLE, t1.TIPO_DENUNCIA TIPODENUNCIA, t2.ID_DIRECCION DIRECCIONESIDDIRECCION, t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO, t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA, t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO, t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO, t3.ID_AREA AREASIDAREA, t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO, t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA, t3.FECHA_REGISTRO AREASFECHAREGISTRO, t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO, t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO, t3.ID_DIRECCION AREASIDDIRECCION FROM AB78.PROCEDIMIENTOS t1 , AB78.DIRECCIONES t2 , AB78.AREAS t3  WHERE t1.ID_PROCEDIMIENTO = ?   AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+)";

		List<Procedimientos> procedimientosList = this.jdbcTemplate.query(query, this.rwMap,
				procedimientos.getIdProcedimiento());
		return DataAccessUtils.uniqueResult(procedimientosList);
	}

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	@Override
	@Transactional(readOnly = true)
	public Procedimientos findProc(Procedimientos procedimientos) {
		String query = "SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.INSPECCIONABLE INSPECCIONABLE, t1.TIPO_DENUNCIA TIPODENUNCIA, t2.ID_DIRECCION DIRECCIONESIDDIRECCION, t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO, t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA, t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO, t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO, t3.ID_AREA AREASIDAREA, t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO, t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA, t3.FECHA_REGISTRO AREASFECHAREGISTRO, t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO, t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO, t3.ID_DIRECCION AREASIDDIRECCION FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3  WHERE t1.COD_PROCEDURE_ID = ? AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+)";

		List<Procedimientos> procedimientosList = this.jdbcTemplate.query(query, this.rwMap,
				procedimientos.getCodProcedureId());
		return DataAccessUtils.uniqueResult(procedimientosList);
	}

	/**
	 * Removes a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return
	 */
	@Override
	public void remove(Procedimientos procedimientos) {
		String query = "DELETE FROM AB78.PROCEDIMIENTOS WHERE ID_PROCEDIMIENTO=?";
		this.jdbcTemplate.update(query, procedimientos.getIdProcedimiento());
	}

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Procedimientos> findAll(Procedimientos procedimientos, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.INSPECCIONABLE INSPECCIONABLE, t1.TIPO_DENUNCIA TIPODENUNCIA,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		query.append("FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(procedimientos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, ProcedimientosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Procedimientos> findAllCenso(Procedimientos procedimientos) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.INSPECCIONABLE INSPECCIONABLE, t1.TIPO_DENUNCIA TIPODENUNCIA,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		query.append("FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3, APLICACIONES t6146 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(procedimientos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) AND t1.ID_APLICACION = t6146.ID_APLICACION"
						+ " AND (SELECT COUNT(1) FROM REL_LIS_PRO t6105 WHERE t1.ID_PROCEDIMIENTO = t6105.ID_PROCEDIMIENTO) > 0"
						+ " AND UPPER(t6146.CODIGO_APLICACION) = UPPER('" + Constantes.CODIGO_APLICACION + "')");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Procedimientos table for Tabla Maestro.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Procedimientos>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Procedimientos> findAllTablaMaestro(Procedimientos procedimientos, Integer idDireccion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO ");
		query.append("FROM PROCEDIMIENTOS t1 JOIN APLICACIONES t6146 ON t1.ID_APLICACION = t6146.ID_APLICACION ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(procedimientos, startsWith);
		StringBuilder where = new StringBuilder("WHERE t6146.CODIGO_APLICACION = '");

		where.append(Constantes.CODIGO_APLICACION);
		where.append("' ");

		if (idDireccion != null && idDireccion != 0) {

			where.append("AND t1.ID_DIRECCION = ");
			where.append(idDireccion);
			where.append(" ");

		}

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), this.rwMapTablaMaestro, params.toArray());
	}

	/**
	 * Finds rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Procedimientos>
	 */
	@Override
	@Transactional(readOnly = true)
	public List<Procedimientos> findAllLike(Procedimientos procedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID, t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.INSPECCIONABLE INSPECCIONABLE, t1.TIPO_DENUNCIA TIPODENUNCIA,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		query.append("FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(procedimientos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, ProcedimientosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Long
	 */
	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(Procedimientos procedimientos) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(procedimientos);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Override
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Procedimientos procedimientos, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(procedimientos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of Procedimientos selected for rup_table
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	@Override
	public List<TableRowDto<Procedimientos>> reorderSelection(Procedimientos procedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		// FROM
		query.append("FROM AB78.PROCEDIMIENTOS t1 ,AB78.DIRECCIONES t2 ,AB78.AREAS t3 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(procedimientos, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto, Procedimientos.class,
				filterParamList, "ID_PROCEDIMIENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Procedimientos>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Procedimientos
	 * @param searchParams
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	@Override
	public List<TableRowDto<Procedimientos>> search(Procedimientos filterParams, Procedimientos searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		// FROM
		query.append("FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_DIRECCION= t2.ID_DIRECCION(+) AND t1.ID_AREA= t3.ID_AREA(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto, Procedimientos.class,
				filterParamList, searchSQL, searchParamList, from_alias, "ID_PROCEDIMIENTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Procedimientos>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterprocedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Procedimientos filterprocedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		// FROM
		query.append("FROM AB78.PROCEDIMIENTOS t1, AB78.DIRECCIONES t2, AB78.AREAS t3 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterprocedimientos, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, Procedimientos.class,
				query, params, "ID_PROCEDIMIENTO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Procedimientos>>
	 */
	@Override
	public List<JerarquiaDto<Procedimientos>> findAllLikeJerarquia(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO,t1.COD_PROCEDURE_ID CODPROCEDUREID,t1.CAMPOS_TITULO_EXPEDIENTE CAMPOSTITULOEXPEDIENTE,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t2.ID_DIRECCION DIRECCIONESIDDIRECCION,t2.DESCRIPCION_CASTELLANO DIRECCIONESCASTELLANO,t2.DESCRIPCION_EUSKERA DIRECCIONESEUSKERA,t2.FECHA_REGISTRO DIRECCIONESFECHAREGISTRO,t2.USUARIO_REGISTRO DIRECCIONESUSUARIOREGISTRO,t3.ID_AREA AREASIDAREA,t3.DESCRIPCION_CASTELLANO AREASDESCRIPCIONCASTELLANO,t3.DESCRIPCION_EUSKERA AREASDESCRIPCIONEUSKERA,t3.FECHA_REGISTRO AREASFECHAREGISTRO,t3.USUARIO_REGISTRO AREASUSUARIOREGISTRO,t2.ID_DEPARTAMENTO DIRECCIONESIDDEPARTAMENTO,t3.ID_DIRECCION AREASIDDIRECCION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM PROCEDIMIENTOS t1
		// ,DIRECCIONES t2 ,AREAS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PROCEDIMIENTOS");
		from.add("AB78.DIRECCIONES");
		from.add("AB78.AREAS");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterProcedimientos, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_PROCEDIMIENTO", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					ProcedimientosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM PROCEDIMIENTOS t1
		// ,DIRECCIONES t2 ,AREAS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PROCEDIMIENTOS");
		from.add("AB78.DIRECCIONES");
		from.add("AB78.AREAS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterProcedimientos, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_PROCEDIMIENTO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Procedimientos>>
	 */
	@Override
	public List<TableRowDto<Procedimientos>> findAllChild(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM PROCEDIMIENTOS t1
		// ,DIRECCIONES t2 ,AREAS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PROCEDIMIENTOS");
		from.add("AB78.DIRECCIONES");
		from.add("AB78.AREAS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterProcedimientos, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_PROCEDIMIENTO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Procedimientos>(this.rwMapPK, "ID_PROCEDIMIENTO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Procedimientos entity
	 *
	 * @param procedimientos
	 *            Procedimientos Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Procedimientos procedimientos) {

		StringBuilder where = new StringBuilder(ProcedimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (procedimientos != null && procedimientos.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(procedimientos.getIdProcedimiento());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getIdDireccion() != null) {
			where.append(" AND t2.ID_DIRECCION = ?");
			params.add(procedimientos.getDirecciones().getIdDireccion());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDepartamentos() != null
				&& procedimientos.getDirecciones().getDepartamentos().getIdDepartamento() != null) {
			where.append(" AND t2.ID_DEPARTAMENTO = ?");
			params.add(procedimientos.getDirecciones().getDepartamentos().getIdDepartamento());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDescripcionCastellano() != null) {
			where.append(" AND t2.DESCRIPCION_CASTELLANO = ?");
			params.add(procedimientos.getDirecciones().getDescripcionCastellano());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDescripcionEuskera() != null) {
			where.append(" AND t2.DESCRIPCION_EUSKERA = ?");
			params.add(procedimientos.getDirecciones().getDescripcionEuskera());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getFechaRegistro() != null) {
			where.append(" AND t2.FECHA_REGISTRO = ?");
			params.add(procedimientos.getDirecciones().getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getUsuarioRegistro() != null) {
			where.append(" AND t2.USUARIO_REGISTRO = ?");
			params.add(procedimientos.getDirecciones().getUsuarioRegistro());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getIdArea() != null) {
			where.append(" AND t3.ID_AREA = ?");
			params.add(procedimientos.getAreas().getIdArea());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDirecciones() != null
				&& procedimientos.getAreas().getDirecciones().getIdDireccion() != null) {
			where.append(" AND t3.ID_DIRECCION = ?");
			params.add(procedimientos.getAreas().getDirecciones().getIdDireccion());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDescripcionCastellano() != null) {
			where.append(" AND t3.DESCRIPCION_CASTELLANO = ?");
			params.add(procedimientos.getAreas().getDescripcionCastellano());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDescripcionEuskera() != null) {
			where.append(" AND t3.DESCRIPCION_EUSKERA = ?");
			params.add(procedimientos.getAreas().getDescripcionEuskera());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getFechaRegistro() != null) {
			where.append(" AND t3.FECHA_REGISTRO = ?");
			params.add(procedimientos.getAreas().getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getUsuarioRegistro() != null) {
			where.append(" AND t3.USUARIO_REGISTRO = ?");
			params.add(procedimientos.getAreas().getUsuarioRegistro());
		}
		if (procedimientos != null && procedimientos.getCodProcedureId() != null) {
			where.append(" AND t1.COD_PROCEDURE_ID = ?");
			params.add(procedimientos.getCodProcedureId());
		}
		if (procedimientos != null && procedimientos.getCamposTituloExpediente() != null) {
			where.append(" AND t1.CAMPOS_TITULO_EXPEDIENTE = ?");
			params.add(procedimientos.getCamposTituloExpediente());
		}
		if (procedimientos != null && procedimientos.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(procedimientos.getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(procedimientos.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Procedimientos entity
	 *
	 * @param procedimientos
	 *            Procedimientos Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Procedimientos procedimientos, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ProcedimientosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (procedimientos != null && procedimientos.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(procedimientos.getIdProcedimiento());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getIdDireccion() != null) {
			where.append(" AND t2.ID_DIRECCION = ?");
			params.add(procedimientos.getDirecciones().getIdDireccion());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDepartamentos() != null
				&& procedimientos.getDirecciones().getDepartamentos().getIdDepartamento() != null) {
			where.append(" AND t2.ID_DEPARTAMENTO = ?");
			params.add(procedimientos.getDirecciones().getDepartamentos().getIdDepartamento());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getDirecciones().getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getDirecciones().getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getDirecciones().getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getDirecciones().getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getFechaRegistro() != null) {
			where.append(" AND t2.FECHA_REGISTRO = ?");
			params.add(procedimientos.getDirecciones().getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getDirecciones() != null
				&& procedimientos.getDirecciones().getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t2.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getDirecciones().getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getDirecciones().getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t2.USUARIO_REGISTRO IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getIdArea() != null) {
			where.append(" AND t3.ID_AREA = ?");
			params.add(procedimientos.getAreas().getIdArea());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDirecciones() != null
				&& procedimientos.getAreas().getDirecciones().getIdDireccion() != null) {
			where.append(" AND t3.ID_DIRECCION = ?");
			params.add(procedimientos.getAreas().getDirecciones().getIdDireccion());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t3.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getAreas().getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getAreas().getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t3.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t3.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getAreas().getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getAreas().getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t3.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getFechaRegistro() != null) {
			where.append(" AND t3.FECHA_REGISTRO = ?");
			params.add(procedimientos.getAreas().getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getAreas() != null
				&& procedimientos.getAreas().getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t3.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getAreas().getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getAreas().getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t3.USUARIO_REGISTRO IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getCodProcedureId() != null) {
			where.append(" AND UPPER(t1.COD_PROCEDURE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getCodProcedureId().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getCodProcedureId().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_PROCEDURE_ID IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getCamposTituloExpediente() != null) {
			where.append(" AND UPPER(t1.CAMPOS_TITULO_EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getCamposTituloExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getCamposTituloExpediente().toUpperCase() + "%");
			}
			where.append(" AND t1.CAMPOS_TITULO_EXPEDIENTE IS NOT NULL");
		}
		if (procedimientos != null && procedimientos.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(procedimientos.getFechaRegistro());
		}
		if (procedimientos != null && procedimientos.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(procedimientos.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + procedimientos.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
