package com.ejie.ab78.dao.procedimientos;

import java.util.List;

import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

public interface ProcedimientosDao {

	/**
	 * Inserts a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos add(Procedimientos procedimientos);

	/**
	 * Updates a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos update(Procedimientos procedimientos);

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos find(Procedimientos procedimientos);

	/**
	 * Finds a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Procedimientos
	 */
	Procedimientos findProc(Procedimientos procedimientos);

	/**
	 * Removes a single row in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 */
	void remove(Procedimientos procedimientos);

	/**
	 * Finds a List of rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Procedimientos> findAll(Procedimientos procedimientos, TableRequestDto TableRequestDto);

	List<Procedimientos> findAllCenso(Procedimientos procedimientos);

	List<Procedimientos> findAllTablaMaestro(Procedimientos procedimientos, Integer idDireccion, Boolean startsWith);

	/**
	 * Finds rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Procedimientos> findAllLike(Procedimientos procedimientos, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 * 
	 *            Boolean
	 */
	void removeMultiple(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Procedimientos table using like.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Procedimientos procedimientos, Boolean startsWith);

	/**
	 * Counts rows in the Procedimientos table.
	 *
	 * @param procedimientos
	 *            Procedimientos
	 * @return Long
	 */
	Long findAllCount(Procedimientos procedimientos);

	/**
	 * Reorder selection.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	List<TableRowDto<Procedimientos>> reorderSelection(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param searchProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Procedimientos>>
	 */
	List<TableRowDto<Procedimientos>> search(Procedimientos filterProcedimientos, Procedimientos searchProcedimientos,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Procedimientos table.
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Procedimientos>>
	 */
	List<JerarquiaDto<Procedimientos>> findAllLikeJerarquia(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Procedimientos filterProcedimientos, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterProcedimientos
	 *            Procedimientos
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Procedimientos>>
	 */
	List<TableRowDto<Procedimientos>> findAllChild(Procedimientos filterProcedimientos,
			TableRequestDto TableRequestDto);

}
