package com.ejie.ab78.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.plantillas.TiposPlantilla;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposPlantillaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TiposPlantillaDaoImpl implements TiposPlantillaDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPOPLANTILLA", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "TASKID", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TiposPlantilla> rwMap = new RowMapper<TiposPlantilla>() {
		public TiposPlantilla mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposPlantilla(resultSet.getLong("IDTIPOPLANTILLA"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"), null,
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));
		}
	};

	private RowMapper<TiposPlantilla> rwMapPK = new RowMapper<TiposPlantilla>() {
		public TiposPlantilla mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TiposPlantilla(resultSet.getLong("IDTIPOPLANTILLA"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<TiposPlantilla>> rwMapJerarquia = new RowMapper<JerarquiaDto<TiposPlantilla>>() {
		public JerarquiaDto<TiposPlantilla> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			TiposPlantilla tiposplantilla = new TiposPlantilla(resultSet.getLong("IDTIPOPLANTILLA"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"), null,
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"));

			JerarquiaDto<TiposPlantilla> jerarquia = new JerarquiaDto<TiposPlantilla>();
			jerarquia.setModel(tiposplantilla);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	public TiposPlantilla add(TiposPlantilla tiposplantilla) {
		String query = "INSERT INTO AB78.TIPOS_PLANTILLA (ID_TIPO_PLANTILLA, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, tiposplantilla.getIdTipoPlantilla(), tiposplantilla.getDescripcionCastellano(),
				tiposplantilla.getDescripcionEuskera(), tiposplantilla.getFechaRegistro(),
				tiposplantilla.getUsuarioRegistro());
		return tiposplantilla;
	}

	/**
	 * Updates a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	public TiposPlantilla update(TiposPlantilla tiposplantilla) {
		String query = "UPDATE AB78.TIPOS_PLANTILLA SET DESCRIPCION_CASTELLANO=?, DESCRIPCION_EUSKERA=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=? WHERE ID_TIPO_PLANTILLA=?";
		this.jdbcTemplate.update(query, tiposplantilla.getDescripcionCastellano(),
				tiposplantilla.getDescripcionEuskera(), tiposplantilla.getFechaRegistro(),
				tiposplantilla.getUsuarioRegistro(), tiposplantilla.getIdTipoPlantilla());
		return tiposplantilla;
	}

	/**
	 * Finds a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	@Transactional(readOnly = true)
	public TiposPlantilla find(TiposPlantilla tiposplantilla) {
		String query = "SELECT t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO FROM AB78.TIPOS_PLANTILLA t1  WHERE t1.ID_TIPO_PLANTILLA = ?  ";

		List<TiposPlantilla> tiposplantillaList = this.jdbcTemplate.query(query, this.rwMap,
				tiposplantilla.getIdTipoPlantilla());
		return (TiposPlantilla) DataAccessUtils.uniqueResult(tiposplantillaList);
	}

	/**
	 * Removes a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return
	 */
	public void remove(TiposPlantilla tiposplantilla) {
		String query = "DELETE FROM TIPOS_PLANTILLA WHERE ID_TIPO_PLANTILLA=?";
		this.jdbcTemplate.update(query, tiposplantilla.getIdTipoPlantilla());
	}

	/**
	 * Finds a list of rows in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TiposPlantilla>
	 */
	@Transactional(readOnly = true)
	public List<TiposPlantilla> findAll(TiposPlantilla tiposplantilla, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPOS_PLANTILLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposplantilla);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposPlantillaDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposPlantilla>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TiposPlantilla table using like.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TiposPlantilla>
	 */
	@Transactional(readOnly = true)
	public List<TiposPlantilla> findAllLike(TiposPlantilla tiposplantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		query.append("FROM AB78.TIPOS_PLANTILLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposplantilla, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, TiposPlantillaDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TiposPlantilla>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TiposPlantilla tiposplantilla) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPOS_PLANTILLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tiposplantilla);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the TiposPlantilla table using like.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TiposPlantilla tiposplantilla, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.TIPOS_PLANTILLA t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposplantilla, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of TiposPlantilla selected for rup_table
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	@Override
	public List<TableRowDto<TiposPlantilla>> reorderSelection(TiposPlantilla tiposplantilla,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPOS_PLANTILLA t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tiposplantilla, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto, TiposPlantilla.class,
				filterParamList, "ID_TIPO_PLANTILLA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposPlantilla>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            TiposPlantilla
	 * @param searchParams
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	@Override
	public List<TableRowDto<TiposPlantilla>> search(TiposPlantilla filterParams, TiposPlantilla searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM AB78.TIPOS_PLANTILLA t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto, TiposPlantilla.class,
				filterParamList, searchSQL, searchParamList, from_alias, "ID_TIPO_PLANTILLA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TiposPlantilla>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filtertiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(TiposPlantilla filtertiposplantilla, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		query.append("FROM TIPOS_PLANTILLA t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtertiposplantilla, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, TiposPlantilla.class,
				query, params, "ID_TIPO_PLANTILLA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposPlantilla>>
	 */
	@Override
	public List<JerarquiaDto<TiposPlantilla>> findAllLikeJerarquia(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_PLANTILLA IDTIPOPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_PLANTILLA t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_PLANTILLA");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposPlantilla, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_TIPO_PLANTILLA", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					TiposPlantillaDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_PLANTILLA t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_PLANTILLA");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposPlantilla, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_TIPO_PLANTILLA",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	@Override
	public List<TableRowDto<TiposPlantilla>> findAllChild(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM TIPOS_PLANTILLA t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.TIPOS_PLANTILLA");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterTiposPlantilla, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_TIPO_PLANTILLA",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TiposPlantilla>(this.rwMapPK, "ID_TIPO_PLANTILLA"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposPlantilla entity
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TiposPlantilla tiposplantilla) {

		StringBuilder where = new StringBuilder(TiposPlantillaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposplantilla != null && tiposplantilla.getIdTipoPlantilla() != null) {
			where.append(" AND t1.ID_TIPO_PLANTILLA = ?");
			params.add(tiposplantilla.getIdTipoPlantilla());
		}
		if (tiposplantilla != null && tiposplantilla.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(tiposplantilla.getDescripcionCastellano());
		}
		if (tiposplantilla != null && tiposplantilla.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(tiposplantilla.getDescripcionEuskera());
		}
		if (tiposplantilla != null && tiposplantilla.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposplantilla.getFechaRegistro());
		}
		if (tiposplantilla != null && tiposplantilla.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tiposplantilla.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TiposPlantilla entity
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TiposPlantilla tiposplantilla, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TiposPlantillaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tiposplantilla != null && tiposplantilla.getIdTipoPlantilla() != null) {
			where.append(" AND t1.ID_TIPO_PLANTILLA = ?");
			params.add(tiposplantilla.getIdTipoPlantilla());
		}
		if (tiposplantilla != null && tiposplantilla.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposplantilla.getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + tiposplantilla.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (tiposplantilla != null && tiposplantilla.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposplantilla.getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + tiposplantilla.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (tiposplantilla != null && tiposplantilla.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tiposplantilla.getFechaRegistro());
		}
		if (tiposplantilla != null && tiposplantilla.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tiposplantilla.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tiposplantilla.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
