package com.ejie.ab78.dao.plantillas;

import java.util.List;

import com.ejie.ab78.model.plantillas.TiposPlantilla;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TiposPlantillaDao  
 * 
 *  
 */

public interface TiposPlantillaDao {

	/**
	 * Inserts a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla add(TiposPlantilla tiposplantilla);

	/**
	 * Updates a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla update(TiposPlantilla tiposplantilla);

	/**
	 * Finds a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return TiposPlantilla
	 */
	TiposPlantilla find(TiposPlantilla tiposplantilla);

	/**
	 * Removes a single row in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 */
	void remove(TiposPlantilla tiposplantilla);

	/**
	 * Finds a List of rows in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TiposPlantilla> findAll(TiposPlantilla tiposplantilla, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the TiposPlantilla table using like.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TiposPlantilla> findAllLike(TiposPlantilla tiposplantilla, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the TiposPlantilla table using like.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TiposPlantilla tiposplantilla, Boolean startsWith);

	/**
	 * Counts rows in the TiposPlantilla table.
	 *
	 * @param tiposplantilla
	 *            TiposPlantilla
	 * @return Long
	 */
	Long findAllCount(TiposPlantilla tiposplantilla);

	/**
	 * Reorder selection.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	List<TableRowDto<TiposPlantilla>> reorderSelection(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param searchTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	List<TableRowDto<TiposPlantilla>> search(TiposPlantilla filterTiposPlantilla, TiposPlantilla searchTiposPlantilla,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical TiposPlantilla table.
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TiposPlantilla>>
	 */
	List<JerarquiaDto<TiposPlantilla>> findAllLikeJerarquia(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(TiposPlantilla filterTiposPlantilla, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterTiposPlantilla
	 *            TiposPlantilla
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TiposPlantilla>>
	 */
	List<TableRowDto<TiposPlantilla>> findAllChild(TiposPlantilla filterTiposPlantilla,
			TableRequestDto TableRequestDto);

}
