package com.ejie.ab78.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * CamposPlantillaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RecuperarDatosCampoDaoImpl implements RecuperarDatosCampoDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDCAMPO", "NOMBRECAMPO", "SELECTCAMPO",
			"NOMBREXML", "DESCRIPCION", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	private static final Logger logger = LoggerFactory.getLogger(RecuperarDatosCampoDaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<String> rwMapString = new RowMapper<String>() {
		public String mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			if (resultSet.getString("VALOR") != null) {
				return new String(resultSet.getString("VALOR"));
			} else {
				return new String("");
			}
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Finds a single row in the CamposPlantilla table.
	 *
	 * @param camposplantilla
	 *            CamposPlantilla
	 * @param param
	 *            String
	 * @return CamposPlantilla
	 */
	@Transactional(readOnly = true)
	public List<String> recuperar(String sql, String[] param) {

		List<String> result = null;

		try {
			result = this.jdbcTemplate.query(sql, this.rwMapString, param);
		} catch (DataAccessException e) {

			RecuperarDatosCampoDaoImpl.logger.info("Error:" + e.getMessage() + " , en la SQL:" + sql);
		}

		return result;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
