package com.ejie.ab78.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.plantillas.Documentos;
import com.ejie.ab78.model.plantillas.Plantillas;
import com.ejie.ab78.model.plantillas.RelExpPla;
import com.ejie.ab78.model.plantillas.TiposPlantilla;
import com.ejie.ab78.model.procedimientos.Areas;
import com.ejie.ab78.model.procedimientos.Direcciones;
import com.ejie.ab78.model.procedimientos.Procedimientos;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PlantillasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class PlantillasDaoImpl implements PlantillasDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDPLANTILLA", "DESCRIPCIONCASTELLANO",
			"DESCRIPCIONEUSKERA", "OBSERVACIONES", "DOCPLANTILLA", "TAREA", "FECHAREGISTRO", "USUARIOREGISTRO",
			"FECHAULTMODIFICACION", "USUARIOULTMODIFICACION", "TIPOSPLANTILLAIDTIPOPLANTILLA", "RUTA", "IDRELEXPPLA",
			"TIPOSPLANTILLADESCASTELLANO", "TIPOSPLANTILLADESEUSKERA", "TIPOSPLANTILLAFECHAREGISTRO",
			"TIPOSPLANTILLAUSUARIOREGISTRO", "PROCEDIMIENTOSIDPROCEDIMIENTO", "PROCEDIMIENTOSCODPROCEDUREID",
			"PROCEDIMIENTOSFOLDERID", "PROCEDIMIENTOSFOLDERNUMBER", "PROCAMPOSTITULOEXPEDIENTE",
			"PROCEDIMIENTOSFECHAREGISTRO", "PROCEDIMIENTOSUSUARIOREGISTRO", "PROCEDIMIENTOSIDDIRECCION", "ARCHIVO",
			"NOMBREDOCUMENTO", "PROCEDIMIENTOSIDAREA" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Plantillas> rwMap = new RowMapper<Plantillas>() {
		public Plantillas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Plantillas plantilla = new Plantillas(resultSet.getInt("IDPLANTILLA"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getString("OBSERVACIONES"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"),
					new Documentos(null, resultSet.getString("NOMBREDOCUMENTO"), null, resultSet.getBlob("ARCHIVO"),
							null, null, null, null, null),
					new RelExpPla(resultSet.getInt("IDRELEXPPLA"), null, null, resultSet.getString("RUTA"), null, null,
							null),
					new TiposPlantilla(resultSet.getLong("TiposPlantillaIDTIPOPLANTILLA"),
							resultSet.getString("TiposPlantillaDESCASTELLANO"),
							resultSet.getString("TIPOSPLANTILLADESEUSKERA"), resultSet.getString("TASKID"),
							resultSet.getDate("TiposPlantillaFECHAREGISTRO"),
							resultSet.getString("TiposPlantillaUSUARIOREGISTRO")),
					new Procedimientos(resultSet.getInt("ProcedimientosIDPROCEDIMIENTO"),
							resultSet.getString("ProcedimientosCODPROCEDUREID"),
							resultSet.getString("PROCAMPOSTITULOEXPEDIENTE"),
							resultSet.getDate("ProcedimientosFECHAREGISTRO"),
							resultSet.getString("ProcedimientosUSUARIOREGISTRO"),
							new Direcciones(resultSet.getInt("ProcedimientosIDDIRECCION"), null, null, null, null, null,
									null, null),
							new Areas(resultSet.getInt("ProcedimientosIDAREA"), null, null, null, null, null, null)));

			Documentos doc = plantilla.getDocumento();
			try {
				doc.setIdioma(resultSet.getInt("idioma"));
			} catch (Exception e) {
				// TODO: handle exception
			}
			plantilla.setDocumento(doc);
			return plantilla;
		}
	};

	private RowMapper<Plantillas> rwMapFindPlantillas = new RowMapper<Plantillas>() {
		public Plantillas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Plantillas(resultSet.getInt("IDPLANTILLA"), resultSet.getString("DESCRIPCIONCASTELLANO"),
					resultSet.getString("DESCRIPCIONEUSKERA"), resultSet.getString("OBSERVACIONES"), null, null, null,
					null,
					new Documentos(null, resultSet.getString("NOMBREDOCUMENTO"), null, resultSet.getBlob("ARCHIVO"),
							null, null, null, null, null),
					new RelExpPla(null, null, null, null, null, null, null),
					new TiposPlantilla(resultSet.getLong("TiposPlantillaIDTIPOPLANTILLA"),
							resultSet.getString("TiposPlantillaDESCASTELLANO"),
							resultSet.getString("TIPOSPLANTILLADESEUSKERA"), resultSet.getString("TASKID"), null, null),
					new Procedimientos(resultSet.getInt("ProcedimientosIDPROCEDIMIENTO"),
							resultSet.getString("ProcedimientosCODPROCEDUREID"),
							resultSet.getString("PROCAMPOSTITULOEXPEDIENTE"), null, null,
							new Direcciones(resultSet.getInt("ProcedimientosIDDIRECCION"), null, null, null, null, null,
									null, null),
							new Areas(resultSet.getInt("ProcedimientosIDAREA"), null, null, null, null, null, null)));
		}
	};

	private RowMapper<Plantillas> rwMapPK = new RowMapper<Plantillas>() {
		public Plantillas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Plantillas(resultSet.getInt("IDPLANTILLA"));
		}
	};

	/**
	 * Rowmapper para Jerarqu�a
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Plantillas>> rwMapJerarquia = new RowMapper<JerarquiaDto<Plantillas>>() {
		public JerarquiaDto<Plantillas> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Plantillas plantillas = new Plantillas(resultSet.getInt("IDPLANTILLA"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getString("OBSERVACIONES"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"),
					new Documentos(null, resultSet.getString("NOMBREDOCUMENTO"), null, resultSet.getBlob("ARCHIVO"),
							null, null, null, null, null),
					new RelExpPla(null, null, null, resultSet.getString("RUTA"), null, null, null),
					new TiposPlantilla(resultSet.getLong("TiposPlantillaIDTIPOPLANTILLA"),
							resultSet.getString("TiposPlantillaDESCASTELLANO"),
							resultSet.getString("TIPOSPLANTILLADESEUSKERA"), resultSet.getString("TASKID"),
							resultSet.getDate("TiposPlantillaFECHAREGISTRO"),
							resultSet.getString("TiposPlantillaUSUARIOREGISTRO")),
					new Procedimientos(resultSet.getInt("ProcedimientosIDPROCEDIMIENTO"),
							resultSet.getString("ProcedimientosCODPROCEDUREID"),
							resultSet.getString("PROCAMPOSTITULOEXPEDIENTE"),
							resultSet.getDate("ProcedimientosFECHAREGISTRO"),
							resultSet.getString("ProcedimientosUSUARIOREGISTRO"),
							new Direcciones(resultSet.getInt("ProcedimientosIDDIRECCION"), null, null, null, null, null,
									null, null),
							new Areas(resultSet.getInt("ProcedimientosIDAREA"), null, null, null, null, null, null)));

			JerarquiaDto<Plantillas> jerarquia = new JerarquiaDto<Plantillas>();
			jerarquia.setModel(plantillas);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	// public Plantillas add(Plantillas plantillas) {
	// int idPlantilla =
	// this.jdbcTemplate.queryForInt(SecuenciasSQL.getSelectNext("AB61.S_AB6110T00"));
	// plantillas.setIdPlantilla(idPlantilla);
	// String query = "INSERT INTO PLANTILLAS (ID_PLANTILLA, ID_TIPO_PLANTILLA,
	// ID_PROCEDIMIENTO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA,
	// OBSERVACIONES, DOC_PLANTILLA, FECHA_REGISTRO, USUARIO_REGISTRO,
	// FECHA_ULTMODIFICACION, USUARIO_ULTMODIFICACION,DOCUMENTO) VALUES
	// (?,?,?,?,?,?,?,?,?,?,?,?)";
	// Object getTiposPlantillaIdTipoPlantillaAux = null;
	// if (plantillas.getTiposPlantilla() != null &&
	// plantillas.getTiposPlantilla().getIdTipoPlantilla() != null) {
	// getTiposPlantillaIdTipoPlantillaAux =
	// plantillas.getTiposPlantilla().getIdTipoPlantilla();
	// }
	// Object getProcedimientosIdProcedimientoAux = null;
	// if (plantillas.getProcedimientos() != null &&
	// plantillas.getProcedimientos().getIdProcedimiento() != null) {
	// getProcedimientosIdProcedimientoAux =
	// plantillas.getProcedimientos().getIdProcedimiento();
	// }
	// this.jdbcTemplate.update(query, plantillas.getIdPlantilla(),
	// getTiposPlantillaIdTipoPlantillaAux, 1,
	// plantillas.getDescripcionCastellano(),
	// plantillas.getDescripcionEuskera(),
	// plantillas.getObservaciones(), plantillas.getDocPlantilla(),
	// plantillas.getFechaRegistro(),
	// plantillas.getUsuarioRegistro(), plantillas.getFechaUltmodificacion(),
	// plantillas.getUsuarioUltmodificacion(), plantillas.getDocumento());
	// return plantillas;
	// }

	/**
	 * Updates a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	// public Plantillas update(Plantillas plantillas) {
	// String query = "UPDATE PLANTILLAS SET ID_TIPO_PLANTILLA=?,
	// ID_PROCEDIMIENTO=?, DESCRIPCION_CASTELLANO=?, DESCRIPCION_EUSKERA=?,
	// OBSERVACIONES=?, DOC_PLANTILLA=?, FECHA_REGISTRO=?, USUARIO_REGISTRO=?,
	// FECHA_ULTMODIFICACION=?, USUARIO_ULTMODIFICACION=?,DOCUMENTO=? WHERE
	// ID_PLANTILLA=?";
	// Object getTiposPlantillaIdTipoPlantillaAux = null;
	// if (plantillas.getTiposPlantilla() != null &&
	// plantillas.getTiposPlantilla().getIdTipoPlantilla() != null) {
	// getTiposPlantillaIdTipoPlantillaAux =
	// plantillas.getTiposPlantilla().getIdTipoPlantilla();
	// }
	// Object getProcedimientosIdProcedimientoAux = null;
	// if (plantillas.getProcedimientos() != null &&
	// plantillas.getProcedimientos().getIdProcedimiento() != null) {
	// getProcedimientosIdProcedimientoAux =
	// plantillas.getProcedimientos().getIdProcedimiento();
	// }
	//
	// byte[] fichero = null;
	// try {
	// if (plantillas.getDocPlantilla() != null &&
	// plantillas.getDocPlantilla().length() > 0) {
	// fichero = BlobUtils.ConvertBlobToByte(plantillas.getDocPlantilla());
	// }
	// } catch (SQLException e) {
	// // TODO Auto-generated catch block
	// e.printStackTrace();
	// }
	// // ConvertBlobToByte
	// this.jdbcTemplate.update(query, getTiposPlantillaIdTipoPlantillaAux,
	// getProcedimientosIdProcedimientoAux,
	// plantillas.getDescripcionCastellano(),
	// plantillas.getDescripcionEuskera(),
	// plantillas.getObservaciones(), fichero, plantillas.getFechaRegistro(),
	// plantillas.getUsuarioRegistro(),
	// plantillas.getFechaUltmodificacion(),
	// plantillas.getUsuarioUltmodificacion(), plantillas.getDocumento(),
	// plantillas.getIdPlantilla());
	// return plantillas;
	// }

	/**
	 * Finds a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	@Transactional(readOnly = true)
	public Plantillas find(Plantillas plantillas) {
		String query = "SELECT  t1.ID_PLANTILLA IDPLANTILLA, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.OBSERVACIONES OBSERVACIONES, t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA, t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO, t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA, t2.TASK_ID TASKID, t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO, t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID, t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE, t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION, t3.ID_AREA PROCEDIMIENTOSIDAREA, t4.ID_DOCUMENTO IDDOCUMENTO ,  t4.NOMBRE_DOCUMENTO NOMBREDOCUMENTO , t4.ARCHIVO ARCHIVO FROM  AB78.PLANTILLAS t1 , AB78.TIPOS_PLANTILLA t2 , AB78.PROCEDIMIENTOS t3, AB78.DOCUMENTOS t4 WHERE t1.ID_PLANTILLA   = ? AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO = t3.ID_PROCEDIMIENTO(+) AND t4.ID_DOCUMENTO(+) = t1.ID_DOCUMENTO";
		List<Plantillas> plantillasList = this.jdbcTemplate.query(query, this.rwMapFindPlantillas,
				plantillas.getIdPlantilla());
		return (Plantillas) DataAccessUtils.uniqueResult(plantillasList);
	}

	/**
	 * Removes a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return
	 */
	public void remove(Plantillas plantillas) {
		String query = "DELETE FROM AB78.PLANTILLAS WHERE ID_PLANTILLA=?";
		this.jdbcTemplate.update(query, plantillas.getIdPlantilla());
	}

	/**
	 * Finds a list of rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<Plantillas>
	 */
	@Transactional(readOnly = true)
	public List<Plantillas> findAll(Plantillas plantillas, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.DOC_PLANTILLA DOCPLANTILLA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t1.DOCUMENTO,t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO,t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ");
		query.append("FROM AB78.PLANTILLAS t1 ,AB78.TIPOS_PLANTILLA t2 ,AB78.PROCEDIMIENTOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(plantillas);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, PlantillasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Plantillas>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Plantillas>
	 */
	@Transactional(readOnly = true)
	public List<Plantillas> findAllLike(Plantillas plantillas, TableRequestDto TableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION , t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO, t2.TASK_ID TASKID , t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ,t4.ID_REL_EXP_PLA  IDRELEXPPLA, t4.RUTA RUTA,   t5.NOMBRE_DOCUMENTO NOMBREDOCUMENTO,  t5.ARCHIVO ARCHIVO  ");
		query.append(
				" FROM AB78.PLANTILLAS t1 , AB78.TIPOS_PLANTILLA t2 , AB78.PROCEDIMIENTOS t3, AB78.REL_EXP_PLA t4 , AB78.DOCUMENTOS t5, REL_PLA_API t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(plantillas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+)   AND t1.ID_PLANTILLA = t4.ID_PLANTILLA (+)  AND t1.ID_DOCUMENTO = t5.ID_DOCUMENTO (+) AND t1.ID_PLANTILLA = t6.ID_PLANTILLA AND t6.ID_APLICACION = ? ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<Object> params = (List<Object>) mapaWhere.get("params");
		params.add(0, Constantes.ID_APLICACION);

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, PlantillasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Plantillas>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Plantillas plantillas) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.PLANTILLAS t1 , AB78.TIPOS_PLANTILLA t2 , AB78.PROCEDIMIENTOS t3 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(plantillas);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+)   ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Plantillas plantillas, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB78.PLANTILLAS t1,AB78.TIPOS_PLANTILLA t2,AB78.PROCEDIMIENTOS t3 , AB78.REL_EXP_PLA t4 , AB78.DOCUMENTOS t5, REL_PLA_API t6 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(plantillas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+) AND t1.ID_PROCEDIMIENTO = t4.ID_PROCEDIMIENTO(+)   AND t1.ID_PLANTILLA = t4.ID_PLANTILLA (+) AND t1.ID_DOCUMENTO = t5.ID_DOCUMENTO (+) AND t1.ID_PLANTILLA = t6.ID_PLANTILLA AND t6.ID_APLICACION = ? ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<Object> params = (List<Object>) mapaWhere.get("params");
		params.add(0, Constantes.ID_APLICACION);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of Plantillas selected for rup_table
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	@Override
	public List<TableRowDto<Plantillas>> reorderSelection(Plantillas plantillas, TableRequestDto TableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.DOC_PLANTILLA DOCPLANTILLA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t1.DOCUMENTO,t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO,t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ");
		// FROM
		query.append("FROM AB78.PLANTILLAS t1, AB78.TIPOS_PLANTILLA t2, AB78.PROCEDIMIENTOS t3 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(plantillas, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Par�metros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenaci�n
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, TableRequestDto, Plantillas.class,
				filterParamList, "ID_PLANTILLA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Plantillas>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Plantillas
	 * @param searchParams
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	@Override
	public List<TableRowDto<Plantillas>> search(Plantillas filterParams, Plantillas searchParams,
			TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.DOC_PLANTILLA DOCPLANTILLA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t1.DOCUMENTO,t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO,t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ");
		// FROM
		query.append("FROM PLANTILLAS t1 ,TIPOS_PLANTILLA t2 ,PROCEDIMIENTOS t3 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.ID_TIPO_PLANTILLA= t2.ID_TIPO_PLANTILLA(+) AND t1.ID_PROCEDIMIENTO= t3.ID_PROCEDIMIENTO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, TableRequestDto, Plantillas.class,
				filterParamList, searchSQL, searchParamList, from_alias, "ID_PLANTILLA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Plantillas>(this.rwMapPK, TableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterplantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Plantillas filterplantillas, TableRequestDto TableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.DOC_PLANTILLA DOCPLANTILLA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t1.DOCUMENTO,t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO,t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ");
		// FROM
		query.append("FROM AB78.PLANTILLAS t1, AB78.TIPOS_PLANTILLA t2, AB78.PROCEDIMIENTOS t3 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterplantillas, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(TableRequestDto, Plantillas.class,
				query, params, "ID_PLANTILLA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Plantillas>>
	 */
	@Override
	public List<JerarquiaDto<Plantillas>> findAllLikeJerarquia(Plantillas filterPlantillas,
			TableRequestDto TableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PLANTILLA IDPLANTILLA,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.OBSERVACIONES OBSERVACIONES,t1.DOC_PLANTILLA DOCPLANTILLA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION,t1.DOCUMENTO,t2.ID_TIPO_PLANTILLA TIPOSPLANTILLAIDTIPOPLANTILLA,t2.DESCRIPCION_CASTELLANO TIPOSPLANTILLADESCASTELLANO,t2.DESCRIPCION_EUSKERA TIPOSPLANTILLADESEUSKERA,t2.FECHA_REGISTRO TIPOSPLANTILLAFECHAREGISTRO,t2.USUARIO_REGISTRO TIPOSPLANTILLAUSUARIOREGISTRO,t3.ID_PROCEDIMIENTO PROCEDIMIENTOSIDPROCEDIMIENTO,t3.COD_PROCEDURE_ID PROCEDIMIENTOSCODPROCEDUREID,t3.CAMPOS_TITULO_EXPEDIENTE PROCAMPOSTITULOEXPEDIENTE,t3.FECHA_REGISTRO PROCEDIMIENTOSFECHAREGISTRO,t3.USUARIO_REGISTRO PROCEDIMIENTOSUSUARIOREGISTRO,t3.ID_DIRECCION PROCEDIMIENTOSIDDIRECCION,t3.ID_AREA PROCEDIMIENTOSIDAREA ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM PLANTILLAS t1
		// ,TIPOS_PLANTILLA t2 ,PROCEDIMIENTOS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PLANTILLAS");
		from.add("AB78.TIPOS_PLANTILLA");
		from.add("AB78.PROCEDIMIENTOS");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqu�a
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPlantillas, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(TableRequestDto, query, mapaWhere, "ID_PLANTILLA", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(TableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (TableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(TableRequestDto, query,
					PlantillasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Plantillas filterPlantillas, TableRequestDto TableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM PLANTILLAS t1
		// ,TIPOS_PLANTILLA t2 ,PROCEDIMIENTOS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PLANTILLAS");
		from.add("AB78.TIPOS_PLANTILLA");
		from.add("AB78.PROCEDIMIENTOS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqu�a
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPlantillas, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere, "ID_PLANTILLA",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Plantillas>>
	 */
	@Override
	public List<TableRowDto<Plantillas>> findAllChild(Plantillas filterPlantillas, TableRequestDto TableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM PLANTILLAS t1
		// ,TIPOS_PLANTILLA t2 ,PROCEDIMIENTOS t3 ");
		List<String> from = new ArrayList<String>();
		from.add("AB78.PLANTILLAS");
		from.add("AB78.TIPOS_PLANTILLA");
		from.add("AB78.PROCEDIMIENTOS");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");
		from_alias.add(" t3 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqu�a
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterPlantillas, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere, "ID_PLANTILLA",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(TableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Plantillas>(this.rwMapPK, "ID_PLANTILLA"), params.toArray());
	}

	/*
	 * M�TODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Plantillas entity
	 *
	 * @param plantillas
	 *            Plantillas Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generaci�n de c�digo de UDA
	private Map<String, ?> getWhereMap(Plantillas plantillas) {

		StringBuilder where = new StringBuilder(PlantillasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (plantillas != null && plantillas.getIdPlantilla() != null) {
			where.append(" AND t1.ID_PLANTILLA = ?");
			params.add(plantillas.getIdPlantilla());
		}

		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getIdTipoPlantilla() != null) {
			where.append(" AND t2.ID_TIPO_PLANTILLA = ?");
			params.add(plantillas.getTiposPlantilla().getIdTipoPlantilla());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getDescripcionCastellano() != null) {
			where.append(" AND t2.DESCRIPCION_CASTELLANO = ?");
			params.add(plantillas.getTiposPlantilla().getDescripcionCastellano());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getDescripcionEuskera() != null) {
			where.append(" AND t2.DESCRIPCION_EUSKERA = ?");
			params.add(plantillas.getTiposPlantilla().getDescripcionEuskera());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getFechaRegistro() != null) {
			where.append(" AND t2.FECHA_REGISTRO = ?");
			params.add(plantillas.getTiposPlantilla().getFechaRegistro());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getUsuarioRegistro() != null) {
			where.append(" AND t2.USUARIO_REGISTRO = ?");
			params.add(plantillas.getTiposPlantilla().getUsuarioRegistro());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getIdProcedimiento() != null) {
			where.append(" AND t3.ID_PROCEDIMIENTO = ?");
			params.add(plantillas.getProcedimientos().getIdProcedimiento());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getDirecciones() != null
				&& plantillas.getProcedimientos().getDirecciones().getIdDireccion() != null) {
			where.append(" AND t3.ID_DIRECCION = ?");
			params.add(plantillas.getProcedimientos().getDirecciones().getIdDireccion());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getAreas() != null
				&& plantillas.getProcedimientos().getAreas().getIdArea() != null) {
			where.append(" AND t3.ID_AREA = ?");
			params.add(plantillas.getProcedimientos().getAreas().getIdArea());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getCodProcedureId() != null) {
			where.append(" AND t3.COD_PROCEDURE_ID = ?");
			params.add(plantillas.getProcedimientos().getCodProcedureId());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getCamposTituloExpediente() != null) {
			where.append(" AND t3.CAMPOS_TITULO_EXPEDIENTE = ?");
			params.add(plantillas.getProcedimientos().getCamposTituloExpediente());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getFechaRegistro() != null) {
			where.append(" AND t3.FECHA_REGISTRO = ?");
			params.add(plantillas.getProcedimientos().getFechaRegistro());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getUsuarioRegistro() != null) {
			where.append(" AND t3.USUARIO_REGISTRO = ?");
			params.add(plantillas.getProcedimientos().getUsuarioRegistro());
		}
		if (plantillas != null && plantillas.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(plantillas.getDescripcionCastellano());
		}
		if (plantillas != null && plantillas.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(plantillas.getDescripcionEuskera());
		}
		if (plantillas != null && plantillas.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(plantillas.getObservaciones());
		}
		if (plantillas != null && plantillas.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(plantillas.getFechaRegistro());
		}
		if (plantillas != null && plantillas.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(plantillas.getUsuarioRegistro());
		}
		if (plantillas != null && plantillas.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(plantillas.getFechaUltmodificacion());
		}
		if (plantillas != null && plantillas.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(plantillas.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generaci�n de c�digo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Plantillas entity
	 *
	 * @param plantillas
	 *            Plantillas Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generaci�n de c�digo de UDA
	private Map<String, Object> getWhereLikeMap(Plantillas plantillas, Boolean startsWith) {

		StringBuilder where = new StringBuilder(PlantillasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (plantillas != null && plantillas.getIdPlantilla() != null) {
			where.append(" AND t1.ID_PLANTILLA = ?");
			params.add(plantillas.getIdPlantilla());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getIdTipoPlantilla() != null) {
			where.append(" AND t2.ID_TIPO_PLANTILLA = ?");
			params.add(plantillas.getTiposPlantilla().getIdTipoPlantilla());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getTiposPlantilla().getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getTiposPlantilla().getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t2.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getTiposPlantilla().getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getTiposPlantilla().getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t2.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getFechaRegistro() != null) {
			where.append(" AND t2.FECHA_REGISTRO = ?");
			params.add(plantillas.getTiposPlantilla().getFechaRegistro());
		}
		if (plantillas != null && plantillas.getTiposPlantilla() != null
				&& plantillas.getTiposPlantilla().getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t2.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getTiposPlantilla().getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getTiposPlantilla().getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t2.USUARIO_REGISTRO IS NOT NULL");
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getIdProcedimiento() != null) {
			where.append(" AND t3.ID_PROCEDIMIENTO = ?");
			params.add(plantillas.getProcedimientos().getIdProcedimiento());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getDirecciones() != null
				&& plantillas.getProcedimientos().getDirecciones().getIdDireccion() != null) {
			where.append(" AND t3.ID_DIRECCION = ?");
			params.add(plantillas.getProcedimientos().getDirecciones().getIdDireccion());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getAreas() != null
				&& plantillas.getProcedimientos().getAreas().getIdArea() != null) {
			where.append(" AND t3.ID_AREA = ?");
			params.add(plantillas.getProcedimientos().getAreas().getIdArea());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getCodProcedureId() != null) {
			where.append(" AND UPPER(t3.COD_PROCEDURE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getProcedimientos().getCodProcedureId().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getProcedimientos().getCodProcedureId().toUpperCase() + "%");
			}
			where.append(" AND t3.COD_PROCEDURE_ID IS NOT NULL");
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getCamposTituloExpediente() != null) {
			where.append(" AND UPPER(t3.CAMPOS_TITULO_EXPEDIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getProcedimientos().getCamposTituloExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getProcedimientos().getCamposTituloExpediente().toUpperCase() + "%");
			}
			where.append(" AND t3.CAMPOS_TITULO_EXPEDIENTE IS NOT NULL");
		}
		if (plantillas != null && plantillas.getOrigen() != null) {
			where.append(" AND t1.ORIGEN = ?");
			params.add(plantillas.getOrigen());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getFechaRegistro() != null) {
			where.append(" AND t3.FECHA_REGISTRO = ?");
			params.add(plantillas.getProcedimientos().getFechaRegistro());
		}
		if (plantillas != null && plantillas.getProcedimientos() != null
				&& plantillas.getProcedimientos().getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t3.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getProcedimientos().getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getProcedimientos().getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t3.USUARIO_REGISTRO IS NOT NULL");
		}
		if (plantillas != null && plantillas.getRelExpPla() != null) {
			if (plantillas.getRelExpPla().getIdExpediente() != null) {
				where.append(" AND t4.ID_EXPEDIENTE(+) =  ? ");
				params.add(plantillas.getRelExpPla().getIdExpediente());
			} else {
				where.append(" AND t4.ID_EXPEDIENTE IS NULL ");
			}

		}
		if (plantillas != null && plantillas.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (plantillas != null && plantillas.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (plantillas != null && plantillas.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}
		if (plantillas != null && plantillas.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(plantillas.getFechaRegistro());
		}
		if (plantillas != null && plantillas.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (plantillas != null && plantillas.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(plantillas.getFechaUltmodificacion());
		}
		if (plantillas != null && plantillas.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(plantillas.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + plantillas.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		if (plantillas != null && plantillas.getDocumento() != null && plantillas.getDocumento().getIdioma() != null) {
			if (plantillas.getDocumento().getIdioma() != Constantes.IDIOMA_NINGUNO) {
				where.append(" AND T5.IDIOMA = ?");
				params.add(plantillas.getDocumento().getIdioma());
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generaci�n de c�digo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
