package com.ejie.ab78.dao.plantillas;

import java.util.List;

import com.ejie.ab78.model.plantillas.Plantillas;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * PlantillasDao  
 * 
 *  
 */

public interface PlantillasDao {

	/**
	 * Inserts a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	// Plantillas add(Plantillas plantillas);

	/**
	 * Updates a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	// Plantillas update(Plantillas plantillas);

	/**
	 * Finds a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Plantillas
	 */
	Plantillas find(Plantillas plantillas);

	/**
	 * Removes a single row in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 */
	void remove(Plantillas plantillas);

	/**
	 * Finds a List of rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Plantillas> findAll(Plantillas plantillas, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Plantillas> findAllLike(Plantillas plantillas, TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Plantillas filterPlantillas, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Plantillas table using like.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Plantillas plantillas, Boolean startsWith);

	/**
	 * Counts rows in the Plantillas table.
	 *
	 * @param plantillas
	 *            Plantillas
	 * @return Long
	 */
	Long findAllCount(Plantillas plantillas);

	/**
	 * Reorder selection.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	List<TableRowDto<Plantillas>> reorderSelection(Plantillas filterPlantillas, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param searchPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Plantillas>>
	 */
	List<TableRowDto<Plantillas>> search(Plantillas filterPlantillas, Plantillas searchPlantillas,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Plantillas table.
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Plantillas>>
	 */
	List<JerarquiaDto<Plantillas>> findAllLikeJerarquia(Plantillas filterPlantillas, TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Plantillas filterPlantillas, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterPlantillas
	 *            Plantillas
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Plantillas>>
	 */
	List<TableRowDto<Plantillas>> findAllChild(Plantillas filterPlantillas, TableRequestDto TableRequestDto);

}
