package com.ejie.ab78.dao.plantillas;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.plantillas.ParametrosConfig;

/**
 * ParametrosConfigDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ParametrosConfigDaoImpl implements ParametrosConfigDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "VALOR" };

	private JdbcTemplate jdbcTemplate;

	private RowMapper<ParametrosConfig> rwMap = new RowMapper<ParametrosConfig>() {
		public ParametrosConfig mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			ParametrosConfig parametrosConfig = new ParametrosConfig();
			if (resultSet.getString("VALOR") != null) {
				parametrosConfig.setValor(Integer.parseInt(resultSet.getString("VALOR")));
			}
			return parametrosConfig;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Buscamos el valor para saber la configuacion de la vista de plantilla
	 * 
	 * @return ParametrosConfig parametrosConfig
	 */
	@Transactional(readOnly = true)
	public ParametrosConfig find(ParametrosConfig parametrosConfig) {
		String query = "SELECT VALOR FROM AB78.PARAMETROS_CONFIG WHERE 1 = 1 AND DESCRIPCION = ?";
		List<ParametrosConfig> parametrosConfigList = this.jdbcTemplate.query(query, this.rwMap,
				parametrosConfig.getDescripcion());

		return (ParametrosConfig) DataAccessUtils.uniqueResult(parametrosConfigList);

	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
