package com.ejie.ab78.dao.nora;

import java.util.List;

import com.ejie.ab78.model.nora.T17TipoVia;
import com.ejie.x38.dto.Pagination;

/**
 * T17TipoViaDao  
 * 
 *  
 */

public interface T17TipoViaDao {

	/**
	 * Inserts a single row in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia add(T17TipoVia t17tipovia);

	/**
	 * Updates a single row in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia update(T17TipoVia t17tipovia);

	/**
	 * Finds a single row in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @return T17TipoVia
	 */
	T17TipoVia find(T17TipoVia t17tipovia);

	/**
	 * Deletes a single row in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @return
	 */
	void remove(T17TipoVia t17tipovia);

	/**
	 * Finds a List of rows in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination<Object>
	 * 
	 * @return List<T17TipoVia>
	 */
	List<T17TipoVia> findAll(T17TipoVia t17tipovia, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17TipoVia table.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @return Long
	 */
	Long findAllCount(T17TipoVia t17tipovia);

	/**
	 * Finds rows in the T17TipoVia table using like.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List<T17TipoVia>
	 */
	List<T17TipoVia> findAllLike(T17TipoVia t17tipovia, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Counts rows in the T17TipoVia table using like.
	 * 
	 * @param t17tipovia
	 *            T17TipoVia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(T17TipoVia t17tipovia, Boolean startsWith);
}
