package com.ejie.ab78.dao.nora;

/**
 * T17Provincia  
 */

import java.util.List;

import com.ejie.ab78.model.nora.T17Provincia;
import com.ejie.x38.dto.Pagination;

/**
 * T17ProvinciaDao  
 * 
 *  
 */
public interface T17ProvinciaDao {
	/**
	 * Inserts a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia add(T17Provincia t17provincia);

	/**
	 * Updates a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia update(T17Provincia t17provincia);

	/**
	 * Finds a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @return T17Provincia
	 */
	T17Provincia find(T17Provincia t17provincia);

	/**
	 * Deletes a single row in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * 
	 */
	void remove(T17Provincia t17provincia);

	/**
	 * Finds a List of rows in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * 
	 * @return List<T17Provincia>
	 */
	List<T17Provincia> findAll(T17Provincia t17provincia, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Provincia table.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @return List
	 */
	Long findAllCount(T17Provincia t17provincia);

	/**
	 * Finds rows in the T17Provincia table using like.
	 * 
	 * @param t17provincia
	 *            T17Provincia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Provincia>
	 */
	List<T17Provincia> findAllLike(T17Provincia t17provincia, Pagination<Object> pagination, Boolean startsWith);
	
	List<T17Provincia> findProvinciasVascas();
}
