package com.ejie.ab78.dao.nora;

/**
 * T17PortalDao  
 */

import java.util.List;

import com.ejie.ab78.model.nora.T17Portal;
import com.ejie.x38.dto.Pagination;

/**
 * T17PortalDao  
 * 
 *  
 */
public interface T17PortalDao {
	/**
	 * Inserts a single row in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal add(T17Portal t17portal);

	/**
	 * Updates a single row in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal update(T17Portal t17portal);

	/**
	 * Finds a single row in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @return T17Portal
	 */
	T17Portal find(T17Portal t17portal);

	/**
	 * Deletes a single row in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * 
	 */
	void remove(T17Portal t17portal);

	/**
	 * Finds a List of rows in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination<Object>
	 * @return List<T17Portal>
	 */
	List<T17Portal> findAll(T17Portal t17portal, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Portal table.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @return List
	 */
	Long findAllCount(T17Portal t17portal);

	/**
	 * Finds rows in the T17Portal table using like.
	 * 
	 * @param t17portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Portal>
	 */
	List<T17Portal> findAllLike(T17Portal t17portal, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Finds a List of distinct rows by CP in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Portal>
	 */
	List<T17Portal> findAllLikeCodigoPostal(T17Portal t17Portal, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Finds a List of distinct CP rows in the T17Portal table.
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Portal
	 */
	public T17Portal findCodigoPostal(T17Portal t17Portal);

	/**
	 * Finds a single row in the T17Portal table.
	 * 
	 * @param idT17portal
	 *            Long
	 * @return T17Portal
	 */
	public T17Portal find(Long idT17portal);
}
