package com.ejie.ab78.dao.nora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilsConfig;
import com.ejie.ab78.model.nora.T17Comarca;
import com.ejie.x38.dto.Pagination;

/**
 * * T17ComarcaDaoImpl  
 * 
 *  
 */
@Repository()
@Transactional()
public class T17ComarcaDaoImpl implements T17ComarcaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<T17Comarca> rwMap = new RowMapper<T17Comarca>() {
		public T17Comarca mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new T17Comarca(resultSet.getString("ID"), resultSet.getString("PROVINCIAID"),
					resultSet.getString("DSO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	public T17Comarca add(T17Comarca t17comarca) {

		String query = "INSERT INTO " + UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA( ID,PROVINCIA_ID,DS_O)" + "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, t17comarca.getId(), t17comarca.getProvinciaId(), t17comarca.getDsO());
		return t17comarca;
	}

	/**
	 * Updates a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	public T17Comarca update(T17Comarca t17comarca) {
		String query = "UPDATE " + UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA SET DS_O=? WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17comarca.getDsO(), t17comarca.getId(), t17comarca.getProvinciaId());
		return t17comarca;

	}

	/**
	 * Finds a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * @return T17Comarca
	 */
	@Transactional(readOnly = true)
	public T17Comarca find(T17Comarca t17comarca) {
		String query = "SELECT t1.ID ID, t1.PROVINCIA_ID PROVINCIAID, t1.DS_O DSO " + "FROM " + UtilsConfig.getAppProperties().getProperty("NORA.DB")
				+ ".T17_COMARCA t1  " + "WHERE t1.ID = ?   AND t1.PROVINCIA_ID = ?    ";
		return (T17Comarca) this.jdbcTemplate.queryForObject(query, this.rwMap, t17comarca.getId(),
				t17comarca.getProvinciaId());
	}

	/**
	 * Removes a single row in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            Pagination
	 * 
	 */
	public void remove(T17Comarca t17comarca) {
		String query = "DELETE  FROM " + UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA WHERE ID=? AND PROVINCIA_ID=?";
		this.jdbcTemplate.update(query, t17comarca.getId(), t17comarca.getProvinciaId());

	}

	/**
	 * Finds a List of rows in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<T17Comarca> findAll(T17Comarca t17comarca, Pagination<Object> pagination) {
		StringBuffer where = new StringBuffer(Constantes.MAGIC_NUMBER_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer("SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO " + "FROM "
				+ UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA t1 ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17comarca.getId());
		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17comarca.getProvinciaId());
		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17comarca.getDsO());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Constantes.MAGIC_NUMBER_3000);
		if (pagination != null) {
			if (pagination.getSidx() != null) {
				order.append(" ORDER BY " + pagination.getSidx() + " " + pagination.getSord());
				query.append(order);
			}
		}

		return (List<T17Comarca>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the T17Comarca table.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(T17Comarca t17comarca) {

		StringBuffer where = new StringBuffer(Constantes.MAGIC_NUMBER_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  " + UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA t1  ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(t17comarca.getId());
		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND t1.PROVINCIA_ID = ?");
			params.add(t17comarca.getProvinciaId());
		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(t17comarca.getDsO());
		}

		query.append(where);

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);

	}

	/**
	 * Finds rows in the T17Comarca table using like.
	 * 
	 * @param t17comarca
	 *            T17Comarca
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Comarca>
	 */
	@Transactional(readOnly = true)
	public List<T17Comarca> findAllLike(T17Comarca t17comarca, Pagination<Object> pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(Constantes.MAGIC_NUMBER_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		StringBuffer query = new StringBuffer("SELECT  t1.ID ID,t1.PROVINCIA_ID PROVINCIAID,t1.DS_O DSO " + "FROM "
				+ UtilsConfig.getAppProperties().getProperty("NORA.DB") + ".T17_COMARCA t1 ");
		if (t17comarca != null && t17comarca.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getId().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");

		}
		if (t17comarca != null && t17comarca.getProvinciaId() != null) {
			where.append(" AND UPPER(t1.PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getProvinciaId().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getProvinciaId().toUpperCase() + "%");
			}
			where.append(" AND t1.PROVINCIA_ID IS NOT NULL");

		}
		if (t17comarca != null && t17comarca.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(t17comarca.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + t17comarca.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");

		}

		query.append(where);

		StringBuffer order = new StringBuffer(Constantes.MAGIC_NUMBER_3000);
		if (pagination != null) {
			if (pagination.getSidx() != null) {
				order.append(" ORDER BY " + pagination.getSidx() + " " + pagination.getSord());
				query.append(order);
			}
		}

		return (List<T17Comarca>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

}
