package com.ejie.ab78.dao.nora;

/**
 * T17CalleDao  
 */

import java.util.List;

import com.ejie.ab78.model.nora.T17Calle;
import com.ejie.ab78.model.nora.T17Portal;
import com.ejie.x38.dto.Pagination;

/**
 * T17CalleDao  
 * 
 *  
 */
public interface T17CalleDao {
	/**
	 * Inserts a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle add(T17Calle t17calle);

	/**
	 * Updates a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle update(T17Calle t17calle);

	/**
	 * Finds a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return T17Calle
	 */
	T17Calle find(T17Calle t17calle);

	/**
	 * Metodo que devuelve la calle con su tipo de v�a
	 * 
	 * @param t17calle
	 *            t17calle
	 * @return T17Calle
	 */
	T17Calle findCalleConTipoVia(T17Calle t17calle);

	/**
	 * Deletes a single row in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * 
	 */
	void remove(T17Calle t17calle);

	/**
	 * Finds a List of rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Calle> findAll(T17Calle t17calle, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @return List
	 */
	Long findAllCount(T17Calle t17calle);

	/**
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Calle>
	 */
	List<T17Calle> findAllLike(T17Calle t17calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Calle>
	 */
	List<T17Calle> findAllLikeCalle(T17Calle t17calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Finds the provincia and municipio associated to the CP
	 * 
	 * @param t17Portal
	 *            T17Portal
	 * @return T17Calle
	 */
	public T17Calle findProvMun(T17Portal t17Portal);

	/**
	 * Finds rows in the T17Calle table using like.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<T17Calle> findAllCalleLike(T17Calle t17calle, Pagination<Object> pagination, Boolean startsWith);

	/**
	 * Counts rows in the T17Calle table.
	 * 
	 * @param t17calle
	 *            T17Calle
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return Long
	 */
	Long findAllCalleLikeCount(T17Calle t17calle, Boolean startsWith);
}
