package com.ejie.ab78.dao.nora;

/**
 * T17Autonomia  
 */

import java.util.List;

import com.ejie.ab78.model.nora.T17Autonomia;
import com.ejie.x38.dto.Pagination;

/**
 * T17AutonomiaDao  
 * 
 *  
 */
public interface T17AutonomiaDao {
	/**
	 * Inserts a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia add(T17Autonomia t17autonomia);

	/**
	 * Updates a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia update(T17Autonomia t17autonomia);

	/**
	 * Finds a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @return T17Autonomia
	 */
	T17Autonomia find(T17Autonomia t17autonomia);

	/**
	 * Deletes a single row in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * 
	 */
	void remove(T17Autonomia t17autonomia);

	/**
	 * Finds a List of rows in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination<Object>
	 * @return List
	 */
	List<T17Autonomia> findAll(T17Autonomia t17autonomia, Pagination<Object> pagination);

	/**
	 * Counts rows in the T17Autonomia table.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @return List
	 */
	Long findAllCount(T17Autonomia t17autonomia);

	/**
	 * Finds rows in the T17Autonomia table using like.
	 * 
	 * @param t17autonomia
	 *            T17Autonomia
	 * @param pagination
	 *            Pagination<Object>
	 * @param startsWith
	 *            Boolean
	 * 
	 * @return List<T17Autonomia>
	 */
	List<T17Autonomia> findAllLike(T17Autonomia t17autonomia, Pagination<Object> pagination, Boolean startsWith);
}
