package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoVentasDaoImpl implements TipoVentasDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPOVENTA", "DESCTIPOES", "DESCTIPOEU", "BAJA",
			"FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TipoVenta> rwMap = new RowMapper<TipoVenta>() {
		public TipoVenta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoVenta(resultSet.getLong("IDTIPOVENTA"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<TipoVenta> rwMapPK = new RowMapper<TipoVenta>() {
		public TipoVenta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoVenta(resultSet.getLong("IDTIPOVENTA"));
		}
	};

	private RowMapper<TipoVenta> rwFindMap = new RowMapper<TipoVenta>() {
		public TipoVenta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TipoVenta tipoVenta = new TipoVenta();
			tipoVenta.setIdTipoVenta(resultSet.getLong("IDTIPOVENTA"));
			tipoVenta.setDescTipoEs(resultSet.getString("DESCTIPOES"));
			tipoVenta.setDescTipoEu(resultSet.getString("DESCTIPOEU"));
			tipoVenta.setBaja(resultSet.getInt("BAJA"));
			tipoVenta.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			tipoVenta.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			tipoVenta.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			tipoVenta.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			tipoVenta.setIdProcedimiento(resultSet.getLong("IDPROCEDIMIENTO"));
			return tipoVenta;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<TipoVenta>> rwMapJerarquia = new RowMapper<JerarquiaDto<TipoVenta>>() {
		public JerarquiaDto<TipoVenta> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			TipoVenta tipoVenta = new TipoVenta(resultSet.getLong("IDTIPOVENTA"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<TipoVenta> jerarquia = new JerarquiaDto<TipoVenta>();
			jerarquia.setModel(tipoVenta);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	public TipoVenta add(TipoVenta tipoVenta) {
		String query = "INSERT INTO AB7804S00 (ID_TIPO_VENTA, DESC_TIPO_ES, DESC_TIPO_EU, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (AB7804Q00.NEXTVAL,?,?,?,SYSDATE,?,?)";
		Long idProd = null;
		if (tipoVenta.getIdProcedimiento() != null && tipoVenta.getIdProcedimiento() != 0L) {
			idProd = tipoVenta.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, tipoVenta.getDescTipoEs(), tipoVenta.getDescTipoEu(), tipoVenta.getBaja(),
				UtilUsuario.getUserConnected(), idProd);
		return tipoVenta;
	}

	/**
	 * Updates a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	public TipoVenta update(TipoVenta tipoVenta) {
		String query = "UPDATE AB7804S00 SET DESC_TIPO_ES=?, DESC_TIPO_EU=?, BAJA=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ID_PROCEDIMIENTO=? WHERE ID_TIPO_VENTA=?";
		Long idProd = null;
		if (tipoVenta.getIdProcedimiento() != null && tipoVenta.getIdProcedimiento() != 0L) {
			idProd = tipoVenta.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, tipoVenta.getDescTipoEs(), tipoVenta.getDescTipoEu(), tipoVenta.getBaja(),
				UtilUsuario.getUserConnected(), idProd, tipoVenta.getIdTipoVenta());
		return tipoVenta;
	}

	/**
	 * Finds a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	@Transactional(readOnly = true)
	public TipoVenta find(TipoVenta tipoVenta) {
		String query = "SELECT t1.ID_TIPO_VENTA IDTIPOVENTA, t1.DESC_TIPO_ES DESCTIPOES, t1.DESC_TIPO_EU DESCTIPOEU, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO FROM AB7804S00 t1  WHERE t1.ID_TIPO_VENTA = ?  ";

		List<TipoVenta> ab7804s00List = this.jdbcTemplate.query(query, this.rwFindMap, tipoVenta.getIdTipoVenta());
		return (TipoVenta) DataAccessUtils.uniqueResult(ab7804s00List);
	}

	/**
	 * Removes a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return
	 */
	public void remove(TipoVenta tipoVenta) {
		String query = "DELETE FROM AB7804S00 WHERE ID_TIPO_VENTA=?";
		this.jdbcTemplate.update(query, tipoVenta.getIdTipoVenta());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<TipoVenta> getMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterAb7804s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, TipoVenta.class, params,
				"ID_TIPO_VENTA");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	@Transactional(readOnly = true)
	public List<TipoVenta> findAll(TipoVenta tipoVenta, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7804S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoVenta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, TipoVentasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TipoVenta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoVenta>
	 */
	@Transactional(readOnly = true)
	public List<TipoVenta> findAllFilterProcedimiento(TipoVenta tipoVenta, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7804S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapProcedimiento(tipoVenta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO (+)");
		where.append(" AND (t1.ID_PROCEDIMIENTO IS NULL");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, TipoVentasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TipoVenta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoVenta>
	 */
	@Transactional(readOnly = true)
	public List<TipoVenta> findAllLike(TipoVenta tipoVenta, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7804S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(tipoVenta, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, TipoVentasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TipoVenta>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoVenta tipoVenta) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7804S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoVenta);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoVenta tipoVenta, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7804S00 t1, PROCEDIMIENTOS t2 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(tipoVenta, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of TipoVenta selected for rup_table
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	@Override
	public List<TableRowDto<TipoVenta>> reorderSelection(TipoVenta tipoVenta, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7804S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoVenta, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, TipoVenta.class,
				filterParamList, "IDTIPOVENTA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoVenta>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            TipoVenta
	 * @param searchParams
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	@Override
	public List<TableRowDto<TipoVenta>> search(TipoVenta filterParams, TipoVenta searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7804S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, TipoVenta.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDTIPOVENTA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoVenta>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterab7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(TipoVenta filterab7804s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7804S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab7804s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, TipoVenta.class, query,
				params, "IDTIPOVENTA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TipoVenta>>
	 */
	@Override
	public List<JerarquiaDto<TipoVenta>> findAllLikeJerarquia(TipoVenta filterAb7804s00,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_VENTA IDTIPOVENTA,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7804S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7804S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7804s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDTIPOVENTA", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					TipoVentasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7804S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7804S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7804s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDTIPOVENTA", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TipoVenta>>
	 */
	@Override
	public List<TableRowDto<TipoVenta>> findAllChild(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7804S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7804S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7804s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDTIPOVENTA",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TipoVenta>(this.rwMapPK, "IDTIPOVENTA"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoVenta entity
	 *
	 * @param tipoVenta
	 *            TipoVenta Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TipoVenta tipoVenta) {

		StringBuilder where = new StringBuilder(TipoVentasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoVenta != null && tipoVenta.getIdTipoVenta() != null) {
			where.append(" AND t1.ID_TIPO_VENTA = ?");
			params.add(tipoVenta.getIdTipoVenta());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(tipoVenta.getDescTipoEs());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(tipoVenta.getDescTipoEu());
		}
		if (tipoVenta != null && tipoVenta.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoVenta.getBaja());
		}
		if (tipoVenta != null && tipoVenta.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoVenta.getFechaRegistro());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tipoVenta.getUsuarioRegistro());
		}
		if (tipoVenta != null && tipoVenta.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoVenta.getFechaUltmodificacion());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(tipoVenta.getUsuarioUltmodificacion());
		}
		if (tipoVenta != null && tipoVenta.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(tipoVenta.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	private Map<String, ?> getWhereMapProcedimiento(TipoVenta tipoVenta) {

		StringBuilder where = new StringBuilder(TipoVentasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// IMPORTANTE, dejar al final del metodo, se esta aadiendo un cierre de
		// parentesis en caso de que el id procedimiento sea null
		if (tipoVenta != null && tipoVenta.getIdProcedimiento() != null) {
			where.append(" OR t1.ID_PROCEDIMIENTO = ?) ");
			params.add(tipoVenta.getIdProcedimiento());
		} else if (tipoVenta != null && tipoVenta.getIdProcedimiento() == null) {

			where.append(" ) ");
		}
		if (tipoVenta != null && tipoVenta.getIdTipoVenta() != null) {
			where.append(" AND t1.ID_TIPO_VENTA = ?");
			params.add(tipoVenta.getIdTipoVenta());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(tipoVenta.getDescTipoEs());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(tipoVenta.getDescTipoEu());
		}
		if (tipoVenta != null && tipoVenta.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoVenta.getBaja());
		}
		if (tipoVenta != null && tipoVenta.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoVenta.getFechaRegistro());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tipoVenta.getUsuarioRegistro());
		}
		if (tipoVenta != null && tipoVenta.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoVenta.getFechaUltmodificacion());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(tipoVenta.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoVenta entity
	 *
	 * @param tipoVenta
	 *            TipoVenta Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TipoVenta tipoVenta, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoVentasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoVenta != null && tipoVenta.getIdTipoVenta() != null) {
			where.append(" AND t1.ID_TIPO_VENTA = ?");
			params.add(tipoVenta.getIdTipoVenta());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoVenta.getBaja());
		}
		if (tipoVenta != null && tipoVenta.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoVenta.getFechaRegistro());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoVenta.getFechaUltmodificacion());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(tipoVenta.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapProcedimiento(TipoVenta tipoVenta, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoVentasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoVenta != null && tipoVenta.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(tipoVenta.getIdProcedimiento());
		} else if (tipoVenta != null && tipoVenta.getIdProcedimiento() == null) {

			where.append(" (+) ");
		}
		if (tipoVenta != null && tipoVenta.getIdTipoVenta() != null) {
			where.append(" AND t1.ID_TIPO_VENTA = ?");
			params.add(tipoVenta.getIdTipoVenta());
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoVenta.getBaja());
		}
		if (tipoVenta != null && tipoVenta.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoVenta.getFechaRegistro());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (tipoVenta != null && tipoVenta.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoVenta.getFechaUltmodificacion());
		}
		if (tipoVenta != null && tipoVenta.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoVenta.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tipoVenta.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
