package com.ejie.ab78.dao.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasDao  
 * 
 *  
 */

public interface TipoVentasDao {

	/**
	 * Inserts a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta add(TipoVenta tipoVenta);

	/**
	 * Updates a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta update(TipoVenta tipoVenta);

	/**
	 * Finds a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return TipoVenta
	 */
	TipoVenta find(TipoVenta tipoVenta);

	/**
	 * Removes a single row in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 */
	void remove(TipoVenta tipoVenta);

	/**
	 * Finds a List of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TipoVenta> findAll(TipoVenta tipoVenta, TableRequestDto tableRequestDto);

	/**
	 * Finds a List of rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TipoVenta> findAllFilterProcedimiento(TipoVenta tipoVenta, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoVenta> findAllLike(TipoVenta tipoVenta, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the TipoVenta table using like.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipoVenta tipoVenta, Boolean startsWith);

	/**
	 * Counts rows in the TipoVenta table.
	 *
	 * @param tipoVenta
	 *            TipoVenta
	 * @return Long
	 */
	Long findAllCount(TipoVenta tipoVenta);

	/**
	 * Reorder selection.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	List<TableRowDto<TipoVenta>> reorderSelection(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param searchAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoVenta>>
	 */
	List<TableRowDto<TipoVenta>> search(TipoVenta filterAb7804s00, TipoVenta searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical TipoVenta table.
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TipoVenta>>
	 */
	List<JerarquiaDto<TipoVenta>> findAllLikeJerarquia(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7804s00
	 *            TipoVenta
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TipoVenta>>
	 */
	List<TableRowDto<TipoVenta>> findAllChild(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<TipoVenta> getMultiple(TipoVenta filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
