package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoReclamacionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoReclamacionesDaoImpl implements TipoReclamacionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPORECLAMACION", "DESCTIPOES", "DESCTIPOEU",
			"BAJA", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TipoReclamacion> rwMap = new RowMapper<TipoReclamacion>() {
		public TipoReclamacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoReclamacion(resultSet.getLong("IDTIPORECLAMACION"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<TipoReclamacion> rwFindMap = new RowMapper<TipoReclamacion>() {
		public TipoReclamacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			TipoReclamacion tipoReclamacion = new TipoReclamacion();
			tipoReclamacion.setIdTipoReclamacion(resultSet.getLong("IDTIPORECLAMACION"));
			tipoReclamacion.setDescTipoEs(resultSet.getString("DESCTIPOES"));
			tipoReclamacion.setDescTipoEu(resultSet.getString("DESCTIPOEU"));
			tipoReclamacion.setBaja(resultSet.getInt("BAJA"));
			tipoReclamacion.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			tipoReclamacion.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			tipoReclamacion.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			tipoReclamacion.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			tipoReclamacion.setIdProcedimiento(resultSet.getLong("IDPROCEDIMIENTO"));
			return tipoReclamacion;
		}
	};

	private RowMapper<TipoReclamacion> rwMapPK = new RowMapper<TipoReclamacion>() {
		public TipoReclamacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoReclamacion(resultSet.getLong("IDTIPORECLAMACION"));
		}
	};

	/**
	 * Rowmapper para Jerarqua
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<TipoReclamacion>> rwMapJerarquia = new RowMapper<JerarquiaDto<TipoReclamacion>>() {
		public JerarquiaDto<TipoReclamacion> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			TipoReclamacion tipoReclamacion = new TipoReclamacion(resultSet.getLong("IDTIPORECLAMACION"),
					resultSet.getString("DESCTIPOES"), resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<TipoReclamacion> jerarquia = new JerarquiaDto<TipoReclamacion>();
			jerarquia.setModel(tipoReclamacion);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion add(TipoReclamacion tipoReclamacion) {
		String query = "INSERT INTO AB7805S00 (ID_TIPO_RECLAMACION, DESC_TIPO_ES, DESC_TIPO_EU, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (AB7805Q00.NEXTVAL,?,?,?,SYSDATE,?,?)";
		Long idProd = null;
		if (tipoReclamacion.getIdProcedimiento() != null && tipoReclamacion.getIdProcedimiento() != 0L) {
			idProd = tipoReclamacion.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, tipoReclamacion.getDescTipoEs(), tipoReclamacion.getDescTipoEu(),
				tipoReclamacion.getBaja(), UtilUsuario.getUserConnected(), idProd);
		return tipoReclamacion;
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion update(TipoReclamacion tipoReclamacion) {
		String query = "UPDATE AB7805S00 SET DESC_TIPO_ES=?, DESC_TIPO_EU=?, BAJA=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ID_PROCEDIMIENTO=? WHERE ID_TIPO_RECLAMACION=?";
		Long idProd = null;
		if (tipoReclamacion.getIdProcedimiento() != null && tipoReclamacion.getIdProcedimiento() != 0L) {
			idProd = tipoReclamacion.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, tipoReclamacion.getDescTipoEs(), tipoReclamacion.getDescTipoEu(),
				tipoReclamacion.getBaja(), UtilUsuario.getUserConnected(), idProd,
				tipoReclamacion.getIdTipoReclamacion());
		return tipoReclamacion;
	}

	/**
	 * Finds a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(readOnly = true)
	public TipoReclamacion find(TipoReclamacion tipoReclamacion) {
		String query = "SELECT t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION, t1.DESC_TIPO_ES DESCTIPOES, t1.DESC_TIPO_EU DESCTIPOEU, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO FROM AB7805S00 t1  WHERE t1.ID_TIPO_RECLAMACION = ?  ";

		List<TipoReclamacion> ab7805s00List = this.jdbcTemplate.query(query, this.rwFindMap,
				tipoReclamacion.getIdTipoReclamacion());
		return (TipoReclamacion) DataAccessUtils.uniqueResult(ab7805s00List);
	}

	/**
	 * Removes a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return
	 */
	public void remove(TipoReclamacion tipoReclamacion) {
		String query = "DELETE FROM AB7805S00 WHERE ID_TIPO_RECLAMACION=?";
		this.jdbcTemplate.update(query, tipoReclamacion.getIdTipoReclamacion());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<TipoReclamacion> getMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterAb7805s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, TipoReclamacion.class,
				params, "ID_TIPO_RECLAMACION");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TipoReclamacion>
	 */
	@Transactional(readOnly = true)
	public List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7805S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoReclamacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					TipoReclamacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TipoReclamacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TipoReclamacion>
	 */
	@Transactional(readOnly = true)
	public List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7805S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(tipoReclamacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					TipoReclamacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<TipoReclamacion>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TipoReclamacion tipoReclamacion) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7805S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tipoReclamacion);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoReclamacion tipoReclamacion, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7805S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(tipoReclamacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of TipoReclamacion selected for rup_table
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	@Override
	public List<TableRowDto<TipoReclamacion>> reorderSelection(TipoReclamacion tipoReclamacion,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7805S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(tipoReclamacion, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parmetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenacin
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto,
				TipoReclamacion.class, filterParamList, "IDTIPORECLAMACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoReclamacion>(this.rwMapPK, tableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            TipoReclamacion
	 * @param searchParams
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	@Override
	public List<TableRowDto<TipoReclamacion>> search(TipoReclamacion filterParams, TipoReclamacion searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7805S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, TipoReclamacion.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDTIPORECLAMACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TipoReclamacion>(this.rwMapPK, tableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterab7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(TipoReclamacion filterab7805s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7805S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab7805s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, TipoReclamacion.class,
				query, params, "IDTIPORECLAMACION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TipoReclamacion>>
	 */
	@Override
	public List<JerarquiaDto<TipoReclamacion>> findAllLikeJerarquia(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_TIPO_RECLAMACION IDTIPORECLAMACION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO ID_PROCEDIMIENTO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7805S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7805S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqua
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7805s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDTIPORECLAMACION", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					TipoReclamacionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7805S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7805S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqua
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7805s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDTIPORECLAMACION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	@Override
	public List<TableRowDto<TipoReclamacion>> findAllChild(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7805S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7805S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarqua
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7805s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDTIPORECLAMACION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<TipoReclamacion>(this.rwMapPK, "IDTIPORECLAMACION"), params.toArray());
	}

	/*
	 * MTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoReclamacion entity
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, ?> getWhereMap(TipoReclamacion tipoReclamacion) {

		StringBuilder where = new StringBuilder(TipoReclamacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoReclamacion != null && tipoReclamacion.getIdTipoReclamacion() != null) {
			where.append(" AND t1.ID_TIPO_RECLAMACION = ?");
			params.add(tipoReclamacion.getIdTipoReclamacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(tipoReclamacion.getDescTipoEs());
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(tipoReclamacion.getDescTipoEu());
		}
		if (tipoReclamacion != null && tipoReclamacion.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoReclamacion.getBaja());
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoReclamacion.getFechaRegistro());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(tipoReclamacion.getUsuarioRegistro());
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoReclamacion.getFechaUltmodificacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(tipoReclamacion.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TipoReclamacion entity
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generacin de cdigo de UDA
	private Map<String, Object> getWhereLikeMap(TipoReclamacion tipoReclamacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoReclamacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoReclamacion != null && tipoReclamacion.getIdTipoReclamacion() != null) {
			where.append(" AND t1.ID_TIPO_RECLAMACION = ?");
			params.add(tipoReclamacion.getIdTipoReclamacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoReclamacion.getBaja());
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoReclamacion.getFechaRegistro());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoReclamacion.getFechaUltmodificacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapProcedimiento(TipoReclamacion tipoReclamacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoReclamacionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (tipoReclamacion != null && tipoReclamacion.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(tipoReclamacion.getIdProcedimiento());
		} else if (tipoReclamacion != null && tipoReclamacion.getIdProcedimiento() == null) {

			where.append(" (+) ");
		}
		if (tipoReclamacion != null && tipoReclamacion.getIdTipoReclamacion() != null) {
			where.append(" AND t1.ID_TIPO_RECLAMACION = ?");
			params.add(tipoReclamacion.getIdTipoReclamacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(tipoReclamacion.getBaja());
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(tipoReclamacion.getFechaRegistro());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (tipoReclamacion != null && tipoReclamacion.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(tipoReclamacion.getFechaUltmodificacion());
		}
		if (tipoReclamacion != null && tipoReclamacion.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(tipoReclamacion.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + tipoReclamacion.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generacin de cdigo de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
