package com.ejie.ab78.dao.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoReclamacionesDao  
 * 
 *  
 */

public interface TipoReclamacionesDao {

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion add(TipoReclamacion tipoReclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion update(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion find(TipoReclamacion tipoReclamacion);

	/**
	 * Removes a single row in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 */
	void remove(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the TipoReclamacion table using like.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipoReclamacion tipoReclamacion, Boolean startsWith);

	/**
	 * Counts rows in the TipoReclamacion table.
	 *
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	Long findAllCount(TipoReclamacion tipoReclamacion);

	/**
	 * Reorder selection.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	List<TableRowDto<TipoReclamacion>> reorderSelection(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param searchAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	List<TableRowDto<TipoReclamacion>> search(TipoReclamacion filterAb7805s00, TipoReclamacion searchAb7805s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical TipoReclamacion table.
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<TipoReclamacion>>
	 */
	List<JerarquiaDto<TipoReclamacion>> findAllLikeJerarquia(TipoReclamacion filterAb7805s00,
			TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7805s00
	 *            TipoReclamacion
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<TipoReclamacion>>
	 */
	List<TableRowDto<TipoReclamacion>> findAllChild(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<TipoReclamacion> getMultiple(TipoReclamacion filterAb7805s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
