package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.TipoEstablecimiento;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * Ab6311s00DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class TipoEstablecimientoDaoImpl implements TipoEstablecimientoDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDTIPOESTABLECIMIENTO", "DESCRIPCIONCASTELLANO",
			"BAJA", "DESCRIPCIONEUSKERA", "ORDENACION", "TIPIFICACION", "FECHAREGISTRO",
			"USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION", "PROCLEYES", "PROCLEYEU", "PROCDECES",
			"PROCDECEU" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TipoEstablecimiento> rwMap = new RowMapper<TipoEstablecimiento>() {
		public TipoEstablecimiento mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TipoEstablecimiento(resultSet.getString("IDTIPOESTABLECIMIENTO"),
					resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getInt("BAJA"), resultSet.getString("DESCRIPCIONEUSKERA"),
					resultSet.getString("ORDENACION"), resultSet.getString("TIPIFICACION"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"),
					resultSet.getString("PROCLEYES"), resultSet.getString("PROCLEYEU"),
					resultSet.getString("PROCDECES"), resultSet.getString("PROCDECEU"));
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	public TipoEstablecimiento add(TipoEstablecimiento ab6311s00) {
		String query = "INSERT INTO TIPOS_ESTABLECIMIENTO (ID_TIPO_ESTABLECIMIENTO, DESCRIPCION_CASTELLANO, BAJA, DESCRIPCION_EUSKERA, ORDENACION, TIPIFICACION, FECHA_REGISTRO, USUARIO_REGISTRO, PROCEDIMIENTO_LEY, PROCEDIMIENTO_LEY_EU, PROCEDIMIENTO_DECRETO, PROCEDIMIENTO_DECRETO_EU) VALUES (?,?,?,?,?,?,SYSDATE,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ab6311s00.getIdTipoEstablecimiento(), ab6311s00.getDescripcionCastellano(),
				ab6311s00.getBaja(), ab6311s00.getDescripcionEuskera(), ab6311s00.getOrdenacion(), ab6311s00.getTipificacion(),
				UtilUsuario.getUserConnected(), ab6311s00.getProcedimientoLeyEs(), ab6311s00.getProcedimientoLeyEu(),
				ab6311s00.getProcedimientoDecretoEs(), ab6311s00.getProcedimientoDecretoEu());
		return ab6311s00;
	}

	public TipoEstablecimiento update(TipoEstablecimiento ab6311s00) {
		String query = "UPDATE TIPOS_ESTABLECIMIENTO SET DESCRIPCION_CASTELLANO=?, DESCRIPCION_EUSKERA=?, BAJA=?, ORDENACION=?, TIPIFICACION=?, PROCEDIMIENTO_LEY=?, PROCEDIMIENTO_LEY_EU=?, PROCEDIMIENTO_DECRETO=?, PROCEDIMIENTO_DECRETO_EU=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_TIPO_ESTABLECIMIENTO=?";
		this.jdbcTemplate.update(query, ab6311s00.getDescripcionCastellano(), ab6311s00.getDescripcionEuskera(), ab6311s00.getBaja(),
				ab6311s00.getOrdenacion(), ab6311s00.getTipificacion(), ab6311s00.getProcedimientoLeyEs(),
				ab6311s00.getProcedimientoLeyEu(), ab6311s00.getProcedimientoDecretoEs(),
				ab6311s00.getProcedimientoDecretoEu(), UtilUsuario.getUserConnected(),
				ab6311s00.getIdTipoEstablecimiento());
		return ab6311s00;
	}

	@Transactional(readOnly = true)
	public TipoEstablecimiento find(TipoEstablecimiento ab6311s00) {
		String query = "SELECT t6311.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO, t6311.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t6311.BAJA BAJA, t6311.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t6311.ORDENACION ORDENACION, t6311.TIPIFICACION TIPIFICACION, t6311.FECHA_REGISTRO FECHAREGISTRO, t6311.USUARIO_REGISTRO USUARIOREGISTRO, t6311.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t6311.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t6311.PROCEDIMIENTO_LEY PROCLEYES, t6311.PROCEDIMIENTO_LEY_EU PROCLEYEU, t6311.PROCEDIMIENTO_DECRETO PROCDECES, t6311.PROCEDIMIENTO_DECRETO_EU PROCDECEU FROM TIPOS_ESTABLECIMIENTO t6311  WHERE t6311.ID_TIPO_ESTABLECIMIENTO = ?  ";

		List<TipoEstablecimiento> ab6311s00List = this.jdbcTemplate.query(query, this.rwMap,
				ab6311s00.getIdTipoEstablecimiento());
		return DataAccessUtils.uniqueResult(ab6311s00List);
	}

	public void remove(TipoEstablecimiento ab6311s00) {
		String query = "DELETE FROM TIPOS_ESTABLECIMIENTO WHERE ID_TIPO_ESTABLECIMIENTO=?";
		this.jdbcTemplate.update(query, ab6311s00.getIdTipoEstablecimiento());
	}

	@Transactional(readOnly = true)
	public List<TipoEstablecimiento> findAll(TipoEstablecimiento ab6311s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t6311.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO,t6311.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t6311.BAJA BAJA,t6311.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t6311.ORDENACION ORDENACION,t6311.TIPIFICACION TIPIFICACION,t6311.FECHA_REGISTRO FECHAREGISTRO,t6311.USUARIO_REGISTRO USUARIOREGISTRO,t6311.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t6311.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t6311.PROCEDIMIENTO_LEY PROCLEYES, t6311.PROCEDIMIENTO_LEY_EU PROCLEYEU, t6311.PROCEDIMIENTO_DECRETO PROCDECES, t6311.PROCEDIMIENTO_DECRETO_EU PROCDECEU ");
		query.append("FROM TIPOS_ESTABLECIMIENTO t6311 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab6311s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query,
					TipoEstablecimientoDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<TipoEstablecimiento> findAllLike(TipoEstablecimiento ab6311s00, TableRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t6311.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO,t6311.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t6311.BAJA BAJA,t6311.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t6311.ORDENACION ORDENACION,t6311.TIPIFICACION TIPIFICACION,t6311.FECHA_REGISTRO FECHAREGISTRO,t6311.USUARIO_REGISTRO USUARIOREGISTRO,t6311.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t6311.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t6311.PROCEDIMIENTO_LEY PROCLEYES, t6311.PROCEDIMIENTO_LEY_EU PROCLEYEU, t6311.PROCEDIMIENTO_DECRETO PROCDECES, t6311.PROCEDIMIENTO_DECRETO_EU PROCDECEU ");
		query.append("FROM TIPOS_ESTABLECIMIENTO t6311 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab6311s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = TableManager.getPaginationQuery(jqGridRequestDto, query,
					TipoEstablecimientoDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public Long findAllCount(TipoEstablecimiento ab6311s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOS_ESTABLECIMIENTO t6311 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab6311s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	@Transactional(readOnly = true)
	public Long findAllLikeCount(TipoEstablecimiento ab6311s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM TIPOS_ESTABLECIMIENTO t6311 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab6311s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	
	private Map<String, ?> getWhereMap(TipoEstablecimiento ab6311s00) {

		StringBuilder where = new StringBuilder(TipoEstablecimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab6311s00 != null && ab6311s00.getIdTipoEstablecimiento() != null) {
			where.append(" AND t6311.ID_TIPO_ESTABLECIMIENTO = ?");
			params.add(ab6311s00.getIdTipoEstablecimiento());
		}
		if (ab6311s00 != null && ab6311s00.getDescripcionCastellano() != null) {
			where.append(" AND t6311.DESCRIPCION_CASTELLANO = ?");
			params.add(ab6311s00.getDescripcionCastellano());
		}
		if (ab6311s00 != null && ab6311s00.getBaja() != null) {
			where.append(" AND t6311.BAJA = ?");
			params.add(ab6311s00.getBaja());
		}
		if (ab6311s00 != null && ab6311s00.getDescripcionEuskera() != null) {
			where.append(" AND t6311.DESCRIPCION_EUSKERA = ?");
			params.add(ab6311s00.getDescripcionEuskera());
		}
		if (ab6311s00 != null && ab6311s00.getOrdenacion() != null) {
			where.append(" AND t6311.ORDENACION = ?");
			params.add(ab6311s00.getOrdenacion());
		}
		if (ab6311s00 != null && ab6311s00.getTipificacion() != null) {
			where.append(" AND t6311.TIPIFICACION = ?");
			params.add(ab6311s00.getTipificacion());
		}
		if (ab6311s00 != null && ab6311s00.getFechaRegistro() != null) {
			where.append(" AND t6311.FECHA_REGISTRO = ?");
			params.add(ab6311s00.getFechaRegistro());
		}
		if (ab6311s00 != null && ab6311s00.getUsuarioRegistro() != null) {
			where.append(" AND t6311.USUARIO_REGISTRO = ?");
			params.add(ab6311s00.getUsuarioRegistro());
		}
		if (ab6311s00 != null && ab6311s00.getFechaUltmodificacion() != null) {
			where.append(" AND t6311.FECHA_ULTMODIFICACION = ?");
			params.add(ab6311s00.getFechaUltmodificacion());
		}
		if (ab6311s00 != null && ab6311s00.getUsuarioUltmodificacion() != null) {
			where.append(" AND t6311.USUARIO_ULTMODIFICACION = ?");
			params.add(ab6311s00.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(TipoEstablecimiento ab6311s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(TipoEstablecimientoDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab6311s00 != null && ab6311s00.getIdTipoEstablecimiento() != null) {
			where.append(" AND UPPER(t6311.ID_TIPO_ESTABLECIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getIdTipoEstablecimiento().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getIdTipoEstablecimiento().toUpperCase() + "%");
			}
			where.append(" AND t6311.ID_TIPO_ESTABLECIMIENTO IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t6311.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getDescripcionCastellano().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t6311.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getBaja() != null) {
			where.append(" AND t6311.BAJA = ?");
			params.add(ab6311s00.getBaja());
		}
		if (ab6311s00 != null && ab6311s00.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t6311.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getDescripcionEuskera().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t6311.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getOrdenacion() != null) {
			where.append(" AND UPPER(t6311.ORDENACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getOrdenacion().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getOrdenacion().toUpperCase() + "%");
			}
			where.append(" AND t6311.ORDENACION IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getTipificacion() != null) {
			where.append(" AND UPPER(t6311.TIPIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getTipificacion().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getTipificacion().toUpperCase() + "%");
			}
			where.append(" AND t6311.TIPIFICACION IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getFechaRegistro() != null) {
			where.append(" AND t6311.FECHA_REGISTRO = ?");
			params.add(ab6311s00.getFechaRegistro());
		}
		if (ab6311s00 != null && ab6311s00.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t6311.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t6311.USUARIO_REGISTRO IS NOT NULL");
		}
		if (ab6311s00 != null && ab6311s00.getFechaUltmodificacion() != null) {
			where.append(" AND t6311.FECHA_ULTMODIFICACION = ?");
			params.add(ab6311s00.getFechaUltmodificacion());
		}
		if (ab6311s00 != null && ab6311s00.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t6311.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t6311.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		if (ab6311s00 != null && ab6311s00.getProcedimientoLeyEs() != null) {
			where.append(" AND UPPER(t6311.PROCEDIMIENTO_LEY) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getProcedimientoLeyEs().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getProcedimientoLeyEs().toUpperCase() + "%");
			}
			where.append(" AND t6311.PROCEDIMIENTO_LEY IS NOT NULL");
		}

		if (ab6311s00 != null && ab6311s00.getProcedimientoLeyEu() != null) {
			where.append(" AND UPPER(t6311.PROCEDIMIENTO_LEY_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getProcedimientoLeyEu().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getProcedimientoLeyEu().toUpperCase() + "%");
			}
			where.append(" AND t6311.PROCEDIMIENTO_LEY_EU IS NOT NULL");
		}

		if (ab6311s00 != null && ab6311s00.getProcedimientoDecretoEs() != null) {
			where.append(" AND UPPER(t6311.PROCEDIMIENTO_DECRETO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getProcedimientoDecretoEs().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getProcedimientoDecretoEs().toUpperCase() + "%");
			}
			where.append(" AND t6311.PROCEDIMIENTO_DECRETO IS NOT NULL");
		}

		if (ab6311s00 != null && ab6311s00.getProcedimientoDecretoEu() != null) {
			where.append(" AND UPPER(t6311.PROCEDIMIENTO_DECRETO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab6311s00.getProcedimientoDecretoEu().toUpperCase() + "%");
			} else {
				params.add("%" + ab6311s00.getProcedimientoDecretoEu().toUpperCase() + "%");
			}
			where.append(" AND t6311.PROCEDIMIENTO_DECRETO_EU IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
