package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.Producto;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProductosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ProductosDaoImpl implements ProductosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDPRODUCTO", "DESCTIPOES", "DESCTIPOEU", "BAJA",
			"FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Producto> rwMap = new RowMapper<Producto>() {
		public Producto mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Producto(resultSet.getLong("IDPRODUCTO"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<Producto> rwMapPK = new RowMapper<Producto>() {
		public Producto mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Producto(resultSet.getLong("IDPRODUCTO"));
		}
	};

	private RowMapper<Producto> rwFindMap = new RowMapper<Producto>() {
		public Producto mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Producto producto = new Producto();
			producto.setIdProducto(resultSet.getLong("IDPRODUCTO"));
			producto.setDescTipoEs(resultSet.getString("DESCTIPOES"));
			producto.setDescTipoEu(resultSet.getString("DESCTIPOEU"));
			producto.setBaja(resultSet.getInt("BAJA"));
			producto.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			producto.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			producto.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			producto.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			producto.setIdProcedimiento(resultSet.getLong("IDPROCEDIMIENTO"));
			return producto;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Producto>> rwMapJerarquia = new RowMapper<JerarquiaDto<Producto>>() {
		public JerarquiaDto<Producto> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Producto producto = new Producto(resultSet.getLong("IDPRODUCTO"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<Producto> jerarquia = new JerarquiaDto<Producto>();
			jerarquia.setModel(producto);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto add(Producto producto) {
		String query = "INSERT INTO AB7803S00 (ID_PRODUCTO, DESC_TIPO_ES, DESC_TIPO_EU, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (AB7803Q00.NEXTVAL,?,?,?,SYSDATE,?,?)";
		Long idProd = null;
		if (producto.getIdProcedimiento() != null && producto.getIdProcedimiento() != 0L) {
			idProd = producto.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, producto.getDescTipoEs(), producto.getDescTipoEu(), producto.getBaja(),
				UtilUsuario.getUserConnected(), idProd);
		return producto;
	}

	/**
	 * Updates a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	public Producto update(Producto producto) {
		String query = "UPDATE AB7803S00 SET DESC_TIPO_ES=?, DESC_TIPO_EU=?, BAJA=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ID_PROCEDIMIENTO=? WHERE ID_PRODUCTO=?";
		Long idProd = null;
		if (producto.getIdProcedimiento() != null && producto.getIdProcedimiento() != 0L) {
			idProd = producto.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, producto.getDescTipoEs(), producto.getDescTipoEu(), producto.getBaja(),
				UtilUsuario.getUserConnected(), idProd, producto.getIdProducto());
		return producto;
	}

	/**
	 * Finds a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@Transactional(readOnly = true)
	public Producto find(Producto producto) {
		String query = "SELECT t1.ID_PRODUCTO IDPRODUCTO, t1.DESC_TIPO_ES DESCTIPOES, t1.DESC_TIPO_EU DESCTIPOEU, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO FROM AB7803S00 t1  WHERE t1.ID_PRODUCTO = ?  ";

		List<Producto> ab7803s00List = this.jdbcTemplate.query(query, this.rwFindMap, producto.getIdProducto());
		return (Producto) DataAccessUtils.uniqueResult(ab7803s00List);
	}

	/**
	 * Removes a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return
	 */
	public void remove(Producto producto) {
		String query = "DELETE FROM AB7803S00 WHERE ID_PRODUCTO=?";
		this.jdbcTemplate.update(query, producto.getIdProducto());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Producto> getMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterAb7803s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, Producto.class, params,
				"ID_PRODUCTO");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAll(Producto producto, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7803S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(producto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ProductosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Producto>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Producto>
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAllFilterProcedimiento(Producto producto, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7803S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapProcedimiento(producto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO (+)");
		where.append(" AND (t1.ID_PROCEDIMIENTO IS NULL");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ProductosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Producto>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Producto>
	 */
	@Transactional(readOnly = true)
	public List<Producto> findAllLike(Producto producto, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7803S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(producto, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ProductosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Producto>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Producto producto) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7803S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(producto);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Producto producto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7803S00 t1, PROCEDIMIENTOS t2 ");

		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(producto, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of Producto selected for rup_table
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	@Override
	public List<TableRowDto<Producto>> reorderSelection(Producto producto, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7803S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(producto, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, Producto.class,
				filterParamList, "IDPRODUCTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Producto>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Producto
	 * @param searchParams
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	@Override
	public List<TableRowDto<Producto>> search(Producto filterParams, Producto searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7803S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, Producto.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDPRODUCTO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Producto>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterab7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Producto filterab7803s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7803S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab7803s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, Producto.class, query,
				params, "IDPRODUCTO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Producto>>
	 */
	@Override
	public List<JerarquiaDto<Producto>> findAllLikeJerarquia(Producto filterAb7803s00,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_PRODUCTO IDPRODUCTO,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7803S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7803S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7803s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDPRODUCTO", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					ProductosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Producto filterAb7803s00, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7803S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7803S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7803s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDPRODUCTO", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Producto>>
	 */
	@Override
	public List<TableRowDto<Producto>> findAllChild(Producto filterAb7803s00, TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7803S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7803S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7803s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDPRODUCTO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Producto>(this.rwMapPK, "IDPRODUCTO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Producto entity
	 *
	 * @param producto
	 *            Producto Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Producto producto) {

		StringBuilder where = new StringBuilder(ProductosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (producto != null && producto.getIdProducto() != null) {
			where.append(" AND t1.ID_PRODUCTO = ?");
			params.add(producto.getIdProducto());
		}
		if (producto != null && producto.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(producto.getDescTipoEs());
		}
		if (producto != null && producto.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(producto.getDescTipoEu());
		}
		if (producto != null && producto.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(producto.getBaja());
		}
		if (producto != null && producto.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(producto.getFechaRegistro());
		}
		if (producto != null && producto.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(producto.getUsuarioRegistro());
		}
		if (producto != null && producto.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(producto.getFechaUltmodificacion());
		}
		if (producto != null && producto.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(producto.getUsuarioUltmodificacion());
		}
		if (producto != null && producto.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(producto.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	private Map<String, ?> getWhereMapProcedimiento(Producto producto) {

		StringBuilder where = new StringBuilder(ProductosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// IMPORTANTE, dejar al final del metodo, se esta aadiendo un cierre de
		// parentesis en caso de que el id procedimiento sea null
		if (producto != null && producto.getIdProcedimiento() != null) {
			where.append(" OR t1.ID_PROCEDIMIENTO = ?) ");
			params.add(producto.getIdProcedimiento());
		} else if (producto != null && producto.getIdProcedimiento() == null) {

			where.append(" ) ");
		}
		if (producto != null && producto.getIdProducto() != null) {
			where.append(" AND t1.ID_PRODUCTO = ?");
			params.add(producto.getIdProducto());
		}
		if (producto != null && producto.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(producto.getDescTipoEs());
		}
		if (producto != null && producto.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(producto.getDescTipoEu());
		}
		if (producto != null && producto.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(producto.getBaja());
		}
		if (producto != null && producto.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(producto.getFechaRegistro());
		}
		if (producto != null && producto.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(producto.getUsuarioRegistro());
		}
		if (producto != null && producto.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(producto.getFechaUltmodificacion());
		}
		if (producto != null && producto.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(producto.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Producto entity
	 *
	 * @param producto
	 *            Producto Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Producto producto, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ProductosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (producto != null && producto.getIdProducto() != null) {
			where.append(" AND t1.ID_PRODUCTO = ?");
			params.add(producto.getIdProducto());
		}
		if (producto != null && producto.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (producto != null && producto.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (producto != null && producto.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(producto.getBaja());
		}
		if (producto != null && producto.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(producto.getFechaRegistro());
		}
		if (producto != null && producto.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (producto != null && producto.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(producto.getFechaUltmodificacion());
		}
		if (producto != null && producto.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		if (producto != null && producto.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(producto.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapProcedimiento(Producto producto, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ProductosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (producto != null && producto.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(producto.getIdProcedimiento());
		} else if (producto != null && producto.getIdProcedimiento() == null) {

			where.append(" (+) ");
		}
		if (producto != null && producto.getIdProducto() != null) {
			where.append(" AND t1.ID_PRODUCTO = ?");
			params.add(producto.getIdProducto());
		}
		if (producto != null && producto.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (producto != null && producto.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (producto != null && producto.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(producto.getBaja());
		}
		if (producto != null && producto.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(producto.getFechaRegistro());
		}
		if (producto != null && producto.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (producto != null && producto.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(producto.getFechaUltmodificacion());
		}
		if (producto != null && producto.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(producto.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + producto.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
