package com.ejie.ab78.dao.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Producto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ProductosDao  
 * 
 *  
 */

public interface ProductosDao {

	/**
	 * Inserts a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto add(Producto producto);

	/**
	 * Updates a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto update(Producto producto);

	/**
	 * Finds a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	Producto find(Producto producto);

	/**
	 * Removes a single row in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 */
	void remove(Producto producto);

	/**
	 * Finds a List of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Producto> findAll(Producto producto, TableRequestDto tableRequestDto);

	/**
	 * Finds a List of rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Producto> findAllFilterProcedimiento(Producto producto, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Producto> findAllLike(Producto producto, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Producto table using like.
	 *
	 * @param producto
	 *            Producto
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Producto producto, Boolean startsWith);

	/**
	 * Counts rows in the Producto table.
	 *
	 * @param producto
	 *            Producto
	 * @return Long
	 */
	Long findAllCount(Producto producto);

	/**
	 * Reorder selection.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	List<TableRowDto<Producto>> reorderSelection(Producto filterAb7803s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param searchAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Producto>>
	 */
	List<TableRowDto<Producto>> search(Producto filterAb7803s00, Producto searchAb7803s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Producto table.
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Producto>>
	 */
	List<JerarquiaDto<Producto>> findAllLikeJerarquia(Producto filterAb7803s00, TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Producto filterAb7803s00, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7803s00
	 *            Producto
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Producto>>
	 */
	List<TableRowDto<Producto>> findAllChild(Producto filterAb7803s00, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Producto> getMultiple(Producto filterAb7803s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
