package com.ejie.ab78.dao.maestros;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.Motivo;

/**
 * MotivosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class MotivosDaoImpl implements MotivosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDMOTIVO", "DESCMOTIVOES", "DESCMOTIVOEU",
			"BAJA", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Motivo> rwMap = new RowMapper<Motivo>() {
		public Motivo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Motivo(resultSet.getLong("IDMOTIVO"), resultSet.getString("DESCMOTIVOES"),
					resultSet.getString("DESCMOTIVOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<Motivo> rwMapPK = new RowMapper<Motivo>() {
		public Motivo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Motivo(resultSet.getLong("IDMOTIVO"));
		}
	};

	private RowMapper<Motivo> rwFindMap = new RowMapper<Motivo>() {
		public Motivo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Motivo motivo = new Motivo();
			motivo.setIdMotivo(resultSet.getLong("IDMOTIVO"));
			motivo.setDescMotivoEs(resultSet.getString("DESCMOTIVOES"));
			motivo.setDescMotivoEu(resultSet.getString("DESCMOTIVOEU"));
			motivo.setBaja(resultSet.getInt("BAJA"));
			motivo.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			motivo.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			motivo.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			motivo.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			motivo.setIdProcedimiento(resultSet.getLong("IDPROCEDIMIENTO"));
			return motivo;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Motivo>> rwMapJerarquia = new RowMapper<JerarquiaDto<Motivo>>() {
		public JerarquiaDto<Motivo> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Motivo motivo = new Motivo(resultSet.getLong("IDMOTIVO"), resultSet.getString("DESCMOTIVOES"),
					resultSet.getString("DESCMOTIVOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<Motivo> jerarquia = new JerarquiaDto<Motivo>();
			jerarquia.setModel(motivo);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public Motivo add(Motivo motivo) {
		String query = "INSERT INTO AB7812S00 (ID_MOTIVO, DESC_MOTIVO_ES, DESC_MOTIVO_EU, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (AB7812Q00.NEXTVAL,?,?,?,SYSDATE,?,?)";
		Long idProd = null;
		if (motivo.getIdProcedimiento() != null && motivo.getIdProcedimiento() != 0L) {
			idProd = motivo.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, motivo.getDescMotivoEs(), motivo.getDescMotivoEu(), motivo.getBaja(),
				UtilUsuario.getUserConnected(), idProd);
		return motivo;
	}

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public Motivo update(Motivo motivo) {
		String query = "UPDATE AB7812S00 SET DESC_MOTIVO_ES=?, DESC_MOTIVO_EU=?, BAJA=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ID_PROCEDIMIENTO=? WHERE ID_MOTIVO=?";
		Long idProd = null;
		if (motivo.getIdProcedimiento() != null && motivo.getIdProcedimiento() != 0L) {
			idProd = motivo.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, motivo.getDescMotivoEs(), motivo.getDescMotivoEu(), motivo.getBaja(),
				UtilUsuario.getUserConnected(), idProd, motivo.getIdMotivo());
		return motivo;
	}

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(readOnly = true)
	public Motivo find(Motivo motivo) {
		String query = "SELECT t1.ID_MOTIVO IDMOTIVO, t1.DESC_MOTIVO_ES DESCMOTIVOES, t1.DESC_MOTIVO_EU DESCMOTIVOEU, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO FROM AB7812S00 t1  WHERE t1.ID_MOTIVO = ? ";

		List<Motivo> motivoList = this.jdbcTemplate.query(query, this.rwFindMap, motivo.getIdMotivo());
		return (Motivo) DataAccessUtils.uniqueResult(motivoList);
	}

	/**
	 * Removes a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return
	 */
	public void remove(Motivo motivo) {
		String query = "DELETE FROM AB7812S00 WHERE ID_MOTIVO=?";
		this.jdbcTemplate.update(query, motivo.getIdMotivo());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Motivo> getMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterMotivo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, Motivo.class, params,
				"ID_MOTIVO");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAll(Motivo motivo, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7812S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(motivo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND BAJA = 0 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, MotivosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAllFilterProcedimiento(Motivo motivo, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7812S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapProcedimiento(motivo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND BAJA = 0 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO (+)");
		where.append(" AND (t1.ID_PROCEDIMIENTO IS NULL");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, MotivosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	@Transactional(readOnly = true)
	public List<Motivo> findAllLike(Motivo motivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7812S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(motivo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, MotivosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Motivo>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Motivo motivo) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7812S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(motivo);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND BAJA = 0 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Motivo motivo, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7812S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(motivo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 AND BAJA = 0 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of RelacionMotivoDen selected for rup_table
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<Motivo>> reorderSelection(Motivo motivo, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7812S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(motivo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, Motivo.class,
				filterParamList, "IDMOTIVO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Motivo>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            RelacionMotivoDen
	 * @param searchParams
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<Motivo>> search(Motivo filterParams, Motivo searchParams, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7812S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, Motivo.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDMOTIVO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Motivo>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filtermotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Motivo filtermotivo, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7812S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtermotivo, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, Motivo.class, query,
				params, "IDMOTIVO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelacionMotivoDen>>
	 */
	@Override
	public List<JerarquiaDto<Motivo>> findAllLikeJerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO IDMOTIVO,t1.DESC_MOTIVO_ES DESCMOTIVOES,t1.DESC_MOTIVO_EU DESCMOTIVOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7812S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7812S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterMotivo, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDMOTIVO", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					MotivosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7812S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7812S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterMotivo, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDMOTIVO", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<Motivo>> findAllChild(Motivo filterMotivo, TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7812S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7812S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterMotivo, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDMOTIVO", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Motivo>(this.rwMapPK, "IDMOTIVO"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelacionMotivoDen entity
	 *
	 * @param motivo
	 *            RelacionMotivoDen Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Motivo motivo) {

		StringBuilder where = new StringBuilder(MotivosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (motivo != null && motivo.getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivo.getIdMotivo());
		}
		if (motivo != null && motivo.getDescMotivoEs() != null) {
			where.append(" AND t1.DESC_MOTIVO_ES = ?");
			params.add(motivo.getDescMotivoEs());
		}
		if (motivo != null && motivo.getDescMotivoEu() != null) {
			where.append(" AND t1.DESC_MOTIVO_EU = ?");
			params.add(motivo.getDescMotivoEu());
		}
		if (motivo != null && motivo.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(motivo.getBaja());
		}
		if (motivo != null && motivo.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(motivo.getFechaRegistro());
		}
		if (motivo != null && motivo.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(motivo.getUsuarioRegistro());
		}
		if (motivo != null && motivo.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(motivo.getFechaUltmodificacion());
		}
		if (motivo != null && motivo.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(motivo.getUsuarioUltmodificacion());
		}
		if (motivo != null && motivo.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(motivo.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	private Map<String, ?> getWhereMapProcedimiento(Motivo motivo) {

		StringBuilder where = new StringBuilder(MotivosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// IMPORTANTE, dejar al final del metodo, se esta aadiendo un cierre de
		// parentesis en caso de que el id procedimiento sea null
		if (motivo != null && motivo.getIdProcedimiento() != null) {
			where.append(" OR t1.ID_PROCEDIMIENTO = ?) ");
			params.add(motivo.getIdProcedimiento());
		} else if (motivo != null && motivo.getIdProcedimiento() == null) {

			where.append(" ) ");
		}
		if (motivo != null && motivo.getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivo.getIdMotivo());
		}
		if (motivo != null && motivo.getDescMotivoEs() != null) {
			where.append(" AND t1.DESC_MOTIVO_ES = ?");
			params.add(motivo.getDescMotivoEs());
		}
		if (motivo != null && motivo.getDescMotivoEu() != null) {
			where.append(" AND t1.DESC_MOTIVO_EU = ?");
			params.add(motivo.getDescMotivoEu());
		}
		if (motivo != null && motivo.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(motivo.getBaja());
		}
		if (motivo != null && motivo.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(motivo.getFechaRegistro());
		}
		if (motivo != null && motivo.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(motivo.getUsuarioRegistro());
		}
		if (motivo != null && motivo.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(motivo.getFechaUltmodificacion());
		}
		if (motivo != null && motivo.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(motivo.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelacionMotivoDen entity
	 *
	 * @param motivo
	 *            RelacionMotivoDen Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Motivo motivo, Boolean startsWith) {

		StringBuilder where = new StringBuilder(MotivosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (motivo != null && motivo.getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivo.getIdMotivo());
		}
		if (motivo != null && motivo.getDescMotivoEs() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getDescMotivoEs().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getDescMotivoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVO_ES IS NOT NULL");
		}
		if (motivo != null && motivo.getDescMotivoEu() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getDescMotivoEu().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getDescMotivoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVO_EU IS NOT NULL");
		}
		if (motivo != null && motivo.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(motivo.getBaja());
		}
		if (motivo != null && motivo.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(motivo.getFechaRegistro());
		}
		if (motivo != null && motivo.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (motivo != null && motivo.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(motivo.getFechaUltmodificacion());
		}
		if (motivo != null && motivo.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		if (motivo != null && motivo.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(motivo.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapProcedimiento(Motivo motivo, Boolean startsWith) {

		StringBuilder where = new StringBuilder(MotivosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (motivo != null && motivo.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(motivo.getIdProcedimiento());
		} else if (motivo != null && motivo.getIdProcedimiento() == null) {

			where.append(" (+) ");
		}
		if (motivo != null && motivo.getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(motivo.getIdMotivo());
		}
		if (motivo != null && motivo.getDescMotivoEs() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getDescMotivoEs().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getDescMotivoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVO_ES IS NOT NULL");
		}
		if (motivo != null && motivo.getDescMotivoEu() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getDescMotivoEu().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getDescMotivoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVO_EU IS NOT NULL");
		}
		if (motivo != null && motivo.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(motivo.getBaja());
		}
		if (motivo != null && motivo.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(motivo.getFechaRegistro());
		}
		if (motivo != null && motivo.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (motivo != null && motivo.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(motivo.getFechaUltmodificacion());
		}
		if (motivo != null && motivo.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(motivo.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + motivo.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
