package com.ejie.ab78.dao.maestros;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

import com.ejie.ab78.model.maestros.Motivo;

/**
 * MotivosDao  
 * 
 *  
 */

public interface MotivosDao {

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo add(Motivo motivo);

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo update(Motivo motivo);

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	Motivo find(Motivo motivo);

	/**
	 * Removes a single row in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 */
	void remove(Motivo motivo);

	/**
	 * Finds a List of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Motivo> findAll(Motivo motivo, TableRequestDto tableRequestDto);

	/**
	 * Finds a List of rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Motivo> findAllFilterProcedimiento(Motivo motivo, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Motivo> findAllLike(Motivo motivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the RelacionMotivoDen table using like.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Motivo motivo, Boolean startsWith);

	/**
	 * Counts rows in the RelacionMotivoDen table.
	 *
	 * @param motivo
	 *            RelacionMotivoDen
	 * @return Long
	 */
	Long findAllCount(Motivo motivo);

	/**
	 * Reorder selection.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<Motivo>> reorderSelection(Motivo filterMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param searchMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<Motivo>> search(Motivo filterMotivo, Motivo searchMotivo, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical RelacionMotivoDen table.
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelacionMotivoDen>>
	 */
	List<JerarquiaDto<Motivo>> findAllLikeJerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Motivo filterMotivo, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterMotivo
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<Motivo>> findAllChild(Motivo filterMotivo, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Motivo> getMultiple(Motivo filterMotivo, TableRequestDto tableRequestDto, Boolean startsWith);

}
