package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TipoVentasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class IrregularidadesDaoImpl implements IrregularidadesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDIRREGULARIDAD", "DESCTIPOES", "DESCTIPOEU",
			"BAJA", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Irregularidad> rwMap = new RowMapper<Irregularidad>() {
		public Irregularidad mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Irregularidad(resultSet.getLong("IDIRREGULARIDAD"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<Irregularidad> rwMapPK = new RowMapper<Irregularidad>() {
		public Irregularidad mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Irregularidad(resultSet.getLong("IDIRREGULARIDAD"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Irregularidad>> rwMapJerarquia = new RowMapper<JerarquiaDto<Irregularidad>>() {
		public JerarquiaDto<Irregularidad> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Irregularidad irregularidad = new Irregularidad(resultSet.getLong("IDIRREGULARIDAD"),
					resultSet.getString("DESCTIPOES"), resultSet.getString("DESCTIPOEU"), resultSet.getInt("BAJA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<Irregularidad> jerarquia = new JerarquiaDto<Irregularidad>();
			jerarquia.setModel(irregularidad);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	public Irregularidad add(Irregularidad irregularidad) {
		String query = "INSERT INTO AB7810S00 (ID_IRREGULARIDAD, DESC_TIPO_ES, DESC_TIPO_EU, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (AB7804Q00.NEXTVAL,?,?,?,SYSDATE,?)";
		this.jdbcTemplate.update(query, irregularidad.getDescTipoEs(), irregularidad.getDescTipoEu(),
				irregularidad.getBaja(), UtilUsuario.getUserConnected());
		return irregularidad;
	}

	/**
	 * Updates a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	public Irregularidad update(Irregularidad irregularidad) {
		String query = "UPDATE AB7810S00 SET DESC_TIPO_ES=?, DESC_TIPO_EU=?, BAJA=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_IRREGULARIDAD=?";
		this.jdbcTemplate.update(query, irregularidad.getDescTipoEs(), irregularidad.getDescTipoEu(),
				irregularidad.getBaja(), UtilUsuario.getUserConnected(), irregularidad.getIdIrregularidad());
		return irregularidad;
	}

	/**
	 * Finds a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	@Transactional(readOnly = true)
	public Irregularidad find(Irregularidad irregularidad) {
		String query = "SELECT t1.ID_IRREGULARIDAD IDIRREGULARIDAD, t1.DESC_TIPO_ES DESCTIPOES, t1.DESC_TIPO_EU DESCTIPOEU, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION FROM AB7810S00 t1  WHERE t1.ID_IRREGULARIDAD = ?  ";

		List<Irregularidad> AB7810S00List = this.jdbcTemplate.query(query, this.rwMap,
				irregularidad.getIdIrregularidad());
		return (Irregularidad) DataAccessUtils.uniqueResult(AB7810S00List);
	}

	/**
	 * Removes a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return
	 */
	public void remove(Irregularidad irregularidad) {
		String query = "DELETE FROM AB7810S00 WHERE ID_IRREGULARIDAD=?";
		this.jdbcTemplate.update(query, irregularidad.getIdIrregularidad());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Irregularidad> getMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterIrregularidad, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, Irregularidad.class, params,
				"ID_IRREGULARIDAD");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Irregularidad>
	 */
	@Transactional(readOnly = true)
	public List<Irregularidad> findAll(Irregularidad irregularidad, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7810S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(irregularidad);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, IrregularidadesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Irregularidad>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Irregularidad>
	 */
	@Transactional(readOnly = true)
	public List<Irregularidad> findAllLike(Irregularidad irregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7810S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(irregularidad, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, IrregularidadesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Irregularidad>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Irregularidad irregularidad) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7810S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(irregularidad);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Irregularidad irregularidad, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7810S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(irregularidad, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of Irregularidad selected for rup_table
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	@Override
	public List<TableRowDto<Irregularidad>> reorderSelection(Irregularidad irregularidad,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7810S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(irregularidad, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, Irregularidad.class,
				filterParamList, "IDIRREGULARIDAD");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Irregularidad>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Irregularidad
	 * @param searchParams
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	@Override
	public List<TableRowDto<Irregularidad>> search(Irregularidad filterParams, Irregularidad searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7810S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, Irregularidad.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDIRREGULARIDAD");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Irregularidad>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7810S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterIrregularidad, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, Irregularidad.class,
				query, params, "IDIRREGULARIDAD");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Irregularidad table.
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Irregularidad>>
	 */
	@Override
	public List<JerarquiaDto<Irregularidad>> findAllLikeJerarquia(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_IRREGULARIDAD IDIRREGULARIDAD,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7810S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7810S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterIrregularidad, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDIRREGULARIDAD", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					IrregularidadesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7810S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7810S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterIrregularidad, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDIRREGULARIDAD",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Irregularidad>>
	 */
	@Override
	public List<TableRowDto<Irregularidad>> findAllChild(Irregularidad filterIrregularidad,
			TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7810S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7810S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterIrregularidad, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDIRREGULARIDAD",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Irregularidad>(this.rwMapPK, "IDIRREGULARIDAD"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Irregularidad entity
	 *
	 * @param irregularidad
	 *            Irregularidad Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Irregularidad irregularidad) {

		StringBuilder where = new StringBuilder(IrregularidadesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (irregularidad != null && irregularidad.getIdIrregularidad() != null) {
			where.append(" AND t1.ID_IRREGULARIDAD = ?");
			params.add(irregularidad.getIdIrregularidad());
		}
		if (irregularidad != null && irregularidad.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(irregularidad.getDescTipoEs());
		}
		if (irregularidad != null && irregularidad.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(irregularidad.getDescTipoEu());
		}
		if (irregularidad != null && irregularidad.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(irregularidad.getBaja());
		}
		if (irregularidad != null && irregularidad.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(irregularidad.getFechaRegistro());
		}
		if (irregularidad != null && irregularidad.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(irregularidad.getUsuarioRegistro());
		}
		if (irregularidad != null && irregularidad.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(irregularidad.getFechaUltmodificacion());
		}
		if (irregularidad != null && irregularidad.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(irregularidad.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Irregularidad entity
	 *
	 * @param irregularidad
	 *            Irregularidad Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Irregularidad irregularidad, Boolean startsWith) {

		StringBuilder where = new StringBuilder(IrregularidadesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (irregularidad != null && irregularidad.getIdIrregularidad() != null) {
			where.append(" AND t1.ID_IRREGULARIDAD = ?");
			params.add(irregularidad.getIdIrregularidad());
		}
		if (irregularidad != null && irregularidad.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidad.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidad.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (irregularidad != null && irregularidad.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidad.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidad.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (irregularidad != null && irregularidad.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(irregularidad.getBaja());
		}
		if (irregularidad != null && irregularidad.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(irregularidad.getFechaRegistro());
		}
		if (irregularidad != null && irregularidad.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidad.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidad.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (irregularidad != null && irregularidad.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(irregularidad.getFechaUltmodificacion());
		}
		if (irregularidad != null && irregularidad.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidad.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidad.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
