package com.ejie.ab78.dao.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * IrregularidadesDao  
 * 
 *  
 */

public interface IrregularidadesDao {

	/**
	 * Inserts a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad add(Irregularidad irregularidad);

	/**
	 * Updates a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad update(Irregularidad irregularidad);

	/**
	 * Finds a single row in the irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Irregularidad
	 */
	Irregularidad find(Irregularidad irregularidad);

	/**
	 * Removes a single row in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 */
	void remove(Irregularidad irregularidad);

	/**
	 * Finds a List of rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Irregularidad> findAll(Irregularidad irregularidad, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Irregularidad> findAllLike(Irregularidad irregularidad, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Irregularidad table.
	 *
	 * @param filterAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Irregularidad filterAb7804s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Irregularidad table using like.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Irregularidad irregularidad, Boolean startsWith);

	/**
	 * Counts rows in the Irregularidad table.
	 *
	 * @param irregularidad
	 *            Irregularidad
	 * @return Long
	 */
	Long findAllCount(Irregularidad irregularidad);

	/**
	 * Reorder selection.
	 *
	 * @param filterAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	List<TableRowDto<Irregularidad>> reorderSelection(Irregularidad filterAb7804s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterAb7804s00
	 *            Irregularidad
	 * @param searchAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Irregularidad>>
	 */
	List<TableRowDto<Irregularidad>> search(Irregularidad filterAb7804s00, Irregularidad searchAb7804s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Irregularidad table.
	 *
	 * @param filterAb7804s00
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Irregularidad>>
	 */
	List<JerarquiaDto<Irregularidad>> findAllLikeJerarquia(Irregularidad filterAb7804s00,
			TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterIrregularidad
	 *            Irregularidad
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Irregularidad>>
	 */
	List<TableRowDto<Irregularidad>> findAllChild(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Irregularidad> getMultiple(Irregularidad filterIrregularidad, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
