package com.ejie.ab78.dao.maestros;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.maestros.Decision;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DecisionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DecisionesDaoImpl implements DecisionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDDECISION", "DESCTIPOES", "DESCTIPOEU",
			"ESNOFORMAL", "BAJA", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION",
			"USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Decision> rwMap = new RowMapper<Decision>() {
		public Decision mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Decision(resultSet.getLong("IDDECISION"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("ESNOFORMAL"), resultSet.getInt("BAJA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<Decision> rwMapPK = new RowMapper<Decision>() {
		public Decision mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Decision(resultSet.getLong("IDDECISION"));
		}
	};

	private RowMapper<Decision> rwFindMap = new RowMapper<Decision>() {
		public Decision mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Decision decision = new Decision();
			decision.setIdDecision(resultSet.getLong("IDDECISION"));
			decision.setDescTipoEs(resultSet.getString("DESCTIPOES"));
			decision.setDescTipoEu(resultSet.getString("DESCTIPOEU"));
			decision.setEsNoFormal(resultSet.getInt("ESNOFORMAL"));
			decision.setBaja(resultSet.getInt("BAJA"));
			decision.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			decision.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			decision.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			decision.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));
			decision.setIdProcedimiento(resultSet.getLong("IDPROCEDIMIENTO"));
			return decision;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Decision>> rwMapJerarquia = new RowMapper<JerarquiaDto<Decision>>() {
		public JerarquiaDto<Decision> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Decision decision = new Decision(resultSet.getLong("IDDECISION"), resultSet.getString("DESCTIPOES"),
					resultSet.getString("DESCTIPOEU"), resultSet.getInt("ESNOFORMAL"), resultSet.getInt("BAJA"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<Decision> jerarquia = new JerarquiaDto<Decision>();
			jerarquia.setModel(decision);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	public Decision add(Decision decision) {
		String query = "INSERT INTO AB7802S00 (ID_DECISION, DESC_TIPO_ES, DESC_TIPO_EU, ES_NO_FORMAL, BAJA, FECHA_REGISTRO, USUARIO_REGISTRO, ID_PROCEDIMIENTO) VALUES (AB7802Q00.NEXTVAL,?,?,?,?,SYSDATE,?,?)";
		Long idProd = null;
		if (decision.getIdProcedimiento() != null && decision.getIdProcedimiento() != 0L) {
			idProd = decision.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, decision.getDescTipoEs(), decision.getDescTipoEu(), decision.getEsNoFormal(),
				decision.getBaja(), UtilUsuario.getUserConnected(), idProd);
		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	public Decision update(Decision decision) {
		String query = "UPDATE AB7802S00 SET DESC_TIPO_ES=?, DESC_TIPO_EU=?, ES_NO_FORMAL=?, BAJA=?,  FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=?, ID_PROCEDIMIENTO=? WHERE ID_DECISION=?";
		Long idProd = null;
		if (decision.getIdProcedimiento() != null && decision.getIdProcedimiento() != 0L) {
			// if (0L != decision.getIdProcedimiento()) {
			idProd = decision.getIdProcedimiento();
		}
		this.jdbcTemplate.update(query, decision.getDescTipoEs(), decision.getDescTipoEu(), decision.getEsNoFormal(),
				decision.getBaja(), UtilUsuario.getUserConnected(), idProd, decision.getIdDecision());
		return decision;
	}

	/**
	 * Finds a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@Transactional(readOnly = true)
	public Decision find(Decision decision) {
		String query = "SELECT t1.ID_DECISION IDDECISION, t1.DESC_TIPO_ES DESCTIPOES, t1.DESC_TIPO_EU DESCTIPOEU, t1.ES_NO_FORMAL ESNOFORMAL, t1.BAJA BAJA, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.ID_PROCEDIMIENTO IDPROCEDIMIENTO  FROM AB7802S00 t1  WHERE t1.ID_DECISION = ?  ";

		List<Decision> ab7802s00List = this.jdbcTemplate.query(query, this.rwFindMap, decision.getIdDecision());
		return (Decision) DataAccessUtils.uniqueResult(ab7802s00List);
	}

	/**
	 * Removes a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return
	 */
	public void remove(Decision decision) {
		String query = "DELETE FROM AB7802S00 WHERE ID_DECISION=?";
		this.jdbcTemplate.update(query, decision.getIdDecision());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<Decision> getMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterAb7802s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, Decision.class, params,
				"ID_DECISION");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Decision>
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAll(Decision decision, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7802S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(decision);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, DecisionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Decision>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the Decision table filtered by idProcedimiento &
	 * if also is null.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<Decision>
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllFilterProcedimiento(Decision decision, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7802S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMapProcedimiento(decision);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO (+)");
		where.append(" AND (t1.ID_PROCEDIMIENTO IS NULL");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, DecisionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Decision>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Decision>
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllLike(Decision decision, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		query.append("FROM AB7802S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(decision, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, DecisionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Decision>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Decision decision) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7802S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(decision);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Counts rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Decision decision, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7802S00 t1, PROCEDIMIENTOS t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapProcedimiento(decision, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(" AND t1.ID_PROCEDIMIENTO = t2.ID_PROCEDIMIENTO ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Reorder the data list of Decision selected for rup_table
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	@Override
	public List<TableRowDto<Decision>> reorderSelection(Decision decision, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7802S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(decision, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto, Decision.class,
				filterParamList, "IDDECISION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Decision>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            Decision
	 * @param searchParams
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	@Override
	public List<TableRowDto<Decision>> search(Decision filterParams, Decision searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7802S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto, Decision.class,
				filterParamList, searchSQL, searchParamList, from_alias, "IDDECISION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Decision>(this.rwMapPK, tableRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterab7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Decision filterab7802s00, TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7802S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab7802s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto, Decision.class, query,
				params, "IDDECISION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Decision>>
	 */
	@Override
	public List<JerarquiaDto<Decision>> findAllLikeJerarquia(Decision filterAb7802s00,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_DECISION IDDECISION,t1.DESC_TIPO_ES DESCTIPOES,t1.DESC_TIPO_EU DESCTIPOEU,t1.ES_NO_FORMAL ESNOFORMAL,t1.BAJA BAJA,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7802S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7802S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7802s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDDECISION", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					DecisionesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Decision filterAb7802s00, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7802S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7802S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7802s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDDECISION", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Decision>>
	 */
	@Override
	public List<TableRowDto<Decision>> findAllChild(Decision filterAb7802s00, TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7802S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7802S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb7802s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDDECISION",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Decision>(this.rwMapPK, "IDDECISION"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Decision entity
	 *
	 * @param decision
	 *            Decision Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Decision decision) {

		StringBuilder where = new StringBuilder(DecisionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (decision != null && decision.getIdDecision() != null) {
			where.append(" AND t1.ID_DECISION = ?");
			params.add(decision.getIdDecision());
		}
		if (decision != null && decision.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(decision.getDescTipoEs());
		}
		if (decision != null && decision.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(decision.getDescTipoEu());
		}
		if (decision != null && decision.getEsNoFormal() != null) {
			where.append(" AND t1.ES_NO_FORMAL = ?");
			params.add(decision.getEsNoFormal());
		}
		if (decision != null && decision.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(decision.getBaja());
		}
		if (decision != null && decision.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(decision.getFechaRegistro());
		}
		if (decision != null && decision.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(decision.getUsuarioRegistro());
		}
		if (decision != null && decision.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(decision.getFechaUltmodificacion());
		}
		if (decision != null && decision.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(decision.getUsuarioUltmodificacion());
		}
		if (decision != null && decision.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ?");
			params.add(decision.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Decision entity
	 *
	 * @param decision
	 *            Decision Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMapProcedimiento(Decision decision) {

		StringBuilder where = new StringBuilder(DecisionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// IMPORTANTE, dejar al inicio del metodo, se esta aadiendo un cierre
		// de
		// parentesis en caso de que el id procedimiento sea null
		if (decision != null && decision.getIdProcedimiento() != null) {
			where.append(" OR t1.ID_PROCEDIMIENTO = ?) ");
			params.add(decision.getIdProcedimiento());
		} else if (decision != null && decision.getIdProcedimiento() == null) {

			where.append(" ) ");
		}
		if (decision != null && decision.getIdDecision() != null) {
			where.append(" AND t1.ID_DECISION = ?");
			params.add(decision.getIdDecision());
		}
		if (decision != null && decision.getDescTipoEs() != null) {
			where.append(" AND t1.DESC_TIPO_ES = ?");
			params.add(decision.getDescTipoEs());
		}
		if (decision != null && decision.getDescTipoEu() != null) {
			where.append(" AND t1.DESC_TIPO_EU = ?");
			params.add(decision.getDescTipoEu());
		}
		if (decision != null && decision.getEsNoFormal() != null) {
			where.append(" AND t1.ES_NO_FORMAL = ?");
			params.add(decision.getEsNoFormal());
		}
		if (decision != null && decision.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(decision.getBaja());
		}
		if (decision != null && decision.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(decision.getFechaRegistro());
		}
		if (decision != null && decision.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(decision.getUsuarioRegistro());
		}
		if (decision != null && decision.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(decision.getFechaUltmodificacion());
		}
		if (decision != null && decision.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(decision.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Decision entity
	 *
	 * @param decision
	 *            Decision Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Decision decision, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DecisionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (decision != null && decision.getIdDecision() != null) {
			where.append(" AND t1.ID_DECISION = ?");
			params.add(decision.getIdDecision());
		}
		if (decision != null && decision.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (decision != null && decision.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (decision != null && decision.getEsNoFormal() != null) {
			where.append(" AND t1.ES_NO_FORMAL = ?");
			params.add(decision.getEsNoFormal());
		}
		if (decision != null && decision.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(decision.getBaja());
		}
		if (decision != null && decision.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(decision.getFechaRegistro());
		}
		if (decision != null && decision.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (decision != null && decision.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(decision.getFechaUltmodificacion());
		}
		if (decision != null && decision.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}
		if (decision != null && decision.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(decision.getIdProcedimiento());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapProcedimiento(Decision decision, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DecisionesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (decision != null && decision.getIdProcedimiento() != null) {
			where.append(" AND t1.ID_PROCEDIMIENTO = ? ");
			params.add(decision.getIdProcedimiento());
		} else if (decision != null && decision.getIdProcedimiento() == null) {

			where.append(" (+) ");
		}

		if (decision != null && decision.getIdDecision() != null) {
			where.append(" AND t1.ID_DECISION = ?");
			params.add(decision.getIdDecision());
		}
		if (decision != null && decision.getDescTipoEs() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_ES IS NOT NULL");
		}
		if (decision != null && decision.getDescTipoEu() != null) {
			where.append(" AND UPPER(t1.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_TIPO_EU IS NOT NULL");
		}
		if (decision != null && decision.getEsNoFormal() != null) {
			where.append(" AND t1.ES_NO_FORMAL = ?");
			params.add(decision.getEsNoFormal());
		}
		if (decision != null && decision.getBaja() != null) {
			where.append(" AND t1.BAJA = ?");
			params.add(decision.getBaja());
		}
		if (decision != null && decision.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(decision.getFechaRegistro());
		}
		if (decision != null && decision.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (decision != null && decision.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(decision.getFechaUltmodificacion());
		}
		if (decision != null && decision.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
