package com.ejie.ab78.dao.maestros;

import java.util.List;

import com.ejie.ab78.model.maestros.Decision;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * DecisionesDao  
 * 
 *  
 */

public interface DecisionesDao {

	/**
	 * Inserts a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision add(Decision decision);

	/**
	 * Updates a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision update(Decision decision);

	/**
	 * Finds a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	Decision find(Decision decision);

	/**
	 * Removes a single row in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 */
	void remove(Decision decision);

	/**
	 * Finds a List of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Decision> findAll(Decision decision, TableRequestDto tableRequestDto);

	/**
	 * Finds a List of rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Decision> findAllFilterProcedimiento(Decision decision, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Decision> findAllLike(Decision decision, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Decision table using like.
	 *
	 * @param decision
	 *            Decision
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Decision decision, Boolean startsWith);

	/**
	 * Counts rows in the Decision table.
	 *
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	Long findAllCount(Decision decision);

	/**
	 * Reorder selection.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	List<TableRowDto<Decision>> reorderSelection(Decision filterAb7802s00, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param searchAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Decision>>
	 */
	List<TableRowDto<Decision>> search(Decision filterAb7802s00, Decision searchAb7802s00,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Decision table.
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Decision>>
	 */
	List<JerarquiaDto<Decision>> findAllLikeJerarquia(Decision filterAb7802s00, TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Decision filterAb7802s00, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterAb7802s00
	 *            Decision
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Decision>>
	 */
	List<TableRowDto<Decision>> findAllChild(Decision filterAb7802s00, TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<Decision> getMultiple(Decision filterAb7802s00, TableRequestDto tableRequestDto, Boolean startsWith);

}
