package com.ejie.ab78.dao.listados;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.listados.Parametros;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ParametrosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ParametrosDaoImpl implements ParametrosDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDPARAMETRO", "IDBUSQUEDA", "NOMBRE",
			"TEXTOMOSTRAR", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION", "TIPOPARAMETRO" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Parametros> rwMap = new RowMapper<Parametros>() {
		public Parametros mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Parametros(resultSet.getInt("IDPARAMETRO"), resultSet.getInt("IDBUSQUEDA"),
					resultSet.getString("NOMBRE"), resultSet.getString("TEXTOMOSTRAR"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"), resultSet.getInt("TIPOPARAMETRO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Parametros table.
	 *
	 * @param parametros
	 *            Parametros
	 * @return Parametros
	 */
	@Transactional(readOnly = true)
	public Parametros find(Parametros parametros) {
		String query = "SELECT t1.ID_PARAMETRO IDPARAMETRO, t1.ID_BUSQUEDA IDBUSQUEDA, t1.NOMBRE NOMBRE, t1.TEXTO_MOSTRAR TEXTOMOSTRAR, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.TIPO_PARAMETRO TIPOPARAMETRO FROM AB78.PARAMETROS t1  WHERE t1.ID_PARAMETRO = ?  ";

		List<Parametros> parametrosList = this.jdbcTemplate.query(query, this.rwMap, parametros.getIdParametro());
		return (Parametros) DataAccessUtils.uniqueResult(parametrosList);
	}

	/**
	 * Finds rows in the Parametros table using like.
	 *
	 * @param parametros
	 *            Parametros
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Parametros>
	 */
	@Transactional(readOnly = true)
	public List<Parametros> findAllLike(Parametros parametros, TableRequestDto TableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_PARAMETRO IDPARAMETRO,t1.ID_BUSQUEDA IDBUSQUEDA,t1.NOMBRE NOMBRE,t1.TEXTO_MOSTRAR TEXTOMOSTRAR,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t1.TIPO_PARAMETRO TIPOPARAMETRO ");
		query.append("FROM AB78.PARAMETROS t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(parametros, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, ParametrosDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Parametros>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Parametros entity
	 *
	 * @param parametros
	 *            Parametros Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Parametros parametros, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ParametrosDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (parametros != null && parametros.getIdParametro() != null) {
			where.append(" AND t1.ID_PARAMETRO = ?");
			params.add(parametros.getIdParametro());
		}
		where.append(" AND t1.ID_BUSQUEDA = ?");
		params.add(parametros.getIdBusqueda());

		if (parametros != null && parametros.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (parametros != null && parametros.getTextoMostrar() != null) {
			where.append(" AND UPPER(t1.TEXTO_MOSTRAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getTextoMostrar().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getTextoMostrar().toUpperCase() + "%");
			}
			where.append(" AND t1.TEXTO_MOSTRAR IS NOT NULL");
		}
		if (parametros != null && parametros.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(parametros.getFechaRegistro());
		}
		if (parametros != null && parametros.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (parametros != null && parametros.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(parametros.getFechaUltmodificacion());
		}
		if (parametros != null && parametros.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(parametros.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + parametros.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
