package com.ejie.ab78.dao.listados;

import java.util.List;

import com.ejie.ab78.model.listados.Listados;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ListadosDao  
 * 
 *  
 */

public interface ListadosDao {

	/**
	 * Finds a single row in the Listados table.
	 *
	 * @param listados
	 *            Listados
	 * @return Listados
	 */
	Listados find(Listados listados);

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param listados
	 *            Listados
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Listados> findAllLike(Listados listados, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param idProcedimiento
	 *            Integer
	 * @return List<Listados>
	 */
	List<Listados> findRelLisProByProc(Integer idProcedimiento);
}
