package com.ejie.ab78.dao.listados;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.listados.Busquedas;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * ListadosDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class BusquedasDaoImpl implements BusquedasDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDLISTADO", "IDPROCEDIMIENTO", "NOMBRE",
			"FICHERO", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Busquedas> rwMap = new RowMapper<Busquedas>() {
		public Busquedas mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Busquedas busqueda = new Busquedas();
			busqueda.setIdBusqueda(resultSet.getInt("IDBUSQUEDA"));
			busqueda.setIdListado(resultSet.getInt("IDLISTADO"));
			busqueda.setNombre(resultSet.getString("NOMBRE"));
			busqueda.setSqlListado(resultSet.getString("SQLLISTADO"));
			busqueda.setCampos(resultSet.getString("CAMPOS"));
			return busqueda;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Finds a single row in the Busquedas table.
	 *
	 * @param busquedas
	 *            Busquedas
	 * @return Busquedas
	 */
	@Transactional(readOnly = true)
	public Busquedas find(Busquedas busquedas) {
		String query = "SELECT T1.ID_BUSQUEDA IDBUSQUEDA, T1.ID_LISTADO IDLISTADO, T1.NOMBRE NOMBRE, T1.SQL_LISTADO SQLLISTADO, T1.CAMPOS CAMPOS FROM AB78.BUSQUEDAS T1 WHERE t1.ID_BUSQUEDA = ? ";

		List<Busquedas> busquedasList = this.jdbcTemplate.query(query, this.rwMap, busquedas.getIdBusqueda());
		return (Busquedas) DataAccessUtils.uniqueResult(busquedasList);
	}

	/**
	 * Finds rows in the Listados table using like.
	 *
	 * @param listados
	 *            Listados
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Listados>
	 */
	@Transactional(readOnly = true)
	public List<Busquedas> findAllLike(Busquedas busquedas, TableRequestDto TableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_BUSQUEDA IDBUSQUEDA, T1.ID_LISTADO IDLISTADO, T1.NOMBRE NOMBRE, T1.SQL_LISTADO SQLLISTADO, T1.CAMPOS CAMPOS FROM AB78.BUSQUEDAS T1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(busquedas, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (TableRequestDto != null) {
			query = TableManager.getPaginationQuery(TableRequestDto, query, BusquedasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<Busquedas>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Listados entity
	 *
	 * @param listados
	 *            Listados Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Busquedas busquedas, Boolean startsWith) {

		StringBuilder where = new StringBuilder(BusquedasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		if (busquedas != null && busquedas.getIdBusqueda() != null) {
			where.append(" AND t1.ID_BUSQUEDA = ?");
			params.add(busquedas.getIdBusqueda());
		}
		if (busquedas != null && busquedas.getIdListado() != null) {
			where.append(" AND t1.ID_LISTADO = ?");
			params.add(busquedas.getIdListado());
		}
		if (busquedas != null && busquedas.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedas.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + busquedas.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (busquedas != null && busquedas.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(busquedas.getFechaRegistro());
		}
		if (busquedas != null && busquedas.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedas.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + busquedas.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (busquedas != null && busquedas.getFechaUltModificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(busquedas.getFechaUltModificacion());
		}
		if (busquedas != null && busquedas.getUsuarioUltModificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(busquedas.getUsuarioUltModificacion().toUpperCase() + "%");
			} else {
				params.add("%" + busquedas.getUsuarioUltModificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
