package com.ejie.ab78.dao.expedientes;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.expedientes.RelExpDir;

/**
 * CanalesAvisoDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelExpDirDaoImpl implements RelExpDirDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelExpDir table.
	 *
	 * @param relExpDir
	 *            RelExpDir
	 * @return RelExpDir
	 */
	@Override
	public RelExpDir add(RelExpDir relExpDir) {

		relExpDir.setIdRelExpDir(
				this.jdbcTemplate.queryForObject("SELECT AB61.S_AB6151T00.NEXTVAL FROM DUAL", Integer.class));

		String query = "INSERT INTO REL_EXP_DIR (ID_REL_EXP_DIR, ID_EXPEDIENTE, ID_DIRECCION, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (?,?,?,SYSDATE,?)";

		this.jdbcTemplate.update(query, relExpDir.getIdRelExpDir(),
				relExpDir.getExpediente() != null ? relExpDir.getExpediente().getIdExpediente() : null,
				relExpDir.getDatosDireccion() != null ? relExpDir.getDatosDireccion().getIdDireccion() : null,
				UtilUsuario.getUserConnected());
		return relExpDir;
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
