package com.ejie.ab78.dao.expedientes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.establecimientos.Establecimiento;
import com.ejie.ab78.model.expedientes.ExpedienteHistorico;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

@Repository
@Transactional
public class ExpedientesHistoricosDaoImpl implements ExpedientesHistoricosDao {

	public static final int STRING_BUILDER_INIT = 4096;

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDEXPHISTORICO", "FOLDERNUMBER", "FOLDERID",
			"TITULO", "FECHAAPERTURA", "DOCUMENTOTITULAR", "DOCUMENTOREPRESENTANTE", "NOMPROCEDIMIENTO",
			"IDESTABLECIMIENTO", "IDDENUNCIA", "ORIGEN", "FECHAREGISTRO", "USUARIOREGISTRO" };

	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	private RowMapper<ExpedienteHistorico> rwMap = new RowMapper<ExpedienteHistorico>() {
		public ExpedienteHistorico mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ExpedienteHistorico(resultSet.getLong("IDEXPHISTORICO"),
					new Establecimiento(resultSet.getInt("IDESTABLECIMIENTO")),
					new Denuncia(resultSet.getInt("IDDENUNCIA")), resultSet.getString("folderNumber"),
					resultSet.getString("folderId"), resultSet.getString("titulo"), resultSet.getDate("fechaApertura"),
					resultSet.getString("documentoTitular"), resultSet.getString("documentoRepresentante"),
					resultSet.getString("NOMPROCEDIMIENTO"), resultSet.getString("origen"),
					resultSet.getDate("fechaRegistro"), resultSet.getString("usuarioRegistro"));
		}
	};

	private RowMapper<ExpedienteHistorico> rwMapPK = new RowMapper<ExpedienteHistorico>() {
		public ExpedienteHistorico mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new ExpedienteHistorico(resultSet.getLong("IDEXPHISTORICO"));
		}
	};

	@Override
	public ExpedienteHistorico find(ExpedienteHistorico expedienteHistorico) {
		String query = "SELECT ID_EXP_HISTORICO IDEXPHISTORICO, FOLDER_NUMBER FOLDERNUMBER, FOLDER_ID FOLDERID, TITULO TITULO, FECHA_APERTURA FECHAAPERTURA, "
				+ " DOCUMENTO_TITULAR DOCUMENTOTITULAR, DOCUMENTO_REPRESENTANTE DOCUMENTOREPRESENTANTE, NOM_PROCEDIMIENTO NOMPROCEDIMIENTO, ID_ESTABLECIMIENTO IDESTABLECIMIENTO, "
				+ " ID_DENUNCIA IDDENUNCIA, ORIGEN ORIGEN, FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO FROM EXP_HISTORICO T1 WHERE T1.ID_EXP_HISTORICO = ?";

		List<ExpedienteHistorico> expedientesList = this.jdbcTemplate.query(query, this.rwMap,
				expedienteHistorico.getIdExpHistorico());
		return (ExpedienteHistorico) DataAccessUtils.uniqueResult(expedientesList);
	}

	@Override
	public ExpedienteHistorico findByFolderNumber(ExpedienteHistorico expedienteHistorico) {
		String query = "SELECT ID_EXP_HISTORICO IDEXPHISTORICO, FOLDER_NUMBER FOLDERNUMBER, FOLDER_ID FOLDERID, TITULO TITULO, FECHA_APERTURA FECHAAPERTURA, "
				+ " DOCUMENTO_TITULAR DOCUMENTOTITULAR, DOCUMENTO_REPRESENTANTE DOCUMENTOREPRESENTANTE, NOM_PROCEDIMIENTO NOMPROCEDIMIENTO, ID_ESTABLECIMIENTO IDESTABLECIMIENTO, "
				+ " ID_DENUNCIA IDDENUNCIA, ORIGEN ORIGEN, FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO FROM EXP_HISTORICO T1 WHERE T1.FOLDER_NUMBER = ? ";

		List<ExpedienteHistorico> expedientesList = this.jdbcTemplate.query(query, this.rwMap,
				expedienteHistorico.getFolderNumber());
		return (ExpedienteHistorico) DataAccessUtils.uniqueResult(expedientesList);

	}

	@Override
	public ExpedienteHistorico findByDenuncia(Denuncia denuncia) {
		String query = "SELECT ID_EXP_HISTORICO IDEXPHISTORICO, FOLDER_NUMBER FOLDERNUMBER, FOLDER_ID FOLDERID, TITULO TITULO, FECHA_APERTURA FECHAAPERTURA, "
				+ " DOCUMENTO_TITULAR DOCUMENTOTITULAR, DOCUMENTO_REPRESENTANTE DOCUMENTOREPRESENTANTE, NOM_PROCEDIMIENTO NOMPROCEDIMIENTO, ID_ESTABLECIMIENTO IDESTABLECIMIENTO, "
				+ " ID_DENUNCIA IDDENUNCIA, ORIGEN ORIGEN, FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO FROM EXP_HISTORICO T1 WHERE T1.ID_DENUNCIA = ? ";

		List<ExpedienteHistorico> expedientesList = this.jdbcTemplate.query(query, this.rwMap,
				denuncia.getIdReclamacion());
		if (expedientesList.isEmpty()) {
			return new ExpedienteHistorico();
		}
		return (ExpedienteHistorico) DataAccessUtils.uniqueResult(expedientesList);
	}

	@Override
	public List<ExpedienteHistorico> findAll(ExpedienteHistorico expedienteHistorico, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT ID_EXP_HISTORICO IDEXPHISTORICO, FOLDER_NUMBER FOLDERNUMBER, FOLDER_ID FOLDERID, TITULO TITULO, FECHA_APERTURA FECHAAPERTURA, DOCUMENTO_TITULAR DOCUMENTOTITULAR, "
				+ " DOCUMENTO_REPRESENTANTE DOCUMENTOREPRESENTANTE, NOM_PROCEDIMIENTO NOMPROCEDIMIENTO, ID_ESTABLECIMIENTO IDESTABLECIMIENTO, ID_DENUNCIA IDDENUNCIA, "
				+ " ORIGEN ORIGEN, FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO FROM EXP_HISTORICO T1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(expedienteHistorico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ExpedientesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<ExpedienteHistorico>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toString());
	}

	@Override
	public List<ExpedienteHistorico> findAllLike(ExpedienteHistorico expedienteHistorico,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT ID_EXP_HISTORICO IDEXPHISTORICO, FOLDER_NUMBER FOLDERNUMBER, FOLDER_ID FOLDERID, TITULO TITULO, FECHA_APERTURA FECHAAPERTURA, DOCUMENTO_TITULAR DOCUMENTOTITULAR, "
				+ " DOCUMENTO_REPRESENTANTE DOCUMENTOREPRESENTANTE, NOM_PROCEDIMIENTO NOMPROCEDIMIENTO, ID_ESTABLECIMIENTO IDESTABLECIMIENTO, ID_DENUNCIA IDDENUNCIA, "
				+ " ORIGEN ORIGEN, FECHA_REGISTRO FECHAREGISTRO, USUARIO_REGISTRO USUARIOREGISTRO FROM EXP_HISTORICO T1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(expedienteHistorico, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, ExpedientesDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<ExpedienteHistorico>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toString());
	}

	@Override
	public Long findAllLikeCount(ExpedienteHistorico expedienteHistorico, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.EXP_HISTORICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(expedienteHistorico, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	@Override
	public Long findAllCount(ExpedienteHistorico expedienteHistorico) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB78.EXP_HISTORICO t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(expedienteHistorico);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	private Map<String, ?> getWhereMap(ExpedienteHistorico expedienteHistorico) {
		StringBuilder where = new StringBuilder(ExpedientesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (expedienteHistorico != null && expedienteHistorico.getIdExpHistorico() != null) {
			where.append(" AND t1.ID_EXP_HISTORICO = ?");
			params.add(expedienteHistorico.getIdExpHistorico());
		}
		if (expedienteHistorico != null && expedienteHistorico.getFolderId() != null) {
			where.append(" AND t1.FOLDER_ID = ?");
			params.add(expedienteHistorico.getFolderId());
		}
		if (expedienteHistorico != null && expedienteHistorico.getFolderNumber() != null) {
			where.append(" AND t1.FOLDER_NUMBER = ?");
			params.add(expedienteHistorico.getFolderNumber());
		}
		if (expedienteHistorico != null && expedienteHistorico.getTitulo() != null) {
			where.append(" AND t1.TITULO = ?");
			params.add(expedienteHistorico.getTitulo());
		}
		if (expedienteHistorico != null && expedienteHistorico.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(expedienteHistorico.getFechaRegistro());
		}
		if (expedienteHistorico != null && expedienteHistorico.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(expedienteHistorico.getUsuarioRegistro());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(ExpedienteHistorico expedienteHistorico, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ExpedientesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (expedienteHistorico != null && expedienteHistorico.getIdExpHistorico() != null) {
			where.append(" AND t1.ID_EXP_HISTORICO = ?");
			params.add(expedienteHistorico.getIdExpHistorico());
		}
		if (expedienteHistorico != null && expedienteHistorico.getFolderId() != null) {
			where.append(" AND UPPER(t1.FOLDER_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedienteHistorico.getFolderId().toUpperCase() + "%");
			} else {
				params.add("%" + expedienteHistorico.getFolderId().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_ID IS NOT NULL");
		}
		if (expedienteHistorico != null && expedienteHistorico.getFolderNumber() != null) {
			where.append(" AND UPPER(t1.FOLDER_NUMBER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedienteHistorico.getFolderNumber().toUpperCase() + "%");
			} else {
				params.add("%" + expedienteHistorico.getFolderNumber().toUpperCase() + "%");
			}
			where.append(" AND t1.FOLDER_NUMBER IS NOT NULL");
		}
		if (expedienteHistorico != null && expedienteHistorico.getTitulo() != null) {
			where.append(" AND UPPER(t1.TITULO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedienteHistorico.getTitulo().toUpperCase() + "%");
			} else {
				params.add("%" + expedienteHistorico.getTitulo().toUpperCase() + "%");
			}
			where.append(" AND t1.TITULO IS NOT NULL");
		}
		if (expedienteHistorico != null && expedienteHistorico.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(expedienteHistorico.getFechaRegistro());
		}
		if (expedienteHistorico != null && expedienteHistorico.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(expedienteHistorico.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + expedienteHistorico.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
