package com.ejie.ab78.dao.expedientes;

import java.util.Date;
import java.util.List;

import com.ejie.ab78.model.Inspeccion;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

public interface ExpedientesDao {

	/**
	 * Inserts a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes add(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes update(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateFolder(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateExpedienteFolder(Expedientes expedientes);

	/**
	 * Updates a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateTituloMigrados(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes find(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findProcedureIdPorExpediente(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table por FolderId.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findByFolderId(Expedientes expedientes);

	/**
	 * Finds a single row in the Expedientes table por FolderId.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes findByFolderNumber(Expedientes expedientes);

	/**
	 * Removes a single row in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 */
	void remove(Expedientes expedientes);

	/**
	 * Finds a List of rows in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Expedientes> findAll(Expedientes expedientes, TableRequestDto TableRequestDto);

	/**
	 * Finds rows in the Expedientes table using like.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	// List<Expedientes> findAllLikeEmpTer(Expedientes expedientes,
	// TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Expedientes filterExpedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Expedientes table using like.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	// Long findAllLikeCount(Expedientes expedientes, Boolean startsWith);

	/**
	 * Counts rows in the Expedientes table using like.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountTer(Expedientes expedientes, Boolean startsWith);

	Long findAllLikeCount(Expedientes expedientes, Boolean startsWith);

	/**
	 * Counts rows in the Expedientes table.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Long
	 */
	Long findAllCount(Expedientes expedientes);

	/**
	 * Finds a list of rows in the Expedientes table.
	 *
	 * @param String
	 *            folderNumber
	 * @return List<Expedientes>
	 */
	List<Expedientes> findLupaExpediente(String folderNumber);

	/**
	 * Finds rows in the Expedientes table using like.
	 *
	 * @param expedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Expedientes>
	 */
	List<Expedientes> findAllLikeTer(Expedientes expedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	List<Expedientes> findAllLike(Expedientes expedientes, TableRequestDto TableRequestDto, Boolean startsWith);

	/**
	 * Reorder selection.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Expedientes>>
	 */
	List<TableRowDto<Expedientes>> reorderSelection(Expedientes filterExpedientes, TableRequestDto TableRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param searchExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Expedientes>>
	 */
	List<TableRowDto<Expedientes>> search(Expedientes filterExpedientes, Expedientes searchExpedientes,
			TableRequestDto TableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Expedientes table.
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<Expedientes>>
	 */
	List<JerarquiaDto<Expedientes>> findAllLikeJerarquia(Expedientes filterExpedientes,
			TableRequestDto TableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Expedientes filterExpedientes, TableRequestDto TableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterExpedientes
	 *            Expedientes
	 * @param TableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<Expedientes>>
	 */
	List<TableRowDto<Expedientes>> findAllChild(Expedientes filterExpedientes, TableRequestDto TableRequestDto);

	List<Expedientes> findExpedientesPendientesByExpediente(Integer idExpediente);

	List<Expedientes> findAllExpedientesOrigen(String identificadorEstablecimiento);

	Boolean updateOrigen(Expedientes expedientes);

	Boolean hasInspectExpedient(Integer idExpediente);

	Boolean hasInspeccion(Integer idExpediente);

	Inspeccion getInspectExpedient(Integer idExpediente);

	boolean checkDateExpediente(Expedientes expediente, String etiqueta);

	/**
	 * Actualiza el territorio hist�rico
	 *
	 * @param expedientes
	 *            Expedientes
	 * @return Expedientes
	 */
	Expedientes updateTerritorioHistorico(Expedientes expediente);

	Date getMaxDateExpediente(Integer idExpediente, String tipoFecha, boolean isEtiqueta);

	Inspeccion getInspect(String identInspeccion);

	Inspeccion getInspectByFolderId(String folderId);

	boolean esExpedienteCerrado(Expedientes expediente);

}
