package com.ejie.ab78.dao.direcciones;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.procedimientos.Departamentos;
import com.ejie.ab78.model.procedimientos.Direcciones;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DatosDireccionesDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DireccionesDaoImpl implements DireccionesDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDDIRECCION", "IDDEPARTAMENTO",
			"DESCRIPCIONCASTELLANO", "DESCRIPCIONEUSKERA", "FECHAREGISTRO", "USUARIOREGISTRO" };

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private JdbcTemplate jdbcTemplate;

	private RowMapper<Direcciones> rwMap = new RowMapper<Direcciones>() {
		public Direcciones mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Direcciones direcciones = new Direcciones();
			Departamentos departamentos = new Departamentos();
			direcciones.setIdDireccion(resultSet.getInt("ID_DIRECCION"));
			departamentos.setIdDepartamento(resultSet.getInt("ID_DEPARTAMENTO"));
			direcciones.setDepartamentos(departamentos);
			direcciones.setDescripcionCastellano(resultSet.getString("DESCRIPCION_CASTELLANO"));
			direcciones.setDescripcionEuskera(resultSet.getString("DESCRIPCION_EUSKERA"));
			return direcciones;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<Direcciones> findAll(Direcciones direcciones, TableRequestDto TableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT ID_DIRECCION, ID_DEPARTAMENTO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA FROM AB78.DIRECCIONES");

		return (List<Direcciones>) this.jdbcTemplate.query(query.toString(), this.rwMap);
	}
}
