package com.ejie.ab78.dao.denuncias;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.model.denuncias.RelDenIns;

/**
 * RelDenInsDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelDenInsDaoImpl implements RelDenInsDao {

	private JdbcTemplate jdbcTemplate;

	private RowMapper<RelDenIns> rwMap = new RowMapper<RelDenIns>() {
		@Override
		public RelDenIns mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			RelDenIns relDenIns = new RelDenIns();
			relDenIns.setIdRelDenIns(resultSet.getInt("IDRELDENINS"));
			relDenIns.setNumDenuncia(resultSet.getString("NUMDENUNCIA"));
			relDenIns.setIdInspeccion(resultSet.getInt("IDINSPECCION"));
			relDenIns.setIdentificadorInspeccion(resultSet.getString("IDENTIFICADORINSPECCION"));

			return relDenIns;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	@Override
	public RelDenIns findByIdentificadorInspeccion(String identificadorInspeccion) {

		String query = "SELECT t6150.ID_REL_DEN_INS IDRELDENINS, t6150.NUM_DENUNCIA NUMDENUNCIA, t6150.ID_INSPECCION IDINSPECCION, t6150.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION FROM REL_DEN_INS t6150 WHERE t6150.IDENTIFICADOR_INSPECCION = ?";

		List<RelDenIns> relDenInsList = this.jdbcTemplate.query(query, this.rwMap, identificadorInspeccion);
		return DataAccessUtils.uniqueResult(relDenInsList);
	}

	@Override
	public RelDenIns findByNumDenuncia(String numDenuncia) {

		String query = "SELECT t6150.ID_REL_DEN_INS IDRELDENINS, t6150.NUM_DENUNCIA NUMDENUNCIA, t6150.ID_INSPECCION IDINSPECCION, t6150.IDENTIFICADOR_INSPECCION IDENTIFICADORINSPECCION "
				+ " FROM REL_DEN_INS t6150 WHERE t6150.NUM_DENUNCIA = ?";

		List<RelDenIns> relDenInsList = this.jdbcTemplate.query(query, this.rwMap, numDenuncia);
		return DataAccessUtils.uniqueResult(relDenInsList);
	}

	
	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
