package com.ejie.ab78.dao.denuncias;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.denuncias.IrregularidadDenuncia;
import com.ejie.ab78.model.maestros.Irregularidad;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DenunciasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class IrregularidadesDenunciaDaoImpl implements IrregularidadesDenunciaDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRELDENIRR", "FECHAREGISTRO", "USUARIOREGISTRO",
			"FECHAULTMODIFICACION", "USUARIOULTMODIFICACION", "DENIDRECLAMACION", "IRRIDIRREGULARIDAD", "IRRDESCTIPOES",
			"IRRDESCTIPOEU", "IRRBAJA", "IRRFECHAREGISTRO", "IRRUSUARIOREGISTRO", "IRRFECHAULTMODIFICACION",
			"IRRUSUARIOULTMODIFICACION"

	};

	private JdbcTemplate jdbcTemplate;

	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<IrregularidadDenuncia> rwMap = new RowMapper<IrregularidadDenuncia>() {
		@Override
		public IrregularidadDenuncia mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			IrregularidadDenuncia irregularidadDenuncia = new IrregularidadDenuncia();
			Irregularidad irregularidad = new Irregularidad();

			Denuncia denuncia = new Denuncia();
			denuncia.setIdReclamacion(resultSet.getInt("DENIDRECLAMACION"));

			irregularidad.setIdIrregularidad(resultSet.getLong("IRRIDIRREGULARIDAD"));
			irregularidad.setDescTipoEs(resultSet.getString("IRRDESCTIPOES"));
			irregularidad.setDescTipoEu(resultSet.getString("IRRDESCTIPOEU"));
			irregularidad.setBaja(resultSet.getInt("IRRBAJA"));
			irregularidad.setFechaRegistro(resultSet.getDate("IRRFECHAREGISTRO"));
			irregularidad.setUsuarioRegistro(resultSet.getString("IRRUSUARIOREGISTRO"));
			irregularidad.setFechaUltmodificacion(resultSet.getDate("IRRFECHAULTMODIFICACION"));
			irregularidad.setUsuarioUltmodificacion(resultSet.getString("IRRUSUARIOULTMODIFICACION"));

			irregularidadDenuncia.setIdRelIregularidadDenuncia(resultSet.getLong("IDRELDENIRR"));
			irregularidadDenuncia.setIrregularidad(irregularidad);
			irregularidadDenuncia.setDenuncia(denuncia);
			irregularidadDenuncia.setFechaRegistro(resultSet.getDate("FECHAREGISTRO"));
			irregularidadDenuncia.setUsuarioRegistro(resultSet.getString("USUARIOREGISTRO"));
			irregularidadDenuncia.setFechaUltmodificacion(resultSet.getDate("FECHAULTMODIFICACION"));
			irregularidadDenuncia.setUsuarioUltmodificacion(resultSet.getString("USUARIOULTMODIFICACION"));

			return irregularidadDenuncia;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public IrregularidadDenuncia add(IrregularidadDenuncia irregularidadDenuncia) {
		String query = "INSERT INTO AB7811S00 (ID_REL_DEN_IRR, ID_DENUNCIA, ID_IRREGULARIDAD, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (AB7811Q00.NEXTVAL, ?, ?, SYSDATE,?)";
		Object idDenuncia = null;
		if (irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			idDenuncia = irregularidadDenuncia.getDenuncia().getIdReclamacion();
		}
		Object idIrregularidad = null;
		if (irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			idIrregularidad = irregularidadDenuncia.getIrregularidad().getIdIrregularidad();
		}
		this.jdbcTemplate.update(query, idDenuncia, idIrregularidad, UtilUsuario.getUserConnected());

		return irregularidadDenuncia;
	}

	@Override
	public IrregularidadDenuncia update(IrregularidadDenuncia irregularidadDenuncia) {
		String query = "UPDATE AB7811S00 SET ID_DENUNCIA=?, ID_IRREGULARIDAD=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_REL_DEN_IRR = ? ";
		Object idDenuncia = null;
		if (irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			idDenuncia = irregularidadDenuncia.getDenuncia().getIdReclamacion();
		}
		Object idIrregularidad = null;
		if (irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			idIrregularidad = irregularidadDenuncia.getIrregularidad().getIdIrregularidad();
		}

		this.jdbcTemplate.update(query, idDenuncia, idIrregularidad, UtilUsuario.getUserConnected(),
				irregularidadDenuncia.getIdRelIregularidadDenuncia());

		return irregularidadDenuncia;
	}

	@Override
	public IrregularidadDenuncia delete(IrregularidadDenuncia irregularidadDenuncia) {
		String query = "DELETE FROM AB7811S00  WHERE ID_REL_DEN_IRR = ? ";

		this.jdbcTemplate.update(query, irregularidadDenuncia.getIdRelIregularidadDenuncia());

		return irregularidadDenuncia;
	}

	@Override
	public IrregularidadDenuncia find(IrregularidadDenuncia irregularidadDenuncia) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_REL_DEN_IRR IDRELDENIRR, T1.FECHA_REGISTRO  FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, "
						+ " T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, ");
		query.append(
				" T2.ID_RECLAMACION DENIDRECLAMACION, T2.ID_EXPEDIENTE DENIDEXPEDIENTE, T2.ID_DIRECCION DENIDDIRECCION, T2.NUM_ANYO DENNUMANYO, T2.NUM_RECLAMACION DENNUMRECLAMACION, "
						+ " T2.ID_PROVINCIA_TTHH DENIDPROVINCIATTHH, T2.IND_CONOCE_ESTABLECIMIENTO DENINDCONOCEESTABLECIMIENTO, "
						+ " T2.OBSERVACIONES_NO_CENSADO DENOBSERVACIONESNOCENSADO, "
						+ " (SELECT MAX(t6142.FECHA_EXPEDIENTE) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE "
						+ " AND t6142.ID_EXPEDIENTE = T2.ID_EXPEDIENTE AND t6144.ETIQUETA_FECHA = '"
						+ Constantes.ETIQUETA_FECHA_EXP_APERTURA + "' ) DENFECHAPRESENTACION, "
						+ " T2.TIPO_INFRACCION DENTIPOINFRACCION, T2.NUM_PAGINA_REC DENNUMPAGINAREC, T2.DESC_MOTIVOS_ES DENDESCMOTIVOSES, T2.DESC_MOTIVOS_EU DENDESCMOTIVOSEU, "
						+ " T2.ASUNTO_HECHOS DENASUNTOHECHOS, T2.FECHA_HECHOS DENFECHAHECHOS, T2.ID_PRODUCTO DENIDPRODUCTO, T2.ID_TIPO_VENTA DENIDTIPOVENTA, T2.DESC_HECHOS_ES DENDESCHECHOSES, "
						+ " T2.DESC_HECHOS_EU DENDESCHECHOSEU, T2.IND_TIPO_RECLAMACION DENINDTIPORECLAMACION, T2.TIPO_COMERCIO DENTIPOCOMERCIO, T2.ID_TIPO_ESTABLECIMIENTO DENIDTIPOESTABLECIMIENTO, "
						+ " T2.TELEFONO_DENUNCIADO DENTELEFONODENUNCIADO, T2.IND_ILEGAL DENINDILEGAL, T2.ID_TIPO_RECLAMACION DENIDTIPORECLAMACION, "
						+ " T2.DEVOLUCION DENDEVOLUCION, T2.IMPORTE_DEVOLUCION DENIMPORTEDEVOLUCION, T2.INDEMNIZACION DENINDEMNIZACION, T2.IMPORTE_INDEMNIZACION DENIMPORTEINDEMNIZACION, "
						+ " T2.DESC_PRETENSIONES_ES DENDESCPRETENSIONESES, T2.DESC_PRETENSIONES_EU DENDESCPRETENSIONESEU, T2.FECHA_REG_ENTRADA DENFECHAREGENTRADA, T2.NUM_REG_ENTRADA DENNUMREGENTRADA, "
						+ " T2.FECHA_REG_SALIDA DENFECHAREGSALIDA, T2.NUM_REG_SALIDA DENNUMREGSALIDA, T2.ORGANISMOS DENORGANISMOS, T2.ID_DECISION DENIDDECISION, T2.FECHA_DECISION DENFECHADECISION, "
						+ " T2.FUNDAMENTO_DENUNCIA_SOLICITUD DENFUNDAMENTO, T2.ARTICULO_INFRIGIDO_ES DENARTICULOINFRIGIDOES, T2.ARTICULO_INFRIGIDO_EU DENARTICULOINFRIGIDOEU, "
						+ " T2.NORMA_INFRIGIDA_ES DENNORMAINFRIGIDAES, T2.NORMA_INFRIGIDA_EU DENNORMAINFRIGIDAEU, T2.OBSERVACIONES_DECISION_ES DENOBSERVACIONESDECISIONES, "
						+ " T2.OBSERVACIONES_DECISION_EU DENOBSERVACIONESDECISIONEU, T2.IND_ELIMINADO DENINDELIMINADO, T2.FECHA_REGISTRO DENFECHAREGISTRO, T2.USUARIO_REGISTRO DENUSUARIOREGISTRO, "
						+ " T2.FECHA_ULTMODIFICACION DENFECHAULTMODIFICACION, T2.USUARIO_ULTMODIFICACION DENUSUARIOULTMODIFICACION, ");
		query.append(
				" T3.ID_IRREGULARIDAD IRRIDIRREGULARIDAD, T3.DESC_TIPO_ES IRRDESCTIPOES, T3.DESC_TIPO_EU IRRDESCTIPOEU, T3.BAJA IRRBAJA, T3.FECHA_REGISTRO IRRFECHAREGISTRO, "
						+ " T3.USUARIO_REGISTRO IRRUSUARIOREGISTRO, T3.FECHA_ULTMODIFICACION IRRFECHAULTMODIFICACION, T3.USUARIO_ULTMODIFICACION IRRUSUARIOULTMODIFICACION ");
		query.append(" FROM AB7811S00 T1, AB7801S00 T2, AB7810S00 T3 ");
		query.append(
				" WHERE T1.ID_DENUNCIA = T2.ID_RECLAMACION AND T1.ID_IRREGULARIDAD = T3.ID_IRREGULARIDAD AND T1.ID_REL_DEN_IRR=?");
		List<IrregularidadDenuncia> irregularidadDenuncias = this.jdbcTemplate.query(query.toString(), this.rwMap,
				irregularidadDenuncia.getIdRelIregularidadDenuncia());
		if (irregularidadDenuncias.isEmpty()) {
			return new IrregularidadDenuncia();
		}
		return irregularidadDenuncias.get(0);
	}

	@Override
	public List<IrregularidadDenuncia> findAllLike(IrregularidadDenuncia expedienteDenuncia,
			TableRequestDto tableRequestDto, Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_REL_DEN_IRR IDRELDENIRR, T1.FECHA_REGISTRO  FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, "
						+ " T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, ");
		query.append(
				" T2.ID_RECLAMACION DENIDRECLAMACION, T2.ID_EXPEDIENTE DENIDEXPEDIENTE, T2.ID_DIRECCION DENIDDIRECCION, T2.NUM_ANYO DENNUMANYO, T2.NUM_RECLAMACION DENNUMRECLAMACION, "
						+ " T2.ID_PROVINCIA_TTHH DENIDPROVINCIATTHH, T2.IND_CONOCE_ESTABLECIMIENTO DENINDCONOCEESTABLECIMIENTO, "
						+ " T2.OBSERVACIONES_NO_CENSADO DENOBSERVACIONESNOCENSADO, "
						+ " (SELECT MAX(t6142.FECHA_EXPEDIENTE) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE "
						+ " AND t6142.ID_EXPEDIENTE = T2.ID_EXPEDIENTE AND t6144.ETIQUETA_FECHA = '"
						+ Constantes.ETIQUETA_FECHA_EXP_APERTURA + "' ) DENFECHAPRESENTACION, "
						+ " T2.TIPO_INFRACCION DENTIPOINFRACCION, T2.NUM_PAGINA_REC DENNUMPAGINAREC, T2.DESC_MOTIVOS_ES DENDESCMOTIVOSES, T2.DESC_MOTIVOS_EU DENDESCMOTIVOSEU, "
						+ " T2.ASUNTO_HECHOS DENASUNTOHECHOS, T2.FECHA_HECHOS DENFECHAHECHOS, T2.ID_PRODUCTO DENIDPRODUCTO, T2.ID_TIPO_VENTA DENIDTIPOVENTA, T2.DESC_HECHOS_ES DENDESCHECHOSES, "
						+ " T2.DESC_HECHOS_EU DENDESCHECHOSEU, T2.IND_TIPO_RECLAMACION DENINDTIPORECLAMACION, T2.TIPO_COMERCIO DENTIPOCOMERCIO, T2.ID_TIPO_ESTABLECIMIENTO DENIDTIPOESTABLECIMIENTO, "
						+ " T2.TELEFONO_DENUNCIADO DENTELEFONODENUNCIADO, T2.IND_ILEGAL DENINDILEGAL, T2.ID_TIPO_RECLAMACION DENIDTIPORECLAMACION, "
						+ " T2.DEVOLUCION DENDEVOLUCION, T2.IMPORTE_DEVOLUCION DENIMPORTEDEVOLUCION, T2.INDEMNIZACION DENINDEMNIZACION, T2.IMPORTE_INDEMNIZACION DENIMPORTEINDEMNIZACION, "
						+ " T2.DESC_PRETENSIONES_ES DENDESCPRETENSIONESES, T2.DESC_PRETENSIONES_EU DENDESCPRETENSIONESEU, T2.FECHA_REG_ENTRADA DENFECHAREGENTRADA, "
						+ " T2.NUM_REG_ENTRADA DENNUMREGENTRADA, T2.FECHA_REG_SALIDA DENFECHAREGSALIDA, T2.NUM_REG_SALIDA DENNUMREGSALIDA, T2.ORGANISMOS DENORGANISMOS, "
						+ " T2.ID_DECISION DENIDDECISION, T2.FECHA_DECISION DENFECHADECISION, T2.FUNDAMENTO_DENUNCIA_SOLICITUD DENFUNDAMENTO, T2.ARTICULO_INFRIGIDO_ES DENARTICULOINFRIGIDOES, "
						+ " T2.ARTICULO_INFRIGIDO_EU DENARTICULOINFRIGIDOEU, T2.NORMA_INFRIGIDA_ES DENNORMAINFRIGIDAES, T2.NORMA_INFRIGIDA_EU DENNORMAINFRIGIDAEU, "
						+ " T2.OBSERVACIONES_DECISION_ES DENOBSERVACIONESDECISIONES, T2.OBSERVACIONES_DECISION_EU DENOBSERVACIONESDECISIONEU, T2.IND_ELIMINADO DENINDELIMINADO, "
						+ " T2.FECHA_REGISTRO DENFECHAREGISTRO, T2.USUARIO_REGISTRO DENUSUARIOREGISTRO, T2.FECHA_ULTMODIFICACION DENFECHAULTMODIFICACION, "
						+ " T2.USUARIO_ULTMODIFICACION DENUSUARIOULTMODIFICACION, ");
		query.append(
				" T3.ID_IRREGULARIDAD IRRIDIRREGULARIDAD, T3.DESC_TIPO_ES IRRDESCTIPOES, T3.DESC_TIPO_EU IRRDESCTIPOEU, T3.BAJA IRRBAJA, T3.FECHA_REGISTRO IRRFECHAREGISTRO, "
						+ " T3.USUARIO_REGISTRO IRRUSUARIOREGISTRO, T3.FECHA_ULTMODIFICACION IRRFECHAULTMODIFICACION, T3.USUARIO_ULTMODIFICACION IRRUSUARIOULTMODIFICACION ");
		query.append(" FROM AB7811S00 T1, AB7801S00 T2, AB7810S00 T3 ");
		query.append(" WHERE T1.ID_DENUNCIA = T2.ID_RECLAMACION AND T1.ID_IRREGULARIDAD = T3.ID_IRREGULARIDAD ");

		Map<String, Object> mapaWhere = this.getWhereLikeMap(expedienteDenuncia, startsWith);
		query.append(mapaWhere.get("query"));
		List<Object> params = (List<Object>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	@Override
	public Long findAllLikeCount(IrregularidadDenuncia expedienteDenuncia, Boolean startsWith) {

		StringBuilder query = new StringBuilder("SELECT COUNT(T1.ID_REL_DEN_IRR) ");
		query.append(" FROM AB7811S00 T1, AB7801S00 T2, AB7810S00 T3 ");
		query.append(" WHERE T1.ID_DENUNCIA = T2.ID_RECLAMACION AND T1.ID_IRREGULARIDAD = T3.ID_IRREGULARIDAD ");

		Map<String, Object> mapaWhere = this.getWhereLikeMap(expedienteDenuncia, startsWith);
		query.append(mapaWhere.get("query"));
		List<Object> params = (List<Object>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	@Override
	public List<IrregularidadDenuncia> findAll(IrregularidadDenuncia expedienteDenuncia,
			TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_REL_DEN_IRR IDRELDENIRR, T1.FECHA_REGISTRO  FECHAREGISTRO, T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, "
						+ " T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, ");
		query.append(
				" T2.ID_RECLAMACION DENIDRECLAMACION, T2.ID_EXPEDIENTE DENIDEXPEDIENTE, T2.ID_DIRECCION DENIDDIRECCION, T2.NUM_ANYO DENNUMANYO, T2.NUM_RECLAMACION DENNUMRECLAMACION, "
						+ " T2.ID_PROVINCIA_TTHH DENIDPROVINCIATTHH, T2.IND_CONOCE_ESTABLECIMIENTO DENINDCONOCEESTABLECIMIENTO, "
						+ " T2.OBSERVACIONES_NO_CENSADO DENOBSERVACIONESNOCENSADO, (SELECT MAX(t6142.FECHA_EXPEDIENTE) FROM REL_EXP_FECH t6142, FECHAS_EXPEDIENTE t6144 "
						+ " WHERE t6142.ID_FECHA_EXPEDIENTE = t6144.ID_FECHA_EXPEDIENTE AND t6142.ID_EXPEDIENTE = T2.ID_EXPEDIENTE AND t6144.ETIQUETA_FECHA = '"
						+ Constantes.ETIQUETA_FECHA_EXP_APERTURA + "' ) DENFECHAPRESENTACION, "
						+ " T2.TIPO_INFRACCION DENTIPOINFRACCION, T2.NUM_PAGINA_REC DENNUMPAGINAREC, T2.DESC_MOTIVOS_ES DENDESCMOTIVOSES, T2.DESC_MOTIVOS_EU DENDESCMOTIVOSEU, "
						+ " T2.ASUNTO_HECHOS DENASUNTOHECHOS, T2.FECHA_HECHOS DENFECHAHECHOS, T2.ID_PRODUCTO DENIDPRODUCTO, T2.ID_TIPO_VENTA DENIDTIPOVENTA, T2.DESC_HECHOS_ES DENDESCHECHOSES, "
						+ " T2.DESC_HECHOS_EU DENDESCHECHOSEU, T2.IND_TIPO_RECLAMACION DENINDTIPORECLAMACION, T2.TIPO_COMERCIO DENTIPOCOMERCIO, T2.ID_TIPO_ESTABLECIMIENTO DENIDTIPOESTABLECIMIENTO, "
						+ " T2.TELEFONO_DENUNCIADO DENTELEFONODENUNCIADO, T2.IND_ILEGAL DENINDILEGAL, T2.ID_TIPO_RECLAMACION DENIDTIPORECLAMACION, "
						+ " T2.DEVOLUCION DENDEVOLUCION, T2.IMPORTE_DEVOLUCION DENIMPORTEDEVOLUCION, T2.INDEMNIZACION DENINDEMNIZACION, T2.IMPORTE_INDEMNIZACION DENIMPORTEINDEMNIZACION, "
						+ " T2.DESC_PRETENSIONES_ES DENDESCPRETENSIONESES, T2.DESC_PRETENSIONES_EU DENDESCPRETENSIONESEU, T2.FECHA_REG_ENTRADA DENFECHAREGENTRADA, T2.NUM_REG_ENTRADA DENNUMREGENTRADA, "
						+ " T2.FECHA_REG_SALIDA DENFECHAREGSALIDA, T2.NUM_REG_SALIDA DENNUMREGSALIDA, T2.ORGANISMOS DENORGANISMOS, T2.ID_DECISION DENIDDECISION, T2.FECHA_DECISION DENFECHADECISION, "
						+ " T2.FUNDAMENTO_DENUNCIA_SOLICITUD DENFUNDAMENTO, T2.ARTICULO_INFRIGIDO_ES DENARTICULOINFRIGIDOES, T2.ARTICULO_INFRIGIDO_EU DENARTICULOINFRIGIDOEU, "
						+ " T2.NORMA_INFRIGIDA_ES DENNORMAINFRIGIDAES, T2.NORMA_INFRIGIDA_EU DENNORMAINFRIGIDAEU, T2.OBSERVACIONES_DECISION_ES DENOBSERVACIONESDECISIONES, "
						+ " T2.OBSERVACIONES_DECISION_EU DENOBSERVACIONESDECISIONEU, T2.IND_ELIMINADO DENINDELIMINADO, T2.FECHA_REGISTRO DENFECHAREGISTRO, T2.USUARIO_REGISTRO DENUSUARIOREGISTRO, "
						+ " T2.FECHA_ULTMODIFICACION DENFECHAULTMODIFICACION, T2.USUARIO_ULTMODIFICACION DENUSUARIOULTMODIFICACION, ");
		query.append(
				" T3.ID_IRREGULARIDAD IRRIDIRREGULARIDAD, T3.DESC_TIPO_ES IRRDESCTIPOES, T3.DESC_TIPO_EU IRRDESCTIPOEU, T3.BAJA IRRBAJA, T3.FECHA_REGISTRO IRRFECHAREGISTRO, T3.USUARIO_REGISTRO IRRUSUARIOREGISTRO, T3.FECHA_ULTMODIFICACION IRRFECHAULTMODIFICACION, T3.USUARIO_ULTMODIFICACION IRRUSUARIOULTMODIFICACION ");
		query.append(" FROM AB7811S00 T1, AB7801S00 T2, AB7810S00 T3 ");
		query.append(" WHERE T1.ID_DENUNCIA = T2.ID_RECLAMACION AND T1.ID_IRREGULARIDAD = T3.ID_IRREGULARIDAD ");

		Map<String, Object> mapaWhere = this.getWhereMap(expedienteDenuncia);
		query.append(mapaWhere.get("query"));
		List<Object> params = (List<Object>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	public Long findAllCount(IrregularidadDenuncia expedienteDenuncia) {
		StringBuilder query = new StringBuilder("SELECT COUNT(T1.ID_REL_DEN_IRR) ");
		query.append(" FROM AB7811S00 T1, AB7801S00 T2, AB7810S00 T3 ");
		query.append(" WHERE T1.ID_DENUNCIA = T2.ID_RECLAMACION AND T1.ID_IRREGULARIDAD = T3.ID_IRREGULARIDAD ");

		Map<String, Object> mapaWhere = this.getWhereMap(expedienteDenuncia);
		query.append(mapaWhere.get("query"));
		List<Object> params = (List<Object>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	private Map<String, Object> getWhereMap(IrregularidadDenuncia irregularidadDenuncia) {
		StringBuilder where = new StringBuilder(IrregularidadesDenunciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (irregularidadDenuncia != null && irregularidadDenuncia.getIdRelIregularidadDenuncia() != null) {
			where.append(" AND t1.ID_REL_DEN_IRR = ?");
			params.add(irregularidadDenuncia.getIdRelIregularidadDenuncia());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			where.append(" AND t1.ID_DENUNCIA = ?");
			params.add(irregularidadDenuncia.getDenuncia().getIdReclamacion());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getIdIrregularidad() != null) {
			where.append(" AND t1.ID_IRREGULARIDAD = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getIdIrregularidad());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getDescTipoEs() != null) {
			where.append(" AND t3.DESC_TIPO_ES = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getDescTipoEs());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getDescTipoEu() != null) {
			where.append(" AND t3.DESC_TIPO_EU = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getDescTipoEu());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getBaja() != null) {
			where.append(" AND t3.BAJA = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(IrregularidadDenuncia irregularidadDenuncia, Boolean startsWith) {

		StringBuilder where = new StringBuilder(IrregularidadesDenunciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// TODO: IFS
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIdRelIregularidadDenuncia() != null) {
			where.append(" AND t1.ID_REL_DEN_IRR = ?");
			params.add(irregularidadDenuncia.getIdRelIregularidadDenuncia());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getDenuncia() != null
				&& irregularidadDenuncia.getDenuncia().getIdReclamacion() != null) {
			where.append(" AND t2.ID_RECLAMACION = ?");
			params.add(irregularidadDenuncia.getDenuncia().getIdReclamacion());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getIdIrregularidad() != null) {
			where.append(" AND t3.ID_IRREGULARIDAD = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getIdIrregularidad());
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getDescTipoEs() != null) {
			where.append(" AND UPPER(t3.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidadDenuncia.getIrregularidad().getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidadDenuncia.getIrregularidad().getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t3.DESC_TIPO_ES IS NOT NULL");
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getDescTipoEu() != null) {
			where.append(" AND UPPER(t3.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(irregularidadDenuncia.getIrregularidad().getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + irregularidadDenuncia.getIrregularidad().getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t3.DESC_TIPO_EU IS NOT NULL");
		}
		if (irregularidadDenuncia != null && irregularidadDenuncia.getIrregularidad() != null
				&& irregularidadDenuncia.getIrregularidad().getBaja() != null) {
			where.append(" AND t3.BAJA = ?");
			params.add(irregularidadDenuncia.getIrregularidad().getBaja());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
