package com.ejie.ab78.dao.denuncias;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.Constantes;
import com.ejie.ab78.model.Aviso;
import com.ejie.ab78.model.denuncias.ExpedienteDenuncia;
import com.ejie.ab78.model.denuncias.ExpedienteDenunciaFilter;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DenunciasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class ExpedienteDenunciaDaoImpl implements ExpedienteDenunciaDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "NUM_ANYO", "NUM_RECLAMACION",
			"FECHA_PRESENTACION", "ID_DIRECCION", "ID_TIPO_ESTABLECIMIENTO", "IDENTIFICADOR_ESTABLECIMIENTO",
			"NOMBRE_COMERCIAL", "ID_TIPO_RECLAMACION", "NUM_PAGINA_REC", "FECHA_HECHOS", "FECHA_DECISION",
			"ID_DECISION", "IND_TIPO_RECLAMACION", "ID_PROCEDIMIENTO", "FOLDER_ID", "FOLDER_NUMBER",
			"NOMBRE_DENUNCIANTE", "APELLIDO1_DENUNCIANTE", "APELLIDO2_DENUNCIANTE", "TIPO_DOC_DENUNCIANTE",
			"DOCUMENTO_DENUNCIANTE", "NOMBRE_AFECTADOS", "NOMBRE_DENUNCIADO", "DIRECCION_DENUNCIADO", "CP_DENUNCIADO",
			"ID_EXPEDIENTE", "PROVINCIA_DENUNCIADO", "ID_PROVINCIA_DENUNCIADO", "ID_MUNICIPIO_DENUNCIADO",
			"MUNICIPIO_DENUNCIADO", "ID_LOCALIDAD_DENUNCIADO", "LOCALIDAD_DENUNCIADO", "ID_MOTIVO",
			"DESCRIPCION_MOTIVO", "IDENTIFICADOR_INSPECCION" };

	private JdbcTemplate jdbcTemplate;

	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<ExpedienteDenuncia> rwMap = new RowMapper<ExpedienteDenuncia>() {
		@Override
		public ExpedienteDenuncia mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			ExpedienteDenuncia expedienteDenuncia = new ExpedienteDenuncia();
			expedienteDenuncia.setIdExpediente(resultSet.getLong("ID_EXPEDIENTE"));

			expedienteDenuncia.setFolderId(resultSet.getString("FOLDER_ID"));
			expedienteDenuncia.setFolderNumber(resultSet.getString("FOLDER_NUMBER"));
			expedienteDenuncia.setIdReclamacion(
					null != resultSet.getObject("ID_RECLAMACION") ? resultSet.getInt("ID_RECLAMACION") : null);
			expedienteDenuncia.setNumAnyo(resultSet.getLong("NUM_ANYO"));
			expedienteDenuncia.setNumReclamacion(resultSet.getLong("NUM_RECLAMACION"));
			expedienteDenuncia.setFechaPresentacion(resultSet.getDate("FECHA_PRESENTACION"));
			expedienteDenuncia.setNombreDenunciante(resultSet.getString("NOMBRE_DENUNCIANTE"));
			expedienteDenuncia.setApellido1Denunciante(resultSet.getString("APELLIDO1_DENUNCIANTE"));
			expedienteDenuncia.setApellido2Denunciante(resultSet.getString("APELLIDO2_DENUNCIANTE"));
			expedienteDenuncia.setDenunciante(
					null != resultSet.getString("NOMBRE_DENUNCIANTE") ? resultSet.getString("NOMBRE_DENUNCIANTE") : "",
					null != resultSet.getString("APELLIDO1_DENUNCIANTE") ? resultSet.getString("APELLIDO1_DENUNCIANTE")
							: "",
					null != resultSet.getString("APELLIDO2_DENUNCIANTE") ? resultSet.getString("APELLIDO2_DENUNCIANTE")
							: "");

			expedienteDenuncia.setNombreDenunciado(resultSet.getString("INCULPADO"));

			expedienteDenuncia
					.setDenunciado(null != resultSet.getString("INCULPADO") ? resultSet.getString("INCULPADO") : "");
			expedienteDenuncia.setNombreAfectados(resultSet.getString("NOMBRE_AFECTADOS"));

			expedienteDenuncia.setNombreDenunciado(resultSet.getString("NOMBRE_DENUNCIADO"));
			expedienteDenuncia.setDireccionDenunciado(resultSet.getString("DIRECCION_DENUNCIADO"));
			expedienteDenuncia.setCodigoPostalDenunciado(resultSet.getString("CP_DENUNCIADO"));

			expedienteDenuncia.setProvinciaDenunciado(resultSet.getString("PROVINCIA_DENUNCIADO"));
			expedienteDenuncia.setMunicipioDenunciado(resultSet.getString("MUNICIPIO_DENUNCIADO"));
			expedienteDenuncia.setLocalidadDenunciado(resultSet.getString("LOCALIDAD_DENUNCIADO"));
			expedienteDenuncia.setIdProvincia(resultSet.getString("ID_PROVINCIA_TTHH"));
			expedienteDenuncia.setNumDenunciaFormateado(resultSet.getLong("NUM_ANYO"),
					resultSet.getLong("NUM_RECLAMACION"));
			expedienteDenuncia.setIdInspeccion(resultSet.getInt("ID_INSPECCION"));
			expedienteDenuncia.setIdentificadorInspeccion(resultSet.getString("IDENTIFICADOR_INSPECCION"));
			expedienteDenuncia.setDescDecisionES(resultSet.getString("DESC_TIPO_ES"));
			expedienteDenuncia.setDescDecisionEU(resultSet.getString("DESC_TIPO_EU"));

			return expedienteDenuncia;
		}
	};

	private RowMapper<Aviso> rwMapAviso = new RowMapper<Aviso>() {
		@Override
		public Aviso mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Aviso aviso = new Aviso(resultSet.getLong("ID_AVISO"), resultSet.getLong("ID_APLICACION"),
					resultSet.getDate("FECHA_INICIO"), resultSet.getDate("FECHA_FIN"),
					resultSet.getString("DESCRIPCION_CASTELLANO"), resultSet.getString("DESCRIPCION_EUSKERA"),
					resultSet.getDate("FECHA_REGISTRO"), resultSet.getString("USUARIO_REGISTRO"),
					resultSet.getDate("FECHA_ULTMODIFICACION"), resultSet.getString("USUARIO_ULTMODIFICACION"));
			return aviso;
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public List<ExpedienteDenuncia> findAllLike(ExpedienteDenuncia expedienteDenuncia, TableRequestDto tableRequestDto,
			Boolean startsWith) {

		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT T1.ID_RECLAMACION, T1.NUM_ANYO, T1.NUM_RECLAMACION, MIN(T8.FH) FECHA_PRESENTACION, T1.ID_DIRECCION, T1.ID_TIPO_ESTABLECIMIENTO, "
				+ " T1.ID_TIPO_RECLAMACION, T1.NUM_PAGINA_REC, T1.FECHA_HECHOS, T1.FECHA_DECISION, T1.ID_DECISION, T1.IND_TIPO_RECLAMACION, T1.ID_PROCEDIMIENTO, "
				+ " T1.FOLDER_ID, T1.FOLDER_NUMBER, T1.NOMBRE_DENUNCIANTE, T1.APELLIDO1_DENUNCIANTE, T1.APELLIDO2_DENUNCIANTE, T1.TIPO_DOC_DENUNCIANTE, T1.DOCUMENTO_DENUNCIANTE, "
				+ " T1.NOMBRE_AFECTADOS, T1.NOMBRE_DENUNCIADO, T1.DIRECCION_DENUNCIADO, T1.CP_DENUNCIADO, T1.ID_EXPEDIENTE, T1.PROVINCIA_DENUNCIADO, T1.ID_PROVINCIA_DENUNCIADO, "
				+ " T1.ID_MUNICIPIO_DENUNCIADO, T1.MUNICIPIO_DENUNCIADO, T1.ID_LOCALIDAD_DENUNCIADO, T1.LOCALIDAD_DENUNCIADO, T1.ID_PROVINCIA_TTHH, t1.inculpado, T1.ID_INSPECCION, "
				+ " T1.IDENTIFICADOR_INSPECCION, T6.DESC_TIPO_ES, T6.DESC_TIPO_EU, T7.TITULO FROM AB78.DENUNCIAS_BUSCADOR_VIEW T1 "
				+ " LEFT JOIN  AB7808S00 T2 ON T1.ID_EXPEDIENTE IS NULL AND T1.ID_RECLAMACION = T2.ID_RECLAMACION "
				+ " LEFT JOIN REL_EXP_TER T3 ON T1.ID_EXPEDIENTE IS NOT NULL AND T1.ID_EXPEDIENTE = T3.ID_EXPEDIENTE "
				+ " LEFT JOIN AB78.DATOS_TERCERO T4 ON ((T1.ID_EXPEDIENTE IS NULL AND T4.ID_TERCERO = T2.ID_TERCERO) OR (T1.ID_EXPEDIENTE IS NOT NULL AND T4.ID_TERCERO = T3.ID_TERCERO))  "
				+ " LEFT JOIN AB78.AB7813T00 T5 ON T1.ID_RECLAMACION = T5.ID_RECLAMACION LEFT JOIN AB78.AB7802T00 T6 ON T1.ID_DECISION = T6.ID_DECISION LEFT JOIN AB78.EXPEDIENTES T7 ON T1.ID_EXPEDIENTE = T7.ID_EXPEDIENTE "
				+ " LEFT JOIN (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE = T44.ID_FECHA_EXPEDIENTE AND T44.ETIQUETA_FECHA = 'FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) T8 ON T1.ID_EXPEDIENTE = T8.ID_EXPEDIENTE WHERE 1=1  ");

		Map<String, Object> mapaWhere = this.getWhereLikeMap(expedienteDenuncia, startsWith);
		query.append(mapaWhere.get("query"));
		List<?> params = (List<?>) mapaWhere.get("params");
		query.append(
				" GROUP BY t1.id_reclamacion, t1.num_anyo, t1.num_reclamacion, t1.id_direccion, t1.id_tipo_establecimiento, t1.id_tipo_reclamacion, t1.num_pagina_rec, t1.fecha_hechos, "
				+ " t1.fecha_decision, t1.id_decision, t1.ind_tipo_reclamacion, t1.id_procedimiento, t1.folder_id, t1.folder_number, t1.nombre_denunciante, t1.apellido1_denunciante, "
				+ " t1.apellido2_denunciante, t1.tipo_doc_denunciante, t1.documento_denunciante, t1.nombre_afectados, t1.nombre_denunciado, t1.direccion_denunciado, t1.cp_denunciado, "
				+ " t1.id_expediente, t1.provincia_denunciado, t1.id_provincia_denunciado, t1.id_municipio_denunciado, t1.municipio_denunciado, t1.id_localidad_denunciado, t1.localidad_denunciado, "
				+ " t1.id_provincia_tthh, t1.inculpado, t1.id_inspeccion, t1.identificador_inspeccion, t6.desc_tipo_es, t6.desc_tipo_eu, t7.titulo");
		if (tableRequestDto != null) {

			if ("NUM_ANYO,NUM_RECLAMACION".equals(tableRequestDto.getSidx())
					&& tableRequestDto.getSidx().indexOf(",") != -1) {
				String[] Columnas = tableRequestDto.getSidx().split(",");
				String col1 = Columnas[0];
				col1 = col1 + " " + tableRequestDto.getSord() + "," + Columnas[1];
				tableRequestDto.setSidx(col1);
			}

			query = TableManager.getPaginationQuery(tableRequestDto, query);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());

	}

	@Override
	public Long findAllLikeCount(ExpedienteDenuncia expedienteDenuncia, Boolean startsWith) {
	
		//Aadimos un SELECT COUNT(1) a la SQL del findAllLike ya que si no no se obtiene bien el total de registros 
		StringBuilder query = new StringBuilder(
						"SELECT COUNT(1) FROM ("
						+ " SELECT DISTINCT T1.ID_RECLAMACION, T1.NUM_ANYO, T1.NUM_RECLAMACION, MIN(T8.FH) FECHA_PRESENTACION, T1.ID_DIRECCION, T1.ID_TIPO_ESTABLECIMIENTO, "
						+ " T1.ID_TIPO_RECLAMACION, T1.NUM_PAGINA_REC, T1.FECHA_HECHOS, T1.FECHA_DECISION, T1.ID_DECISION, T1.IND_TIPO_RECLAMACION, T1.ID_PROCEDIMIENTO, "
						+ " T1.FOLDER_ID, T1.FOLDER_NUMBER, T1.NOMBRE_DENUNCIANTE, T1.APELLIDO1_DENUNCIANTE, T1.APELLIDO2_DENUNCIANTE, T1.TIPO_DOC_DENUNCIANTE, T1.DOCUMENTO_DENUNCIANTE, "
						+ " T1.NOMBRE_AFECTADOS, T1.NOMBRE_DENUNCIADO, T1.DIRECCION_DENUNCIADO, T1.CP_DENUNCIADO, T1.ID_EXPEDIENTE, T1.PROVINCIA_DENUNCIADO, T1.ID_PROVINCIA_DENUNCIADO, "
						+ " T1.ID_MUNICIPIO_DENUNCIADO, T1.MUNICIPIO_DENUNCIADO, T1.ID_LOCALIDAD_DENUNCIADO, T1.LOCALIDAD_DENUNCIADO, T1.ID_PROVINCIA_TTHH, t1.inculpado, T1.ID_INSPECCION, "
						+ " T1.IDENTIFICADOR_INSPECCION, T6.DESC_TIPO_ES, T6.DESC_TIPO_EU, T7.TITULO FROM AB78.DENUNCIAS_BUSCADOR_VIEW T1 "
						+ " LEFT JOIN  AB7808S00 T2 ON T1.ID_EXPEDIENTE IS NULL AND T1.ID_RECLAMACION = T2.ID_RECLAMACION "
						+ " LEFT JOIN REL_EXP_TER T3 ON T1.ID_EXPEDIENTE IS NOT NULL AND T1.ID_EXPEDIENTE = T3.ID_EXPEDIENTE "
						+ " LEFT JOIN AB78.DATOS_TERCERO T4 ON ((T1.ID_EXPEDIENTE IS NULL AND T4.ID_TERCERO = T2.ID_TERCERO) OR (T1.ID_EXPEDIENTE IS NOT NULL AND T4.ID_TERCERO = T3.ID_TERCERO))  "
						+ " LEFT JOIN AB78.AB7813T00 T5 ON T1.ID_RECLAMACION = T5.ID_RECLAMACION LEFT JOIN AB78.AB7802T00 T6 ON T1.ID_DECISION = T6.ID_DECISION LEFT JOIN AB78.EXPEDIENTES T7 ON T1.ID_EXPEDIENTE = T7.ID_EXPEDIENTE "
						+ " LEFT JOIN (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE = T44.ID_FECHA_EXPEDIENTE AND T44.ETIQUETA_FECHA = 'FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) T8 ON T1.ID_EXPEDIENTE = T8.ID_EXPEDIENTE WHERE 1=1  ");
		
		Map<String, Object> mapaWhere = this.getWhereLikeMap(expedienteDenuncia, startsWith);
		query.append(mapaWhere.get("query"));
		
		query.append(
				" GROUP BY t1.id_reclamacion, t1.num_anyo, t1.num_reclamacion, t1.id_direccion, t1.id_tipo_establecimiento, t1.id_tipo_reclamacion, t1.num_pagina_rec, t1.fecha_hechos, "
				+ " t1.fecha_decision, t1.id_decision, t1.ind_tipo_reclamacion, t1.id_procedimiento, t1.folder_id, t1.folder_number, t1.nombre_denunciante, t1.apellido1_denunciante, "
				+ " t1.apellido2_denunciante, t1.tipo_doc_denunciante, t1.documento_denunciante, t1.nombre_afectados, t1.nombre_denunciado, t1.direccion_denunciado, t1.cp_denunciado, "
				+ " t1.id_expediente, t1.provincia_denunciado, t1.id_provincia_denunciado, t1.id_municipio_denunciado, t1.municipio_denunciado, t1.id_localidad_denunciado, t1.localidad_denunciado, "
				+ " t1.id_provincia_tthh, t1.inculpado, t1.id_inspeccion, t1.identificador_inspeccion, t6.desc_tipo_es, t6.desc_tipo_eu, t7.titulo ");
		
		//Cerramos para el COUNT
		query.append(")");
		
		List<Object> params = (List<Object>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	@Override
	public List<Aviso> avisoPorFecha(Integer idAplicacion) {

		String query = "SELECT ID_AVISO, ID_APLICACION, FECHA_INICIO, FECHA_FIN, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_REGISTRO, USUARIO_REGISTRO, FECHA_ULTMODIFICACION, USUARIO_ULTMODIFICACION FROM AVISOS WHERE ID_APLICACION = ?";
		List<Object> params = new ArrayList<Object>();
		params.add(idAplicacion);

		return this.jdbcTemplate.query(query.toString(), this.rwMapAviso, params.toArray());
	}

	private Map<String, Object> getWhereLikeMap(ExpedienteDenuncia expedienteDenuncia, Boolean startsWith) {

		StringBuilder where = new StringBuilder(ExpedienteDenunciaDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (null != expedienteDenuncia && null != expedienteDenuncia.getFilter()) {

			ExpedienteDenunciaFilter filter = expedienteDenuncia.getFilter();

			if (null != filter.getDirecciones() && null != filter.getDirecciones().getIdDireccion()) {
				where.append(" AND T1.ID_DIRECCION IN (?)");
				params.add(filter.getDirecciones().getIdDireccion());
			}

			if (StringUtils.isNotBlank(filter.getFolderNumber())) {
				where.append(" AND TRIM(UPPER(T1.FOLDER_NUMBER)) LIKE ?");
				params.add("%" + filter.getFolderNumber().trim() + "%");
			}

			if (null != filter.getTipoEstablecimiento()
					&& StringUtils.isNotBlank(filter.getTipoEstablecimiento().getIdTipoEstablecimiento())) {
				where.append(" AND T1.ID_TIPO_ESTABLECIMIENTO = ?");
				params.add(filter.getTipoEstablecimiento().getIdTipoEstablecimiento());
			}

			if (null != filter.getTipoReclamacion() && null != filter.getTipoReclamacion().getIdTipoReclamacion()) {
				where.append(" AND T1.ID_TIPO_RECLAMACION = ?");
				params.add(filter.getTipoReclamacion().getIdTipoReclamacion());
			}

			if (null != filter.getNumReclamacion()) {
				where.append(
						" AND T1.NUM_ANYO|| '-' ||(DECODE(T1.ID_EXPEDIENTE, '0', '', NVL2(T1.ID_EXPEDIENTE, DECODE(T1.ID_PROVINCIA_TTHH, '48', 'BI-','20', 'SS-','01', 'VI-','1', 'VI-',''),''))|| TRIM(TO_CHAR(T1.NUM_RECLAMACION, '00000'))) LIKE ? ");
				params.add("%" + filter.getNumReclamacion().trim() + "%");
			}

			if (StringUtils.isNotBlank(filter.getNumPaginaRec())) {
				where.append(" AND TRIM(UPPER(T1.NUM_PAGINA_REC)) LIKE ?");
				params.add("%" + filter.getNumPaginaRec().toUpperCase().trim() + "%");
			}
			if (null != filter.getFechaPresentacionDesde() && null != filter.getFechaPresentacionHasta()) {
				where.append(" AND TRUNC(T8.FH) >= ? AND TRUNC(T8.FH) <= ? ");
				params.add(filter.getFechaPresentacionDesde());
				params.add(filter.getFechaPresentacionHasta());
			}

			else if (null != filter.getFechaPresentacionDesde()) {
				where.append(" AND TRUNC(T8.FH) >= ? ");
				params.add(filter.getFechaPresentacionDesde());
			}

			else if (null != filter.getFechaPresentacionHasta()) {
				where.append(" AND TRUNC(T8.FH) <= ? ");
				params.add(filter.getFechaPresentacionHasta());
			}

			if (null != filter.getFechaHechosDesde()) {
				where.append(" AND TRUNC(T1.FECHA_HECHOS) >= ?");
				params.add(filter.getFechaHechosDesde());
			}

			if (null != filter.getFechaHechosHasta()) {
				where.append(" AND TRUNC(T1.FECHA_HECHOS) <= ? ");
				params.add(filter.getFechaHechosHasta());
			}

			if (null != filter.getFechaDecisionDesde()) {
				where.append(" AND TRUNC(T1.FECHA_DECISION) >= ?");
				params.add(filter.getFechaDecisionDesde());
			}

			if (null != filter.getFechaDecisionHasta()) {
				where.append(" AND TRUNC(T1.FECHA_DECISION) <= ? ");
				params.add(filter.getFechaDecisionHasta());
			}

			if (null != filter.getTipoDecision() && null != filter.getTipoDecision().getIdDecision()
					&& 0 != filter.getTipoDecision().getIdDecision()) {
				where.append(" AND T1.ID_DECISION = ?");
				params.add(filter.getTipoDecision().getIdDecision());
			}

			if (null != filter.getTipoDecision() && null != filter.getTipoDecision().getIdDecision()
					&& 0 == filter.getTipoDecision().getIdDecision()) {
				where.append(" AND T1.ID_DECISION IS NULL");
			}

			if (null != filter.getRelacionMotivo() && null != filter.getRelacionMotivo().getMotivo()
					&& null != filter.getRelacionMotivo().getMotivo().getIdMotivo()) {
				where.append(" AND T5.ID_MOTIVO = ?");
				params.add(filter.getRelacionMotivo().getMotivo().getIdMotivo());
			}

			if (null != filter.getRelacionMotivo() && null != filter.getRelacionMotivo().getDescMotivo()) {
				where.append(" AND T5.DESCRIPCION_MOTIVO LIKE ?");
				params.add("%" + filter.getRelacionMotivo().getDescMotivo() + "%");
			}

			if (null != filter.getIndTipoReclamacion()) {
				where.append(" AND T1.IND_TIPO_RECLAMACION = ?");
				params.add(filter.getIndTipoReclamacion());
			}

			if (null != filter.getDatosTerceros()) {

				if (null != filter.getDatosTerceros().getTiposTercero()
						&& null != filter.getDatosTerceros().getTiposTercero().getIdTipoTercero()) {
					where.append(
							" AND ((T1.ID_EXPEDIENTE IS NULL AND T2.ID_TIPO_TERCERO = ? ) OR (T1.ID_EXPEDIENTE IS NOT NULL AND T3.ID_TIPO_TERCERO = ? )) ");
					params.add(filter.getDatosTerceros().getTiposTercero().getIdTipoTercero());
					params.add(filter.getDatosTerceros().getTiposTercero().getIdTipoTercero());
				}

				if (null != filter.getDatosTerceros().getTiposDocumento()
						&& null != filter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento()) {

					where.append(" AND T4.ID_TIPO_DOCUMENTO = ?");
					params.add(filter.getDatosTerceros().getTiposDocumento().getIdTipoDocumento());

				}

				if (StringUtils.isNotBlank(filter.getDatosTerceros().getDocumento())) {
					where.append(" AND T4.DOCUMENTO = ?");
					params.add(filter.getDatosTerceros().getDocumento());
				}

				if (StringUtils.isNotBlank(filter.getDatosTerceros().getNombre())) {

					where.append(" AND UPPER(T4.NOMBRE) LIKE ? ");
					params.add("%" + filter.getDatosTerceros().getNombre().toUpperCase() + "%");

				}

				if (StringUtils.isNotBlank(filter.getDatosTerceros().getApellido1())) {
					if (null != filter.getDatosTerceros().getTiposTercero()
							&& null != filter.getDatosTerceros().getTiposTercero().getIdTipoTercero()
							&& filter.getDatosTerceros().getTiposTercero()
									.getIdTipoTercero() == Constantes.ID_TIPO_TERCERO_DENUNCIADO) {
						where.append(" AND UPPER(T4.NOMBRE) LIKE ? ");
					} else {
						where.append(" AND UPPER(T4.APELLIDO1) LIKE ? ");
					}
					params.add("%" + filter.getDatosTerceros().getApellido1().toUpperCase() + "%");

				}

				if (StringUtils.isNotBlank(filter.getDatosTerceros().getApellido2())) {
					if (null != filter.getDatosTerceros().getTiposTercero()
							&& null != filter.getDatosTerceros().getTiposTercero().getIdTipoTercero()
							&& filter.getDatosTerceros().getTiposTercero()
									.getIdTipoTercero() == Constantes.ID_TIPO_TERCERO_DENUNCIADO) {
						where.append(" AND UPPER(T4.NOMBRE) LIKE ? ");
					} else {
						where.append(" AND UPPER(T4.APELLIDO2) LIKE ? ");
					}
					params.add("%" + filter.getDatosTerceros().getApellido2().toUpperCase() + "%");

				}
			}

			if (null != filter.getDatosDirecciones()) {

				if (null != filter.getDatosDirecciones().getIdProvincia()) {
					where.append(" AND T1.ID_PROVINCIA_DENUNCIADO = ?");
					params.add(filter.getDatosDirecciones().getIdProvincia());
				}

				if (null != filter.getDatosDirecciones().getIdMunicipio()) {
					where.append(" AND T1.ID_MUNICIPIO_DENUNCIADO = ?");
					params.add(filter.getDatosDirecciones().getIdMunicipio());

				}

				if (null != filter.getDatosDirecciones().getIdLocalidad()) {
					where.append(" AND T1.ID_LOCALIDAD_DENUNCIADO = ?");
					params.add(filter.getDatosDirecciones().getIdLocalidad());
				}

				if (filter.getDatosTerceros().getNombre() != null) {
					where.append(" AND UPPER(T1.NOMBRE_DENUNCIADO) = UPPER(?)");
					params.add(filter.getDatosTerceros().getNombre());
				}
				
				if (StringUtils.isNotBlank(filter.getDatosDirecciones().getDireccion())) {
					where.append(" AND UPPER(T1.DIRECCION_DENUNCIADO) LIKE ?");
					params.add("%" + filter.getDatosDirecciones().getDireccion().toUpperCase() + "%");
				}

				if (filter.getDatosDirecciones().getNumero() != null) {
					where.append(" AND UPPER(T1.NUMERO_DENUNCIADO) = UPPER(?)");
					params.add(filter.getDatosDirecciones().getNumero());
				}
				if (filter.getDatosDirecciones().getEscalera() != null) {
					where.append(" AND UPPER(T1.ESCALERA_DENUNCIADO) = UPPER(?)");
					params.add(filter.getDatosDirecciones().getEscalera());
				}
				if (filter.getDatosDirecciones().getPiso() != null) {
					where.append(" AND UPPER(T1.PISO_DENUNCIADO) = UPPER(?)");
					params.add(filter.getDatosDirecciones().getPiso());
				}
				if (filter.getDatosDirecciones().getLetra() != null) {
					where.append(" AND UPPER(T1.LETRA_DENUNCIADO) = UPPER(?)");
					params.add(filter.getDatosDirecciones().getLetra());
				}

				if (StringUtils.isNotBlank(filter.getDatosDirecciones().getCodigoPostal())) {
					where.append(" AND UPPER(T1.CP_DENUNCIADO) LIKE ?");
					params.add("%" + filter.getDatosDirecciones().getCodigoPostal().toUpperCase() + "%");
				}
			}
			if (filter.getFilterInactivos() != null && filter.getFilterInactivos() == Constantes.FILTER_SOLO_ACTIVOS) {
				where.append(
						" AND T1.ID_EXPEDIENTE NOT IN(SELECT ID_EXPEDIENTE FROM REL_EXP_FECH TT1, FECHAS_EXPEDIENTE TT2 WHERE TT1.ID_FECHA_EXPEDIENTE = TT2.ID_FECHA_EXPEDIENTE AND TT2.ETIQUETA_FECHA = 'FECHA_CIERRE') ");
			}
			if (filter.getFilterInactivos() != null
					&& filter.getFilterInactivos() == Constantes.FILTER_SOLO_INACTIVOS) {
				where.append(
						" AND T1.ID_EXPEDIENTE IN(SELECT ID_EXPEDIENTE FROM REL_EXP_FECH TT1, FECHAS_EXPEDIENTE TT2 WHERE TT1.ID_FECHA_EXPEDIENTE = TT2.ID_FECHA_EXPEDIENTE AND TT2.ETIQUETA_FECHA = 'FECHA_CIERRE') ");
			}

			if (StringUtils.isNotBlank(filter.getIdentificadorInspeccion())) {
				where.append(" AND UPPER(T1.IDENTIFICADOR_INSPECCION) LIKE ?");
				params.add("%" + filter.getIdentificadorInspeccion().toUpperCase() + "%");
			}

			if (filter.getTieneInspeccion() != null && filter.getTieneInspeccion() == true) {
				where.append(" AND UPPER(T1.IDENTIFICADOR_INSPECCION) IS NOT NULL");
			}
			if (StringUtils.isNotBlank(filter.getTituloExpediente())) {
				where.append(" AND TRIM(UPPER(T7.TITULO)) LIKE ?");
				params.add("%" + filter.getTituloExpediente().toUpperCase() + "%");
			}
			if (filter.getIdProcedimiento() != null) {
				where.append(" AND T1.ID_PROCEDIMIENTO = ? ");
				params.add(filter.getIdProcedimiento());
			}
		}

		
		if(expedienteDenuncia != null && expedienteDenuncia.getIdExpediente() != null){
			where.append(" AND T1.ID_EXPEDIENTE = ? ");
			params.add(expedienteDenuncia.getIdExpediente());
		}
		
		Map<String, Object> mapWhere = new HashMap<String, Object>();

		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

}
