package com.ejie.ab78.dao.denuncias;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.ab78.model.expedientes.Expedientes;
import com.ejie.ab78.model.maestros.Decision;
import com.ejie.ab78.model.maestros.Producto;
import com.ejie.ab78.model.maestros.TipoReclamacion;
import com.ejie.ab78.model.maestros.TipoVenta;
import com.ejie.ab78.model.terceros.DatosDirecciones;
import com.ejie.ab78.model.terceros.TiposDireccion;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DenunciasDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class DenunciasDaoImpl implements DenunciasDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDRECLAMACION", "IDEXPEDIENTE", "IDDIRECCION",
			"NUMANYO", "NUMRECLAMACION", "IDPROVINCIATTHH", "INDCONOCEESTABLECIMIENTO", "OBSERVACIONESNOCENSADO",
			"FECHAPRESENTACION", "TIPOINFRACCION", "NUMPAGINAREC", "DESCMOTIVOSES", "DESCMOTIVOSEU", "ASUNTOHECHOS",
			"FECHAHECHOS", "DESCHECHOSES", "DESCHECHOSEU", "INDTIPORECLAMACION", "TIPOCOMERCIO",
			"IDTIPOESTABLECIMIENTO", "TELEFONODENUNCIADO", "INDILEGAL", "DEVOLUCION", "IMPORTEDEVOLUCION",
			"INDEMNIZACION", "IMPORTEINDEMNIZACION", "DESCPRETENSIONESES", "DESCPRETENSIONESEU", "FECHAREGENTRADA",
			"NUMREGENTRADA", "FECHAREGSALIDA", "NUMREGSALIDA", "ORGANISMOS", "FECHADECISION",
			"FUNDAMENTODENUNCIASOLICITUD", "ARTICULOINFRIGIDOES", "ARTICULOINFRIGIDOEU", "NORMAINFRIGIDAES",
			"NORMAINFRIGIDAEU", "OBSERVACIONESDECISIONES", "OBSERVACIONESDECISIONEU", "INDELIMINADO", "FECHAREGISTRO",
			"USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION", "AB7805S00IDTIPORECLAMACION",
			"AB7805S00DESCTIPOES", "AB7805S00DESCTIPOEU", "AB7805S00BAJA", "AB7805S00FECHAREGISTRO",
			"AB7805S00USUARIOREGISTRO", "AB7805S00FECHAULTMODIFICACION", "AB7805S00USUARIOULTMODIF",
			"AB7802S00IDDECISION", "AB7802S00DESCTIPOES", "AB7802S00DESCTIPOEU", "AB7802S00BAJA",
			"AB7802S00FECHAREGISTRO", "AB7802S00USUARIOREGISTRO", "AB7802S00FECHAULTMODIFICACION",
			"AB7802S00USUARIOULTMODIF", "AB7803S00IDPRODUCTO", "AB7803S00DESCTIPOES", "AB7803S00DESCTIPOEU",
			"AB7803S00BAJA", "AB7803S00FECHAREGISTRO", "AB7803S00USUARIOREGISTRO", "AB7803S00FECHAULTMODIFICACION",
			"AB7803S00USUARIOULTMODIF", "AB7804S00IDTIPOVENTA", "AB7804S00DESCTIPOES", "AB7804S00DESCTIPOEU",
			"AB7804S00BAJA", "AB7804S00FECHAREGISTRO", "AB7804S00USUARIOREGISTRO", "AB7804S00FECHAULTMODIFICACION",
			"AB7804S00USUARIOULTMODIF", "FOLDERID", "FOLDERNUMBER", "TITULOEXP", "TFNODENUNCIANTENF" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Denuncia> rwMap = new RowMapper<Denuncia>() {
		@Override
		public Denuncia mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Denuncia denuncia = new Denuncia(resultSet.getInt("IDRECLAMACION"),
					new Expedientes(resultSet.getInt("IDEXPEDIENTE"), null, resultSet.getString("FOLDERID"),
							resultSet.getString("FOLDERNUMBER"), resultSet.getString("TITULOEXP"), null, null, null,
							null),
					resultSet.getInt("IDDIRECCION"), resultSet.getLong("NUMANYO"), resultSet.getInt("NUMRECLAMACION"),
					resultSet.getString("IDPROVINCIATTHH"), resultSet.getInt("INDCONOCEESTABLECIMIENTO"),
					resultSet.getString("OBSERVACIONESNOCENSADO"), resultSet.getDate("FECHAPRESENTACION"),
					resultSet.getInt("TIPOINFRACCION"), resultSet.getString("NUMPAGINAREC"),
					resultSet.getString("DESCMOTIVOSES"), resultSet.getString("DESCMOTIVOSEU"),
					resultSet.getString("ASUNTOHECHOS"), resultSet.getDate("FECHAHECHOS"),
					resultSet.getString("DESCHECHOSES"), resultSet.getString("DESCHECHOSEU"),
					null != resultSet.getObject("INDTIPORECLAMACION") ? resultSet.getInt("INDTIPORECLAMACION") : null,
					resultSet.getString("TIPOCOMERCIO"), resultSet.getString("IDTIPOESTABLECIMIENTO"),
					resultSet.getString("TELEFONODENUNCIADO"), resultSet.getInt("INDILEGAL"),
					resultSet.getInt("DEVOLUCION"), resultSet.getBigDecimal("IMPORTEDEVOLUCION"),
					resultSet.getInt("INDEMNIZACION"), resultSet.getBigDecimal("IMPORTEINDEMNIZACION"),
					resultSet.getString("DESCPRETENSIONESES"), resultSet.getString("DESCPRETENSIONESEU"),
					resultSet.getDate("FECHAREGENTRADA"), resultSet.getString("NUMREGENTRADA"),
					resultSet.getDate("FECHAREGSALIDA"), resultSet.getString("NUMREGSALIDA"),
					resultSet.getString("ORGANISMOS"), resultSet.getDate("FECHADECISION"),
					resultSet.getString("FUNDAMENTODENUNCIASOLICITUD"), resultSet.getString("ARTICULOINFRIGIDOES"),
					resultSet.getString("ARTICULOINFRIGIDOEU"), resultSet.getString("NORMAINFRIGIDAES"),
					resultSet.getString("NORMAINFRIGIDAEU"), resultSet.getString("OBSERVACIONESDECISIONES"),
					resultSet.getString("OBSERVACIONESDECISIONEU"), resultSet.getString("INDELIMINADO"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"),
					resultSet.getInt("TFNODENUNCIANTENF"),
					new TipoReclamacion(
							null != resultSet.getObject("Ab7805s00IDTIPORECLAMACION")
									? resultSet.getLong("Ab7805s00IDTIPORECLAMACION") : null,
							resultSet.getString("Ab7805s00DESCTIPOES"), resultSet.getString("Ab7805s00DESCTIPOEU"),
							resultSet.getInt("Ab7805s00BAJA"), resultSet.getDate("Ab7805s00FECHAREGISTRO"),
							resultSet.getString("Ab7805s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7805s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7805S00USUARIOULTMODIF")),
					new Decision(
							null != resultSet.getObject("Ab7802s00IDDECISION")
									? resultSet.getLong("Ab7802s00IDDECISION") : null,
							resultSet.getString("Ab7802s00DESCTIPOES"), resultSet.getString("Ab7802s00DESCTIPOEU"),
							resultSet.getInt("Ab7802s00BAJA"), resultSet.getDate("Ab7802s00FECHAREGISTRO"),
							resultSet.getString("Ab7802s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7802s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7802S00USUARIOULTMODIF")),
					new Producto(
							null != resultSet.getObject("Ab7803s00IDPRODUCTO")
									? resultSet.getLong("Ab7803s00IDPRODUCTO") : null,
							resultSet.getString("Ab7803s00DESCTIPOES"), resultSet.getString("Ab7803s00DESCTIPOEU"),
							resultSet.getInt("Ab7803s00BAJA"), resultSet.getDate("Ab7803s00FECHAREGISTRO"),
							resultSet.getString("Ab7803s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7803s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7803S00USUARIOULTMODIF")),
					new TipoVenta(
							null != resultSet.getObject("Ab7804s00IDTIPOVENTA")
									? resultSet.getLong("Ab7804s00IDTIPOVENTA") : null,
							resultSet.getString("Ab7804s00DESCTIPOES"), resultSet.getString("Ab7804s00DESCTIPOEU"),
							resultSet.getInt("Ab7804s00BAJA"), resultSet.getDate("Ab7804s00FECHAREGISTRO"),
							resultSet.getString("Ab7804s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7804s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7804S00USUARIOULTMODIF")),
					resultSet.getInt("ID_INSPECCION"), resultSet.getString("IDENTIFICADOR_INSPECCION"),
					null, null != resultSet.getObject("IDDIRECCIONDENUNCIADO")
							? new DatosDirecciones(resultSet.getInt("IDDIRECCIONDENUNCIADO"),
									resultSet.getString("ESTABLECIMIENTO"), resultSet.getString("DIRECCIONDENUNCIADO"),
									resultSet.getString("NUMERODENUNCIADO"), resultSet.getString("ESCALERADENUNCIADO"),
									resultSet.getString("PISODENUNCIADO"), resultSet.getString("LETRADENUNCIADO"),
									resultSet.getString("CODIGOPOSTALDENUNCIADO"), resultSet.getLong("IDPAIS"),
									null != resultSet.getObject("IDPROVINCIADENUNCIADO")
											? resultSet.getLong("IDPROVINCIADENUNCIADO") : null,
									null != resultSet.getObject("IDMUNICIPIODENUNCIADO")
											? resultSet.getLong("IDMUNICIPIODENUNCIADO") : null,
									null != resultSet.getObject("IDLOCALIDADDENUNCIADO")
											? resultSet.getLong("IDLOCALIDADDENUNCIADO") : null,
									resultSet.getString("DESCPROVINCIAEXTRANJERA"),
									resultSet.getString("DESCCIUDADEXTRANJERA"),
									resultSet.getString("IDENTIFICADORESTABLECIMIENTO"), null,
									null != resultSet.getObject("IDTIPODIRECCIONDENUNCIADO")
											? new TiposDireccion(resultSet.getLong("IDTIPODIRECCIONDENUNCIADO")) : null,
									null)
							: null);

			try {
				denuncia.setIdExpRel(resultSet.getString("IDEXPREL"));
			} catch (Exception e) {
				// TODO: handle exception
			}
			return denuncia;

		}
	};

	private RowMapper<Denuncia> rwMapDenuncia = new RowMapper<Denuncia>() {
		@Override
		public Denuncia mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			return new Denuncia(resultSet.getInt("IDRECLAMACION"),
					new Expedientes(resultSet.getInt("IDEXPEDIENTE"), null, resultSet.getString("FOLDERID"),
							resultSet.getString("FOLDERNUMBER"), resultSet.getString("TITULOEXP"), null, null, null,
							null),
					resultSet.getInt("IDDIRECCION"), resultSet.getLong("NUMANYO"), resultSet.getInt("NUMRECLAMACION"),
					resultSet.getString("IDPROVINCIATTHH"), resultSet.getInt("INDCONOCEESTABLECIMIENTO"),
					resultSet.getString("OBSERVACIONESNOCENSADO"), null, resultSet.getInt("TIPOINFRACCION"),
					resultSet.getString("NUMPAGINAREC"), resultSet.getString("DESCMOTIVOSES"),
					resultSet.getString("DESCMOTIVOSEU"), resultSet.getString("ASUNTOHECHOS"),
					resultSet.getDate("FECHAHECHOS"), resultSet.getString("DESCHECHOSES"),
					resultSet.getString("DESCHECHOSEU"),
					null != resultSet.getObject("INDTIPORECLAMACION") ? resultSet.getInt("INDTIPORECLAMACION") : null,
					resultSet.getString("TIPOCOMERCIO"), resultSet.getString("IDTIPOESTABLECIMIENTO"),
					resultSet.getString("TELEFONODENUNCIADO"), resultSet.getInt("INDILEGAL"),
					resultSet.getInt("DEVOLUCION"), resultSet.getBigDecimal("IMPORTEDEVOLUCION"),
					resultSet.getInt("INDEMNIZACION"), resultSet.getBigDecimal("IMPORTEINDEMNIZACION"),
					resultSet.getString("DESCPRETENSIONESES"), resultSet.getString("DESCPRETENSIONESEU"),
					resultSet.getDate("FECHAREGENTRADA"), resultSet.getString("NUMREGENTRADA"),
					resultSet.getDate("FECHAREGSALIDA"), resultSet.getString("NUMREGSALIDA"),
					resultSet.getString("ORGANISMOS"), resultSet.getDate("FECHADECISION"),
					resultSet.getString("FUNDAMENTODENUNCIASOLICITUD"), resultSet.getString("ARTICULOINFRIGIDOES"),
					resultSet.getString("ARTICULOINFRIGIDOEU"), resultSet.getString("NORMAINFRIGIDAES"),
					resultSet.getString("NORMAINFRIGIDAEU"), resultSet.getString("OBSERVACIONESDECISIONES"),
					resultSet.getString("OBSERVACIONESDECISIONEU"), resultSet.getString("INDELIMINADO"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"),
					resultSet.getInt("TFNODENUNCIANTENF"),
					new TipoReclamacion(
							null != resultSet.getObject("Ab7805s00IDTIPORECLAMACION")
									? resultSet.getLong("Ab7805s00IDTIPORECLAMACION") : null,
							resultSet.getString("Ab7805s00DESCTIPOES"), resultSet.getString("Ab7805s00DESCTIPOEU"),
							resultSet.getInt("Ab7805s00BAJA"), resultSet.getDate("Ab7805s00FECHAREGISTRO"),
							resultSet.getString("Ab7805s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7805s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7805S00USUARIOULTMODIF")),
					new Decision(
							null != resultSet.getObject("Ab7802s00IDDECISION")
									? resultSet.getLong("Ab7802s00IDDECISION") : null,
							resultSet.getString("Ab7802s00DESCTIPOES"), resultSet.getString("Ab7802s00DESCTIPOEU"),
							resultSet.getInt("Ab7802s00BAJA"), resultSet.getDate("Ab7802s00FECHAREGISTRO"),
							resultSet.getString("Ab7802s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7802s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7802S00USUARIOULTMODIF")),
					new Producto(
							null != resultSet.getObject("Ab7803s00IDPRODUCTO")
									? resultSet.getLong("Ab7803s00IDPRODUCTO") : null,
							resultSet.getString("Ab7803s00DESCTIPOES"), resultSet.getString("Ab7803s00DESCTIPOEU"),
							resultSet.getInt("Ab7803s00BAJA"), resultSet.getDate("Ab7803s00FECHAREGISTRO"),
							resultSet.getString("Ab7803s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7803s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7803S00USUARIOULTMODIF")),
					new TipoVenta(
							null != resultSet.getObject("Ab7804s00IDTIPOVENTA")
									? resultSet.getLong("Ab7804s00IDTIPOVENTA") : null,
							resultSet.getString("Ab7804s00DESCTIPOES"), resultSet.getString("Ab7804s00DESCTIPOEU"),
							resultSet.getInt("Ab7804s00BAJA"), resultSet.getDate("Ab7804s00FECHAREGISTRO"),
							resultSet.getString("Ab7804s00USUARIOREGISTRO"),
							resultSet.getDate("Ab7804s00FECHAULTMODIFICACION"),
							resultSet.getString("AB7804S00USUARIOULTMODIF")),
					resultSet.getInt("ID_INSPECCION"), resultSet.getString("IDENTIFICADOR_INSPECCION"), null,
					null != resultSet.getObject("IDDIRECCIONDENUNCIADO") ? new DatosDirecciones(
							resultSet.getInt("IDDIRECCIONDENUNCIADO"), null, resultSet.getString("DIRECCIONDENUNCIADO"),
							resultSet.getString("NUMERODENUNCIADO"), resultSet.getString("ESCALERADENUNCIADO"),
							resultSet.getString("PISODENUNCIADO"), resultSet.getString("LETRADENUNCIADO"),
							resultSet.getString("CODIGOPOSTALDENUNCIADO"), null,
							null != resultSet.getObject("IDPROVINCIADENUNCIADO")
									? resultSet.getLong("IDPROVINCIADENUNCIADO") : null,
							null != resultSet.getObject("IDMUNICIPIODENUNCIADO")
									? resultSet.getLong("IDMUNICIPIODENUNCIADO") : null,
							null != resultSet.getObject("IDLOCALIDADDENUNCIADO")
									? resultSet.getLong("IDLOCALIDADDENUNCIADO") : null,
							resultSet.getString("DESCPROVINCIAEXTRANJERA"), resultSet.getString("DESCCIUDADEXTRANJERA"),
							resultSet.getString("IDENTIFICADORESTABLECIMIENTO"), null,
							null != resultSet.getObject("IDTIPODIRECCIONDENUNCIADO")
									? new TiposDireccion(resultSet.getLong("IDTIPODIRECCIONDENUNCIADO")) : null,
							null) : null);
		}
	};

	private RowMapper<Denuncia> rwMapPK = new RowMapper<Denuncia>() {
		@Override
		public Denuncia mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Denuncia(resultSet.getInt("IDRECLAMACION"));
		}
	};

	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Override
	public Denuncia add(Denuncia denuncia) {

		String query = "INSERT INTO AB7801S00 (ID_RECLAMACION, ID_TIPO_RECLAMACION, ID_DECISION, ID_PRODUCTO, ID_TIPO_VENTA, ID_EXPEDIENTE, ID_DIRECCION, NUM_ANYO, "
				+ " NUM_RECLAMACION, ID_PROVINCIA_TTHH, IND_CONOCE_ESTABLECIMIENTO, OBSERVACIONES_NO_CENSADO, TIPO_INFRACCION, NUM_PAGINA_REC, "
				+ " DESC_MOTIVOS_ES, DESC_MOTIVOS_EU, ASUNTO_HECHOS, FECHA_HECHOS, DESC_HECHOS_ES, DESC_HECHOS_EU, IND_TIPO_RECLAMACION, TIPO_COMERCIO, "
				+ " ID_TIPO_ESTABLECIMIENTO, TELEFONO_DENUNCIADO, IND_ILEGAL, "
				+ " DEVOLUCION, IMPORTE_DEVOLUCION, INDEMNIZACION, IMPORTE_INDEMNIZACION, DESC_PRETENSIONES_ES, DESC_PRETENSIONES_EU, FECHA_REG_ENTRADA, NUM_REG_ENTRADA, "
				+ " FECHA_REG_SALIDA, NUM_REG_SALIDA, ORGANISMOS, FECHA_DECISION, FUNDAMENTO_DENUNCIA_SOLICITUD, ARTICULO_INFRIGIDO_ES, ARTICULO_INFRIGIDO_EU, "
				+ " NORMA_INFRIGIDA_ES, NORMA_INFRIGIDA_EU, OBSERVACIONES_DECISION_ES, OBSERVACIONES_DECISION_EU, IND_ELIMINADO, FECHA_REGISTRO, USUARIO_REGISTRO) "
				+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,SYSDATE,?)";
		Object getAb7805s00IdTipoReclamacionAux = null;
		if (denuncia.getTipoReclamacion() != null && denuncia.getTipoReclamacion().getIdTipoReclamacion() != null) {
			getAb7805s00IdTipoReclamacionAux = denuncia.getTipoReclamacion().getIdTipoReclamacion();
		}
		Object getAb7802s00IdDecisionAux = null;
		if (denuncia.getDecision() != null && denuncia.getDecision().getIdDecision() != null) {
			getAb7802s00IdDecisionAux = denuncia.getDecision().getIdDecision();
		}
		Object getAb7803s00IdProductoAux = null;
		if (denuncia.getProducto() != null && denuncia.getProducto().getIdProducto() != null) {
			getAb7803s00IdProductoAux = denuncia.getProducto().getIdProducto();
		}
		Object getAb7804s00IdTipoVentaAux = null;
		if (denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getIdTipoVenta() != null) {
			getAb7804s00IdTipoVentaAux = denuncia.getTipoVenta().getIdTipoVenta();
		}
		this.jdbcTemplate.update(query, denuncia.getIdReclamacion(), getAb7805s00IdTipoReclamacionAux,
				getAb7802s00IdDecisionAux, getAb7803s00IdProductoAux, getAb7804s00IdTipoVentaAux,
				denuncia.getExpediente().getIdExpediente(), denuncia.getIdDireccion(), denuncia.getNumAnyo(),
				denuncia.getNumReclamacion(), denuncia.getIdProvinciaTthh(), denuncia.getIndConoceEstablecimiento(),
				denuncia.getObservacionesNoCensado(), denuncia.getTipoInfraccion(), denuncia.getNumPaginaRec(),
				denuncia.getDescMotivosEs(), denuncia.getDescMotivosEu(), denuncia.getAsuntoHechos(),
				denuncia.getFechaHechos(), denuncia.getDescHechosEs(), denuncia.getDescHechosEu(),
				denuncia.getIndTipoReclamacion(), denuncia.getTipoComercio(), denuncia.getIdTipoEstablecimiento(),
				denuncia.getTelefonoDenunciado(), denuncia.getIndIlegal(), denuncia.getDevolucion(),
				denuncia.getImporteDevolucion(), denuncia.getIndemnizacion(), denuncia.getImporteIndemnizacion(),
				denuncia.getDescPretensionesEs(), denuncia.getDescPretensionesEu(), denuncia.getFechaRegEntrada(),
				denuncia.getNumRegEntrada(), denuncia.getFechaRegSalida(), denuncia.getNumRegSalida(),
				denuncia.getOrganismos(), denuncia.getFechaDecision(), denuncia.getFundamentoDenunciaSolicitud(),
				denuncia.getArticuloInfrigidoEs(), denuncia.getArticuloInfrigidoEu(), denuncia.getNormaInfrigidaEs(),
				denuncia.getNormaInfrigidaEu(), denuncia.getObservacionesDecisionEs(),
				denuncia.getObservacionesDecisionEu(), denuncia.getIndEliminado(), denuncia.getUsuarioRegistro());
		return denuncia;
	}

	@Override
	public Denuncia update(Denuncia denuncia) {
		String query = "UPDATE AB7801S00 SET ID_TIPO_RECLAMACION=?, ID_DECISION=?, ID_PRODUCTO=?, ID_TIPO_VENTA=?, ID_EXPEDIENTE=?, ID_DIRECCION=?, NUM_ANYO=?, NUM_RECLAMACION=?, "
				+ " ID_PROVINCIA_TTHH=?, IND_CONOCE_ESTABLECIMIENTO=?, OBSERVACIONES_NO_CENSADO=?, TIPO_INFRACCION=?, NUM_PAGINA_REC=?, DESC_MOTIVOS_ES=?, DESC_MOTIVOS_EU=?, "
				+ " ASUNTO_HECHOS=?, FECHA_HECHOS=?, DESC_HECHOS_ES=?, DESC_HECHOS_EU=?, IND_TIPO_RECLAMACION=?, TIPO_COMERCIO=?, ID_TIPO_ESTABLECIMIENTO=?, "
				+ " TELEFONO_DENUNCIADO=?, IND_ILEGAL=?, DEVOLUCION=?, "
				+ " IMPORTE_DEVOLUCION=?, INDEMNIZACION=?, IMPORTE_INDEMNIZACION=?, DESC_PRETENSIONES_ES=?, DESC_PRETENSIONES_EU=?, FECHA_REG_ENTRADA=?, NUM_REG_ENTRADA=?, "
				+ " FECHA_REG_SALIDA=?, NUM_REG_SALIDA=?, ORGANISMOS=?, FECHA_DECISION=?, FUNDAMENTO_DENUNCIA_SOLICITUD=?, ARTICULO_INFRIGIDO_ES=?, ARTICULO_INFRIGIDO_EU=?, "
				+ " NORMA_INFRIGIDA_ES=?, NORMA_INFRIGIDA_EU=?, OBSERVACIONES_DECISION_ES=?, OBSERVACIONES_DECISION_EU=?, IND_ELIMINADO=?, FECHA_ULTMODIFICACION=SYSDATE, "
				+ " USUARIO_ULTMODIFICACION=?, ID_EXP_REL=? WHERE ID_RECLAMACION=?";
		Object getAb7805s00IdTipoReclamacionAux = null;
		if (denuncia.getTipoReclamacion() != null && denuncia.getTipoReclamacion().getIdTipoReclamacion() != null) {
			getAb7805s00IdTipoReclamacionAux = denuncia.getTipoReclamacion().getIdTipoReclamacion();
		}
		Object getAb7802s00IdDecisionAux = null;
		if (denuncia.getDecision() != null && denuncia.getDecision().getIdDecision() != null) {
			getAb7802s00IdDecisionAux = denuncia.getDecision().getIdDecision();
		}
		Object getAb7803s00IdProductoAux = null;
		if (denuncia.getProducto() != null && denuncia.getProducto().getIdProducto() != null) {
			getAb7803s00IdProductoAux = denuncia.getProducto().getIdProducto();
		}
		Object getAb7804s00IdTipoVentaAux = null;
		if (denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getIdTipoVenta() != null) {
			getAb7804s00IdTipoVentaAux = denuncia.getTipoVenta().getIdTipoVenta();
		}
		Object idExpedienteAux = null;
		if (denuncia.getExpediente() != null && denuncia.getExpediente().getIdExpediente() != null) {
			idExpedienteAux = denuncia.getExpediente().getIdExpediente();
		}
		this.jdbcTemplate.update(query, getAb7805s00IdTipoReclamacionAux, getAb7802s00IdDecisionAux,
				getAb7803s00IdProductoAux, getAb7804s00IdTipoVentaAux, idExpedienteAux, denuncia.getIdDireccion(),
				denuncia.getNumAnyo(), denuncia.getNumReclamacion(), denuncia.getIdProvinciaTthh(),
				denuncia.getIndConoceEstablecimiento(), denuncia.getObservacionesNoCensado(),
				denuncia.getTipoInfraccion(), denuncia.getNumPaginaRec(), denuncia.getDescMotivosEs(),
				denuncia.getDescMotivosEu(), denuncia.getAsuntoHechos(), denuncia.getFechaHechos(),
				denuncia.getDescHechosEs(), denuncia.getDescHechosEu(), denuncia.getIndTipoReclamacion(),
				denuncia.getTipoComercio(), denuncia.getIdTipoEstablecimiento(), denuncia.getTelefonoDenunciado(),
				denuncia.getIndIlegal(), denuncia.getDevolucion(), denuncia.getImporteDevolucion(),
				denuncia.getIndemnizacion(), denuncia.getImporteIndemnizacion(), denuncia.getDescPretensionesEs(),
				denuncia.getDescPretensionesEu(), denuncia.getFechaRegEntrada(), denuncia.getNumRegEntrada(),
				denuncia.getFechaRegSalida(), denuncia.getNumRegSalida(), denuncia.getOrganismos(),
				denuncia.getFechaDecision(), denuncia.getFundamentoDenunciaSolicitud(),
				denuncia.getArticuloInfrigidoEs(), denuncia.getArticuloInfrigidoEu(), denuncia.getNormaInfrigidaEs(),
				denuncia.getNormaInfrigidaEu(), denuncia.getObservacionesDecisionEs(),
				denuncia.getObservacionesDecisionEu(), denuncia.getIndEliminado(), UtilUsuario.getUserConnected(),
				denuncia.getIdExpRel(), denuncia.getIdReclamacion());
		return denuncia;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@Override
	@Transactional(readOnly = true)
	public Denuncia find(Denuncia denuncia) {
		String query = "SELECT T1.ID_RECLAMACION IDRECLAMACION, EXP.ID_EXPEDIENTE IDEXPEDIENTE, EXP.FOLDER_ID FOLDERID, EXP.FOLDER_NUMBER FOLDERNUMBER, EXP.TITULO TITULOEXP, "
				+ " T1.ID_DIRECCION IDDIRECCION, T1.NUM_ANYO NUMANYO, T1.NUM_RECLAMACION NUMRECLAMACION, T1.ID_PROVINCIA_TTHH IDPROVINCIATTHH, T1.IND_CONOCE_ESTABLECIMIENTO INDCONOCEESTABLECIMIENTO, "
				+ " T1.OBSERVACIONES_NO_CENSADO OBSERVACIONESNOCENSADO, T1.TIPO_INFRACCION TIPOINFRACCION, T1.NUM_PAGINA_REC NUMPAGINAREC, T1.DESC_MOTIVOS_ES DESCMOTIVOSES, "
				+ " T1.DESC_MOTIVOS_EU DESCMOTIVOSEU, T1.ASUNTO_HECHOS ASUNTOHECHOS, T1.FECHA_HECHOS FECHAHECHOS, T1.DESC_HECHOS_ES DESCHECHOSES, T1.DESC_HECHOS_EU DESCHECHOSEU, "
				+ " T1.IND_TIPO_RECLAMACION INDTIPORECLAMACION, T1.TIPO_COMERCIO TIPOCOMERCIO, T1.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO, T1.TELEFONO_DENUNCIADO TELEFONODENUNCIADO, "
				+ " T1.IND_ILEGAL INDILEGAL, T1.DEVOLUCION DEVOLUCION, T1.IMPORTE_DEVOLUCION IMPORTEDEVOLUCION, T1.INDEMNIZACION INDEMNIZACION, "
				+ " T1.IMPORTE_INDEMNIZACION IMPORTEINDEMNIZACION, T1.DESC_PRETENSIONES_ES DESCPRETENSIONESES, T1.DESC_PRETENSIONES_EU DESCPRETENSIONESEU, "
				+ " T1.FECHA_REG_ENTRADA FECHAREGENTRADA, T1.NUM_REG_ENTRADA NUMREGENTRADA, T1.FECHA_REG_SALIDA FECHAREGSALIDA, T1.NUM_REG_SALIDA NUMREGSALIDA, "
				+ " T1.ORGANISMOS ORGANISMOS, T1.FECHA_DECISION FECHADECISION, T1.FUNDAMENTO_DENUNCIA_SOLICITUD FUNDAMENTODENUNCIASOLICITUD, T1.ARTICULO_INFRIGIDO_ES ARTICULOINFRIGIDOES, "
				+ " T1.ARTICULO_INFRIGIDO_EU ARTICULOINFRIGIDOEU, T1.NORMA_INFRIGIDA_ES NORMAINFRIGIDAES, T1.NORMA_INFRIGIDA_EU NORMAINFRIGIDAEU, T1.OBSERVACIONES_DECISION_ES OBSERVACIONESDECISIONES, "
				+ " T1.OBSERVACIONES_DECISION_EU OBSERVACIONESDECISIONEU, T1.IND_ELIMINADO INDELIMINADO, t1.TFNO_DENUNCIANTE_NF TFNODENUNCIANTENF,T1.FECHA_REGISTRO FECHAREGISTRO, "
				+ " T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " T2.ID_TIPO_RECLAMACION AB7805S00IDTIPORECLAMACION, T2.DESC_TIPO_ES AB7805S00DESCTIPOES, T2.DESC_TIPO_EU AB7805S00DESCTIPOEU, T2.BAJA AB7805S00BAJA, "
				+ " T2.FECHA_REGISTRO AB7805S00FECHAREGISTRO, T2.USUARIO_REGISTRO AB7805S00USUARIOREGISTRO, T2.FECHA_ULTMODIFICACION AB7805S00FECHAULTMODIFICACION, "
				+ " T2.USUARIO_ULTMODIFICACION AB7805S00USUARIOULTMODIF, T3.ID_DECISION AB7802S00IDDECISION, T3.DESC_TIPO_ES AB7802S00DESCTIPOES, T3.DESC_TIPO_EU AB7802S00DESCTIPOEU, "
				+ " T3.BAJA AB7802S00BAJA, T3.FECHA_REGISTRO AB7802S00FECHAREGISTRO, T3.USUARIO_REGISTRO AB7802S00USUARIOREGISTRO, T3.FECHA_ULTMODIFICACION AB7802S00FECHAULTMODIFICACION, "
				+ " T3.USUARIO_ULTMODIFICACION AB7802S00USUARIOULTMODIF, T4.ID_PRODUCTO AB7803S00IDPRODUCTO, T4.DESC_TIPO_ES AB7803S00DESCTIPOES, T4.DESC_TIPO_EU AB7803S00DESCTIPOEU, "
				+ " T4.BAJA AB7803S00BAJA, T4.FECHA_REGISTRO AB7803S00FECHAREGISTRO, T4.USUARIO_REGISTRO AB7803S00USUARIOREGISTRO, T4.FECHA_ULTMODIFICACION AB7803S00FECHAULTMODIFICACION, "
				+ " T4.USUARIO_ULTMODIFICACION AB7803S00USUARIOULTMODIF, T5.ID_TIPO_VENTA AB7804S00IDTIPOVENTA, T5.DESC_TIPO_ES AB7804S00DESCTIPOES, T5.DESC_TIPO_EU AB7804S00DESCTIPOEU, "
				+ " T5.BAJA AB7804S00BAJA, T5.FECHA_REGISTRO AB7804S00FECHAREGISTRO, T5.USUARIO_REGISTRO AB7804S00USUARIOREGISTRO, T5.FECHA_ULTMODIFICACION AB7804S00FECHAULTMODIFICACION, "
				+ " T5.USUARIO_ULTMODIFICACION AB7804S00USUARIOULTMODIF, INSP.ID_INSPECCION, INSP.IDENTIFICADOR_INSPECCION, R_EXP_DIR.ID_DIRECCION IDDIRECCIONDENUNCIADO, "
				+ " DIR.ID_TIPO_DIRECCION IDTIPODIRECCIONDENUNCIADO, DIR.DIRECCION DIRECCIONDENUNCIADO, DIR.NUMERO NUMERODENUNCIADO, DIR.ESCALERA ESCALERADENUNCIADO, "
				+ " DIR.PISO PISODENUNCIADO, DIR.LETRA LETRADENUNCIADO, DIR.ID_PAIS IDPAIS, DIR.DESCRIPCION_PROVINCIA DESCPROVINCIAEXTRANJERA, DIR.DESCRIPCION_CIUDAD DESCCIUDADEXTRANJERA, "
				+ " DIR.CODIGO_POSTAL CODIGOPOSTALDENUNCIADO, DIR.ID_PROVINCIA IDPROVINCIADENUNCIADO, DIR.ID_MUNICIPIO IDMUNICIPIODENUNCIADO, DIR.ID_LOCALIDAD IDLOCALIDADDENUNCIADO, "
				+ " DIR.ESTABLECIMIENTO ESTABLECIMIENTO, DIR.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, DIR.ESTABLECIMIENTO NOMBRECOMERCIAL "

				+ " FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, AB78.EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
				+ " AB78.INSPECCIONES_EXPEDIENTE INSP, AB78.DATOS_DIRECCIONES DIR, AB78.PROVINCIAS P, AB78.MUNICIPIOS M, AB78.LOCALIDADES L, "
				+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
				+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER "

				+ " WHERE T1.ID_RECLAMACION =? AND T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = INSP.ID_EXPEDIENTE (+) "
				+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
				+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
				+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
				+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ";

		List<Denuncia> ab7801s00List = this.jdbcTemplate.query(query, this.rwMapDenuncia, denuncia.getIdReclamacion());
		return DataAccessUtils.uniqueResult(ab7801s00List);
	}

	@Override
	@Transactional(readOnly = true)
	public Denuncia findByIdExpediente(Denuncia denuncia) {
		String query = "SELECT T1.ID_RECLAMACION IDRECLAMACION, EXP.ID_EXPEDIENTE IDEXPEDIENTE, t1.id_exp_rel idexprel, EXP.FOLDER_ID FOLDERID, EXP.FOLDER_NUMBER FOLDERNUMBER, "
				+ " EXP.TITULO TITULOEXP, T1.ID_DIRECCION IDDIRECCION, T1.NUM_ANYO NUMANYO, T1.NUM_RECLAMACION NUMRECLAMACION, T1.ID_PROVINCIA_TTHH IDPROVINCIATTHH, "
				+ " T1.IND_CONOCE_ESTABLECIMIENTO INDCONOCEESTABLECIMIENTO, T1.OBSERVACIONES_NO_CENSADO OBSERVACIONESNOCENSADO, TAPER.FH FECHAPRESENTACION, T1.TIPO_INFRACCION TIPOINFRACCION, "
				+ " T1.NUM_PAGINA_REC NUMPAGINAREC, T1.DESC_MOTIVOS_ES DESCMOTIVOSES, T1.DESC_MOTIVOS_EU DESCMOTIVOSEU, T1.ASUNTO_HECHOS ASUNTOHECHOS, T1.FECHA_HECHOS FECHAHECHOS, "
				+ " T1.DESC_HECHOS_ES DESCHECHOSES, T1.DESC_HECHOS_EU DESCHECHOSEU, T1.IND_TIPO_RECLAMACION INDTIPORECLAMACION, T1.TIPO_COMERCIO TIPOCOMERCIO, "
				+ " T1.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO, T1.TELEFONO_DENUNCIADO TELEFONODENUNCIADO, T1.IND_ILEGAL INDILEGAL, "
				+ " T1.DEVOLUCION DEVOLUCION, T1.IMPORTE_DEVOLUCION IMPORTEDEVOLUCION, T1.INDEMNIZACION INDEMNIZACION, T1.IMPORTE_INDEMNIZACION IMPORTEINDEMNIZACION, "
				+ " T1.DESC_PRETENSIONES_ES DESCPRETENSIONESES, T1.DESC_PRETENSIONES_EU DESCPRETENSIONESEU, T1.FECHA_REG_ENTRADA FECHAREGENTRADA, T1.NUM_REG_ENTRADA NUMREGENTRADA, "
				+ " T1.FECHA_REG_SALIDA FECHAREGSALIDA, T1.NUM_REG_SALIDA NUMREGSALIDA, T1.ORGANISMOS ORGANISMOS, T1.FECHA_DECISION FECHADECISION, "
				+ " T1.FUNDAMENTO_DENUNCIA_SOLICITUD FUNDAMENTODENUNCIASOLICITUD, T1.ARTICULO_INFRIGIDO_ES ARTICULOINFRIGIDOES, T1.ARTICULO_INFRIGIDO_EU ARTICULOINFRIGIDOEU, "
				+ " T1.NORMA_INFRIGIDA_ES NORMAINFRIGIDAES, T1.NORMA_INFRIGIDA_EU NORMAINFRIGIDAEU, T1.OBSERVACIONES_DECISION_ES OBSERVACIONESDECISIONES, "
				+ " T1.OBSERVACIONES_DECISION_EU OBSERVACIONESDECISIONEU, T1.IND_ELIMINADO INDELIMINADO, t1.TFNO_DENUNCIANTE_NF TFNODENUNCIANTENF, T1.FECHA_REGISTRO FECHAREGISTRO, "
				+ " T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
				+ " T2.ID_TIPO_RECLAMACION AB7805S00IDTIPORECLAMACION, T2.DESC_TIPO_ES AB7805S00DESCTIPOES, T2.DESC_TIPO_EU AB7805S00DESCTIPOEU, T2.BAJA AB7805S00BAJA,"
				+ "  T2.FECHA_REGISTRO AB7805S00FECHAREGISTRO, T2.USUARIO_REGISTRO AB7805S00USUARIOREGISTRO, T2.FECHA_ULTMODIFICACION AB7805S00FECHAULTMODIFICACION, "
				+ " T2.USUARIO_ULTMODIFICACION AB7805S00USUARIOULTMODIF, T3.ID_DECISION AB7802S00IDDECISION, T3.DESC_TIPO_ES AB7802S00DESCTIPOES, T3.DESC_TIPO_EU AB7802S00DESCTIPOEU, "
				+ " T3.BAJA AB7802S00BAJA, T3.FECHA_REGISTRO AB7802S00FECHAREGISTRO, T3.USUARIO_REGISTRO AB7802S00USUARIOREGISTRO, T3.FECHA_ULTMODIFICACION AB7802S00FECHAULTMODIFICACION, "
				+ " T3.USUARIO_ULTMODIFICACION AB7802S00USUARIOULTMODIF, T4.ID_PRODUCTO AB7803S00IDPRODUCTO, T4.DESC_TIPO_ES AB7803S00DESCTIPOES, T4.DESC_TIPO_EU AB7803S00DESCTIPOEU, "
				+ " T4.BAJA AB7803S00BAJA, T4.FECHA_REGISTRO AB7803S00FECHAREGISTRO, T4.USUARIO_REGISTRO AB7803S00USUARIOREGISTRO, T4.FECHA_ULTMODIFICACION AB7803S00FECHAULTMODIFICACION, "
				+ " T4.USUARIO_ULTMODIFICACION AB7803S00USUARIOULTMODIF, T5.ID_TIPO_VENTA AB7804S00IDTIPOVENTA, T5.DESC_TIPO_ES AB7804S00DESCTIPOES, T5.DESC_TIPO_EU AB7804S00DESCTIPOEU, "
				+ " T5.BAJA AB7804S00BAJA, T5.FECHA_REGISTRO AB7804S00FECHAREGISTRO, T5.USUARIO_REGISTRO AB7804S00USUARIOREGISTRO, T5.FECHA_ULTMODIFICACION AB7804S00FECHAULTMODIFICACION, "
				+ " T5.USUARIO_ULTMODIFICACION AB7804S00USUARIOULTMODIF, DECODE (t6143.ID_INSPECCION, NULL, t6150.ID_INSPECCION, t6143.ID_INSPECCION) AS ID_INSPECCION,"
				+ " DECODE (t6143.IDENTIFICADOR_INSPECCION, NULL, t6150.IDENTIFICADOR_INSPECCION, t6143.IDENTIFICADOR_INSPECCION) AS IDENTIFICADOR_INSPECCION, R_EXP_DIR.ID_DIRECCION IDDIRECCIONDENUNCIADO, "
				+ " DIR.ID_TIPO_DIRECCION IDTIPODIRECCIONDENUNCIADO, DIR.DIRECCION DIRECCIONDENUNCIADO, DIR.NUMERO NUMERODENUNCIADO, DIR.ESCALERA ESCALERADENUNCIADO, "
				+ " DIR.PISO PISODENUNCIADO, DIR.LETRA LETRADENUNCIADO, DIR.ID_PAIS IDPAIS, DIR.DESCRIPCION_PROVINCIA DESCPROVINCIAEXTRANJERA, DIR.DESCRIPCION_CIUDAD DESCCIUDADEXTRANJERA, "
				+ " DIR.CODIGO_POSTAL CODIGOPOSTALDENUNCIADO, DIR.ID_PROVINCIA IDPROVINCIADENUNCIADO, DIR.ID_MUNICIPIO IDMUNICIPIODENUNCIADO, DIR.ID_LOCALIDAD IDLOCALIDADDENUNCIADO, "
				+ " DIR.ESTABLECIMIENTO ESTABLECIMIENTO, DIR.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, DIR.ESTABLECIMIENTO NOMBRECOMERCIAL "

				+ " FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
				+ " INSPECCIONES_EXPEDIENTE t6143, REL_DEN_INS t6150, DATOS_DIRECCIONES DIR, PROVINCIAS P, MUNICIPIOS M, LOCALIDADES L, "
				+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
				+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER "

				+ " WHERE T1.ID_EXPEDIENTE =? AND T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = t6143.ID_EXPEDIENTE (+) AND T1.NUM_ANYO || '-' || DECODE(T1.ID_PROVINCIA_TTHH, '1', 'VI', '01', 'VI', '20', 'SS', '48', 'BI', '') || '-' || LPAD(T1.NUM_RECLAMACION, 5, '0') = t6150.NUM_DENUNCIA(+) "
				+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
				+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
				+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
				+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ";
		List<Denuncia> ab7801s00List = this.jdbcTemplate.query(query, this.rwMap,
				denuncia.getExpediente().getIdExpediente());
		return DataAccessUtils.uniqueResult(ab7801s00List);
	}

	@Override
	public void remove(Denuncia denuncia) {
		String query = "DELETE FROM AB7801S00 WHERE ID_RECLAMACION=?";
		this.jdbcTemplate.update(query, denuncia.getIdReclamacion());
	}

	public List<Denuncia> getMultiple(Denuncia filterAb7801s00, TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterAb7801s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, Denuncia.class, params,
				"ID_RECLAMACION");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public List<Denuncia> findAll(Denuncia denuncia, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_RECLAMACION IDRECLAMACION, EXP.ID_EXPEDIENTE IDEXPEDIENTE, t1.id_exp_rel idexprel, EXP.FOLDER_ID FOLDERID, EXP.FOLDER_NUMBER FOLDERNUMBER, "
						+ " EXP.TITULO TITULOEXP, T1.ID_DIRECCION IDDIRECCION, T1.NUM_ANYO NUMANYO, T1.NUM_RECLAMACION NUMRECLAMACION, T1.ID_PROVINCIA_TTHH IDPROVINCIATTHH, "
						+ " T1.IND_CONOCE_ESTABLECIMIENTO INDCONOCEESTABLECIMIENTO, T1.OBSERVACIONES_NO_CENSADO OBSERVACIONESNOCENSADO, TAPER.FH FECHAPRESENTACION, T1.TIPO_INFRACCION TIPOINFRACCION, "
						+ " T1.NUM_PAGINA_REC NUMPAGINAREC, T1.DESC_MOTIVOS_ES DESCMOTIVOSES, T1.DESC_MOTIVOS_EU DESCMOTIVOSEU, T1.ASUNTO_HECHOS ASUNTOHECHOS, T1.FECHA_HECHOS FECHAHECHOS, "
						+ " T1.DESC_HECHOS_ES DESCHECHOSES, T1.DESC_HECHOS_EU DESCHECHOSEU, T1.IND_TIPO_RECLAMACION INDTIPORECLAMACION, T1.TIPO_COMERCIO TIPOCOMERCIO, "
						+ " T1.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO, T1.TELEFONO_DENUNCIADO TELEFONODENUNCIADO, T1.IND_ILEGAL INDILEGAL, "
						+ " T1.DEVOLUCION DEVOLUCION, T1.IMPORTE_DEVOLUCION IMPORTEDEVOLUCION, T1.INDEMNIZACION INDEMNIZACION, T1.IMPORTE_INDEMNIZACION IMPORTEINDEMNIZACION, "
						+ " T1.DESC_PRETENSIONES_ES DESCPRETENSIONESES, T1.DESC_PRETENSIONES_EU DESCPRETENSIONESEU, T1.FECHA_REG_ENTRADA FECHAREGENTRADA, T1.NUM_REG_ENTRADA NUMREGENTRADA, "
						+ " T1.FECHA_REG_SALIDA FECHAREGSALIDA, T1.NUM_REG_SALIDA NUMREGSALIDA, T1.ORGANISMOS ORGANISMOS, T1.FECHA_DECISION FECHADECISION, "
						+ " T1.FUNDAMENTO_DENUNCIA_SOLICITUD FUNDAMENTODENUNCIASOLICITUD, T1.ARTICULO_INFRIGIDO_ES ARTICULOINFRIGIDOES, T1.ARTICULO_INFRIGIDO_EU ARTICULOINFRIGIDOEU, "
						+ " T1.NORMA_INFRIGIDA_ES NORMAINFRIGIDAES, T1.NORMA_INFRIGIDA_EU NORMAINFRIGIDAEU, T1.OBSERVACIONES_DECISION_ES OBSERVACIONESDECISIONES, "
						+ " T1.OBSERVACIONES_DECISION_EU OBSERVACIONESDECISIONEU, T1.IND_ELIMINADO INDELIMINADO, t1.TFNO_DENUNCIANTE_NF TFNODENUNCIANTENF, T1.FECHA_REGISTRO FECHAREGISTRO, "
						+ " T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
						+ " T2.ID_TIPO_RECLAMACION AB7805S00IDTIPORECLAMACION, T2.DESC_TIPO_ES AB7805S00DESCTIPOES, T2.DESC_TIPO_EU AB7805S00DESCTIPOEU, T2.BAJA AB7805S00BAJA,"
						+ " T2.FECHA_REGISTRO AB7805S00FECHAREGISTRO, T2.USUARIO_REGISTRO AB7805S00USUARIOREGISTRO, T2.FECHA_ULTMODIFICACION AB7805S00FECHAULTMODIFICACION, "
						+ " T2.USUARIO_ULTMODIFICACION AB7805S00USUARIOULTMODIF, T3.ID_DECISION AB7802S00IDDECISION, T3.DESC_TIPO_ES AB7802S00DESCTIPOES, T3.DESC_TIPO_EU AB7802S00DESCTIPOEU, "
						+ " T3.BAJA AB7802S00BAJA, T3.FECHA_REGISTRO AB7802S00FECHAREGISTRO, T3.USUARIO_REGISTRO AB7802S00USUARIOREGISTRO, T3.FECHA_ULTMODIFICACION AB7802S00FECHAULTMODIFICACION, "
						+ " T3.USUARIO_ULTMODIFICACION AB7802S00USUARIOULTMODIF, T4.ID_PRODUCTO AB7803S00IDPRODUCTO, T4.DESC_TIPO_ES AB7803S00DESCTIPOES, T4.DESC_TIPO_EU AB7803S00DESCTIPOEU, "
						+ " T4.BAJA AB7803S00BAJA, T4.FECHA_REGISTRO AB7803S00FECHAREGISTRO, T4.USUARIO_REGISTRO AB7803S00USUARIOREGISTRO, T4.FECHA_ULTMODIFICACION AB7803S00FECHAULTMODIFICACION, "
						+ " T4.USUARIO_ULTMODIFICACION AB7803S00USUARIOULTMODIF, T5.ID_TIPO_VENTA AB7804S00IDTIPOVENTA, T5.DESC_TIPO_ES AB7804S00DESCTIPOES, T5.DESC_TIPO_EU AB7804S00DESCTIPOEU, "
						+ " T5.BAJA AB7804S00BAJA, T5.FECHA_REGISTRO AB7804S00FECHAREGISTRO, T5.USUARIO_REGISTRO AB7804S00USUARIOREGISTRO, T5.FECHA_ULTMODIFICACION AB7804S00FECHAULTMODIFICACION, "
						+ " T5.USUARIO_ULTMODIFICACION AB7804S00USUARIOULTMODIF, INSP.ID_INSPECCION, INSP.IDENTIFICADOR_INSPECCION, R_EXP_DIR.ID_DIRECCION IDDIRECCIONDENUNCIADO, "
						+ " DIR.ID_TIPO_DIRECCION IDTIPODIRECCIONDENUNCIADO, DIR.DIRECCION DIRECCIONDENUNCIADO, DIR.NUMERO NUMERODENUNCIADO, DIR.ESCALERA ESCALERADENUNCIADO, "
						+ " DIR.PISO PISODENUNCIADO, DIR.LETRA LETRADENUNCIADO, DIR.ID_PAIS IDPAIS, DIR.DESCRIPCION_PROVINCIA DESCPROVINCIAEXTRANJERA, DIR.DESCRIPCION_CIUDAD DESCCIUDADEXTRANJERA, "
						+ " DIR.CODIGO_POSTAL CODIGOPOSTALDENUNCIADO, DIR.ID_PROVINCIA IDPROVINCIADENUNCIADO, DIR.ID_MUNICIPIO IDMUNICIPIODENUNCIADO, DIR.ID_LOCALIDAD IDLOCALIDADDENUNCIADO, "
						+ " DIR.ESTABLECIMIENTO ESTABLECIMIENTO, DIR.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, DIR.ESTABLECIMIENTO NOMBRECOMERCIAL ");

		query.append(
				" FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, AB78.EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
						+ " AB78.INSPECCIONES_EXPEDIENTE INSP, AB78.DATOS_DIRECCIONES DIR, AB78.PROVINCIAS P, AB78.MUNICIPIOS M, AB78.LOCALIDADES L, "
						+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
						+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(denuncia);
		StringBuilder where = new StringBuilder(
				" WHERE T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = INSP.ID_EXPEDIENTE (+) "
						+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
						+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
						+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
						+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, DenunciasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public List<Denuncia> findAllLike(Denuncia denuncia, TableRequestDto tableRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT T1.ID_RECLAMACION IDRECLAMACION, EXP.ID_EXPEDIENTE IDEXPEDIENTE, t1.id_exp_rel idexprel, EXP.FOLDER_ID FOLDERID, EXP.FOLDER_NUMBER FOLDERNUMBER, "
						+ " EXP.TITULO TITULOEXP, T1.ID_DIRECCION IDDIRECCION, T1.NUM_ANYO NUMANYO, T1.NUM_RECLAMACION NUMRECLAMACION, T1.ID_PROVINCIA_TTHH IDPROVINCIATTHH, "
						+ " T1.IND_CONOCE_ESTABLECIMIENTO INDCONOCEESTABLECIMIENTO, T1.OBSERVACIONES_NO_CENSADO OBSERVACIONESNOCENSADO, TAPER.FH FECHAPRESENTACION, T1.TIPO_INFRACCION TIPOINFRACCION, "
						+ " T1.NUM_PAGINA_REC NUMPAGINAREC, T1.DESC_MOTIVOS_ES DESCMOTIVOSES, T1.DESC_MOTIVOS_EU DESCMOTIVOSEU, T1.ASUNTO_HECHOS ASUNTOHECHOS, T1.FECHA_HECHOS FECHAHECHOS, "
						+ " T1.DESC_HECHOS_ES DESCHECHOSES, T1.DESC_HECHOS_EU DESCHECHOSEU, T1.IND_TIPO_RECLAMACION INDTIPORECLAMACION, T1.TIPO_COMERCIO TIPOCOMERCIO, "
						+ " T1.ID_TIPO_ESTABLECIMIENTO IDTIPOESTABLECIMIENTO, T1.TELEFONO_DENUNCIADO TELEFONODENUNCIADO, T1.IND_ILEGAL INDILEGAL, "
						+ " T1.DEVOLUCION DEVOLUCION, T1.IMPORTE_DEVOLUCION IMPORTEDEVOLUCION, T1.INDEMNIZACION INDEMNIZACION, T1.IMPORTE_INDEMNIZACION IMPORTEINDEMNIZACION, "
						+ " T1.DESC_PRETENSIONES_ES DESCPRETENSIONESES, T1.DESC_PRETENSIONES_EU DESCPRETENSIONESEU, T1.FECHA_REG_ENTRADA FECHAREGENTRADA, T1.NUM_REG_ENTRADA NUMREGENTRADA, "
						+ " T1.FECHA_REG_SALIDA FECHAREGSALIDA, T1.NUM_REG_SALIDA NUMREGSALIDA, T1.ORGANISMOS ORGANISMOS, T1.FECHA_DECISION FECHADECISION, "
						+ " T1.FUNDAMENTO_DENUNCIA_SOLICITUD FUNDAMENTODENUNCIASOLICITUD, T1.ARTICULO_INFRIGIDO_ES ARTICULOINFRIGIDOES, T1.ARTICULO_INFRIGIDO_EU ARTICULOINFRIGIDOEU, "
						+ " T1.NORMA_INFRIGIDA_ES NORMAINFRIGIDAES, T1.NORMA_INFRIGIDA_EU NORMAINFRIGIDAEU, T1.OBSERVACIONES_DECISION_ES OBSERVACIONESDECISIONES, "
						+ " T1.OBSERVACIONES_DECISION_EU OBSERVACIONESDECISIONEU, T1.IND_ELIMINADO INDELIMINADO, t1.TFNO_DENUNCIANTE_NF TFNODENUNCIANTENF, T1.FECHA_REGISTRO FECHAREGISTRO, "
						+ " T1.USUARIO_REGISTRO USUARIOREGISTRO, T1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, T1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, "
						+ " T2.ID_TIPO_RECLAMACION AB7805S00IDTIPORECLAMACION, T2.DESC_TIPO_ES AB7805S00DESCTIPOES, T2.DESC_TIPO_EU AB7805S00DESCTIPOEU, T2.BAJA AB7805S00BAJA,"
						+ "  T2.FECHA_REGISTRO AB7805S00FECHAREGISTRO, T2.USUARIO_REGISTRO AB7805S00USUARIOREGISTRO, T2.FECHA_ULTMODIFICACION AB7805S00FECHAULTMODIFICACION, "
						+ " T2.USUARIO_ULTMODIFICACION AB7805S00USUARIOULTMODIF, T3.ID_DECISION AB7802S00IDDECISION, T3.DESC_TIPO_ES AB7802S00DESCTIPOES, T3.DESC_TIPO_EU AB7802S00DESCTIPOEU, "
						+ " T3.BAJA AB7802S00BAJA, T3.FECHA_REGISTRO AB7802S00FECHAREGISTRO, T3.USUARIO_REGISTRO AB7802S00USUARIOREGISTRO, T3.FECHA_ULTMODIFICACION AB7802S00FECHAULTMODIFICACION, "
						+ " T3.USUARIO_ULTMODIFICACION AB7802S00USUARIOULTMODIF, T4.ID_PRODUCTO AB7803S00IDPRODUCTO, T4.DESC_TIPO_ES AB7803S00DESCTIPOES, T4.DESC_TIPO_EU AB7803S00DESCTIPOEU, "
						+ " T4.BAJA AB7803S00BAJA, T4.FECHA_REGISTRO AB7803S00FECHAREGISTRO, T4.USUARIO_REGISTRO AB7803S00USUARIOREGISTRO, T4.FECHA_ULTMODIFICACION AB7803S00FECHAULTMODIFICACION, "
						+ " T4.USUARIO_ULTMODIFICACION AB7803S00USUARIOULTMODIF, T5.ID_TIPO_VENTA AB7804S00IDTIPOVENTA, T5.DESC_TIPO_ES AB7804S00DESCTIPOES, T5.DESC_TIPO_EU AB7804S00DESCTIPOEU, "
						+ " T5.BAJA AB7804S00BAJA, T5.FECHA_REGISTRO AB7804S00FECHAREGISTRO, T5.USUARIO_REGISTRO AB7804S00USUARIOREGISTRO, T5.FECHA_ULTMODIFICACION AB7804S00FECHAULTMODIFICACION, "
						+ " T5.USUARIO_ULTMODIFICACION AB7804S00USUARIOULTMODIF, INSP.ID_INSPECCION, INSP.IDENTIFICADOR_INSPECCION, R_EXP_DIR.ID_DIRECCION IDDIRECCIONDENUNCIADO, "
						+ " DIR.ID_TIPO_DIRECCION IDTIPODIRECCIONDENUNCIADO, DIR.DIRECCION DIRECCIONDENUNCIADO, DIR.NUMERO NUMERODENUNCIADO, DIR.ESCALERA ESCALERADENUNCIADO, "
						+ " DIR.PISO PISODENUNCIADO, DIR.LETRA LETRADENUNCIADO, DIR.ID_PAIS IDPAIS, DIR.DESCRIPCION_PROVINCIA DESCPROVINCIAEXTRANJERA, DIR.DESCRIPCION_CIUDAD DESCCIUDADEXTRANJERA, "
						+ " DIR.CODIGO_POSTAL CODIGOPOSTALDENUNCIADO, DIR.ID_PROVINCIA IDPROVINCIADENUNCIADO, DIR.ID_MUNICIPIO IDMUNICIPIODENUNCIADO, DIR.ID_LOCALIDAD IDLOCALIDADDENUNCIADO, "
						+ " DIR.ESTABLECIMIENTO ESTABLECIMIENTO, DIR.IDENTIFICADOR_ESTABLECIMIENTO IDENTIFICADORESTABLECIMIENTO, DIR.ESTABLECIMIENTO NOMBRECOMERCIAL ");

		query.append(
				" FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, AB78.EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
						+ " AB78.INSPECCIONES_EXPEDIENTE INSP, AB78.DATOS_DIRECCIONES DIR, AB78.PROVINCIAS P, AB78.MUNICIPIOS M, AB78.LOCALIDADES L, "
						+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
						+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(denuncia, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = INSP.ID_EXPEDIENTE (+) "
						+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
						+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
						+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
						+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query, DenunciasDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllCount(Denuncia denuncia) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, AB78.EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
						+ " AB78.INSPECCIONES_EXPEDIENTE INSP, AB78.DATOS_DIRECCIONES DIR, AB78.PROVINCIAS P, AB78.MUNICIPIOS M, AB78.LOCALIDADES L, "
						+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
						+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(denuncia);
		StringBuilder where = new StringBuilder(
				" WHERE T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = INSP.ID_EXPEDIENTE (+) "
						+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
						+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
						+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
						+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	@Override
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Denuncia denuncia, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB7801S00 T1, AB7805S00 T2, AB7802S00 T3, AB7803S00 T4, AB7804S00 T5, AB78.EXPEDIENTES EXP, REL_EXP_DIR R_EXP_DIR, "
						+ " AB78.INSPECCIONES_EXPEDIENTE INSP, AB78.DATOS_DIRECCIONES DIR, AB78.PROVINCIAS P, AB78.MUNICIPIOS M, AB78.LOCALIDADES L, "
						+ " (SELECT ID_EXPEDIENTE, MAX(FECHA_EXPEDIENTE) FH FROM REL_EXP_FECH T42, FECHAS_EXPEDIENTE T44 WHERE T42.ID_FECHA_EXPEDIENTE=T44.ID_FECHA_EXPEDIENTE "
						+ " AND ETIQUETA_FECHA='FECHA_APERTURA' GROUP BY ID_EXPEDIENTE) TAPER ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(denuncia, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE T1.ID_EXPEDIENTE = EXP.ID_EXPEDIENTE AND T1.ID_EXPEDIENTE = INSP.ID_EXPEDIENTE (+) "
						+ " AND T1.ID_TIPO_RECLAMACION = T2.ID_TIPO_RECLAMACION (+) AND T1.ID_DECISION = T3.ID_DECISION (+) AND T1.ID_PRODUCTO = T4.ID_PRODUCTO (+) AND T1.ID_TIPO_VENTA = T5.ID_TIPO_VENTA (+) "
						+ " AND EXP.ID_EXPEDIENTE = R_EXP_DIR.ID_EXPEDIENTE(+) AND DIR.ID_DIRECCION (+) = R_EXP_DIR.ID_DIRECCION AND DIR.ID_PROVINCIA = P.ID (+) "
						+ " AND ( DIR.ID_PROVINCIA = M.PROVINCIA_ID (+) AND DIR.ID_MUNICIPIO = M.ID (+) ) AND ( DIR.ID_PROVINCIA = L.PROVINCIA_ID (+) "
						+ " AND DIR.ID_MUNICIPIO = L.MUNICIPIO_ID (+) AND DIR.ID_LOCALIDAD = L.ID (+) ) AND T1.ID_EXPEDIENTE = TAPER.ID_EXPEDIENTE (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), Long.class, params.toArray());
	}

	private Map<String, ?> getWhereMap(Denuncia denuncia) {

		StringBuilder where = new StringBuilder(DenunciasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (denuncia != null && denuncia.getIdReclamacion() != null) {
			where.append(" AND t1.ID_RECLAMACION = ?");
			params.add(denuncia.getIdReclamacion());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getIdTipoReclamacion() != null) {
			where.append(" AND t2.ID_TIPO_RECLAMACION = ?");
			params.add(denuncia.getTipoReclamacion().getIdTipoReclamacion());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getDescTipoEs() != null) {
			where.append(" AND t2.DESC_TIPO_ES = ?");
			params.add(denuncia.getTipoReclamacion().getDescTipoEs());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getDescTipoEu() != null) {
			where.append(" AND t2.DESC_TIPO_EU = ?");
			params.add(denuncia.getTipoReclamacion().getDescTipoEu());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getBaja() != null) {
			where.append(" AND t2.BAJA = ?");
			params.add(denuncia.getTipoReclamacion().getBaja());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getIdDecision() != null) {
			where.append(" AND t3.ID_DECISION = ?");
			params.add(denuncia.getDecision().getIdDecision());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getDescTipoEs() != null) {
			where.append(" AND t3.DESC_TIPO_ES = ?");
			params.add(denuncia.getDecision().getDescTipoEs());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getDescTipoEu() != null) {
			where.append(" AND t3.DESC_TIPO_EU = ?");
			params.add(denuncia.getDecision().getDescTipoEu());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getBaja() != null) {
			where.append(" AND t3.BAJA = ?");
			params.add(denuncia.getDecision().getBaja());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getIdProducto() != null) {
			where.append(" AND t4.ID_PRODUCTO = ?");
			params.add(denuncia.getProducto().getIdProducto());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getDescTipoEs() != null) {
			where.append(" AND t4.DESC_TIPO_ES = ?");
			params.add(denuncia.getProducto().getDescTipoEs());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getDescTipoEu() != null) {
			where.append(" AND t4.DESC_TIPO_EU = ?");
			params.add(denuncia.getProducto().getDescTipoEu());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getBaja() != null) {
			where.append(" AND t4.BAJA = ?");
			params.add(denuncia.getProducto().getBaja());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getIdTipoVenta() != null) {
			where.append(" AND t5.ID_TIPO_VENTA = ?");
			params.add(denuncia.getTipoVenta().getIdTipoVenta());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getDescTipoEs() != null) {
			where.append(" AND t5.DESC_TIPO_ES = ?");
			params.add(denuncia.getTipoVenta().getDescTipoEs());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getDescTipoEu() != null) {
			where.append(" AND t5.DESC_TIPO_EU = ?");
			params.add(denuncia.getTipoVenta().getDescTipoEu());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getBaja() != null) {
			where.append(" AND t5.BAJA = ?");
			params.add(denuncia.getTipoVenta().getBaja());
		}
		if (denuncia != null && denuncia.getExpediente() != null
				&& denuncia.getExpediente().getIdExpediente() != null) {
			where.append(" AND t1.ID_EXPEDIENTE = ?");
			params.add(denuncia.getExpediente().getIdExpediente());
		}
		if (denuncia != null && denuncia.getIdDireccion() != null) {
			where.append(" AND t1.ID_DIRECCION = ?");
			params.add(denuncia.getIdDireccion());
		}
		if (denuncia != null && denuncia.getNumAnyo() != null) {
			where.append(" AND t1.NUM_ANYO = ?");
			params.add(denuncia.getNumAnyo());
		}
		if (denuncia != null && denuncia.getNumReclamacion() != null) {
			where.append(" AND t1.NUM_RECLAMACION = ?");
			params.add(denuncia.getNumReclamacion());
		}
		if (denuncia != null && denuncia.getIdProvinciaTthh() != null) {
			where.append(" AND t1.ID_PROVINCIA_TTHH = ?");
			params.add(denuncia.getIdProvinciaTthh());
		}
		if (denuncia != null && denuncia.getIndConoceEstablecimiento() != null) {
			where.append(" AND t1.IND_CONOCE_ESTABLECIMIENTO = ?");
			params.add(denuncia.getIndConoceEstablecimiento());
		}
		if (denuncia != null && denuncia.getObservacionesNoCensado() != null) {
			where.append(" AND t1.OBSERVACIONES_NO_CENSADO = ?");
			params.add(denuncia.getObservacionesNoCensado());
		}
		if (denuncia != null && denuncia.getTipoInfraccion() != null) {
			where.append(" AND t1.TIPO_INFRACCION = ?");
			params.add(denuncia.getTipoInfraccion());
		}
		if (denuncia != null && denuncia.getNumPaginaRec() != null) {
			where.append(" AND t1.NUM_PAGINA_REC = ?");
			params.add(denuncia.getNumPaginaRec());
		}
		if (denuncia != null && denuncia.getDescMotivosEs() != null) {
			where.append(" AND t1.DESC_MOTIVOS_ES = ?");
			params.add(denuncia.getDescMotivosEs());
		}
		if (denuncia != null && denuncia.getDescMotivosEu() != null) {
			where.append(" AND t1.DESC_MOTIVOS_EU = ?");
			params.add(denuncia.getDescMotivosEu());
		}
		if (denuncia != null && denuncia.getAsuntoHechos() != null) {
			where.append(" AND t1.ASUNTO_HECHOS = ?");
			params.add(denuncia.getAsuntoHechos());
		}
		if (denuncia != null && denuncia.getFechaHechos() != null) {
			where.append(" AND t1.FECHA_HECHOS = ?");
			params.add(denuncia.getFechaHechos());
		}
		if (denuncia != null && denuncia.getDescHechosEs() != null) {
			where.append(" AND t1.DESC_HECHOS_ES = ?");
			params.add(denuncia.getDescHechosEs());
		}
		if (denuncia != null && denuncia.getDescHechosEu() != null) {
			where.append(" AND t1.DESC_HECHOS_EU = ?");
			params.add(denuncia.getDescHechosEu());
		}
		if (denuncia != null && denuncia.getIndTipoReclamacion() != null) {
			where.append(" AND t1.IND_TIPO_RECLAMACION = ?");
			params.add(denuncia.getIndTipoReclamacion());
		}
		if (denuncia != null && denuncia.getTipoComercio() != null) {
			where.append(" AND t1.TIPO_COMERCIO = ?");
			params.add(denuncia.getTipoComercio());
		}
		if (denuncia != null && denuncia.getIdTipoEstablecimiento() != null) {
			where.append(" AND t1.ID_TIPO_ESTABLECIMIENTO = ?");
			params.add(denuncia.getIdTipoEstablecimiento());
		}
		if (denuncia != null && denuncia.getTelefonoDenunciado() != null) {
			where.append(" AND t1.TELEFONO_DENUNCIA = ?");
			params.add(denuncia.getTelefonoDenunciado());
		}
		if (denuncia != null && denuncia.getIndIlegal() != null) {
			where.append(" AND t1.IND_ILEGAL = ?");
			params.add(denuncia.getIndIlegal());
		}
		if (denuncia != null && denuncia.getDevolucion() != null) {
			where.append(" AND t1.DEVOLUCION = ?");
			params.add(denuncia.getDevolucion());
		}
		if (denuncia != null && denuncia.getImporteDevolucion() != null) {
			where.append(" AND t1.IMPORTE_DEVOLUCION = ?");
			params.add(denuncia.getImporteDevolucion());
		}
		if (denuncia != null && denuncia.getIndemnizacion() != null) {
			where.append(" AND t1.INDEMNIZACION = ?");
			params.add(denuncia.getIndemnizacion());
		}
		if (denuncia != null && denuncia.getImporteIndemnizacion() != null) {
			where.append(" AND t1.IMPORTE_INDEMNIZACION = ?");
			params.add(denuncia.getImporteIndemnizacion());
		}
		if (denuncia != null && denuncia.getDescPretensionesEs() != null) {
			where.append(" AND t1.DESC_PRETENSIONES_ES = ?");
			params.add(denuncia.getDescPretensionesEs());
		}
		if (denuncia != null && denuncia.getDescPretensionesEu() != null) {
			where.append(" AND t1.DESC_PRETENSIONES_EU = ?");
			params.add(denuncia.getDescPretensionesEu());
		}
		if (denuncia != null && denuncia.getFechaRegEntrada() != null) {
			where.append(" AND t1.FECHA_REG_ENTRADA = ?");
			params.add(denuncia.getFechaRegEntrada());
		}
		if (denuncia != null && denuncia.getNumRegEntrada() != null) {
			where.append(" AND t1.NUM_REG_ENTRADA = ?");
			params.add(denuncia.getNumRegEntrada());
		}
		if (denuncia != null && denuncia.getFechaRegSalida() != null) {
			where.append(" AND t1.FECHA_REG_SALIDA = ?");
			params.add(denuncia.getFechaRegSalida());
		}
		if (denuncia != null && denuncia.getNumRegSalida() != null) {
			where.append(" AND t1.NUM_REG_SALIDA = ?");
			params.add(denuncia.getNumRegSalida());
		}
		if (denuncia != null && denuncia.getOrganismos() != null) {
			where.append(" AND t1.ORGANISMOS = ?");
			params.add(denuncia.getOrganismos());
		}
		if (denuncia != null && denuncia.getFechaDecision() != null) {
			where.append(" AND t1.FECHA_DECISION = ?");
			params.add(denuncia.getFechaDecision());
		}
		if (denuncia != null && denuncia.getFundamentoDenunciaSolicitud() != null) {
			where.append(" AND t1.FUNDAMENTO_DENUNCIA_SOLICITUD = ?");
			params.add(denuncia.getFundamentoDenunciaSolicitud());
		}
		if (denuncia != null && denuncia.getArticuloInfrigidoEs() != null) {
			where.append(" AND t1.ARTICULO_INFRIGIDO_ES = ?");
			params.add(denuncia.getArticuloInfrigidoEs());
		}
		if (denuncia != null && denuncia.getArticuloInfrigidoEu() != null) {
			where.append(" AND t1.ARTICULO_INFRIGIDO_EU = ?");
			params.add(denuncia.getArticuloInfrigidoEu());
		}
		if (denuncia != null && denuncia.getNormaInfrigidaEs() != null) {
			where.append(" AND t1.NORMA_INFRIGIDA_ES = ?");
			params.add(denuncia.getNormaInfrigidaEs());
		}
		if (denuncia != null && denuncia.getNormaInfrigidaEu() != null) {
			where.append(" AND t1.NORMA_INFRIGIDA_EU = ?");
			params.add(denuncia.getNormaInfrigidaEu());
		}
		if (denuncia != null && denuncia.getObservacionesDecisionEs() != null) {
			where.append(" AND t1.OBSERVACIONES_DECISION_ES = ?");
			params.add(denuncia.getObservacionesDecisionEs());
		}
		if (denuncia != null && denuncia.getObservacionesDecisionEu() != null) {
			where.append(" AND t1.OBSERVACIONES_DECISION_EU = ?");
			params.add(denuncia.getObservacionesDecisionEu());
		}
		if (denuncia != null && denuncia.getIndEliminado() != null) {
			where.append(" AND t1.IND_ELIMINADO = ?");
			params.add(denuncia.getIndEliminado());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMap(Denuncia denuncia, Boolean startsWith) {

		StringBuilder where = new StringBuilder(DenunciasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (denuncia != null && denuncia.getIdReclamacion() != null) {
			where.append(" AND t1.ID_RECLAMACION = ?");
			params.add(denuncia.getIdReclamacion());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getIdTipoReclamacion() != null) {
			where.append(" AND t2.ID_TIPO_RECLAMACION = ?");
			params.add(denuncia.getTipoReclamacion().getIdTipoReclamacion());
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getDescTipoEs() != null) {
			where.append(" AND UPPER(t2.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTipoReclamacion().getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTipoReclamacion().getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t2.DESC_TIPO_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getDescTipoEu() != null) {
			where.append(" AND UPPER(t2.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTipoReclamacion().getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTipoReclamacion().getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t2.DESC_TIPO_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTipoReclamacion() != null
				&& denuncia.getTipoReclamacion().getBaja() != null) {
			where.append(" AND t2.BAJA = ?");
			params.add(denuncia.getTipoReclamacion().getBaja());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getIdDecision() != null) {
			where.append(" AND t3.ID_DECISION = ?");
			params.add(denuncia.getDecision().getIdDecision());
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getDescTipoEs() != null) {
			where.append(" AND UPPER(t3.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDecision().getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDecision().getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t3.DESC_TIPO_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getDescTipoEu() != null) {
			where.append(" AND UPPER(t3.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDecision().getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDecision().getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t3.DESC_TIPO_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDecision() != null && denuncia.getDecision().getBaja() != null) {
			where.append(" AND t3.BAJA = ?");
			params.add(denuncia.getDecision().getBaja());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getIdProducto() != null) {
			where.append(" AND t4.ID_PRODUCTO = ?");
			params.add(denuncia.getProducto().getIdProducto());
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getDescTipoEs() != null) {
			where.append(" AND UPPER(t4.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getProducto().getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getProducto().getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t4.DESC_TIPO_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getDescTipoEu() != null) {
			where.append(" AND UPPER(t4.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getProducto().getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getProducto().getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t4.DESC_TIPO_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getProducto() != null && denuncia.getProducto().getBaja() != null) {
			where.append(" AND t4.BAJA = ?");
			params.add(denuncia.getProducto().getBaja());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getIdTipoVenta() != null) {
			where.append(" AND t5.ID_TIPO_VENTA = ?");
			params.add(denuncia.getTipoVenta().getIdTipoVenta());
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getDescTipoEs() != null) {
			where.append(" AND UPPER(t5.DESC_TIPO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTipoVenta().getDescTipoEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTipoVenta().getDescTipoEs().toUpperCase() + "%");
			}
			where.append(" AND t5.DESC_TIPO_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getDescTipoEu() != null) {
			where.append(" AND UPPER(t5.DESC_TIPO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTipoVenta().getDescTipoEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTipoVenta().getDescTipoEu().toUpperCase() + "%");
			}
			where.append(" AND t5.DESC_TIPO_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTipoVenta() != null && denuncia.getTipoVenta().getBaja() != null) {
			where.append(" AND t5.BAJA = ?");
			params.add(denuncia.getTipoVenta().getBaja());
		}
		if (denuncia != null && denuncia.getExpediente() != null
				&& denuncia.getExpediente().getIdExpediente() != null) {
			where.append(" AND t1.ID_EXPEDIENTE = ?");
			params.add(denuncia.getExpediente().getIdExpediente());
		}
		if (denuncia != null && denuncia.getIdDireccion() != null) {
			where.append(" AND t1.ID_DIRECCION = ?");
			params.add(denuncia.getIdDireccion());
		}
		if (denuncia != null && denuncia.getNumAnyo() != null) {
			where.append(" AND t1.NUM_ANYO = ?");
			params.add(denuncia.getNumAnyo());
		}
		if (denuncia != null && denuncia.getNumReclamacion() != null) {
			where.append(" AND t1.NUM_RECLAMACION = ?");
			params.add(denuncia.getNumReclamacion());
		}
		if (denuncia != null && denuncia.getIdProvinciaTthh() != null) {
			where.append(" AND UPPER(t1.ID_PROVINCIA_TTHH) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getIdProvinciaTthh().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getIdProvinciaTthh().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_PROVINCIA_TTHH IS NOT NULL");
		}
		if (denuncia != null && denuncia.getIndConoceEstablecimiento() != null) {
			where.append(" AND t1.IND_CONOCE_ESTABLECIMIENTO = ?");
			params.add(denuncia.getIndConoceEstablecimiento());
		}
		if (denuncia != null && denuncia.getObservacionesNoCensado() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES_NO_CENSADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getObservacionesNoCensado().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getObservacionesNoCensado().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES_NO_CENSADO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTipoInfraccion() != null) {
			where.append(" AND t1.TIPO_INFRACCION = ?");
			params.add(denuncia.getTipoInfraccion());
		}
		if (denuncia != null && denuncia.getNumPaginaRec() != null) {
			where.append(" AND UPPER(t1.NUM_PAGINA_REC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getNumPaginaRec().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getNumPaginaRec().toUpperCase() + "%");
			}
			where.append(" AND t1.NUM_PAGINA_REC IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDescMotivosEs() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVOS_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescMotivosEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescMotivosEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVOS_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDescMotivosEu() != null) {
			where.append(" AND UPPER(t1.DESC_MOTIVOS_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescMotivosEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescMotivosEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_MOTIVOS_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getAsuntoHechos() != null) {
			where.append(" AND UPPER(t1.ASUNTO_HECHOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getAsuntoHechos().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getAsuntoHechos().toUpperCase() + "%");
			}
			where.append(" AND t1.ASUNTO_HECHOS IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFechaHechos() != null) {
			where.append(" AND t1.FECHA_HECHOS = ?");
			params.add(denuncia.getFechaHechos());
		}
		if (denuncia != null && denuncia.getDescHechosEs() != null) {
			where.append(" AND UPPER(t1.DESC_HECHOS_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescHechosEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescHechosEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_HECHOS_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDescHechosEu() != null) {
			where.append(" AND UPPER(t1.DESC_HECHOS_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescHechosEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescHechosEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_HECHOS_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getIndTipoReclamacion() != null) {
			where.append(" AND t1.IND_TIPO_RECLAMACION = ?");
			params.add(denuncia.getIndTipoReclamacion());
		}
		if (denuncia != null && denuncia.getTipoComercio() != null) {
			where.append(" AND UPPER(t1.TIPO_COMERCIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTipoComercio().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTipoComercio().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPO_COMERCIO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getIdTipoEstablecimiento() != null) {
			where.append(" AND UPPER(t1.ID_TIPO_ESTABLECIMIENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getIdTipoEstablecimiento().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getIdTipoEstablecimiento().toUpperCase() + "%");
			}
			where.append(" AND t1.ID_TIPO_ESTABLECIMIENTO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getTelefonoDenunciado() != null) {
			where.append(" AND UPPER(t1.TELEFONO_DENUNCIADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getTelefonoDenunciado().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getTelefonoDenunciado().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO_DENUNCIADO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getIndIlegal() != null) {
			where.append(" AND t1.IND_ILEGAL = ?");
			params.add(denuncia.getIndIlegal());
		}
		if (denuncia != null && denuncia.getDevolucion() != null) {
			where.append(" AND t1.DEVOLUCION = ?");
			params.add(denuncia.getDevolucion());
		}
		if (denuncia != null && denuncia.getImporteDevolucion() != null) {
			where.append(" AND t1.IMPORTE_DEVOLUCION = ?");
			params.add(denuncia.getImporteDevolucion());
		}
		if (denuncia != null && denuncia.getIndemnizacion() != null) {
			where.append(" AND t1.INDEMNIZACION = ?");
			params.add(denuncia.getIndemnizacion());
		}
		if (denuncia != null && denuncia.getImporteIndemnizacion() != null) {
			where.append(" AND t1.IMPORTE_INDEMNIZACION = ?");
			params.add(denuncia.getImporteIndemnizacion());
		}
		if (denuncia != null && denuncia.getDescPretensionesEs() != null) {
			where.append(" AND UPPER(t1.DESC_PRETENSIONES_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescPretensionesEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescPretensionesEs().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_PRETENSIONES_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDescPretensionesEu() != null) {
			where.append(" AND UPPER(t1.DESC_PRETENSIONES_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDescPretensionesEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDescPretensionesEu().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_PRETENSIONES_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFechaRegEntrada() != null) {
			where.append(" AND t1.FECHA_REG_ENTRADA = ?");
			params.add(denuncia.getFechaRegEntrada());
		}
		if (denuncia != null && denuncia.getNumRegEntrada() != null) {
			where.append(" AND UPPER(t1.NUM_REG_ENTRADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getNumRegEntrada().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getNumRegEntrada().toUpperCase() + "%");
			}
			where.append(" AND t1.NUM_REG_ENTRADA IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFechaRegSalida() != null) {
			where.append(" AND t1.FECHA_REG_SALIDA = ?");
			params.add(denuncia.getFechaRegSalida());
		}
		if (denuncia != null && denuncia.getNumRegSalida() != null) {
			where.append(" AND UPPER(t1.NUM_REG_SALIDA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getNumRegSalida().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getNumRegSalida().toUpperCase() + "%");
			}
			where.append(" AND t1.NUM_REG_SALIDA IS NOT NULL");
		}
		if (denuncia != null && denuncia.getOrganismos() != null) {
			where.append(" AND UPPER(t1.ORGANISMOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getOrganismos().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getOrganismos().toUpperCase() + "%");
			}
			where.append(" AND t1.ORGANISMOS IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFechaDecision() != null) {
			where.append(" AND t1.FECHA_DECISION = ?");
			params.add(denuncia.getFechaDecision());
		}
		if (denuncia != null && denuncia.getFundamentoDenunciaSolicitud() != null) {
			where.append(" AND UPPER(t1.FUNDAMENTO_DENUNCIA_SOLICITUD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFundamentoDenunciaSolicitud().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getFundamentoDenunciaSolicitud().toUpperCase() + "%");
			}
			where.append(" AND t1.FUNDAMENTO_DENUNCIA_SOLICITUD IS NOT NULL");
		}
		if (denuncia != null && denuncia.getArticuloInfrigidoEs() != null) {
			where.append(" AND UPPER(t1.ARTICULO_INFRIGIDO_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getArticuloInfrigidoEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getArticuloInfrigidoEs().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTICULO_INFRIGIDO_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getArticuloInfrigidoEu() != null) {
			where.append(" AND UPPER(t1.ARTICULO_INFRIGIDO_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getArticuloInfrigidoEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getArticuloInfrigidoEu().toUpperCase() + "%");
			}
			where.append(" AND t1.ARTICULO_INFRIGIDO_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getNormaInfrigidaEs() != null) {
			where.append(" AND UPPER(t1.NORMA_INFRIGIDA_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getNormaInfrigidaEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getNormaInfrigidaEs().toUpperCase() + "%");
			}
			where.append(" AND t1.NORMA_INFRIGIDA_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getNormaInfrigidaEu() != null) {
			where.append(" AND UPPER(t1.NORMA_INFRIGIDA_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getNormaInfrigidaEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getNormaInfrigidaEu().toUpperCase() + "%");
			}
			where.append(" AND t1.NORMA_INFRIGIDA_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getObservacionesDecisionEs() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES_DECISION_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getObservacionesDecisionEs().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getObservacionesDecisionEs().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES_DECISION_ES IS NOT NULL");
		}
		if (denuncia != null && denuncia.getObservacionesDecisionEu() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES_DECISION_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getObservacionesDecisionEu().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getObservacionesDecisionEu().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES_DECISION_EU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getIndEliminado() != null) {
			where.append(" AND UPPER(t1.IND_ELIMINADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getIndEliminado().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getIndEliminado().toUpperCase() + "%");
			}
			where.append(" AND t1.IND_ELIMINADO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	public static final int STRING_BUILDER_INIT = 4096;
}
