package com.ejie.ab78.dao.denuncias;

import java.util.List;

import com.ejie.ab78.model.denuncias.Denuncia;
import com.ejie.x38.dto.TableRequestDto;

/**
 * DenunciasDao  
 * 
 *  
 */

public interface DenunciasDao {

	/**
	 * Inserts a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia add(Denuncia denuncia);

	/**
	 * Updates a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia update(Denuncia denuncia);

	/**
	 * Finds a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	Denuncia find(Denuncia denuncia);

	/**
	 * Removes a single row in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 */
	void remove(Denuncia denuncia);

	/**
	 * Finds a List of rows in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<Denuncia> findAll(Denuncia denuncia, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the Denuncia table using like.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Denuncia> findAllLike(Denuncia denuncia, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Denuncia table using like.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Denuncia denuncia, Boolean startsWith);

	/**
	 * Counts rows in the Denuncia table.
	 *
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	Long findAllCount(Denuncia denuncia);

	Denuncia findByIdExpediente(Denuncia denuncia);

}
