package com.ejie.ab78.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab78.comun.UtilUsuario;
import com.ejie.ab78.model.denuncias.RelacionMotivoDen;
import com.ejie.ab78.model.maestros.Motivo;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableManager;
import com.ejie.x38.dto.TableManagerJerarquia;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * RelacionMotivoDenDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class RelacionMotivoDenDaoImpl implements RelacionMotivoDenDao {

	public static final String[] ORDER_BY_WHITE_LIST = new String[] { "IDMOTIVOINTERNO", "IDRECLAMACION", "IDMOTIVO",
			"DESCRIPCIONMOTIVO", "FECHAREGISTRO", "USUARIOREGISTRO", "FECHAULTMODIFICACION", "USUARIOULTMODIFICACION",
			"DESCMOTIVOES", "DESCMOTIVOEU" };

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<RelacionMotivoDen> rwMap = new RowMapper<RelacionMotivoDen>() {
		public RelacionMotivoDen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Motivo motivo = new Motivo();
			motivo.setIdMotivo(resultSet.getLong("IDMOTIVO"));
			motivo.setDescMotivoEs(resultSet.getString("DESCMOTIVOES"));
			motivo.setDescMotivoEu(resultSet.getString("DESCMOTIVOEU"));
			return new RelacionMotivoDen(resultSet.getLong("IDMOTIVOINTERNO"), resultSet.getInt("IDRECLAMACION"),
					motivo, resultSet.getString("DESCRIPCIONMOTIVO"), resultSet.getDate("FECHAREGISTRO"),
					resultSet.getString("USUARIOREGISTRO"), resultSet.getDate("FECHAULTMODIFICACION"),
					resultSet.getString("USUARIOULTMODIFICACION"));
		}
	};

	private RowMapper<RelacionMotivoDen> rwMapPK = new RowMapper<RelacionMotivoDen>() {
		public RelacionMotivoDen mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new RelacionMotivoDen(resultSet.getLong("IDMOTIVOINTERNO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<RelacionMotivoDen>> rwMapJerarquia = new RowMapper<JerarquiaDto<RelacionMotivoDen>>() {
		public JerarquiaDto<RelacionMotivoDen> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Motivo motivo = new Motivo();
			motivo.setIdMotivo(resultSet.getLong("IDMOTIVO"));
			motivo.setDescMotivoEs(resultSet.getString("DESCMOTIVOES"));
			motivo.setDescMotivoEu(resultSet.getString("DESCMOTIVOEU"));
			RelacionMotivoDen relacionMotivoDen = new RelacionMotivoDen(resultSet.getLong("IDMOTIVOINTERNO"),
					resultSet.getInt("IDRECLAMACION"), motivo, resultSet.getString("DESCRIPCIONMOTIVO"),
					resultSet.getDate("FECHAREGISTRO"), resultSet.getString("USUARIOREGISTRO"),
					resultSet.getDate("FECHAULTMODIFICACION"), resultSet.getString("USUARIOULTMODIFICACION"));

			JerarquiaDto<RelacionMotivoDen> jerarquia = new JerarquiaDto<RelacionMotivoDen>();
			jerarquia.setModel(relacionMotivoDen);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 *
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public RelacionMotivoDen add(RelacionMotivoDen relacionMotivoDen) {
		String query = "INSERT INTO AB7813S00 (ID_MOTIVO_INTERNO, ID_RECLAMACION, ID_MOTIVO, DESCRIPCION_MOTIVO, FECHA_REGISTRO, USUARIO_REGISTRO) VALUES (AB7813Q00.NEXTVAL,?,?,?,SYSDATE,?)";
		this.jdbcTemplate.update(query, relacionMotivoDen.getIdReclamacion(),
				relacionMotivoDen.getMotivo().getIdMotivo(), relacionMotivoDen.getDescMotivo(),
				UtilUsuario.getUserConnected());
		return relacionMotivoDen;
	}

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	public RelacionMotivoDen update(RelacionMotivoDen relacionMotivoDen) {
		String query = "UPDATE AB7813S00 SET ID_RECLAMACION=?, ID_MOTIVO=?, DESCRIPCION_MOTIVO=?, FECHA_ULTMODIFICACION=SYSDATE, USUARIO_ULTMODIFICACION=? WHERE ID_MOTIVO_INTERNO=?";
		this.jdbcTemplate.update(query, relacionMotivoDen.getIdReclamacion(),
				relacionMotivoDen.getMotivo().getIdMotivo(), relacionMotivoDen.getDescMotivo(),
				UtilUsuario.getUserConnected(), relacionMotivoDen.getIdMotivoInterno());
		return relacionMotivoDen;
	}

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	@Transactional(readOnly = true)
	public RelacionMotivoDen find(RelacionMotivoDen relacionMotivoDen) {
		String query = "SELECT t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO, t1.ID_RECLAMACION IDRECLAMACION, t1.ID_MOTIVO IDMOTIVO, t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO, t1.FECHA_REGISTRO FECHAREGISTRO, t1.USUARIO_REGISTRO USUARIOREGISTRO, t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION, t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t2.DESC_MOTIVO_ES DESCMOTIVOES, t2.DESC_MOTIVO_EU DESCMOTIVOEU FROM AB7813S00 t1 LEFT JOIN AB7812S00 t2 ON t1.ID_MOTIVO = t2.ID_MOTIVO  WHERE t1.ID_MOTIVO_INTERNO = ?  ";

		List<RelacionMotivoDen> relacionMotivoDenList = this.jdbcTemplate.query(query, this.rwMap,
				relacionMotivoDen.getIdMotivoInterno());
		return (RelacionMotivoDen) DataAccessUtils.uniqueResult(relacionMotivoDenList);
	}

	/**
	 * Removes a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return
	 */
	public void remove(RelacionMotivoDen relacionMotivoDen) {
		String query = "DELETE FROM AB7813S00 WHERE ID_MOTIVO_INTERNO=?";
		this.jdbcTemplate.update(query, relacionMotivoDen.getIdMotivoInterno());
	}

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	public List<RelacionMotivoDen> getMultiple(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith) {

		// Where clause & Params
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterRelacionMotivoDen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbMultipleSQL = TableManager.getSelectMultipleQuery(tableRequestDto, RelacionMotivoDen.class,
				params, "ID_MOTIVO_INTERNO");

		return this.jdbcTemplate.query(sbMultipleSQL.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds a list of rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<RelacionMotivoDen>
	 */
	@Transactional(readOnly = true)
	public List<RelacionMotivoDen> findAll(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION , t2.DESC_MOTIVO_ES DESCMOTIVOES, t2.DESC_MOTIVO_EU DESCMOTIVOEU  ");
		query.append("FROM AB7813S00 t1 LEFT JOIN AB7812S00 t2 ON t1.ID_MOTIVO = t2.ID_MOTIVO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relacionMotivoDen);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					RelacionMotivoDenDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelacionMotivoDen>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<RelacionMotivoDen>
	 */
	@Transactional(readOnly = true)
	public List<RelacionMotivoDen> findAllLike(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION, t2.DESC_MOTIVO_ES DESCMOTIVOES, t2.DESC_MOTIVO_EU DESCMOTIVOEU ");
		query.append("FROM AB7813S00 t1 LEFT JOIN AB7812S00 t2 ON t1.ID_MOTIVO = t2.ID_MOTIVO ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relacionMotivoDen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (tableRequestDto != null) {
			query = TableManager.getPaginationQuery(tableRequestDto, query,
					RelacionMotivoDenDaoImpl.ORDER_BY_WHITE_LIST);
		}

		return (List<RelacionMotivoDen>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(RelacionMotivoDen relacionMotivoDen) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7813S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(relacionMotivoDen);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Counts rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(RelacionMotivoDen relacionMotivoDen, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB7813S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relacionMotivoDen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Reorder the data list of RelacionMotivoDen selected for rup_table
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<RelacionMotivoDen>> reorderSelection(RelacionMotivoDen relacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7813S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(relacionMotivoDen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = TableManager.getReorderQuery(query, tableRequestDto,
				RelacionMotivoDen.class, filterParamList, "IDMOTIVOINTERNO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RelacionMotivoDen>(this.rwMapPK, tableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 *
	 * @param filterParams
	 *            RelacionMotivoDen
	 * @param searchParams
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<RelacionMotivoDen>> search(RelacionMotivoDen filterParams, RelacionMotivoDen searchParams,
			TableRequestDto tableRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7813S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = TableManager.getSearchQuery(query, tableRequestDto,
				RelacionMotivoDen.class, filterParamList, searchSQL, searchParamList, from_alias, "IDMOTIVOINTERNO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<RelacionMotivoDen>(this.rwMapPK, tableRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 *
	 * @param filterrelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(RelacionMotivoDen filterrelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		query.append("FROM AB7813S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterrelacionMotivoDen, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = TableManager.getRemoveMultipleQuery(tableRequestDto,
				RelacionMotivoDen.class, query, params, "IDMOTIVOINTERNO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelacionMotivoDen>>
	 */
	@Override
	public List<JerarquiaDto<RelacionMotivoDen>> findAllLikeJerarquia(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ID_MOTIVO_INTERNO IDMOTIVOINTERNO,t1.ID_RECLAMACION IDRECLAMACION,t1.ID_MOTIVO IDMOTIVO,t1.DESCRIPCION_MOTIVO DESCRIPCIONMOTIVO,t1.FECHA_REGISTRO FECHAREGISTRO,t1.USUARIO_REGISTRO USUARIOREGISTRO,t1.FECHA_ULTMODIFICACION FECHAULTMODIFICACION,t1.USUARIO_ULTMODIFICACION USUARIOULTMODIFICACION ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7813S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7813S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelacionMotivoDen, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = TableManagerJerarquia.getQuery(tableRequestDto, query, mapaWhere, "IDMOTIVOINTERNO", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = TableManagerJerarquia.getQuery(tableRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (tableRequestDto != null) {
			query = TableManagerJerarquia.getPaginationQuery(tableRequestDto, query,
					RelacionMotivoDenDaoImpl.ORDER_BY_WHITE_LIST);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7813S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7813S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelacionMotivoDen, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "IDMOTIVOINTERNO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryCount(tableRequestDto, mapaWhere, "ID",
		// "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForObject(query.toString(), params.toArray(), Long.class);
	}

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	@Override
	public List<TableRowDto<RelacionMotivoDen>> findAllChild(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB7813S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB7813S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterRelacionMotivoDen, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere, "IDMOTIVOINTERNO",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// TableManagerJerarquia.getQueryChildren(tableRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<RelacionMotivoDen>(this.rwMapPK, "IDMOTIVOINTERNO"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelacionMotivoDen entity
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(RelacionMotivoDen relacionMotivoDen) {

		StringBuilder where = new StringBuilder(RelacionMotivoDenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relacionMotivoDen != null && relacionMotivoDen.getIdMotivoInterno() != null) {
			where.append(" AND t1.ID_MOTIVO_INTERNO = ?");
			params.add(relacionMotivoDen.getIdMotivoInterno());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getIdReclamacion() != null) {
			where.append(" AND t1.ID_RECLAMACION = ?");
			params.add(relacionMotivoDen.getIdReclamacion());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getMotivo() != null
				&& relacionMotivoDen.getMotivo().getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(relacionMotivoDen.getMotivo().getIdMotivo());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getDescMotivo() != null) {
			where.append(" AND t1.DESCRIPCION_MOTIVO = ?");
			params.add(relacionMotivoDen.getDescMotivo());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(relacionMotivoDen.getFechaRegistro());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getUsuarioRegistro() != null) {
			where.append(" AND t1.USUARIO_REGISTRO = ?");
			params.add(relacionMotivoDen.getUsuarioRegistro());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(relacionMotivoDen.getFechaUltmodificacion());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getUsuarioUltmodificacion() != null) {
			where.append(" AND t1.USUARIO_ULTMODIFICACION = ?");
			params.add(relacionMotivoDen.getUsuarioUltmodificacion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the RelacionMotivoDen entity
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(RelacionMotivoDen relacionMotivoDen, Boolean startsWith) {

		StringBuilder where = new StringBuilder(RelacionMotivoDenDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (relacionMotivoDen != null && relacionMotivoDen.getIdMotivoInterno() != null) {
			where.append(" AND t1.ID_MOTIVO_INTERNO = ?");
			params.add(relacionMotivoDen.getIdMotivoInterno());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getIdReclamacion() != null) {
			where.append(" AND t1.ID_RECLAMACION = ?");
			params.add(relacionMotivoDen.getIdReclamacion());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getMotivo() != null
				&& relacionMotivoDen.getMotivo().getIdMotivo() != null) {
			where.append(" AND t1.ID_MOTIVO = ?");
			params.add(relacionMotivoDen.getMotivo().getIdMotivo());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getDescMotivo() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_MOTIVO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relacionMotivoDen.getDescMotivo().toUpperCase() + "%");
			} else {
				params.add("%" + relacionMotivoDen.getDescMotivo().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_MOTIVO IS NOT NULL");
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getFechaRegistro() != null) {
			where.append(" AND t1.FECHA_REGISTRO = ?");
			params.add(relacionMotivoDen.getFechaRegistro());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getUsuarioRegistro() != null) {
			where.append(" AND UPPER(t1.USUARIO_REGISTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relacionMotivoDen.getUsuarioRegistro().toUpperCase() + "%");
			} else {
				params.add("%" + relacionMotivoDen.getUsuarioRegistro().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_REGISTRO IS NOT NULL");
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getFechaUltmodificacion() != null) {
			where.append(" AND t1.FECHA_ULTMODIFICACION = ?");
			params.add(relacionMotivoDen.getFechaUltmodificacion());
		}
		if (relacionMotivoDen != null && relacionMotivoDen.getUsuarioUltmodificacion() != null) {
			where.append(" AND UPPER(t1.USUARIO_ULTMODIFICACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(relacionMotivoDen.getUsuarioUltmodificacion().toUpperCase() + "%");
			} else {
				params.add("%" + relacionMotivoDen.getUsuarioUltmodificacion().toUpperCase() + "%");
			}
			where.append(" AND t1.USUARIO_ULTMODIFICACION IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
