package com.ejie.ab78.dao;

import com.ejie.ab78.model.denuncias.RelacionMotivoDen;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

/**
 * RelacionMotivoDenDao  
 * 
 *  
 */

public interface RelacionMotivoDenDao {

	/**
	 * Inserts a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen add(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Updates a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen update(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Finds a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return RelacionMotivoDen
	 */
	RelacionMotivoDen find(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Removes a single row in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 */
	void remove(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Finds a List of rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List
	 */
	List<RelacionMotivoDen> findAll(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto);

	/**
	 * Finds rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RelacionMotivoDen> findAllLike(RelacionMotivoDen relacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the RelacionMotivoDen table using like.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(RelacionMotivoDen relacionMotivoDen, Boolean startsWith);

	/**
	 * Counts rows in the RelacionMotivoDen table.
	 *
	 * @param relacionMotivoDen
	 *            RelacionMotivoDen
	 * @return Long
	 */
	Long findAllCount(RelacionMotivoDen relacionMotivoDen);

	/**
	 * Reorder selection.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<RelacionMotivoDen>> reorderSelection(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param searchRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<RelacionMotivoDen>> search(RelacionMotivoDen filterRelacionMotivoDen,
			RelacionMotivoDen searchRelacionMotivoDen, TableRequestDto tableRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical RelacionMotivoDen table.
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<JerarquiaDto<RelacionMotivoDen>>
	 */
	List<JerarquiaDto<RelacionMotivoDen>> findAllLikeJerarquia(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto);

	/**
	 * Count rows in hierarchy
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto);

	/**
	 * Find dependent hierarchical rows
	 *
	 * @param filterRelacionMotivoDen
	 *            RelacionMotivoDen
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<TableRowDto<RelacionMotivoDen>>
	 */
	List<TableRowDto<RelacionMotivoDen>> findAllChild(RelacionMotivoDen filterRelacionMotivoDen,
			TableRequestDto tableRequestDto);

	/**
	 * Exporta Datos al clipBoard
	 *
	 */
	List<RelacionMotivoDen> getMultiple(RelacionMotivoDen filterRelacionMotivoDen, TableRequestDto tableRequestDto,
			Boolean startsWith);

}
