package com.ejie.ab78.comun;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.ejie.x38.util.StaticsContainer;

import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import weblogic.apache.xpath.XPathAPI;

/**
 * 
 *  
 * 
 */
public final class UtilsXlnets {

	private static UtilsXlnets INSTANCE = null;
	private static final Logger logger = LoggerFactory.getLogger(UtilsXlnets.class);

	/**
	 * Constructro privado.
	 */
	private UtilsXlnets() {
	}

	/**
	 * creador sincronizado para protegerse de posibles problemas multi-hilo
	 * otra prueba para evitar instanciacin mltiple
	 * 
	 */
	private synchronized static void createInstance() {
		if (UtilsXlnets.INSTANCE == null) {
			UtilsXlnets.INSTANCE = new UtilsXlnets();
		}
	}

	/**
	 * 
	 * @return XlnetsUtils valor devuelto
	 */
	public static UtilsXlnets getInstance() {
		if (UtilsXlnets.INSTANCE == null) {
			UtilsXlnets.createInstance();
		}
		return UtilsXlnets.INSTANCE;
	}

	/**
	 * Metodo que realiza el login de aplicacion en XLNETs
	 * 
	 * @return String: Token de aplicacin de XLNets
	 */
	public String getTokenAplicacion() throws Exception {
		return this.getTokenAplicacion(StaticsContainer.webAppName);
	}

	/**
	 * getTokenAplicacion
	 * 
	 * @param app
	 *            String app
	 * @return strDocumento valor devuelto
	 */
	public String getTokenAplicacion(String app) throws Exception {
		Document documento = this.getTokenAplicacionDocument(app);
		String strDocumento = UtilsDOM.getStringDoc(documento);
		if (logger.isDebugEnabled()) {
			logger.debug("getTokenAplicacion - Token:" + strDocumento);
		}
		return strDocumento;
	}

	/**
	 * Metodo que recupera el token de aplicacin de XLNets.
	 * 
	 * @return {@link Document} Token de aplicacin de XLNets
	 */
	public Document getTokenAplicacionDocument() {
		return this.getTokenAplicacionDocument(StaticsContainer.webAppName);
	}

	/**
	 * Metodo que recupera el token de aplicacin de XLNets.
	 * 
	 * @param app
	 *            aplicacin para la que se desea recuperar el token
	 * @return {@link Document} Token de aplicacin de XLNets
	 */
	public Document getTokenAplicacionDocument(String app) {
		UtilsXlnets.logger.info("getTokenAplicacion - EJIE");
		N38APISesion miApiSesion = new N38APISesion();
		return miApiSesion.n38APISesionCrearApp(app);
	}

	/**
	 * Recupera el login de N38
	 * 
	 * @return <code>String</code> login N38
	 */
	public static String obtenerLogin(HttpServletRequest request) {

		N38API n38API = new N38API(request);
		NodeList nodeLi = null;
		try {
			String filtro = "//parent::elemento/parametro[@id=\"n38login\"]/valor/text()";
			nodeLi = XPathAPI.selectNodeList(n38API.n38ItemSesion(), filtro);
			return nodeLi.item(0).getNodeValue();
		} catch (Exception e) {
			return nodeLi.toString();
		}

	}
}
