package com.ejie.ab78.comun;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * UtilsConfig
 * 
 *  
 *
 */
public class UtilsConfig {

	private static final Logger logger = LoggerFactory.getLogger(UtilsConfig.class);

	private static Properties appProperties;

	/**
	 * UtilConfig
	 */
	private UtilsConfig() {
	}

	/**
	 * Static methos to obtain app properties.
	 * 
	 * @return properties valor devuelto
	 */
	public static Properties getAppProperties() {

		if (appProperties == null) {
			appProperties = getProperties(Constantes.FICHERO_CONFIGURACION);
		}

		return appProperties;
	}

	/**
	 * Mtodo que carga el fichero de propiedades
	 * 
	 * @param nombreFichero
	 *            String nombreFichero
	 * @return Properties valor devuelto
	 */
	public static Properties getProperties(String nombreFichero) {
		InputStream inputStreamFichero = UtilsConfig.class.getResourceAsStream(nombreFichero);
		Properties propertiesApp = new Properties();
		try {
			propertiesApp.load(inputStreamFichero);
		} catch (IOException e) {
			logger.error("IOException", e);
		}
		return propertiesApp;
	}
}
