package com.ejie.ab78.comun;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

import com.ejie.ab78.model.procedimientos.Procedimientos;

public abstract class SeguridadAplicacion {

	// ROLES de la Aplicacin
	
	private static String ROLE_ADMINISTRADOR = "ROLE_AB78-IN-0001";
	private static String ROLE_RESPONSABLE_TURISMO = "ROLE_AB78-IN-0002";
	private static String ROLE_TECNICO_TURISMO = "ROLE_AB78-IN-0003";
	private static String ROLE_RESPONSABLE_COMERCIO = "ROLE_AB78-IN-0004";
	private static String ROLE_TECNICO_COMERCIO = "ROLE_AB78-IN-0005";
	private static String ROLE_RESPONSABLE_TURISMO_ARABA = "ROLE_AB78-IN-0006";
	private static String ROLE_RESPONSABLE_TURISMO_BIZKAIA = "ROLE_AB78-IN-0007";
	private static String ROLE_RESPONSABLE_TURISMO_GIPUZKOA = "ROLE_AB78-IN-0008";
	private static String ROLE_TECNICO_TURISMO_ARABA = "ROLE_AB78-IN-0009";
	private static String ROLE_TECNICO_TURISMO_BIZKAIA = "ROLE_AB78-IN-0010";
	private static String ROLE_TECNICO_TURISMO_GIPUZKOA = "ROLE_AB78-IN-0011";
	private static String ROLE_RESPONSABLE_COMERCIO_ARABA = "ROLE_AB78-IN-0012";
	private static String ROLE_RESPONSABLE_COMERCIO_BIZKAIA = "ROLE_AB78-IN-0013";
	private static String ROLE_RESPONSABLE_COMERCIO_GIPUZKOA = "ROLE_AB78-IN-0014";
	private static String ROLE_TECNICO_COMERCIO_ARABA = "ROLE_AB78-IN-0015";
	private static String ROLE_TECNICO_COMERCIO_BIZKAIA = "ROLE_AB78-IN-0016";
	private static String ROLE_TECNICO_COMERCIO_GIPUZKOA = "ROLE_AB78-IN-0017";
	
	// USUARIOS de la Aplicacin
	
	// AB78U001: Administrador
	// AB78U002: Responsable de Turismo
	// AB78U003: Tcnico de Turismo
	// AB78U004: Responsable de Comercio
	// AB78U005: Tcnico de Comercio
	// AB78U006: Responsable de Turismo de Araba
	// AB78U007: Responsable de Turismo de Bizkaia
	// AB78U008: Responsable de Turismo de Gipuzkoa
	// AB78U009: Tcnico de Turismo de Araba
	// AB78U010: Tcnico de Turismo de Bizkaia
	// AB78U011: Tcnico de Turismo de Gipuzkoa
	// AB78U012: Responsable de Comercio de Araba
	// AB78U013: Responsable de Comercio de Bizkaia
	// AB78U014: Responsable de Comercio de Gipuzkoa
	// AB78U015: Tcnico de Comercio de Araba
	// AB78U016: Tcnico de Comercio de Bizkaia
	// AB78U017: Tcnico de Comercio de Gipuzkoa


	public SeguridadAplicacion() {

	}

	/**
	 * 
	 * @param authentication
	 *            org.springframework.security.core.Authentication
	 * @return Vector<String> con los roles del usuario
	 */
	public static Vector<String> getRolesUsuario(Authentication authentication) {
		List<GrantedAuthority> list = new ArrayList<GrantedAuthority>(authentication.getAuthorities());
		Vector<String> vecPermisos = new Vector<String>();

		for (GrantedAuthority grantedAuthority : list) {
			vecPermisos.add(grantedAuthority.getAuthority());
		}

		return vecPermisos;
	}

	/**
	 * 
	 * @param authentication
	 *            org.springframework.security.core.Authentication
	 * @param procedimientos
	 *            Procedimientos
	 * @return boolean para indicar si tiene acceso o no al procedimiento
	 */
	public static boolean validarAccesoProcedimiento(Authentication authentication, Procedimientos procedimientos) {
		Vector<String> vecPermisos = SeguridadAplicacion
				.getRolesUsuario(SecurityContextHolder.getContext().getAuthentication());

		vecPermisos.add(SeguridadAplicacion.ROLE_RESPONSABLE_TURISMO);

		boolean bolAcceso = false;

		if (procedimientos != null && procedimientos.getDirecciones() != null) {
			// Si el procedimiento tiene codigo de direccion 1 es visible
			// para perfil administrador y responsable de turismo
			if (procedimientos.getDirecciones().getIdDireccion() == Constantes.COD_DIRECCION_TURISMO
					&& (vecPermisos.contains(SeguridadAplicacion.ROLE_ADMINISTRADOR)
							|| vecPermisos.contains(SeguridadAplicacion.ROLE_RESPONSABLE_TURISMO)))
				bolAcceso = true;
			// Si el procedimiento tiene codigo de direccion 1 es visible
			// para perfil administrador y responsable de comercio
			else if (procedimientos.getDirecciones()
					.getIdDireccion() == Constantes.ID_TIPO_DIRECCION_ESTABLECIMIENTO_EXPEDIENTE
					&& (vecPermisos.contains(SeguridadAplicacion.ROLE_ADMINISTRADOR)
							|| vecPermisos.contains(SeguridadAplicacion.ROLE_RESPONSABLE_COMERCIO)))
				bolAcceso = true;
		}

		return bolAcceso;
	}
	
	public static String precargarDireccion() {

		String direccion = "";

		Vector<String> vecPermisos = SeguridadAplicacion
				.getRolesUsuario(SecurityContextHolder.getContext().getAuthentication());

		// Si solo pertenece a turismo
		if ((vecPermisos.contains(ROLE_RESPONSABLE_TURISMO) || vecPermisos.contains(ROLE_TECNICO_TURISMO) 
				|| vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_ARABA)
				|| vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_BIZKAIA)
				|| vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_GIPUZKOA)
				|| vecPermisos.contains(ROLE_TECNICO_TURISMO_ARABA)
				|| vecPermisos.contains(ROLE_TECNICO_TURISMO_BIZKAIA)
				|| vecPermisos.contains(ROLE_TECNICO_TURISMO_GIPUZKOA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO)
				&& !vecPermisos.contains(ROLE_TECNICO_COMERCIO)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_ARABA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_BIZKAIA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_GIPUZKOA)
				&& !vecPermisos.contains(ROLE_TECNICO_COMERCIO_ARABA)
				&& !vecPermisos.contains(ROLE_TECNICO_COMERCIO_BIZKAIA)
				&& !vecPermisos.contains(ROLE_TECNICO_COMERCIO_GIPUZKOA))) {
			direccion = String.valueOf(Constantes.DPTO_TURISMO);

			// Si solo pretenece a Comercio
		} else if ((vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO) || vecPermisos.contains(ROLE_TECNICO_COMERCIO) 
				|| vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_ARABA)
				|| vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_BIZKAIA)
				|| vecPermisos.contains(ROLE_RESPONSABLE_COMERCIO_GIPUZKOA)
				|| vecPermisos.contains(ROLE_TECNICO_COMERCIO_ARABA)
				|| vecPermisos.contains(ROLE_TECNICO_COMERCIO_BIZKAIA)
				|| vecPermisos.contains(ROLE_TECNICO_COMERCIO_GIPUZKOA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_TURISMO)
				&& !vecPermisos.contains(ROLE_TECNICO_TURISMO)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_ARABA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_BIZKAIA)
				&& !vecPermisos.contains(ROLE_RESPONSABLE_TURISMO_GIPUZKOA)
				&& !vecPermisos.contains(ROLE_TECNICO_TURISMO_ARABA)
				&& !vecPermisos.contains(ROLE_TECNICO_TURISMO_BIZKAIA)
				&& !vecPermisos.contains(ROLE_TECNICO_TURISMO_GIPUZKOA))) {
			direccion = String.valueOf(Constantes.DPTO_COMERCIO);
		}

		return direccion;
	}
}
