/**
 * 
 */
package com.ejie.ab78.adaptadores.service;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.clientesWS.ab61WebService.Ab61WebService;
import com.ejie.ab78.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab78.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab78.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab78.clientesWS.ab61WebService.IdentificadoresPid;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioTitularWS;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioWS;
import com.ejie.ab78.clientesWS.ab61WebService.Origen;
import com.ejie.ab78.clientesWS.ab61WebService.PifException_Exception;
import com.ejie.ab78.clientesWS.ab61WebService.Usuario;
import com.ejie.ab78.clientesWS.ab61WebService.WebServiceImpl;
import com.ejie.ab78.comun.UtilsConfig;

/**
 *  
 * 
 */
@Service(value = "ab61WebServiceServiceImpl")
public class ab61WebServiceServiceImpl implements ab61WebServiceService {

	private static final Logger logger = LoggerFactory.getLogger(ab61WebServiceServiceImpl.class);

	private Ab61WebService service;

	private static final QName qname = new QName("http://com.ejie.ab61.serviciosWeb", "ab61WebService");

	private WebServiceImpl getab61WebServiceServiceImplServicePort() {
		return this.getab61WebServiceServiceImplServicePort(true);
	}

	private WebServiceImpl getab61WebServiceServiceImplServicePort(boolean getPort) {
		try {

			if (this.service == null) {
				logger.info("INICIANDO SERVICE ab61WebServiceService");
				// Creamos el servicio

				logger.info("URL: " + UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL"));

				service = new Ab61WebService(new URL(UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL")),
						qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					@Override
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new ab61WebServiceServiceHandler());
					}
				});
				logger.info("INICIADO SERVICE ab61WebServiceService");
			}
			if (getPort) {
				logger.info("get SERVICE PORT ab61WebServiceService inicia llamada WS");
				WebServiceImpl proxy = this.service.getAb61WebServicePort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						UtilsConfig.getAppProperties().getProperty("Ab61WebService_URL"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}

	@Override
	public String generarExcelListados(int idListado, List<BusquedasWS> listaBusquedas, String codAplic)
			throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().generarExcelListados(idListado, listaBusquedas, codAplic,
				null);
	}

	@Override
	public String descargarDocumento(Integer idPlantilla, String procedureId, String foderId, String codAplic)
			throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().descargarDocumento(idPlantilla, procedureId, foderId, null,
				codAplic);

	}

	@Override
	public String generarDocumento(Integer idPlantilla, String procedureId, String foderId, String usuario)
			throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().generarDocumento(idPlantilla, procedureId, foderId, null,
				usuario);

	}

	@Override
	public String modificarDocumento(Integer idPlantilla, String procedureId, String foderId, String usuario)
			throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().modificarDocumento(idPlantilla, procedureId, foderId, null,
				usuario);
	}

	/**
	 * Llama al webService que realiza la tarea indicada
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param n38Login
	 *            String
	 * @return String
	 * @throws Ab61Exception
	 */
	@Override
	public String aportarDocumento(Integer idPlantilla, String procedureId, String folderId, String n38Login,
			String usuario) throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().aportarDocumento(idPlantilla, procedureId, folderId, n38Login,
				usuario);
	}

	@Override
	public String eliminarDocumento(Integer idPlantilla, String folderId, String procedureId) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().eliminarDocumento(idPlantilla, folderId, procedureId, null);

	}

	@Override
	public DatosInicioOficio generarInicioOficio(InicioOficioWS inicioOficioWS) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().generarInicioOficio(inicioOficioWS);

	}

	@Override
	public String generarDocumentoNegocio(Integer idPlantilla, String idEstablecimiento, Origen origen, String usuario)
			throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().generarDocumentoNegocio(idPlantilla, idEstablecimiento, origen,
				usuario);

	}

	@Override
	public String descargarDocumentoNegocio(Integer idPlantilla, String idEstablecimiento, Origen origen,
			String usuario, Boolean descargarFormatoPdf) throws Ab61Exception {

		return getab61WebServiceServiceImplServicePort().descargarDocumentoNegocio(idPlantilla, idEstablecimiento,
				origen, usuario, descargarFormatoPdf);
	}

	@Override
	public String generarExcelListados(Integer idListado, List<BusquedasWS> listaBusqueda, String aplicacion,
			Integer idProcedimiento) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().generarExcelListados(idListado, listaBusqueda, aplicacion,
				idProcedimiento);
	}

	@Override
	public String descargarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String aplicacion) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().descargarDocumento(idPlantilla, procedureId, foderId,
				identificadorInspeccion, aplicacion);
	}

	@Override
	public String generarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String usuario) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().generarDocumento(idPlantilla, procedureId, foderId,
				identificadorInspeccion, usuario);
	}

	@Override
	public String modificarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String usuario) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().modificarDocumento(idPlantilla, procedureId, foderId,
				identificadorInspeccion, usuario);
	}

	@Override
	public String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario)
			throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().modificarDocumentoNegocio(idPlantilla, identificador, usuario);
	}

	@Override
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().aportarDocumentoPlatea(idPlantilla, procedureId, folderId,
				usuario);
	}

	@Override
	public String aportarDocumentoNegocio(Integer idPlantilla, String procedureId, String folderId, String n38Login,
			String usuario) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().aportarDocumentoNegocio(idPlantilla, procedureId, folderId,
				n38Login, usuario);
	}

	@Override
	public String eliminarDocumento(Integer idPlantilla, String foderId, String procedureId,
			String identificadorInspeccion) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().eliminarDocumento(idPlantilla, foderId, procedureId,
				identificadorInspeccion);
	}

	@Override
	public String eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().eliminarDocumentoNegocio(idPlantilla, identificador);
	}

	@Override
	public DatosInicioOficio generarInicioOficioTitular(InicioOficioTitularWS inicioOficioTitularWS)
			throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().generarInicioOficioTitular(inicioOficioTitularWS);
	}

	@Override
	public String descargarDocumentoDokusi(String oidDokusi, String aplicacion) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().descargarDocumentoDokusi(oidDokusi, aplicacion, null);
		} catch (PifException_Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public String descargarDocumentoPid(String oidPid, String aplicacion) throws Ab61Exception {
		try {
			return getab61WebServiceServiceImplServicePort().descargarDocumentoPid(oidPid, aplicacion, null);
		} catch (PifException_Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public void eliminarDocumentoPid(String oidPid) throws Ab61Exception {
		getab61WebServiceServiceImplServicePort().eliminarDocumentoPid(oidPid);

	}

	@Override
	public IdentificadoresPid insertarDocumentoPid(String pathPif, String fileName, Integer idTipoPlantilla,
			String nombreDocumento, Integer aportadoExpediente, String aplicacion, String usuario)
			throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().insertarDocumentoPid(pathPif, fileName, idTipoPlantilla,
				nombreDocumento, aportadoExpediente, aplicacion, usuario);
	}

	@Override
	public Boolean actualizarParticipaciones(String folderId, String usuario)
			throws Ab61Exception, Exception_Exception {
		return getab61WebServiceServiceImplServicePort().actualizarParticipaciones(folderId, usuario);
	}

	@Override
	public String actualizarTituloExpediente(String folderId, String tituloExpediente) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().actualizarTituloExpediente(folderId, tituloExpediente);
	}

	@Override
	public String insertarParticipacion(String folderId, Integer idTercero, String desCasParticipacion,
			String desEusParticipacion) throws Ab61Exception {
		return getab61WebServiceServiceImplServicePort().insertarParticipacion(folderId, idTercero, desCasParticipacion,
				desEusParticipacion);
	}
}
