/**
 * 
 */
package com.ejie.ab78.adaptadores.service;

import java.util.List;

import javax.jws.WebParam;

import com.ejie.ab78.clientesWS.ab61WebService.Ab61Exception;
import com.ejie.ab78.clientesWS.ab61WebService.BusquedasWS;
import com.ejie.ab78.clientesWS.ab61WebService.DatosInicioOficio;
import com.ejie.ab78.clientesWS.ab61WebService.Exception_Exception;
import com.ejie.ab78.clientesWS.ab61WebService.IdentificadoresPid;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioTitularWS;
import com.ejie.ab78.clientesWS.ab61WebService.InicioOficioWS;
import com.ejie.ab78.clientesWS.ab61WebService.Origen;
import com.ejie.ab78.clientesWS.ab61WebService.Usuario;

/**
 *  
 * 
 */
public interface ab61WebServiceService {

	public String generarExcelListados(int idListado, List<BusquedasWS> listaBusquedas, String codAplic)
			throws Ab61Exception;

	public String descargarDocumento(Integer idPlantilla, String procedureId, String foderId, String codAplic)
			throws Ab61Exception;

	public String generarDocumento(Integer idPlantilla, String procedureId, String foderId, String usuario)
			throws Ab61Exception;

	public String modificarDocumento(Integer idPlantilla, String procedureId, String foderId, String usuario)
			throws Ab61Exception;

	/**
	 * llama al webService que realiza la tarea indicada
	 * 
	 * @param idPlantilla
	 *            Integer
	 * @param procedureId
	 *            String
	 * @param folderId
	 *            String
	 * @param n38Login
	 *            String
	 * @return String
	 * @throws Ab61Exception
	 */

	public String eliminarDocumento(Integer idPlantilla, String folderId, String procedureId) throws Ab61Exception;

	/**
	 * 
	 * @param aplicacion
	 * @param listaBusqueda
	 * @param idProcedimiento
	 * @param idListado
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String generarExcelListados(Integer idListado, List<BusquedasWS> listaBusqueda, String aplicacion,
			Integer idProcedimiento) throws Ab61Exception;

	/**
	 * 
	 * @param aplicacion
	 * @param identificadorInspeccion
	 * @param foderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */

	public String descargarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String aplicacion) throws Ab61Exception;

	/**
	 * 
	 * @param aplicacion
	 * @param identificador
	 * @param origen
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String descargarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String aplicacion,
			Boolean descargarFormatoPdf) throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param identificadorInspeccion
	 * @param foderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String generarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String usuario) throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param identificador
	 * @param origen
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String generarDocumentoNegocio(Integer idPlantilla, String identificador, Origen origen, String usuario)
			throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param identificadorInspeccion
	 * @param foderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String modificarDocumento(Integer idPlantilla, String procedureId, String foderId,
			String identificadorInspeccion, String usuario) throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param identificador
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String modificarDocumentoNegocio(Integer idPlantilla, String identificador, String usuario)
			throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param n38Login
	 * @param folderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String aportarDocumento(Integer idPlantilla, String procedureId, String folderId, String n38Login,
			String usuario) throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param n38Login
	 * @param folderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String aportarDocumentoPlatea(Integer idPlantilla, String procedureId, String folderId, Usuario usuario)
			throws Ab61Exception;

	/**
	 * 
	 * @param usuario
	 * @param n38Login
	 * @param folderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String aportarDocumentoNegocio(Integer idPlantilla, String procedureId, String folderId, String n38Login,
			String usuario) throws Ab61Exception;

	/**
	 * 
	 * @param identificadorInspeccion
	 * @param foderId
	 * @param procedureId
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String eliminarDocumento(Integer idPlantilla, String foderId, String procedureId,
			String identificadorInspeccion) throws Ab61Exception;

	/**
	 * 
	 * @param identificador
	 * @param idPlantilla
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String eliminarDocumentoNegocio(Integer idPlantilla, String identificador) throws Ab61Exception;

	/**
	 * 
	 * @param inicioOficioWS
	 * @return returns com.ejie.ab63.clientesWS.ab61WebService.DatosInicioOficio
	 * @throws Ab61Exception
	 */
	public DatosInicioOficio generarInicioOficio(InicioOficioWS inicioOficioWS) throws Ab61Exception;

	/**
	 * 
	 * @param inicioOficioTitularWS
	 * @return returns com.ejie.ab63.clientesWS.ab61WebService.DatosInicioOficio
	 * @throws Ab61Exception
	 */
	public DatosInicioOficio generarInicioOficioTitular(InicioOficioTitularWS inicioOficioTitularWS)
			throws Ab61Exception;

	/**
	 * 
	 * @param aplicacion
	 * @param oidDokusi
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String descargarDocumentoDokusi(@WebParam(name = "oidDokusi", targetNamespace = "") String oidDokusi,
			@WebParam(name = "aplicacion", targetNamespace = "") String aplicacion) throws Ab61Exception;

	/**
	 * 
	 * @param aplicacion
	 * @param oidPid
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */
	public String descargarDocumentoPid(String oidPid, String aplicacion) throws Ab61Exception;

	/**
	 * 
	 * @param oidPid
	 * @throws Ab61Exception
	 */
	public void eliminarDocumentoPid(String oidPid) throws Ab61Exception;

	public IdentificadoresPid insertarDocumentoPid(String fileName, String pathPif, Integer idTipoPlantilla,
			String nombreDocumento, Integer aportadoExpediente, String aplicacion, String usuario) throws Ab61Exception

	;
	/*
	 * IdentificadoresPid insertarDocumentoPid(String pathPif, String fileName,
	 * Integer idTipoPlantilla, String nombreDocumento, Integer
	 * aportadoExpediente, String aplicacion) throws Ab61Exception;
	 */

	/**
	 * 
	 * @param folderId
	 * @param usuario
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 * @throws Exception_Exception
	 */

	public Boolean actualizarParticipaciones(String folderId, String usuario) throws Ab61Exception, Exception_Exception;

	public String actualizarTituloExpediente(String folderId, String tituloExpediente) throws Ab61Exception;

	/**
	 * 
	 * @param folderId
	 * @return returns java.lang.String
	 * @throws Ab61Exception
	 */

	public String insertarParticipacion(String folderId, Integer idTercero, String desCasParticipacion,
			String desEusParticipacion) throws Ab61Exception;

}
