/**
 * 
 */
package com.ejie.ab78.adaptadores.service;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ejie.ab78.clientesWS.ab79WebService.Ab79Exception;
import com.ejie.ab78.clientesWS.ab79WebService.Ab79WebService;
import com.ejie.ab78.clientesWS.ab79WebService.InspeccionWS;
import com.ejie.ab78.clientesWS.ab79WebService.PreguntasExpedienteWS;
import com.ejie.ab78.clientesWS.ab79WebService.WebServiceImpl;
import com.ejie.ab78.comun.UtilsConfig;

/**
 *  
 * 
 */
@Service(value = "ab79WebServiceServiceImpl")
public class Ab79WebServiceServiceImpl implements Ab79WebServiceService {

	private static final Logger logger = LoggerFactory.getLogger(Ab79WebServiceServiceImpl.class);

	private Ab79WebService service;

	private static final QName qname = new QName("http://com.ejie.ab79.serviciosWeb", "ab79WebService");

	private WebServiceImpl getab79WebServiceServiceImplServicePort() {
		return this.getab79WebServiceServiceImplServicePort(true);
	}

	private WebServiceImpl getab79WebServiceServiceImplServicePort(boolean getPort) {
		try {

			if (this.service == null) {
				logger.info("INICIANDO SERVICE ab79WebServiceService");
				// Creamos el servicio

				logger.info("URL: " + UtilsConfig.getAppProperties().getProperty("Ab79WebService_URL"));

				service = new Ab79WebService(new URL(UtilsConfig.getAppProperties().getProperty("Ab79WebService_URL")),
						qname);

				// definimos un handler cliente
				service.setHandlerResolver(new HandlerResolver() {
					@Override
					public List getHandlerChain(PortInfo portInfo) {
						return Collections.singletonList(new Ab79WebServiceServiceHandler());
					}
				});
				logger.info("INICIADO SERVICE ab79WebServiceService");
			}
			if (getPort) {
				logger.info("get SERVICE PORT ab79WebServiceService inicia llamada WS");
				WebServiceImpl proxy = this.service.getAb79WebServicePort();

				Map<String, Object> ctxt = ((BindingProvider) proxy).getRequestContext();
				ctxt.put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY,
						UtilsConfig.getAppProperties().getProperty("Ab79WebService_URL"));

				return proxy;
			}
		} catch (Exception e) {
			this.service = null;
		}
		return null;
	}

	@Override
	public String crearInspeccion(String folderId, InspeccionWS inspeccion,
			List<PreguntasExpedienteWS> preguntasExpedienteWS, String usuario, Integer idOrigenInspeccion,
			Integer idExpedienteOrigen, String numDenuncia) throws Ab79Exception {
		return getab79WebServiceServiceImplServicePort().crearInspeccion(folderId, inspeccion, preguntasExpedienteWS,
				usuario, idOrigenInspeccion, idExpedienteOrigen, numDenuncia);
	}

	@Override
	public String eliminarInspeccion(String identificadorInspeccion, String usuario) throws Ab79Exception {
		return getab79WebServiceServiceImplServicePort().eliminarInspeccion(identificadorInspeccion, usuario);
	}

}
